/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.olap.cube.model.CubeBuildCommand;
import oracle.olap.syntax.BaseSyntax;
import oracle.olapi.syntax.AggregationCommand;
import oracle.olapi.syntax.AnalyzeCommand;
import oracle.olapi.syntax.BuildCommand;
import oracle.olapi.syntax.BuildSpecification;
import oracle.olapi.syntax.ClearCommand;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.GroupCommand;
import oracle.olapi.syntax.LoadCommand;
import oracle.olapi.syntax.ModelCommand;
import oracle.olapi.syntax.OLAPDMLCommand;
import oracle.olapi.syntax.PLSQLCommand;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SolveCommand;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;

public class BuildSyntax
extends BaseSyntax {
    public static final String CUBE_BUILD_COMMANDS_KEY = "CUBE_BUILD_COMMANDS_KEY";
    public static final String CUBE_BUILD_SPECIFICATION_NAME_KEY = "CUBE_BUILD_SPECIFICATION_NAME_KEY";
    public static final String CUBE_BUILD_SPECIFICATION_SYNTAX_KEY = "CUBE_BUILD_SPECIFICATION_SYNTAX_KEY";
    private static BuildSyntax buildSyntaxInstance;

    private BuildSyntax() {
    }

    public static BuildSyntax getInstance() {
        if (buildSyntaxInstance == null) {
            buildSyntaxInstance = new BuildSyntax();
        }
        return buildSyntaxInstance;
    }

    public Map<String, Object> fromSyntax(String string, String string2) throws SyntaxException, Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            BuildSpecification buildSpecification = (BuildSpecification)SyntaxObject.fromSyntax((String)string2, null, (String)string);
            if (buildSpecification != null) {
                String string3 = buildSpecification.getName();
                hashMap.put(CUBE_BUILD_SPECIFICATION_NAME_KEY, string3);
                List<Object> list = new ArrayList();
                BuildCommand[] buildCommandArray = buildSpecification.getCommands();
                list = this._getCubeBuildCommands(buildCommandArray);
                hashMap.put(CUBE_BUILD_COMMANDS_KEY, list);
                hashMap.put(CUBE_BUILD_SPECIFICATION_SYNTAX_KEY, string2);
            }
        }
        catch (SyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Exception exception) {
            throw exception;
        }
        return hashMap;
    }

    private List<CubeBuildCommand> _getCubeBuildCommands(BuildCommand[] buildCommandArray) {
        ArrayList<CubeBuildCommand> arrayList = new ArrayList<CubeBuildCommand>();
        for (int i = 0; i < buildCommandArray.length; ++i) {
            CubeBuildCommand cubeBuildCommand;
            BuildCommand buildCommand = buildCommandArray[i];
            if (buildCommand instanceof SimpleCommand) {
                cubeBuildCommand = this._getCubeBuildCommand(buildCommand);
                arrayList.add(cubeBuildCommand);
                continue;
            }
            if (!(buildCommand instanceof GroupCommand)) continue;
            cubeBuildCommand = (GroupCommand)buildCommand;
            SymmetricCondition symmetricCondition = cubeBuildCommand.getWhereCondition();
            String string = null;
            if (symmetricCondition != null) {
                string = cubeBuildCommand.getWhereCondition().toSyntax();
            }
            String[] stringArray = cubeBuildCommand.getMeasureIDs();
            String string2 = "";
            for (int j = 0; j < stringArray.length; ++j) {
                String string3 = stringArray[j];
                string2 = string2.length() == 0 ? string2 + string3 : string2 + "," + string3;
            }
            SimpleCommand[] simpleCommandArray = cubeBuildCommand.getCommands();
            for (int j = 0; j < simpleCommandArray.length; ++j) {
                CubeBuildCommand cubeBuildCommand2 = this._getCubeBuildCommand((BuildCommand)simpleCommandArray[j]);
                cubeBuildCommand2.setDimensionCondition(string);
                cubeBuildCommand2.setMeasureSelection(string2);
                arrayList.add(cubeBuildCommand2);
            }
        }
        return arrayList;
    }

    private CubeBuildCommand _getCubeBuildCommand(BuildCommand buildCommand) {
        CubeBuildCommand cubeBuildCommand = null;
        if (buildCommand instanceof AnalyzeCommand) {
            cubeBuildCommand = new CubeBuildCommand("ANALYZE");
        } else if (!(buildCommand instanceof AggregationCommand)) {
            if (buildCommand instanceof ClearCommand) {
                ClearCommand clearCommand = (ClearCommand)buildCommand;
                cubeBuildCommand = new CubeBuildCommand("CLEAR");
                String string = clearCommand.getClearTarget();
                String string2 = clearCommand.getParallelismOption();
                if (string2.equalsIgnoreCase("")) {
                    if (string.equalsIgnoreCase("AGGREGATES")) {
                        cubeBuildCommand.setOption("AGGREGATES");
                    } else if (string.equalsIgnoreCase("ALL AGGREGATES")) {
                        cubeBuildCommand.setOption("ALL AGGREGATES");
                    } else if (string.equalsIgnoreCase("STALE AGGREGATES")) {
                        cubeBuildCommand.setOption("STALE AGGREGATES");
                    } else if (string.equalsIgnoreCase("LEAVES")) {
                        cubeBuildCommand.setOption("LEAVES");
                    } else if (string.equalsIgnoreCase("VALUES")) {
                        cubeBuildCommand.setOption("VALUES");
                    } else if (string.equalsIgnoreCase("")) {
                        cubeBuildCommand.setOption("");
                    }
                } else if (string2.equalsIgnoreCase("PARALLEL")) {
                    if (string.equalsIgnoreCase("AGGREGATES")) {
                        cubeBuildCommand.setOption("AGGREGATES PARALLEL");
                    } else if (string.equalsIgnoreCase("ALL AGGREGATES")) {
                        cubeBuildCommand.setOption("ALL AGGREGATES PARALLEL");
                    } else if (string.equalsIgnoreCase("STALE AGGREGATES")) {
                        cubeBuildCommand.setOption("STALE AGGREGATES PARALLEL");
                    } else if (string.equalsIgnoreCase("LEAVES")) {
                        cubeBuildCommand.setOption("LEAVES PARALLEL");
                    } else if (string.equalsIgnoreCase("VALUES")) {
                        cubeBuildCommand.setOption("VALUES PARALLEL");
                    } else if (string.equalsIgnoreCase("")) {
                        cubeBuildCommand.setOption("PARALLEL");
                    }
                } else if (string2.equalsIgnoreCase("SERIAL")) {
                    if (string.equalsIgnoreCase("AGGREGATES")) {
                        cubeBuildCommand.setOption("AGGREGATES SERIAL");
                    } else if (string.equalsIgnoreCase("ALL AGGREGATES")) {
                        cubeBuildCommand.setOption("ALL AGGREGATES SERIAL");
                    } else if (string.equalsIgnoreCase("STALE AGGREGATES")) {
                        cubeBuildCommand.setOption("STALE AGGREGATES SERIAL");
                    } else if (string.equalsIgnoreCase("LEAVES")) {
                        cubeBuildCommand.setOption("LEAVES SERIAL");
                    } else if (string.equalsIgnoreCase("VALUES")) {
                        cubeBuildCommand.setOption("VALUES SERIAL");
                    } else if (string.equalsIgnoreCase("")) {
                        cubeBuildCommand.setOption("SERIAL");
                    }
                }
            } else if (buildCommand instanceof LoadCommand) {
                LoadCommand loadCommand = (LoadCommand)buildCommand;
                cubeBuildCommand = new CubeBuildCommand("LOAD");
                cubeBuildCommand.setOption(loadCommand.getLoadOption());
                Condition condition = loadCommand.getWhereCondition();
                if (condition != null) {
                    cubeBuildCommand.setExpression(loadCommand.getWhereCondition().toSyntax());
                }
            } else if (!(buildCommand instanceof ModelCommand)) {
                if (buildCommand instanceof OLAPDMLCommand) {
                    OLAPDMLCommand oLAPDMLCommand = (OLAPDMLCommand)buildCommand;
                    cubeBuildCommand = new CubeBuildCommand("OLAP DML");
                    cubeBuildCommand.setOption(oLAPDMLCommand.getOption());
                    cubeBuildCommand.setExpression(oLAPDMLCommand.getDML());
                } else if (buildCommand instanceof PLSQLCommand) {
                    PLSQLCommand pLSQLCommand = (PLSQLCommand)buildCommand;
                    cubeBuildCommand = new CubeBuildCommand("PLSQL");
                    cubeBuildCommand.setExpression(pLSQLCommand.getPLSQL());
                } else if (buildCommand instanceof SolveCommand) {
                    SolveCommand solveCommand = (SolveCommand)buildCommand;
                    cubeBuildCommand = new CubeBuildCommand("SOLVE");
                    String string = solveCommand.getParallelismOption();
                    if (string.equalsIgnoreCase("")) {
                        cubeBuildCommand.setOption("");
                    } else if (string.equalsIgnoreCase("PARALLEL")) {
                        cubeBuildCommand.setOption("PARALLEL");
                    } else if (string.equalsIgnoreCase("SERIAL")) {
                        cubeBuildCommand.setOption("SERIAL");
                    }
                }
            }
        }
        return cubeBuildCommand;
    }

    public String toSyntax(Map<String, Object> map) {
        String string = (String)map.get(CUBE_BUILD_SPECIFICATION_NAME_KEY);
        List list = (List)map.get(CUBE_BUILD_COMMANDS_KEY);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BUILD SPEC ");
        stringBuffer.append(string);
        stringBuffer.append("(");
        int n = 0;
        for (CubeBuildCommand cubeBuildCommand : list) {
            String string2;
            String string3;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            String string4 = cubeBuildCommand.getMeasureSelection();
            String string5 = cubeBuildCommand.getDimensionCondition();
            boolean bl = false;
            if (string4 != null && string4.length() > 0 || string5 != null && string5.length() > 0) {
                bl = true;
                stringBuffer.append("FOR");
                if (string5 != null && string5.length() > 0) {
                    stringBuffer.append(" ");
                    stringBuffer.append(string5);
                }
                if (string4 != null && string4.length() > 0) {
                    stringBuffer.append(" MEASURES(");
                    stringBuffer.append(string4);
                    stringBuffer.append(")");
                }
                stringBuffer.append(" BUILD(");
            }
            if ((string3 = cubeBuildCommand.getType()).equalsIgnoreCase("OLAP DML") || string3.equalsIgnoreCase("PLSQL")) {
                stringBuffer.append("EXECUTE ");
            }
            stringBuffer.append(string3);
            String string6 = cubeBuildCommand.getOption();
            if (string6 != null && string6.length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string6);
            }
            if ((string2 = cubeBuildCommand.getExpression()) != null && string2.length() > 0) {
                stringBuffer.append(" ");
                if (string3.equalsIgnoreCase("OLAP DML") || string3.equalsIgnoreCase("PLSQL")) {
                    string2 = string2.replaceAll("'", "''");
                    stringBuffer.append("'");
                    stringBuffer.append(string2);
                    stringBuffer.append("'");
                } else if (string3.equalsIgnoreCase("LOAD")) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(string2);
                }
            }
            if (bl) {
                stringBuffer.append(")");
            }
            ++n;
        }
        stringBuffer.append(")");
        String string7 = stringBuffer.toString();
        map.put(CUBE_BUILD_SPECIFICATION_SYNTAX_KEY, string7);
        return string7;
    }
}

