/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.stringexpr;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import oracle.olap.stringexpr.Node;
import oracle.olap.stringexpr.SimpleNode;
import oracle.olap.stringexpr.StringExprParser;

public abstract class ExprNode
extends SimpleNode {
    private static Pattern numeric = Pattern.compile("-?\\d*(\\.\\d+)?");
    private static Pattern integer = Pattern.compile("-?\\d*\\.0+");

    public ExprNode(int n) {
        super(n);
    }

    public ExprNode(StringExprParser stringExprParser, int n) {
        super(stringExprParser, n);
    }

    public Object getValue(int n) {
        Node node = this.jjtGetChild(n);
        if (node instanceof ExprNode) {
            ExprNode exprNode = (ExprNode)node;
            return exprNode.getValue();
        }
        return "";
    }

    protected boolean isNumeric(String string) {
        return !string.isEmpty() && numeric.matcher(string).matches();
    }

    protected boolean isFloating(String string) {
        return !integer.matcher(string).matches();
    }

    public String stripQuotes(String string) {
        if (string.startsWith("'")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.replaceAll("\\\\n", "\n");
        return string;
    }

    public Iterator iterator(Object object) {
        return new Itr(object);
    }

    public abstract Object getValue();

    private class Itr
    implements Iterator {
        private boolean first;
        private Object object;
        private Iterator it;

        public Itr(Object list) {
            Object object;
            if (list instanceof Object[]) {
                object = (Object[])list;
                list = Arrays.asList(object);
            }
            if (list instanceof List) {
                object = list;
                this.it = object.iterator();
            } else {
                this.object = list;
                this.first = false;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.it != null) {
                return this.it.hasNext();
            }
            return !this.first;
        }

        public Object next() {
            if (this.it != null) {
                return this.it.next();
            }
            if (!this.first) {
                this.first = true;
                return this.object;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void remove() {
        }
    }
}

