/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.sql;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.metadata.JdbcMetadataProvider;
import com.adbs.querybuilder.AddObjectDialogOptions;
import com.adbs.querybuilder.CriteriaListOptions;
import com.adbs.querybuilder.MetadataTreeOptions;
import com.adbs.querybuilder.ObjectsGroupingType;
import com.adbs.querybuilder.ObjectsSortingType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryStructureTreeOptions;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.OracleSyntaxProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.app.db.DatabaseUtils;

public class QueryDesigner {
    private QueryBuilder qb = new QueryBuilder();
    private JFrame frame;

    public QueryDesigner(Connection connection) {
        this.initQueryBuilder2(this.qb);
        this.init(connection);
        String string = "select channel_id from channel_dim";
        this.qb.setSQL(string);
    }

    private void initQueryBuilder1(QueryBuilder queryBuilder) {
        QueryStructureTreeOptions queryStructureTreeOptions = queryBuilder.getQueryStructureTreeOptions();
        queryStructureTreeOptions.beginUpdate();
        queryStructureTreeOptions.setTreeVisible(false);
        queryStructureTreeOptions.setFieldIcon(OracleIcons.getIcon((String)"field.png"));
        queryStructureTreeOptions.setFieldsIcon(OracleIcons.getIcon((String)"folder.png"));
        queryStructureTreeOptions.setFromIcon(RaptorImage.getIcon((String)"table_folder.png"));
        queryStructureTreeOptions.setFromObjIcon(OracleIcons.getIcon((String)"table.png"));
        queryStructureTreeOptions.setQueriesIcon(OracleIcons.getIcon((String)"schema_folder.png"));
        queryStructureTreeOptions.endUpdate();
        MetadataTreeOptions metadataTreeOptions = queryBuilder.getMetadataTreeOptions();
        metadataTreeOptions.beginUpdate();
        metadataTreeOptions.setTreeVisible(false);
        metadataTreeOptions.setShowSystemProcedures(true);
        metadataTreeOptions.setShowSystemSynonyms(true);
        metadataTreeOptions.setShowSystemTables(true);
        metadataTreeOptions.setShowSystemViews(true);
        metadataTreeOptions.setShowSystemProcedures(false);
        metadataTreeOptions.setShowSystemSynonyms(false);
        metadataTreeOptions.setShowSystemTables(false);
        metadataTreeOptions.setShowSystemViews(false);
        metadataTreeOptions.endUpdate();
        AddObjectDialogOptions addObjectDialogOptions = queryBuilder.getAddObjectDialogOptions();
        addObjectDialogOptions.beginUpdate();
        addObjectDialogOptions.setTablesIcon(OracleIcons.getIcon((String)"table.png"));
        addObjectDialogOptions.setViewsIcon(OracleIcons.getIcon((String)"view.png"));
        addObjectDialogOptions.setProceduresIcon(RaptorImage.getIcon((String)"procedure.png"));
        addObjectDialogOptions.setSynonymsIcon(RaptorImage.getIcon((String)"synonym.png"));
        addObjectDialogOptions.endUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQueryBuilder2(QueryBuilder queryBuilder) {
        Locale.setDefault(Locale.US);
        queryBuilder.beginUpdate();
        try {
            QueryStructureTreeOptions queryStructureTreeOptions = queryBuilder.getQueryStructureTreeOptions();
            queryStructureTreeOptions.beginUpdate();
            queryStructureTreeOptions.endUpdate();
            MetadataTreeOptions metadataTreeOptions = queryBuilder.getMetadataTreeOptions();
            metadataTreeOptions.beginUpdate();
            metadataTreeOptions.setGroupingType(ObjectsGroupingType.DatabaseSchemaType);
            metadataTreeOptions.setSortingType(ObjectsSortingType.SchemaTypeName);
            metadataTreeOptions.setShowSystemTables(false);
            metadataTreeOptions.setShowSystemViews(false);
            metadataTreeOptions.setShowSystemProcedures(false);
            metadataTreeOptions.setShowSystemSynonyms(false);
            metadataTreeOptions.endUpdate();
            AddObjectDialogOptions addObjectDialogOptions = queryBuilder.getAddObjectDialogOptions();
            addObjectDialogOptions.beginUpdate();
            addObjectDialogOptions.endUpdate();
            CriteriaListOptions criteriaListOptions = queryBuilder.getCriteriaListOptions();
            criteriaListOptions.setExpressionColumnWidth(200);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, exception);
            JOptionPane.showMessageDialog(null, exception.getMessage());
        }
        finally {
            queryBuilder.endUpdate();
        }
    }

    private void init(Connection connection) {
        JdbcMetadataProvider jdbcMetadataProvider = new JdbcMetadataProvider();
        jdbcMetadataProvider.setConnection(connection);
        OracleSyntaxProvider oracleSyntaxProvider = new OracleSyntaxProvider();
        this.qb.setSyntaxProvider((BaseSyntaxProvider)oracleSyntaxProvider);
        this.qb.setMetadataProvider((BaseMetadataProvider)jdbcMetadataProvider);
        this.qb.refreshMetadata();
    }

    public void show() {
        this.frame = new JFrame("Query Builder");
        this.frame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        this.frame.setContentPane(jPanel);
        jPanel.setLayout(new GridBagLayout());
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryDesigner.this.frame.dispose();
            }
        });
        jPanel.add((Component)this.qb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.frame.setSize(600, 600);
        this.frame.setVisible(true);
    }

    private static Connection connect() throws SQLException {
        String string;
        Connection connection = null;
        String string2 = "adc6141176:1521:omain3";
        String string3 = string = "global";
        connection = DatabaseUtils.GetConnection(string2, string, string3);
        return connection;
    }

    public static void main(String[] stringArray) {
        Connection connection = null;
        try {
            connection = QueryDesigner.connect();
            QueryDesigner queryDesigner = new QueryDesigner(connection);
            queryDesigner.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
    }
}

