/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.cubeddl.model.AccessControlEntry;
import oracle.olap.app.cubeddl.model.Realm;
import oracle.olap.app.table.Queries;
import oracle.olap.data.DimensionMetadataContext;
import oracle.olap.db.DatabaseConnection;
import oracle.olap.db.view.TransactionWaitCursorManager;
import oracle.olap.security.AccessControlList;
import oracle.olap.security.ORASUtil;
import oracle.olap.security.RealmConstraint;

public class PolicyPersistance {
    private Queries queries;
    private Connection conn;
    private DimensionMetadataContext dimensionMetadataContext;
    private final String PLSQL_XML_FILE = "securitycommands.xml";
    private String schemaName;
    private String objectName;
    private static final Logger LOG = Logger.getLogger(PolicyPersistance.class.getName());

    public PolicyPersistance(Connection connection, String string) {
        try {
            this.conn = connection;
            this.schemaName = string;
            String string2 = "oracle.olap.app.table";
            String string3 = JavaXMLBind.LoadDocument(this.getClass(), "securitycommands.xml");
            JavaXMLBind.BindToJavaStr(string3, string2, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PolicyPersistance(Connection connection, DimensionMetadataContext dimensionMetadataContext) {
        try {
            this.conn = connection;
            this.dimensionMetadataContext = dimensionMetadataContext;
            this.schemaName = dimensionMetadataContext.getDimension().getSchema().getName();
            this.objectName = dimensionMetadataContext.getDimension().getName();
            String string = "oracle.olap.app.table";
            String string2 = JavaXMLBind.LoadDocument(this.getClass(), "securitycommands.xml");
            JavaXMLBind.BindToJavaStr(string2, string, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    private void createPolicy(String string, String string2, String string3) throws SQLException {
        String string4 = this.queries.getSQL("CREATE_POLICY");
        CallableStatement callableStatement = this.conn.prepareCall(string4);
        callableStatement.setString("REALM", string3);
        callableStatement.setString("ACL_NAME", string);
        callableStatement.setString("POLICY_NAME", string2);
        callableStatement.execute();
    }

    public void createACL(AccessControlList accessControlList) throws SQLException {
        ORASUtil oRASUtil = ORASUtil.getInstance();
        String string = oRASUtil.getCreateACLPLSQL(accessControlList);
        CallableStatement callableStatement = this.conn.prepareCall(string);
        callableStatement.setString("ACLNAME", accessControlList.getName());
        callableStatement.setString("ACLDESC", accessControlList.getDescription());
        callableStatement.execute();
    }

    private void applyPolicy(String string, String string2, String string3) throws SQLException {
        String string4 = this.queries.getSQL("APPLY_POLICY");
        CallableStatement callableStatement = this.conn.prepareCall(string4);
        callableStatement.setString("POLICY_NAME", string3);
        callableStatement.setString("SCHEMA", string);
        callableStatement.setString("OBJECT", string2);
        callableStatement.execute();
    }

    private void appendRealm(String string, String string2, String string3) throws SQLException {
        String string4 = this.queries.getSQL("APPEND_REALM");
        CallableStatement callableStatement = this.conn.prepareCall(string4);
        callableStatement.setString("REALM_CONDITION", string3);
        callableStatement.setString("ACL_NAME", string);
        callableStatement.setString("POLICY_NAME", string2);
        callableStatement.execute();
    }

    public void savePolicy(String string, RealmConstraint realmConstraint) {
        try {
            boolean bl = false;
            ORASUtil oRASUtil = ORASUtil.getInstance();
            if (string == null) {
                string = oRASUtil.createDSPName(this.objectName);
                bl = true;
            }
            AccessControlList accessControlList = null;
            String string2 = accessControlList.getName();
            this.createACL(accessControlList);
            if (bl) {
                this.createPolicy(string2, string, realmConstraint.getRealmCondition());
            } else {
                this.appendRealm(string2, string, realmConstraint.getRealmCondition());
            }
            this.applyPolicy(this.schemaName, this.objectName, string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public String getCreateRealmSQL(Realm realm) {
        String string = null;
        ORASUtil oRASUtil = ORASUtil.getInstance();
        String string2 = realm.getPolicy();
        String string3 = oRASUtil.getObjectNameFromPolicyName(string2);
        String string4 = realm.getRealmCondition();
        List<AccessControlEntry> list = realm.getACEs();
        String string5 = realm.getACLName();
        String string6 = realm.getDescription();
        String string7 = realm.getParentACLName();
        String string8 = this.getCreateACLPLSQL(list, string7);
        string8 = string8.replaceAll(":ACLNAME", "'" + string5 + "'");
        string8 = string8.replaceAll(":ACLDESC", "'" + string6 + "'");
        string = this.queries.getSQL("CREATE_REALM_SQL");
        int n = string.indexOf("BEGIN");
        String string9 = string.substring(0, n + 6);
        String string10 = string.substring(n + 6);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string9);
        stringBuffer.append(string8);
        stringBuffer.append(string10);
        string = stringBuffer.toString();
        string = string.replaceAll(":REALMCOND", string4);
        string = string.replaceAll(":ACLNAME", "'" + string5 + "'");
        string = string.replaceAll(":OBJNAME", "'" + string3 + "'");
        string = string.replaceAll(":SCHEMA", "'" + this.schemaName + "'");
        string = string.replaceAll(":POLICY", "'" + string2 + "'");
        return string;
    }

    private String getCreateACLPLSQL(List<AccessControlEntry> list, String string) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        int n2 = list.size();
        for (AccessControlEntry accessControlEntry : list) {
            String string3 = accessControlEntry.getPrivilege();
            String string4 = accessControlEntry.getPrincipal();
            stringBuffer.append("XS$ACE_TYPE(privilege_list => XS$NAME_LIST(");
            stringBuffer.append(string3);
            stringBuffer.append("),granted=>true, principal_name=>'");
            stringBuffer.append(string4);
            stringBuffer.append("', principal_type=> xs_acl.ptype_db)");
            if (n < n2) {
                stringBuffer.append(",\n");
            } else {
                stringBuffer.append("\n");
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("--create acl\n");
        stringBuffer2.append("DECLARE\n");
        stringBuffer2.append(" ace_list XS$ACE_LIST;\n");
        stringBuffer2.append("BEGIN\n");
        stringBuffer2.append(" ace_list := XS$ACE_LIST(\n");
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append(");\n");
        if (string != null) {
            stringBuffer2.append(" xs_acl.create_acl(name => :ACLNAME, ace_list => ace_list, description => :ACLDESC, parent => '" + string + "', inherit_mode => 1);\n");
        } else {
            stringBuffer2.append(" xs_acl.create_acl(name => :ACLNAME, ace_list => ace_list, description => :ACLDESC);\n");
        }
        stringBuffer2.append("END;\n");
        string2 = stringBuffer2.toString();
        return string2;
    }

    public String getCreateACLinOLAPSecurityClassPLSQL(oracle.olap.app.cubeddl.model.AccessControlList accessControlList) {
        List<AccessControlEntry> list = accessControlList.getACEs();
        String string = accessControlList.getName();
        String string2 = accessControlList.getDescription();
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "'SYS.\"OlapPrivileges\"'";
        int n = 1;
        int n2 = list.size();
        for (AccessControlEntry accessControlEntry : list) {
            String string5 = accessControlEntry.getPrivilege();
            String string6 = accessControlEntry.getPrincipal();
            stringBuffer.append("XS$ACE_TYPE(privilege_list => XS$NAME_LIST(");
            stringBuffer.append(string5);
            stringBuffer.append("),granted=>true, principal_name=>'");
            stringBuffer.append(string6);
            stringBuffer.append("', principal_type=> xs_acl.ptype_db)");
            if (n < n2) {
                stringBuffer.append(",\n");
            } else {
                stringBuffer.append("\n");
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("--create acl with OlapPrivileges security class\n");
        stringBuffer2.append("DECLARE\n");
        stringBuffer2.append(" ace_list XS$ACE_LIST;\n");
        stringBuffer2.append("BEGIN\n");
        stringBuffer2.append(" ace_list := XS$ACE_LIST(\n");
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append(");\n");
        stringBuffer2.append(" xs_acl.create_acl(name => :ACLNAME, ace_list => ace_list, description => :ACLDESC, sec_class => ");
        stringBuffer2.append(string4);
        stringBuffer2.append(", inherit_mode => 1");
        stringBuffer2.append(");\n");
        stringBuffer2.append("END;\n");
        string3 = stringBuffer2.toString();
        string3 = string3.replaceAll(":ACLNAME", "'" + string + "'");
        string3 = string3.replaceAll(":ACLDESC", "'" + string2 + "'");
        return string3;
    }

    public String executeSQL(Realm realm) throws Exception {
        String string = this.getCreateRealmSQL(realm);
        LOG.log(Level.FINEST, string);
        boolean bl = true;
        TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
        Connection connection = null;
        try {
            transactionWaitCursorManager.showWaitCursor();
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
            if (bl) {
                connection = DatabaseConnection.getInstance().getClonedConnection(this.conn);
                dBUtil = DBUtil.getInstance((Connection)connection);
            }
            ExceptionHandler.reset();
            dBUtil.execute(string);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Exception exception = (Exception)throwable;
            throw exception;
        }
        finally {
            transactionWaitCursorManager.showDefaultCursor();
            transactionWaitCursorManager.reset();
        }
        return string;
    }

    public String executeSQL(oracle.olap.app.cubeddl.model.AccessControlList accessControlList) throws Exception {
        String string = this.getCreateACLinOLAPSecurityClassPLSQL(accessControlList);
        LOG.log(Level.FINEST, string);
        boolean bl = true;
        TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
        Connection connection = null;
        try {
            transactionWaitCursorManager.showWaitCursor();
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
            if (bl) {
                connection = DatabaseConnection.getInstance().getClonedConnection(this.conn);
                dBUtil = DBUtil.getInstance((Connection)connection);
            }
            ExceptionHandler.reset();
            dBUtil.execute(string);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Exception exception = (Exception)throwable;
            throw exception;
        }
        finally {
            transactionWaitCursorManager.showDefaultCursor();
            transactionWaitCursorManager.reset();
        }
        return string;
    }

    private String getObfuscatedCubeSQL(Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection != null) {
            for (String string : collection) {
                stringBuffer.append(this.getObfuscatedCubeSQL(string));
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private String getObfuscatedCubeSQL(String string) {
        String string2 = string;
        if (string.startsWith("CREATE REALM ")) {
            string2 = string.replaceFirst("CREATE REALM ", "CR ");
        }
        if (string.startsWith("ALTER REALM ")) {
            string2 = string.replaceFirst("ALTER REALM ", "AR ");
        }
        return string2;
    }
}

