/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.dml.DMLObject;
import oracle.olap.security.RealmConstraint;

public class DMLDataSecurityPanel
extends BaseEditorPanel<RealmConstraint> {
    private JTextField m_leftHandSideTextField;
    private JTextArea m_rightHandSideTextArea;
    private JComboBox m_compOperatorComboBox;
    private JComboBox m_dataTypeComboBox;
    private JTextArea m_reviewExpressionTextArea;
    private JLabel m_olapDmlExpressionLabel;
    private JButton m_compileButton;
    private JLabel m_operatorLabel;
    private JLabel m_returnValueLabel;
    private JLabel m_returnDataTypeLabel;
    private String m_initialEnumRule;
    private String m_currentDataType;
    private String m_currentCompOperator;
    private boolean m_isInitializing = false;
    private boolean m_isModifying = false;
    private RealmConstraint realmConstraint;
    private boolean enabled = true;
    private Connection connection;
    private Logger LOG = Logger.getLogger(DMLDataSecurityPanel.class.getName());

    protected void initialisePanel() {
        this.initialiseFields();
        this.realmConstraint = (RealmConstraint)this.getUpdatedObject();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        this.connection = oracleDatabaseImpl.getConnection();
        this.enableComponents();
    }

    public void initialiseFields() {
        this.m_isInitializing = true;
        String string = "";
        if (string != null) {
            if (string.contains("OLAP_DML_EXPRESSION") || string.contains("olap_dml_expression")) {
                this.m_leftHandSideTextField.setText(DMLDataSecurityPanel.getLeftHandSideExpression(string));
                this.m_rightHandSideTextArea.setText(DMLDataSecurityPanel.unwrapWithoutEscapedSingleQuotes(DMLDataSecurityPanel.getRightHandSideExpression(string)));
                this.m_currentCompOperator = DMLDataSecurityPanel.getComparisonOperator(string);
                String string2 = DMLDataSecurityPanel.getDataTypeOfExpression(string).toUpperCase();
                this.m_currentDataType = string2.equalsIgnoreCase("NUMBER") ? "NUMBER" : (string2.equalsIgnoreCase("VARCHAR2") ? "VARCHAR2" : "NUMBER");
                this.m_dataTypeComboBox.setSelectedItem(this.m_currentDataType);
                if (this.m_currentCompOperator.equals("=")) {
                    this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_EQUALS_LITERAL"));
                } else if (this.m_currentCompOperator.equals("!=")) {
                    this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_NOT_EQUALS_LITERAL"));
                } else if (this.m_currentCompOperator.equals("<")) {
                    this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_LITERAL"));
                } else if (this.m_currentCompOperator.equals(">")) {
                    this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_LITERAL"));
                } else if (this.m_currentCompOperator.equals("<=")) {
                    this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_EQUALS_LITERAL"));
                } else if (this.m_currentCompOperator.equals(">=")) {
                    this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_EQUALS_LITERAL"));
                }
                this.m_initialEnumRule = this.getTextAreaText();
                this.m_reviewExpressionTextArea.setText(string);
            } else {
                this.m_currentDataType = "NUMBER";
                this.m_currentCompOperator = "=";
                this.resetTextArea();
                this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_EQUALS_LITERAL"));
                this.m_dataTypeComboBox.setSelectedItem(this.m_currentDataType);
            }
        } else {
            this.m_currentDataType = "NUMBER";
            this.m_currentCompOperator = "=";
            this.resetTextArea();
            this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_EQUALS_LITERAL"));
            this.m_dataTypeComboBox.setSelectedItem(this.m_currentDataType);
        }
        this.m_isInitializing = false;
    }

    protected void initialiseComponents() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel.add((Component)new JLabel(OLAPArb.getString("DATA_SECURITY_OLAP_DML_INSTRUCTIONS_MSG")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 2, 5);
        this.m_olapDmlExpressionLabel = new JLabel(StringUtils.stripMnemonic((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_EXPRESSION_LABEL")));
        this.m_olapDmlExpressionLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_EXPRESSION_LABEL")));
        jPanel.add((Component)this.m_olapDmlExpressionLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.m_rightHandSideTextArea = new JTextArea(5, 1);
        this.m_rightHandSideTextArea.setMinimumSize(new Dimension(400, 200));
        this.m_rightHandSideTextArea.setLineWrap(true);
        this.m_rightHandSideTextArea.setWrapStyleWord(true);
        this.m_olapDmlExpressionLabel.setLabelFor(this.m_rightHandSideTextArea);
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.m_rightHandSideTextArea);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.m_compileButton = new JButton(StringUtils.stripMnemonic((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_COMPILE_EXPRESSION_BUTTON_LABEL")));
        this.m_compileButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_COMPILE_EXPRESSION_BUTTON_LABEL")));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 0, 5, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.m_compileButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.m_compOperatorComboBox = new JComboBox();
        this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_EQUALS_LITERAL"));
        this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_NOT_EQUALS_LITERAL"));
        this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_LITERAL"));
        this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_LITERAL"));
        this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_EQUALS_LITERAL"));
        this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_EQUALS_LITERAL"));
        gridBagConstraints.insets = new Insets(10, 0, 2, 5);
        this.m_operatorLabel = new JLabel(StringUtils.stripMnemonic((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_OPERATOR_LABEL")));
        this.m_operatorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_OPERATOR_LABEL")));
        jPanel.add((Component)this.m_operatorLabel, gridBagConstraints);
        this.m_operatorLabel.setLabelFor(this.m_compOperatorComboBox);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        jPanel.add((Component)this.m_compOperatorComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 0, 2, 5);
        this.m_returnValueLabel = new JLabel(StringUtils.stripMnemonic((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_RETURN_VALUE_LABEL")));
        this.m_returnValueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_RETURN_VALUE_LABEL")));
        jPanel.add((Component)this.m_returnValueLabel, gridBagConstraints);
        this.m_leftHandSideTextField = new JTextField();
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        jPanel.add((Component)this.m_leftHandSideTextField, gridBagConstraints);
        this.m_returnValueLabel.setLabelFor(this.m_leftHandSideTextField);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 2, 5);
        this.m_returnDataTypeLabel = new JLabel(StringUtils.stripMnemonic((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_SPECIFY_RETURN_DATA_TYPE_LABEL")));
        this.m_returnDataTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.getString("DATA_SECURITY_OLAP_DML_SPECIFY_RETURN_DATA_TYPE_LABEL")));
        jPanel.add((Component)this.m_returnDataTypeLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.m_dataTypeComboBox = new JComboBox();
        this.m_dataTypeComboBox.addItem("NUMBER");
        this.m_dataTypeComboBox.addItem("VARCHAR2");
        this.m_dataTypeComboBox.setSelectedItem("NUMBER");
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        jPanel.add((Component)this.m_dataTypeComboBox, gridBagConstraints);
        this.m_returnDataTypeLabel.setLabelFor(this.m_dataTypeComboBox);
        ++gridBagConstraints.gridy;
        this.m_reviewExpressionTextArea = new JTextArea(5, 1);
        this.m_reviewExpressionTextArea.setMinimumSize(new Dimension(400, 100));
        this.m_reviewExpressionTextArea.setLineWrap(true);
        this.m_reviewExpressionTextArea.setWrapStyleWord(true);
        this.m_reviewExpressionTextArea.setEditable(false);
        gridBagConstraints.insets = new Insets(10, 0, 2, 5);
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.m_reviewExpressionTextArea);
        jPanel.add((Component)new JLabel(OLAPArb.getString("DATA_SECURITY_OLAP_DML_VIEW_DML_EXPRESSION_LABEL")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(new JPanel(), gridBagConstraints);
        this.m_rightHandSideTextArea.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DMLDataSecurityPanel.this.m_reviewExpressionTextArea.setText(DMLDataSecurityPanel.this.m_leftHandSideTextField.getText() + DMLDataSecurityPanel.this.m_currentCompOperator + "OLAP_DML_EXPRESSION(" + DMLDataSecurityPanel.wrapWithEscapedSingleQuotes(DMLDataSecurityPanel.this.m_rightHandSideTextArea.getText()) + ", " + DMLDataSecurityPanel.this.m_currentDataType + ")");
                String string = DMLDataSecurityPanel.this.getTextAreaText();
                if (DMLDataSecurityPanel.this.m_initialEnumRule != null ? !DMLDataSecurityPanel.this.m_initialEnumRule.equalsIgnoreCase(string) && !DMLDataSecurityPanel.this.m_isInitializing : string == null || !DMLDataSecurityPanel.this.m_isInitializing) {
                    // empty if block
                }
            }
        });
        this.m_leftHandSideTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DMLDataSecurityPanel.this.m_reviewExpressionTextArea.setText(DMLDataSecurityPanel.this.m_leftHandSideTextField.getText() + DMLDataSecurityPanel.this.m_currentCompOperator + "OLAP_DML_EXPRESSION(" + DMLDataSecurityPanel.wrapWithEscapedSingleQuotes(DMLDataSecurityPanel.this.m_rightHandSideTextArea.getText()) + ", " + DMLDataSecurityPanel.this.m_currentDataType + ")");
                String string = DMLDataSecurityPanel.this.getTextAreaText();
                if (DMLDataSecurityPanel.this.m_initialEnumRule != null ? !DMLDataSecurityPanel.this.m_initialEnumRule.equalsIgnoreCase(string) && !DMLDataSecurityPanel.this.m_isInitializing : string == null || !DMLDataSecurityPanel.this.m_isInitializing) {
                    // empty if block
                }
            }
        });
        this.m_dataTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DMLDataSecurityPanel.this.m_currentDataType = (String)DMLDataSecurityPanel.this.m_dataTypeComboBox.getSelectedItem();
                if (DMLDataSecurityPanel.this.m_currentDataType.equalsIgnoreCase("VARCHAR2")) {
                    if (DMLDataSecurityPanel.this.m_compOperatorComboBox.getItemCount() == 6) {
                        DMLDataSecurityPanel.this.m_isModifying = true;
                        DMLDataSecurityPanel.this.m_compOperatorComboBox.removeItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_LITERAL"));
                        DMLDataSecurityPanel.this.m_compOperatorComboBox.removeItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_LITERAL"));
                        DMLDataSecurityPanel.this.m_compOperatorComboBox.removeItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_EQUALS_LITERAL"));
                        DMLDataSecurityPanel.this.m_compOperatorComboBox.removeItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_EQUALS_LITERAL"));
                        DMLDataSecurityPanel.this.m_isModifying = false;
                        if (DMLDataSecurityPanel.this.m_currentCompOperator.equalsIgnoreCase(">") || DMLDataSecurityPanel.this.m_currentCompOperator.equalsIgnoreCase("<") || DMLDataSecurityPanel.this.m_currentCompOperator.equalsIgnoreCase(">=") || DMLDataSecurityPanel.this.m_currentCompOperator.equalsIgnoreCase("<=")) {
                            DMLDataSecurityPanel.this.m_currentCompOperator = "=";
                            DMLDataSecurityPanel.this.m_compOperatorComboBox.setSelectedItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_EQUALS_LITERAL"));
                        }
                    }
                } else if (DMLDataSecurityPanel.this.m_compOperatorComboBox.getItemCount() == 2) {
                    DMLDataSecurityPanel.this.m_isModifying = true;
                    DMLDataSecurityPanel.this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_LITERAL"));
                    DMLDataSecurityPanel.this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_LITERAL"));
                    DMLDataSecurityPanel.this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_EQUALS_LITERAL"));
                    DMLDataSecurityPanel.this.m_compOperatorComboBox.addItem(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_EQUALS_LITERAL"));
                    DMLDataSecurityPanel.this.m_isModifying = false;
                }
                DMLDataSecurityPanel.this.m_reviewExpressionTextArea.setText(DMLDataSecurityPanel.this.m_leftHandSideTextField.getText() + DMLDataSecurityPanel.this.m_currentCompOperator + "OLAP_DML_EXPRESSION(" + DMLDataSecurityPanel.wrapWithEscapedSingleQuotes(DMLDataSecurityPanel.this.m_rightHandSideTextArea.getText()) + ", " + DMLDataSecurityPanel.this.m_currentDataType + ")");
                if (!DMLDataSecurityPanel.this.m_isInitializing) {
                    // empty if block
                }
            }
        });
        this.m_compOperatorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DMLDataSecurityPanel.this.m_isModifying) {
                    return;
                }
                String string = (String)DMLDataSecurityPanel.this.m_compOperatorComboBox.getSelectedItem();
                if (string.equalsIgnoreCase(OLAPArb.getString("DATA_SECURITY_OLAP_DML_EQUALS_LITERAL"))) {
                    DMLDataSecurityPanel.this.m_currentCompOperator = "=";
                } else if (string.equalsIgnoreCase(OLAPArb.getString("DATA_SECURITY_OLAP_DML_NOT_EQUALS_LITERAL"))) {
                    DMLDataSecurityPanel.this.m_currentCompOperator = "!=";
                } else if (string.equalsIgnoreCase(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_LITERAL"))) {
                    DMLDataSecurityPanel.this.m_currentCompOperator = ">";
                } else if (string.equalsIgnoreCase(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_LITERAL"))) {
                    DMLDataSecurityPanel.this.m_currentCompOperator = "<";
                } else if (string.equalsIgnoreCase(OLAPArb.getString("DATA_SECURITY_OLAP_DML_GREATER_THAN_EQUALS_LITERAL"))) {
                    DMLDataSecurityPanel.this.m_currentCompOperator = ">=";
                } else if (string.equalsIgnoreCase(OLAPArb.getString("DATA_SECURITY_OLAP_DML_LESS_THAN_EQUALS_LITERAL"))) {
                    DMLDataSecurityPanel.this.m_currentCompOperator = "<=";
                }
                DMLDataSecurityPanel.this.m_reviewExpressionTextArea.setText(DMLDataSecurityPanel.this.m_leftHandSideTextField.getText() + DMLDataSecurityPanel.this.m_currentCompOperator + "OLAP_DML_EXPRESSION(" + DMLDataSecurityPanel.wrapWithEscapedSingleQuotes(DMLDataSecurityPanel.this.m_rightHandSideTextArea.getText()) + ", " + DMLDataSecurityPanel.this.m_currentDataType + ")");
                if (!DMLDataSecurityPanel.this.m_isInitializing) {
                    // empty if block
                }
            }
        });
        this.m_compileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DMLDataSecurityPanel.this.compileExpression(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compileExpression(boolean bl) {
        boolean bl2 = true;
        String string = this.realmConstraint.getSchema().getName();
        String string2 = this.realmConstraint.getAnalyticWorkspace();
        String string3 = this.m_currentDataType;
        String string4 = DMLDataSecurityPanel.getRightHandSideExpression(this.getTextAreaText());
        String string5 = string + '.' + string2;
        try {
            DatabaseUtils.ExecuteSPL(this.connection, "aw attach " + string5);
        }
        catch (Exception exception) {
            DBMessageDialog.showErrorDialog((Exception)exception, (Object)this.realmConstraint, (Level)Level.ALL);
        }
        string4 = DMLDataSecurityPanel.unwrapWithoutEscapedSingleQuotes(string4);
        try {
            String string6 = "__AWM_TEMP_FORMULA";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("define ");
            stringBuffer.append(string5);
            stringBuffer.append("!");
            stringBuffer.append(string6);
            stringBuffer.append(" formula ");
            stringBuffer.append(string3);
            stringBuffer.append("\n");
            stringBuffer.append("eq ");
            stringBuffer.append(string4);
            DMLObject dMLObject = new DMLObject(this.connection, string5, string6, stringBuffer.toString());
            if (dMLObject.isExists()) {
                dMLObject.drop();
            }
            dMLObject.create();
            String string7 = dMLObject.compile();
            if (string7.length() > 0) {
                string7 = string7.replaceAll(string2 + "!" + string6, OLAPArb.getString("DATA_SECURITY_OLAP_DML_COMMAND_LABEL"));
                DBMessageDialog.showErrorDialog((String)string7, (Object)this.realmConstraint, (Level)Level.ALL);
                bl2 = false;
            } else {
                if (bl) {
                    String string8 = OLAPArb.getString("DATA_SECURITY_OLAP_DML_EXPRESSION_COMPILE_SUCCCESS_DIALOG_TITLE");
                    String string9 = OLAPArb.getString("DATA_SECURITY_OLAP_DML_EXPRESSION_COMPILE_SUCCCESS");
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string9, (String)string8, null);
                }
                bl2 = true;
            }
        }
        catch (SQLException sQLException) {
            DBMessageDialog.showErrorDialog((Exception)sQLException, (Object)this.realmConstraint, (Level)Level.ALL);
            boolean bl3 = false;
            return bl3;
        }
        catch (IOException iOException) {
            DBMessageDialog.showErrorDialog((Exception)iOException, (Object)this.realmConstraint, (Level)Level.ALL);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                DatabaseUtils.ExecuteSPL(this.connection, "aw detach " + string5);
                DatabaseUtils.ExecuteSPL(this.connection, "aw attach " + string5 + " rw first");
                this.connection.rollback();
                this.grabFocus();
            }
            catch (Exception exception) {
                this.LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        return bl2;
    }

    public String getTextAreaText() {
        if (this.m_currentDataType.equalsIgnoreCase("VARCHAR2")) {
            return DMLDataSecurityPanel.wrapOutsideOnlyWithSingleQuotes(this.m_leftHandSideTextField.getText()) + this.m_currentCompOperator + "OLAP_DML_EXPRESSION(" + DMLDataSecurityPanel.wrapWithEscapedSingleQuotes(this.m_rightHandSideTextArea.getText()) + ", " + this.m_currentDataType + ")";
        }
        return this.m_leftHandSideTextField.getText() + this.m_currentCompOperator + "OLAP_DML_EXPRESSION(" + DMLDataSecurityPanel.wrapWithEscapedSingleQuotes(this.m_rightHandSideTextArea.getText()) + ", " + this.m_currentDataType + ")";
    }

    public void resetTextArea() {
        this.m_leftHandSideTextField.setText("");
        this.m_rightHandSideTextArea.setText("");
        this.m_currentCompOperator = "=";
        this.m_currentDataType = "NUMBER";
        this.m_reviewExpressionTextArea.setText(this.getTextAreaText());
        this.m_initialEnumRule = this.getTextAreaText();
    }

    private static String getLeftHandSideExpression(String string) {
        int n = -1;
        if (string.indexOf("!=") > -1) {
            n = string.indexOf("!=");
            return string.substring(0, n);
        }
        if (string.indexOf("<=") > -1) {
            n = string.indexOf("<=");
            return string.substring(0, n);
        }
        if (string.indexOf("<") > -1) {
            n = string.indexOf("<");
            return string.substring(0, n);
        }
        if (string.indexOf(">=") > -1) {
            n = string.indexOf(">=");
            return string.substring(0, n);
        }
        if (string.indexOf(">") > -1) {
            n = string.indexOf(">");
            return string.substring(0, n);
        }
        if (string.indexOf("=") > -1) {
            n = string.indexOf("=");
            return string.substring(0, n);
        }
        return string;
    }

    private static String getComparisonOperator(String string) {
        if (string.indexOf("!=") > -1) {
            return "!=";
        }
        if (string.indexOf("<=") > -1) {
            return "<=";
        }
        if (string.indexOf("<") > -1) {
            return "<";
        }
        if (string.indexOf(">=") > -1) {
            return ">=";
        }
        if (string.indexOf(">") > -1) {
            return ">";
        }
        if (string.indexOf("=") > -1) {
            return "=";
        }
        return "=";
    }

    private static String getRightHandSideExpression(String string) {
        String string2 = string;
        int n = -1;
        n = string.indexOf("OLAP_DML_EXPRESSION(");
        if (n > -1) {
            int n2 = n + 20;
            int n3 = string.lastIndexOf(",");
            string2 = string.substring(n2, n3);
        }
        return string2;
    }

    private static String getDataTypeOfExpression(String string) {
        int n = string.lastIndexOf(",");
        return string.substring(n + 2, string.length() - 1);
    }

    private static String wrapOutsideOnlyWithSingleQuotes(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "''";
        }
        if (!string.substring(0, 1).equals("'")) {
            string = "'" + string;
        }
        if (!string.substring((n = string.length()) - 1, n).equals("'")) {
            string = string + "'";
        }
        return string;
    }

    private static String wrapWithEscapedSingleQuotes(String string) {
        if (string == null || string.length() == 0) {
            return "''";
        }
        string = string.replaceAll("'", "''");
        string = "'" + string + "'";
        return string;
    }

    private static String unwrapWithoutEscapedSingleQuotes(String string) {
        int n;
        if (string == null || string.length() <= 1) {
            return string;
        }
        if (string.substring(0, 1).equals("'")) {
            string = string.substring(1);
        }
        if (string.substring((n = string.length()) - 1, n).equals("'")) {
            string = n > 1 ? string.substring(0, n - 1) : null;
        }
        if (string != null && string.length() > 0) {
            string = string.replaceAll("''", "'");
        }
        return string;
    }

    private void enableComponents() {
        RealmConstraint realmConstraint = (RealmConstraint)this.getUpdatedObject();
        boolean bl = realmConstraint.getRealmConditionType().equals("DML_SELECTION_TYPE");
        if (bl != this.enabled) {
            for (Component component : this.getComponents((Component)((Object)this))) {
                component.setEnabled(bl);
            }
            this.enabled = bl;
        }
    }

    private Component[] getComponents(Component component) {
        ArrayList<Object> arrayList = null;
        try {
            arrayList = new ArrayList<Component>(Arrays.asList(((Container)component).getComponents()));
            for (int i = 0; i < arrayList.size(); ++i) {
                for (Component component2 : this.getComponents((Component)arrayList.get(i))) {
                    arrayList.add(component2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            arrayList = new ArrayList();
        }
        return arrayList.toArray(new Component[arrayList.size()]);
    }

    public void setData(RealmConstraint realmConstraint) {
        String string = this.m_reviewExpressionTextArea.getText();
        realmConstraint.setRealmCondition(string);
    }

    protected void commitPanel() throws TraversalException {
        if (this.enabled) {
            RealmConstraint realmConstraint = (RealmConstraint)this.getUpdatedObject();
            this.setData(realmConstraint);
        }
    }
}

