/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.measure;

import java.util.ArrayList;
import oracle.olap.app.olapmetadata.Measure;

public class MeasureSelectorNode {
    private ArrayList<Object> children;
    private String name;
    private String type;
    private Measure measure;
    private boolean selected;
    private ArrayList<Measure> measures;
    public static String CUBE_FOLDER = "CUBE_FOLDER";
    public static String CUBE = "CUBE";
    public static String MEASURE_FOLDER = "MEASURE_FOLDER";
    public static String DERIVED_FOLDER = "DERIVED_FOLDER";
    public static String MEASURE = "MEASURE";
    public static String DERIVED_MEASURE = "DERIVED_MEASURE";

    public MeasureSelectorNode() {
    }

    public MeasureSelectorNode(String string, String string2) {
        this.name = string;
        this.type = string2;
        this.children = new ArrayList();
        this.measures = new ArrayList();
    }

    public MeasureSelectorNode(Measure measure) {
        this.measure = measure;
        this.children = new ArrayList();
    }

    public String toString() {
        if (this.measure != null) {
            return this.measure.getName();
        }
        return this.name;
    }

    protected Object[] getChildren() {
        return this.children.toArray();
    }

    protected boolean isParent() {
        return this.children.size() <= 0;
    }

    protected MeasureSelectorNode addMeasureNode(String string, String string2) {
        MeasureSelectorNode measureSelectorNode = new MeasureSelectorNode(string, string2);
        this.children.add(measureSelectorNode);
        return measureSelectorNode;
    }

    protected MeasureSelectorNode addMeasureNode(Measure measure) {
        MeasureSelectorNode measureSelectorNode = new MeasureSelectorNode(measure);
        this.children.add(measureSelectorNode);
        return measureSelectorNode;
    }

    public String getName() {
        if (this.measure != null) {
            return this.measure.getName();
        }
        return this.name;
    }

    public String getDescription() {
        if (this.measure != null) {
            return this.measure.getDescription();
        }
        return "";
    }

    public String getExpression() {
        if (this.measure != null) {
            return this.measure.getExpression();
        }
        return "";
    }

    public String getType() {
        if (this.measure != null) {
            if (this.measure.isDerived()) {
                return DERIVED_MEASURE;
            }
            return MEASURE;
        }
        return this.type;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public void addMeasure(Measure measure) {
        this.measures.add(measure);
    }

    public ArrayList<Measure> getMeasures() {
        return this.measures;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

