/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.map.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.olap.OLAPArb;
import oracle.olap.map.panels.SourceValidationController;
import oracle.olap.map.panels.SourceValidator;

public class SourceTextField
extends JTextField {
    private boolean currentlyInvalid;
    private SourceValidationController controller;
    private Timer timer;
    private SourceValidator sourceValidator;
    private boolean sourceActionPeformed;
    private static final String SOURCE_ACTION = "SOURCE_ACTION";

    public SourceTextField(SourceValidator sourceValidator, final Action action) {
        this.sourceValidator = sourceValidator;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SourceTextField.this.validateText();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SourceTextField.this.validateText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SourceTextField.this.validateText();
            }
        });
        boolean bl = true;
        if (bl) {
            this.controller = new SourceValidationController(this);
            this.controller.setyOffset(20);
            this.controller.setXOffset(-120);
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceTextField.this.sourceActionPeformed = true;
                action.actionPerformed(actionEvent);
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 128), SOURCE_ACTION);
        this.getActionMap().put(SOURCE_ACTION, action);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (!keyEvent.isControlDown() && n == 10) {
                    keyEvent.consume();
                }
            }
        });
    }

    public void setSourceActionPeformed(boolean bl) {
        this.sourceActionPeformed = bl;
    }

    public void validateText() {
        if (this.currentlyInvalid) {
            this.showValidationMessage(this.getValidationMessage());
        } else if (!this.sourceActionPeformed) {
            this.controller.showTooltip(OLAPArb.get("MAP_PANEL_MAP_SOURCE_SHORTCUT_MSG"), null);
        }
        this.getTimer().restart();
    }

    protected void showValidationMessage(String string) {
        if (this.controller != null) {
            this.controller.showError(string);
        }
    }

    public void hidePopup() {
        if (this.controller != null) {
            this.controller.hidePopup();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.controller != null) {
            this.controller.hidePopup();
        }
        super.setEnabled(bl);
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SourceTextField.this.getValidationMessage();
                    if (string != null) {
                        SourceTextField.this.showValidationMessage(string);
                    }
                }
            };
            this.timer = new Timer(1500, actionListener);
            this.timer.setRepeats(false);
        }
        return this.timer;
    }

    private String getValidationMessage() {
        this.currentlyInvalid = true;
        this.getTimer().stop();
        String string = this.getText();
        String string2 = this.sourceValidator.validateSource(string);
        if (string2 == null) {
            this.currentlyInvalid = false;
        }
        return string2;
    }
}

