/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.tree.loader.TreeLoaderBreadthFirst;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.app.tree.model.Tree;

public class DimensionLoader
extends TreeLoaderBreadthFirst {
    protected DBUtil dbUtil;
    protected Connection connection;
    protected String etViewName;
    private Dimension dimension;
    String column = null;
    boolean useDescription = false;

    public DimensionLoader(Connection connection, Dimension dimension) throws SQLException {
        this(connection, dimension.getViewName());
        this.dimension = dimension;
    }

    protected DimensionLoader(Connection connection, String string) throws SQLException {
        super(new Tree());
        this.dbUtil = DBUtil.getInstance((Connection)connection);
        this.etViewName = string;
        this.connection = connection;
        this.getTree().setTreeLoader(this);
    }

    String checkAttributes() throws SQLException, IOException {
        String string = null;
        string = this.dimension.getLongDescriptionColumnName();
        if (string == null) {
            string = this.dimension.getShortDescriptionColumnName();
        }
        return string;
    }

    public String getETViewName() {
        return this.etViewName;
    }

    @Override
    public void loadData() throws SQLException, IOException {
        this.column = this.checkAttributes();
        if (this.column != null) {
            this.useDescription = true;
        }
        this.loadDataSynch(this.etViewName);
    }

    private void loadDataSynch(String string) throws SQLException {
        this.setLoadingState(true);
        String string2 = null;
        string2 = this.useDescription ? "select dim_key key, " + this.column + " description from " + string : "select dim_key key from " + string;
        string2 = string2 + " order by dim_order";
        this.loadTree(string2);
        this.setLoadingState(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadTree(String string) throws SQLException {
        ResultSet resultSet;
        block9: {
            block8: {
                Map map = null;
                resultSet = null;
                try {
                    Connections.getInstance().lock(this.connection);
                    resultSet = this.dbUtil.executeQuery(string, map);
                    resultSet.setFetchSize(3000);
                    int n = -1;
                    int n2 = 0;
                    while (resultSet.next()) {
                        HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
                        hierarchyNodeData.dimKey = resultSet.getString("key");
                        if (this.useDescription) {
                            hierarchyNodeData.desc = resultSet.getString("description");
                        }
                        this.load(hierarchyNodeData, hierarchyNodeData, n2);
                        if (n2 != n) {
                            this.setFinishedLoadingDepth(n);
                            n = n2;
                        }
                        if (!this.isStopLoadingData()) continue;
                        break block8;
                    }
                    break block9;
                }
                catch (SQLException sQLException) {
                    try {
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(this.connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.connection);
            return;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(this.connection);
    }
}

