/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor.language;

import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.parser.plsql.PlsqlTokens;
import oracle.javatools.parser.plsql.SqlKeywords;
import oracle.olap.OLAPArb;

public final class OLAPDMLStyles {
    public static final String OLAPDML_COMMENT_STYLE = "olapdml-comment-style";
    public static final String OLAPDML_KEYWORD_STYLE = "olapdml-keyword-style";
    public static final String OLAPDML_IDENTIFIER_STYLE = "olapdml-identifier-style";
    public static final String OLAPDML_STRING_STYLE = "olapdml-string-style";
    public static final String OLAPDML_NUMBER_STYLE = "olapdml-number-style";
    public static final String OLAPDML_BRACE_STYLE = "olapdml-brace-style";
    public static final String OLAPDML_OPERATOR_STYLE = "olapdml-operator-style";
    public static final String OLAPDML_ERROR_HIGHLIGHT_STYLE = "olapdml-error-highlight-style";
    public static final String OLAPDML_WARNING_HIGHLIGHT_STYLE = "olapdml-warning-highlight-style";
    public static final String OLAPDML_FATAL_HIGHLIGHT_STYLE = "olapdml-fatal-highlight-style";
    public static final String[] STYLE_NAMES = new String[]{"olapdml-comment-style", "olapdml-keyword-style", "olapdml-identifier-style", "olapdml-string-style", "olapdml-number-style", "olapdml-brace-style", "olapdml-operator-style"};
    public static BaseStyle olapdmlPlainStyle;
    public static BaseStyle olapdmlCommentStyle;
    public static BaseStyle olapdmlKeywordStyle;
    public static BaseStyle olapdmlIdentifierStyle;
    public static BaseStyle olapdmlStringStyle;
    public static BaseStyle olapdmlNumberStyle;
    public static BaseStyle olapdmlBraceStyle;
    public static BaseStyle olapdmlOperatorStyle;

    public OLAPDMLStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String string;
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        olapdmlPlainStyle = builtInStyles.plainStyle;
        olapdmlCommentStyle = styleRegistry.lookupStyle(OLAPDML_COMMENT_STYLE);
        if (olapdmlCommentStyle == null) {
            string = OLAPArb.getString("OLAPDML_COMMENT_STYLE");
            olapdmlCommentStyle = styleRegistry.createStyle(OLAPDML_COMMENT_STYLE, string, "base-comment-style");
        }
        if ((olapdmlStringStyle = styleRegistry.lookupStyle(OLAPDML_STRING_STYLE)) == null) {
            string = OLAPArb.getString("OLAPDML_STRING_STYLE");
            olapdmlStringStyle = styleRegistry.createStyle(OLAPDML_STRING_STYLE, string, "base-string-style");
        }
        if ((olapdmlKeywordStyle = styleRegistry.lookupStyle(OLAPDML_KEYWORD_STYLE)) == null) {
            string = OLAPArb.getString("OLAPDML_KEYWORD_STYLE");
            olapdmlKeywordStyle = styleRegistry.createStyle(OLAPDML_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((olapdmlIdentifierStyle = styleRegistry.lookupStyle(OLAPDML_IDENTIFIER_STYLE)) == null) {
            string = OLAPArb.getString("OLAPDML_IDENTIFIER_STYLE");
            olapdmlIdentifierStyle = styleRegistry.createStyle(OLAPDML_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((olapdmlNumberStyle = styleRegistry.lookupStyle(OLAPDML_NUMBER_STYLE)) == null) {
            string = OLAPArb.getString("OLAPDML_NUMBER_STYLE");
            olapdmlNumberStyle = styleRegistry.createStyle(OLAPDML_NUMBER_STYLE, string, "base-number-style");
        }
        if ((olapdmlBraceStyle = styleRegistry.lookupStyle(OLAPDML_BRACE_STYLE)) == null) {
            string = OLAPArb.getString("OLAPDML_BRACE_STYLE");
            olapdmlBraceStyle = styleRegistry.createStyle(OLAPDML_BRACE_STYLE, string, "base-brace-style");
        }
        if ((olapdmlOperatorStyle = styleRegistry.lookupStyle(OLAPDML_OPERATOR_STYLE)) == null) {
            string = OLAPArb.getString("OLAPDML_OPERATOR_STYLE");
            olapdmlOperatorStyle = styleRegistry.createStyle(OLAPDML_OPERATOR_STYLE, string, "base-operator-style");
        }
    }

    public static String highlightSyntax(String string) {
        List list = LexerToken.parse((String)string, (boolean)true, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (LexerToken lexerToken : list) {
            if (lexerToken.type == Token.IDENTIFIER && OLAPDMLStyles.isKeyword(lexerToken.content)) {
                stringBuilder.append(OLAPDMLStyles.sugarcoat(lexerToken.content));
                continue;
            }
            stringBuilder.append(lexerToken.content);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String sugarcoat(String string) {
        return "<font color=#005577><b>" + string + "</b></font>";
    }

    public static boolean isKeyword(String string) {
        for (String string2 : SqlKeywords.KW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : SqlKeywords.DW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : PlsqlTokens.KW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

