/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml;

import java.sql.Connection;
import oracle.olap.dml.DMLObject;

public class DMLProgram
extends DMLObject {
    public static String[] RETURN_DATATYPES = new String[]{"BOOLEAN", "DATE", "DATETIME", "DAY", "DECIMAL", "ID", "INTEGER", "LONGINTEGER", "MONTH", "NTEXT", "NUMBER", "SHORTINTEGER", "SHORT", "QUARTER", "TEXT", "WEEK", "YEAR"};
    public static final String TYPE = "OLAPDMLPROGRAM";
    private String dataType = "";
    private String dimension = "";
    private String body = "";
    private String name = "";
    private String description = "";
    private String awName = "";
    private String owner = "";

    public DMLProgram(Connection connection, String string, String string2, String string3) {
        super(connection, string2, string3);
        this.owner = string;
        this.awName = string2;
        this.name = string3;
    }

    public String getObjectSpecificCreateCommands() {
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("define ").append(this.getName()).append(" program ");
        if (this.getDataType().length() > 0) {
            stringBuffer.append(this.getDataType()).append(" ");
        } else if (this.getDimension().length() > 0) {
            stringBuffer.append(String.format("%s.%s!", this.owner, this.awName));
            stringBuffer.append(this.getDimension()).append(" ");
        }
        stringBuffer.append(";");
        if (this.getBody().length() > 0) {
            stringBuffer.append(String.format("program;%s;end;", this.getBody()));
        }
        return stringBuffer.toString();
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDimension(String string) {
        this.dimension = string;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getBody() {
        return this.body;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        String string = DMLProgram.removeContChar(this.description);
        return string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getAWName() {
        return this.awName;
    }

    public static String removeContChar(String string) {
        String string2 = string;
        while (string2.endsWith("-") || string2.endsWith(" ")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

