/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.olap.app.tree.loader.TreeLoaderXML;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.NodeXMLData;
import oracle.olap.app.tree.model.Tree;
import oracle.olap.app.tree.model.TreeTable;
import oracle.olap.app.tree.xmleditor.NodeFold;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescriptionPanelTreeLoaderXML
extends TreeLoaderXML {
    private Map<String, StringBuffer> translations;

    public DescriptionPanelTreeLoaderXML(Document document) {
        super(document);
        this.initObjects();
    }

    public DescriptionPanelTreeLoaderXML(String string) throws Exception {
        super(string);
        this.initObjects();
    }

    public DescriptionPanelTreeLoaderXML(String string, Class clazz, String string2, List<String> list) throws Exception {
        super(string, clazz, string2, list);
        this.initObjects();
    }

    private void initObjects() {
        this.translations = new HashMap<String, StringBuffer>();
    }

    @Override
    protected void loadNode(Node node, oracle.olap.app.tree.model.Node node2) {
        if (node.getNodeName().equalsIgnoreCase("LANGUAGEDESCRIPTION")) {
            return;
        }
        super.loadNode(node, node2);
    }

    @Override
    protected void loadNodeAttributes(Node node, oracle.olap.app.tree.model.Node node2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = node.getNodeName();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Object object;
                Node node3 = namedNodeMap.item(i);
                String string2 = node3.getNodeName();
                String string3 = DescriptionPanelTreeLoaderXML.getNodePath(node3);
                if (this.getXMLEditor() != null) {
                    boolean bl = false;
                    for (NodeFold nodeFold : this.getXMLEditor().getNodeFolds()) {
                        if (!nodeFold.getNode().equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                }
                String string4 = node3.getNodeValue();
                NodeXMLData nodeXMLData = (NodeXMLData)node2.getUserObject();
                if (!nodeXMLData.getName().equals(string)) {
                    string2 = string + "/" + string2;
                }
                NodeXMLData nodeXMLData2 = new NodeXMLData(string2, string4);
                NodeList nodeList = node.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    object = nodeList.item(j).getAttributes();
                    if (object == null) continue;
                    int n = -1;
                    for (int k = 0; k < object.getLength(); ++k) {
                        Node node4 = object.item(k);
                        if (node4.getNodeName().equalsIgnoreCase("language")) {
                            n = this.getLanguageColumn(node4.getNodeValue());
                            continue;
                        }
                        if (string2.indexOf(node4.getNodeName()) <= -1 || n <= -1) continue;
                        nodeXMLData2.setData(n, node4.getNodeValue());
                    }
                }
                DefaultNode defaultNode = new DefaultNode(this.getTree(), node2, nodeXMLData2);
                object = this.getDisplayName(node3);
                nodeXMLData2.setDisplayName(this.getResources().getXLIFFResource(this.getTranslationKey(), (String)object));
            }
        }
    }

    private int getLanguageColumn(String string) {
        if (this.getTree() instanceof TreeTable) {
            TreeTable treeTable = (TreeTable)this.getTree();
            for (int i = 0; i < treeTable.getColumnCount(); ++i) {
                if (!string.equalsIgnoreCase(treeTable.getColumnName(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected void generateXML(oracle.olap.app.tree.model.Node node, Tree tree) {
        CharSequence charSequence;
        String string;
        int n;
        Object object;
        NodeXMLData nodeXMLData;
        TreeTable treeTable = null;
        if (tree instanceof TreeTable) {
            treeTable = (TreeTable)tree;
        }
        if (!(nodeXMLData = (NodeXMLData)node.getUserObject()).isAttribute()) {
            this.openNonAttributeTag(nodeXMLData);
        } else {
            boolean bl = this.unfold(node, true);
            if (!bl) {
                CharSequence charSequence2;
                object = nodeXMLData.getData(0).toString();
                n = ((String)object).indexOf("/");
                if (n != -1) {
                    this.setDepth(this.getDepth() + 1);
                    string = ((String)object).substring(0, n);
                    object = nodeXMLData.getName().substring(n + 1, ((String)object).length());
                    DescriptionPanelTreeLoaderXML.append(this.getXMLBuffer(), " ", this.getDepth());
                    String string2 = DescriptionPanelTreeLoaderXML.getLastNodeName(this.getXMLBuffer());
                    if (!string.equals(string2)) {
                        this.getXMLBuffer().append("<" + string + ">\n");
                        if (treeTable != null && treeTable.getColumnCount() > 2) {
                            for (int i = 2; i < treeTable.getColumnCount(); ++i) {
                                StringBuffer stringBuffer;
                                charSequence = treeTable.getColumnName(i);
                                if (!this.translations.containsKey(charSequence)) {
                                    stringBuffer = new StringBuffer();
                                    stringBuffer.append(String.format("<%s language=\"%s\" >", string, charSequence));
                                    this.translations.put((String)charSequence, stringBuffer);
                                    continue;
                                }
                                stringBuffer = this.translations.get(charSequence);
                                stringBuffer.append(String.format("<%s language=\"%s\" >", string, charSequence));
                            }
                        }
                        this.getNodeNameList().add(string);
                    } else {
                        String string3 = "</" + string2 + ">";
                        charSequence = this.getXMLBuffer();
                        if (((StringBuffer)charSequence).toString().trim().endsWith(string3)) {
                            charSequence = new StringBuffer(((StringBuffer)charSequence).toString().trim());
                            ((StringBuffer)charSequence).delete(((StringBuffer)charSequence).length() - string3.length(), ((StringBuffer)charSequence).length());
                            charSequence = new StringBuffer(((StringBuffer)charSequence).toString().trim());
                            ((StringBuffer)charSequence).append("\n");
                            this.setXMLBuffer((StringBuffer)charSequence);
                            this.getNodeNameList().remove(string2);
                        }
                        if (treeTable != null && treeTable.getColumnCount() > 2) {
                            for (int i = 2; i < treeTable.getColumnCount(); ++i) {
                                String string4 = treeTable.getColumnName(i);
                                charSequence2 = this.translations.get(string4);
                                if (!((StringBuffer)charSequence2).toString().trim().endsWith(string3)) continue;
                                charSequence2 = new StringBuffer(((StringBuffer)charSequence2).toString().trim());
                                ((StringBuffer)charSequence2).delete(((StringBuffer)charSequence2).length() - string3.length(), ((StringBuffer)charSequence2).length());
                                charSequence2 = new StringBuffer(((StringBuffer)charSequence2).toString().trim());
                                ((StringBuffer)charSequence2).append("\n");
                                this.translations.put(string4, (StringBuffer)charSequence2);
                            }
                        }
                    }
                }
                this.getXMLBuffer().delete(this.getXMLBuffer().length() - 2, this.getXMLBuffer().length());
                string = nodeXMLData.getData(1).toString();
                this.getXMLBuffer().append(" " + (String)object + "=\"" + string + "\">\n");
                if (treeTable != null && treeTable.getColumnCount() > 2) {
                    for (int i = 2; i < treeTable.getColumnCount(); ++i) {
                        String string5 = treeTable.getColumnName(i);
                        if (this.translations.containsKey(string5)) {
                            charSequence = String.format("</%s>", this.getNodeNameList().get(this.getNodeNameList().size() - 1));
                            StringBuffer stringBuffer = this.translations.get(string5);
                            boolean bl2 = false;
                            if (stringBuffer.toString().endsWith((String)charSequence)) {
                                stringBuffer = new StringBuffer(stringBuffer.toString().trim());
                                stringBuffer.delete(stringBuffer.length() - ((String)charSequence).length(), stringBuffer.length());
                                stringBuffer = new StringBuffer(stringBuffer.toString().trim());
                                bl2 = true;
                                this.translations.put(string5, stringBuffer);
                            }
                            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                            charSequence2 = nodeXMLData.getData(i).toString();
                            stringBuffer.append(" " + (String)object + "=\"" + (String)charSequence2 + "\" >");
                            if (!bl2) continue;
                            stringBuffer.append(String.format("</%s>", this.getNodeNameList().get(this.getNodeNameList().size() - 1)));
                            continue;
                        }
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append(String.format("<%s language=\"%s\" %s=\"%s\" ></%s>", this.getNodeNameList().get(this.getNodeNameList().size() - 1), string5, object, nodeXMLData.getData(i), this.getNodeNameList().get(this.getNodeNameList().size() - 1)));
                        this.translations.put(string5, (StringBuffer)charSequence);
                    }
                }
            }
        }
        List<oracle.olap.app.tree.model.Node> list = node.getChildren();
        object = list.iterator();
        while (object.hasNext()) {
            oracle.olap.app.tree.model.Node node2 = (oracle.olap.app.tree.model.Node)object.next();
            this.setDepth(this.getDepth() + 1);
            this.generateXML(node2, tree);
            this.setDepth(this.getDepth() - 1);
        }
        if (!nodeXMLData.isAttribute()) {
            this.closeNonAttributeTag(nodeXMLData);
        } else if (!this.unfold(node, false) && (n = ((String)(object = nodeXMLData.getData(0).toString())).indexOf("/")) != -1) {
            string = nodeXMLData.getName().substring(0, n);
            DescriptionPanelTreeLoaderXML.append(this.getXMLBuffer(), " ", this.getDepth());
            this.getXMLBuffer().append("</" + string + ">\n");
            if (treeTable != null && treeTable.getColumnCount() > 2) {
                for (int i = 2; i < treeTable.getColumnCount(); ++i) {
                    String string6 = treeTable.getColumnName(i);
                    charSequence = this.translations.get(string6);
                    ((StringBuffer)charSequence).append("</" + string + ">\n");
                }
            }
            this.getNodeNameList().remove(string);
            this.setDepth(this.getDepth() - 1);
        }
    }

    private void openNonAttributeTag(NodeXMLData nodeXMLData) {
        DescriptionPanelTreeLoaderXML.append(this.getXMLBuffer(), " ", this.getDepth());
        this.getXMLBuffer().append("<" + nodeXMLData.getName() + ">\n");
        this.getNodeNameList().add(nodeXMLData.getName());
    }

    private void closeNonAttributeTag(NodeXMLData nodeXMLData) {
        DescriptionPanelTreeLoaderXML.append(this.getXMLBuffer(), " ", this.getDepth());
        this.getXMLBuffer().append("</" + nodeXMLData.getName() + ">\n");
        this.getNodeNameList().remove(nodeXMLData.getName());
    }

    @Override
    protected boolean unfold(oracle.olap.app.tree.model.Node node, boolean bl) {
        NodeXMLData nodeXMLData = (NodeXMLData)node.getUserObject();
        if (this.getXMLEditor() != null) {
            String string = nodeXMLData.getData(0).toString();
            for (NodeFold nodeFold : this.getXMLEditor().getNodeFolds()) {
                if (!nodeFold.getNode().equals(string)) continue;
                String string2 = this.getLeafNodeName(string);
                if (bl) {
                    DescriptionPanelTreeLoaderXML.append(this.getXMLBuffer(), " ", this.getDepth());
                    this.getXMLBuffer().append("<" + string2);
                    String string3 = nodeXMLData.getData(1).toString();
                    String string4 = DescriptionPanelTreeLoaderXML.getLeafAttributeName(string);
                    this.getXMLBuffer().append(" " + string4 + "=\"" + string3 + "\">\n");
                    this.getNodeNameList().add(string2);
                } else {
                    Set<String> set = this.translations.keySet();
                    for (String string5 : set) {
                        this.getXMLBuffer().append(this.translations.get(string5));
                        this.translations.put(string5, new StringBuffer());
                    }
                    this.getXMLBuffer().append("</" + string2 + ">\n");
                    this.getNodeNameList().remove(string2);
                }
                return true;
            }
        }
        return false;
    }
}

