/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.table.CopyColumnPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.db.BaseCubeVerifier;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.DataTypeProperty;
import oracle.olap.db.view.ChildObjectEditorPanel2;
import oracle.olap.db.view.DBObjectInitializer;

public abstract class ChildListEditorPanel2<C extends AbstractChildObjectWithDesc, P extends AbstractSchemaObjectWithDesc>
extends ChildListEditorPanel<C, P> {
    private boolean m_initialized;
    private ChildObjectEditorPanel2<C, P> m_childPanel;
    private DBObjectInitializer dbObjectInitializer;
    private BaseCubeVerifier verifier;
    private static final String INITIALIZED = "INITIALIZED";

    public ChildListEditorPanel2(ChildObjectEditorPanel2<C, P> childObjectEditorPanel2, String string, boolean bl) {
        this.m_childPanel = childObjectEditorPanel2;
        if (bl) {
            Component[] componentArray = this.getComponents();
            JButton jButton = new JButton();
            jButton.setIcon(OracleIcons.getIcon((String)"copy.png"));
            Dimension dimension = new Dimension(28, 25);
            jButton.setPreferredSize(dimension);
            jButton.setMaximumSize(dimension);
            jButton.setMinimumSize(dimension);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChildListEditorPanel2.this.copyAction();
                }
            });
            jButton.setToolTipText(UIBundle.get((String)"COLUMN_INFO_TOOLTIP_COPY_COLS"));
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i].getName() == null || !componentArray[i].getName().equals("ChildListPanel") || !(componentArray[i] instanceof JPanel)) continue;
                JPanel jPanel = (JPanel)componentArray[i];
                jPanel.add((Component)jButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 5, 0, 0), 0, 0));
            }
        }
    }

    protected void setDbObjectInitializer(DBObjectInitializer dBObjectInitializer) {
        this.dbObjectInitializer = dBObjectInitializer;
    }

    protected final BaseCubeVerifier getVerifier() {
        Namespace namespace = this.getDataContext();
        if (namespace instanceof TraversableContext) {
            this.verifier = (BaseCubeVerifier)((Object)namespace.find("BaseCubeVerifier"));
        }
        return this.verifier;
    }

    protected void copyAction() {
        try {
            DataTypeProperty dataTypeProperty;
            String string;
            Object object3;
            Table table;
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setSkipValidation(true);
            this.commitPanel();
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setSkipValidation(false);
            boolean bl = this.isEditing();
            int n = 7;
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIBundle.format((String)"COPY_COLUMN_TITLE", (Object[])new Object[]{((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName()}), (int)n);
            AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)this.getUpdatedObject();
            String string2 = this.getChildProperty();
            final ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object2 = null;
            try {
                object2 = this.getPropertyHelper().getPropertyValueOrFail((Object)abstractSchemaObjectWithDesc, string2);
            }
            catch (MissingPropertyException missingPropertyException) {
                System.out.println((Object)missingPropertyException);
            }
            if (object2 != null && object2 instanceof DBObject[]) {
                table = (Table)object2;
                for (int i = 0; i < ((DBObject[])table).length; ++i) {
                    object3 = table[i];
                    string = null;
                    if (!(object3 instanceof DataTypeProperty)) continue;
                    dataTypeProperty = (DataTypeProperty)object3;
                    string = dataTypeProperty.getDataType();
                    arrayList.add(object3.getName());
                    hashMap.put(object3.getName(), string);
                }
            }
            table = new Table(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName(), ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema());
            for (Object object3 : hashMap.keySet()) {
                string = (String)hashMap.get(object3);
                dataTypeProperty = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema();
                DataTypeUsage dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.getProvider(), (Schema)dataTypeProperty, (String)string);
                Column column = new Column((String)object3, dataTypeUsage);
                table.addColumn(column);
            }
            final CopyColumnPanel copyColumnPanel = new CopyColumnPanel(this.getProvider(), (Relation)table, bl);
            jEWTDialog.setContent((Component)copyColumnPanel);
            object3 = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                        for (Column column : copyColumnPanel.getSelectedColumns()) {
                            String string3;
                            String string2 = null;
                            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                            for (String string3 : arrayList) {
                                defaultListModel.addElement(string3);
                            }
                            String string4 = ChildListEditorPanel2.this.processColumName(column.getName());
                            string2 = ChildListEditorPanel2.this.getUniqueName(string4, defaultListModel);
                            string3 = ChildListEditorPanel2.this.getDataTypeFromColumn(column);
                            if (string2 == null) continue;
                            ChildListEditorPanel2.this.addRelationalColumnToList(column, string2, string3);
                        }
                        if (copyColumnPanel.getSelectedColumns().size() > 0) {
                            ChildListEditorPanel2.this.initialisePanel();
                        }
                    }
                }
            };
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)object3);
            jEWTDialog.runDialog();
        }
        catch (TraversalException traversalException) {
            traversalException.showMessageDialog((Component)((Object)this));
        }
    }

    protected void listSelectionChanged() {
        super.listSelectionChanged();
    }

    public String processColumName(String string) {
        return string;
    }

    private String getDataTypeFromColumn(Column column) {
        String string = "VARCHAR2(256)";
        DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
        DBObjectID dBObjectID = dataTypeUsage.getDataTypeID();
        String string2 = null;
        if (dataTypeUsage.getAttributeValue("size") != null) {
            string2 = dataTypeUsage.getAttributeValue("size").toString();
        }
        if (string2 == null && dataTypeUsage.getAttributeValue("precision") != null) {
            string2 = dataTypeUsage.getAttributeValue("precision").toString();
        }
        String string3 = null;
        if (dataTypeUsage.getProperty("scale") != null) {
            string3 = dataTypeUsage.getProperty("scale").toString();
        }
        if (dBObjectID instanceof DataTypeID) {
            DataTypeID dataTypeID = (DataTypeID)dBObjectID;
            string = dataTypeID.getTypeName();
        }
        if (string2 != null) {
            string = string + "(" + string2 + ")";
        }
        if (string2 != null && string3 != null) {
            string = string + "(" + string2 + "," + string3 + ")";
        }
        return string;
    }

    public void addRelationalColumnToList(Column column, String string, String string2) {
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return this.m_childPanel;
    }

    protected void initialisePanel() {
        Object object = this.getDataContext().get(INITIALIZED);
        if (object == null) {
            if (!this.isEditing() && this.dbObjectInitializer != null) {
                this.dbObjectInitializer.init(this.getProvider(), (AbstractSchemaObjectWithDesc)this.getOriginalObject(), (AbstractSchemaObjectWithDesc)this.getUpdatedObject());
            }
            if (!this.isEditing() && this.createDefaultChild()) {
                this.newChild();
            }
            this.m_initialized = true;
            this.getDataContext().put(INITIALIZED, (Object)true);
        }
        super.initialisePanel();
    }

    protected boolean createDefaultChild() {
        return false;
    }

    protected boolean canMoveUp(Object object) {
        return false;
    }

    protected boolean canMoveDown(Object object) {
        return false;
    }

    protected boolean canReorder() {
        return false;
    }

    protected boolean includeReorderButtons() {
        return false;
    }

    protected ChildSelectableComponentEditorPanel.DefaultButtonsHelper createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            public void addToList() {
                super.addToList();
                ChildListEditorPanel2.this.m_childPanel.getNameField().setEnabled(true);
            }

            public Integer getMaxListSize() {
                return 1000;
            }

            public boolean canRemove(Object object) {
                if (ChildListEditorPanel2.this.getVerifier() != null) {
                    return ChildListEditorPanel2.this.getVerifier().canRemove(object);
                }
                return super.canRemove();
            }

            public boolean canMoveDown(Object object) {
                return ChildListEditorPanel2.this.canMoveDown(object);
            }

            public boolean canMoveUp(Object object) {
                return ChildListEditorPanel2.this.canMoveUp(object);
            }

            public boolean canReorder() {
                return ChildListEditorPanel2.this.canReorder();
            }

            public boolean includeReorderButtons() {
                return ChildListEditorPanel2.this.includeReorderButtons();
            }
        };
    }
}

