/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubexml;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.SystemObject;
import oracle.olap.app.cubeddl.CubeParser;
import oracle.olap.app.cubeddl.ParseException;
import oracle.olap.app.olapixml.MetadataUtil;
import oracle.olap.app.olapmetadata.MetadataChange;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.ModelToXML;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.db.DatabaseConnection;
import oracle.olap.db.view.TransactionWaitCursorManager;
import oracle.olap.dml.DMLObject;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.xmlbind.BaseMeasure;
import oracle.olap.xmlbind.Cube;
import oracle.olap.xmlbind.DerivedMeasure;
import oracle.olap.xmlbind.Measure;
import oracle.olap.xmlbind.Metadata;
import oracle.olap.xmlbind.OrganizationalSchema;
import oracle.olap.xmlbind.StandardDimension;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetadataXML {
    private static final Logger LOG = Logger.getLogger(MetadataXML.class.getName());
    private MetadataContext metadataContext;
    private Object marshalObj;
    private List marshalObjs;
    private static final String cpackage = "oracle.olap.xmlbind";
    private JAXBContext jc;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public MetadataXML(MetadataContext metadataContext) throws SQLException, IOException, JAXBException {
        this.metadataContext = metadataContext;
        this.jc = JAXBContext.newInstance((String)cpackage);
        this.unmarshaller = this.jc.createUnmarshaller();
    }

    public MetadataContext getMetadataContext() {
        return this.metadataContext;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jc == null) {
            this.jc = JAXBContext.newInstance((String)cpackage);
        }
        return this.jc;
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        if (this.unmarshaller == null) {
            this.unmarshaller = this.getJAXBContext().createUnmarshaller();
        }
        return this.unmarshaller;
    }

    private void parseAll() throws ParseException {
        Collection<String> collection = this.metadataContext.getCubeDDLStatements();
        String string = this.getObfuscatedCubeSQL(collection);
        LOG.log(Level.FINEST, string);
        this.marshalObjs = new ArrayList();
        for (String string2 : collection) {
            this.marshalObj = this.parse(this.metadataContext.getSchema(), string2);
            if (this.marshalObj == null) continue;
            this.marshalObjs.add(this.marshalObj);
        }
    }

    private Object parse(Schema schema, String string) throws ParseException {
        string = this.handleReservedWords(string);
        StringReader stringReader = new StringReader(string);
        CubeParser cubeParser = new CubeParser(stringReader);
        cubeParser.setMetadataContext(this.metadataContext);
        Object object = cubeParser.sqlStatement(schema);
        return object;
    }

    @Deprecated
    private void parse(String string) throws ParseException, JAXBException {
        this.parseAll();
        this.jc = JAXBContext.newInstance((String)cpackage);
        this.marshaller = this.jc.createMarshaller();
    }

    public void parse() throws ParseException, JAXBException {
        if (this.metadataContext.isMultiObject()) {
            this.parseMultiObjects();
        } else {
            this.parseAll();
            ModelToXML modelToXML = new ModelToXML(this.metadataContext, this.marshalObjs);
            modelToXML.save();
            this.jc = JAXBContext.newInstance((String)cpackage);
            this.marshaller = this.jc.createMarshaller();
        }
    }

    private void parseMultiObjects() throws ParseException, JAXBException {
        this.marshalObjs = new ArrayList();
        List<CubeDDLStatements> list = this.metadataContext.getMultipleObjectDDLList();
        for (CubeDDLStatements cubeDDLStatements : list) {
            SystemObject systemObject = cubeDDLStatements.getOriginalObject();
            SystemObject systemObject2 = cubeDDLStatements.getUpdatedObject();
            Collection<String> collection = cubeDDLStatements.getCubeDDLs();
            CubeDDLStatements cubeDDLStatements2 = new CubeDDLStatements(systemObject, systemObject2, collection);
            MetadataContext metadataContext = new MetadataContext(this.metadataContext.getDatabase(), cubeDDLStatements2);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (String string : collection) {
                String string2 = this.getObfuscatedCubeSQL(collection);
                LOG.log(Level.FINEST, string2);
                string = this.handleReservedWords(string);
                StringReader stringReader = new StringReader(string);
                CubeParser cubeParser = new CubeParser(stringReader);
                cubeParser.setMetadataContext(metadataContext);
                this.marshalObj = cubeParser.sqlStatement(this.metadataContext.getSchema());
                if (this.marshalObj == null) continue;
                this.marshalObjs.add(this.marshalObj);
                arrayList.add(this.marshalObj);
            }
            ModelToXML modelToXML = new ModelToXML(metadataContext, arrayList);
            modelToXML.save();
        }
        this.jc = JAXBContext.newInstance((String)cpackage);
        this.marshaller = this.jc.createMarshaller();
    }

    public Object getObject(String string) throws JAXBException {
        List<Object> list;
        Object object;
        StringReader stringReader = new StringReader(string);
        Object object2 = this.unmarshaller.unmarshal((Reader)stringReader);
        if (object2 instanceof JAXBElement) {
            object = null;
            object = (JAXBElement)object2;
            object2 = object.getValue();
        }
        if (object2 instanceof Metadata && (list = ((Metadata)(object = (Metadata)object2)).getStandardDimensionOrTimeDimensionOrCube()).size() > 0) {
            object2 = list.get(0);
        }
        return object2;
    }

    public String generateXML() throws JAXBException, ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        return this.generateXML(true);
    }

    public String generateXML(boolean bl) throws JAXBException, ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        if (this.marshalObjs == null || this.marshalObjs.size() == 0) {
            return null;
        }
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter stringWriter = new StringWriter();
        if (bl) {
            object5 = new Metadata();
            ((Metadata)object5).setVersion(Float.valueOf(1.3f));
            ((Metadata)object5).setMinimumDatabaseVersion("11.2.0.2");
            object4 = ((Metadata)object5).getStandardDimensionOrTimeDimensionOrCube();
            for (Object object32 : this.marshalObjs) {
                if (object32 instanceof ArrayList) {
                    object2 = (ArrayList)object32;
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        object4.add(e);
                    }
                    continue;
                }
                object4.add(object32);
            }
            this.marshalObj = object5;
            this.marshaller.marshal(object5, (Writer)stringWriter);
        } else {
            if (this.marshalObj instanceof Metadata && (object4 = ((Metadata)(object5 = (Metadata)this.marshalObj)).getStandardDimensionOrTimeDimensionOrCube()).size() > 0) {
                this.marshalObj = object4.get(0);
            }
            this.marshaller.marshal(this.marshalObj, (Writer)stringWriter);
        }
        object5 = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object5).setNamespaceAware(false);
        object4 = ((DocumentBuilderFactory)object5).newDocumentBuilder();
        StringReader stringReader = new StringReader(stringWriter.toString());
        object32 = new InputSource(stringReader);
        object2 = ((DocumentBuilder)object4).parse((InputSource)object32);
        object2.normalize();
        MetadataXML.processXMLCDATA((Node)object2);
        object2.setDocumentURI(null);
        object2.setPrefix(null);
        object = MetadataXML.getXML((Document)object2);
        return object;
    }

    private static void processXMLCDATA(Node node) {
        String string;
        Object object;
        node.setPrefix(null);
        node.normalize();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object = namedNodeMap.item(i);
                string = object.getNodeName();
                if (object.getNodeType() != 2 || !string.startsWith("xmlns")) continue;
                namedNodeMap.removeNamedItem(object.getNodeName());
            }
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            object = text.getData();
            if (((String)(object = ((String)object).trim())).indexOf("\n") >= 0) {
                string = text.getNodeName();
                short s = text.getNodeType();
                if (s != 4) {
                    Document document = node.getOwnerDocument();
                    CDATASection cDATASection = document.createCDATASection(node.getNodeName());
                    cDATASection.setTextContent((String)object);
                    Node node2 = node.getParentNode();
                    node2.removeChild(node);
                    node2.appendChild(cDATASection);
                }
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MetadataXML.processXMLCDATA(nodeList.item(i));
        }
    }

    private static String getXML(Document document) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("cdata-section-elements", "ConsistentSolve DefaultBuild BuildSpecifications MeasureExpression");
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
        String string = stringWriter.toString();
        return string;
    }

    public String getSQLXML() throws JAXBException, ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        String string = this.generateXML();
        String string2 = null;
        SystemObject systemObject = this.metadataContext.getOriginalObject();
        SystemObject systemObject2 = this.metadataContext.getUpdatedObject();
        boolean bl = true;
        if (systemObject == null && systemObject2 != null) {
            bl = false;
        }
        if (string != null) {
            String string3 = MetadataXML.GenerateCubeSQLXML("xmlCLOB", string, bl);
            String string4 = this.getObfuscatedCubeSQL(this.metadataContext.getCubeDDLStatements());
            boolean bl2 = System.getProperty("sqldev.debug", "false").equalsIgnoreCase("true");
            if (bl2) {
                String string5 = string4.replaceAll("\n", "\n-- ");
                string2 = String.format("%s\n\n-- %s", string3, string5);
            } else {
                string2 = string3;
            }
        }
        return string2;
    }

    public String executeSQL() throws Exception {
        String string = this.getObfuscatedCubeSQL(this.metadataContext.getCubeDDLStatements());
        String string2 = this.getSQLXML();
        LOG.log(Level.FINEST, string);
        LOG.log(Level.FINEST, string2);
        boolean bl = true;
        TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
        if (!bl) {
            this.metadataContext.getDatabase().executeSQL(string2);
        } else {
            Connection connection = null;
            try {
                Object object;
                transactionWaitCursorManager.showWaitCursor();
                Connection connection2 = this.metadataContext.getDatabase().getConnection();
                String string3 = this.metadataContext.getFullAWName();
                if (string3 != null && (object = DMLObject.getAWAttachModeInSession(connection2, string3)) != null && ((String)object).equalsIgnoreCase("RW")) {
                    bl = false;
                }
                object = DBUtil.getInstance((Connection)connection2);
                if (bl) {
                    connection = DatabaseConnection.getInstance().getClonedConnection(connection2);
                    object = DBUtil.getInstance((Connection)connection);
                }
                ExceptionHandler.reset();
                object.execute(string2);
                SQLException sQLException = object.getLastException();
                if (sQLException != null) {
                    throw sQLException;
                }
                this.recordMetadataChanges();
            }
            catch (Throwable throwable) {
                Exception exception = (Exception)throwable;
                throw exception;
            }
            finally {
                transactionWaitCursorManager.showDefaultCursor();
                transactionWaitCursorManager.reset();
            }
        }
        return string2;
    }

    private void recordMetadataChanges() {
        Connection connection = this.metadataContext.getDatabase().getConnection();
        String string = Connections.getInstance().getConnectionName(connection);
        String string2 = this.metadataContext.getSchema().getName();
        LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
        for (Object object : this.marshalObjs) {
            boolean bl = false;
            if (object instanceof Cube) {
                boolean list = false;
                Cube cube = (Cube)object;
                if (!(cube.getOrganization() != null || cube.getOwner() != null || cube.getDimensionality() != null && cube.getDimensionality().size() != 0 || cube.getCubeMap() != null && cube.getCubeMap().size() != 0 || cube.getClassification() != null && cube.getClassification().size() != 0 || cube.getMeasure() == null || cube.getMeasure().size() <= 0)) {
                    LOG.finest(String.format("recording change for measures of cube %s", cube.getName()));
                    block1: for (Measure measure : cube.getMeasure()) {
                        for (Object object2 : measure.getContent()) {
                            String string3 = null;
                            String string4 = null;
                            if (object2 instanceof BaseMeasure) {
                                string3 = ((BaseMeasure)object2).getName();
                                string4 = ((BaseMeasure)object2).getNewName();
                            }
                            if (object2 instanceof DerivedMeasure) {
                                string3 = ((DerivedMeasure)object2).getName();
                                string4 = ((DerivedMeasure)object2).getNewName();
                            }
                            if (string4 != null) {
                                list = false;
                                continue block1;
                            }
                            list = true;
                            linkedList.add(new MetadataChange(cube.getName(), string3, Type.MEASURE));
                        }
                    }
                }
                if (!list) {
                    linkedList.add(new MetadataChange(cube.getName(), cube.getName(), Type.CUBE));
                    if (cube.getNewName() != null && !cube.getName().equals(cube.getNewName())) {
                        linkedList.add(new MetadataChange(cube.getNewName(), cube.getNewName(), Type.CUBE));
                    }
                }
            } else if (object instanceof StandardDimension) {
                StandardDimension standardDimension = (StandardDimension)object;
                linkedList.add(new MetadataChange(standardDimension.getName(), standardDimension.getName(), Type.DIMENSION));
                if (standardDimension.getNewName() != null && !standardDimension.getName().equals(standardDimension.getNewName())) {
                    linkedList.add(new MetadataChange(standardDimension.getNewName(), standardDimension.getNewName(), Type.DIMENSION));
                    linkedList.add(new MetadataChange(standardDimension.getNewName(), standardDimension.getNewName(), Type.DIMENSION, "RENAMEIT"));
                }
            } else if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty() || !(list.get(0) instanceof OrganizationalSchema)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            OLAPMetadataCache.removeSchema(string, string2);
            return;
        }
        for (MetadataChange metadataChange : linkedList) {
            LOG.finest(String.format("recording change for %s", metadataChange.getObjectName()));
            OLAPMetadataCache.recordMetadataChange(string, string2, metadataChange);
        }
    }

    public void executeSQL(boolean bl) throws JAXBException, ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException, SQLException {
        String string = this.getSQLXML();
        if (string == null) {
            String string2 = String.format("Cannot generate OLAPI XML for sql $$%s$$", this.metadataContext.getCubeDDLStatements());
            System.out.println(string2);
        } else {
            System.out.println(string);
            System.out.println("/\n");
        }
        System.out.flush();
        if (bl) {
            try {
                this.metadataContext.getDatabase().executeSQL(string);
            }
            catch (SQLException sQLException) {
                PrintStream printStream = System.err;
                printStream.println(String.format("In MetadataXML Failed on %s", this.metadataContext.getCubeDDLStatements()));
                printStream.println(string);
                throw sQLException;
            }
        }
    }

    private String handleReservedWords(String string) {
        string = ReservedWordsSyntaxHandler.Process(string);
        return string;
    }

    public static String GenerateCubeSQLXML(String string) {
        return MetadataXML.GenerateCubeSQLXML("xmlCLOB", string);
    }

    public static String GenerateCubeSQLXML(String string, String string2) {
        return MetadataXML.GenerateCubeSQLXML(string, string2, true);
    }

    public static String GenerateCubeSQLXML(String string, String string2, boolean bl) {
        String string3 = null;
        string3 = MetadataUtil.GenerateCubeSQLXML(string, string2, bl);
        return string3;
    }

    private String getObfuscatedCubeSQL(Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection != null) {
            for (String string : collection) {
                stringBuffer.append(this.getObfuscatedCubeSQL(string));
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private String getObfuscatedCubeSQL(String string) {
        String string2 = string;
        if (string.startsWith("CREATE CUBE DIMENSION ")) {
            string2 = string.replaceFirst("CREATE CUBE DIMENSION ", "CCD ");
        }
        if (string.startsWith("ALTER CUBE DIMENSION ")) {
            string2 = string.replaceFirst("ALTER CUBE DIMENSION ", "ACD ");
        }
        if (string.startsWith("DROP CUBE DIMENSION ")) {
            string2 = string.replaceFirst("DROP CUBE DIMENSION ", "DCD ");
        }
        if (string.startsWith("CREATE CUBE ")) {
            string2 = string.replaceFirst("CREATE CUBE ", "CC ");
        }
        if (string.startsWith("ALTER CUBE ")) {
            string2 = string.replaceFirst("ALTER CUBE ", "AC ");
        }
        if (string.startsWith("DROP CUBE ")) {
            string2 = string.replaceFirst("DROP CUBE ", "DC ");
        }
        if (string.startsWith("CREATE MEASURE FOLDER ")) {
            string2 = string.replaceFirst("CREATE MEASURE FOLDER ", "CMF ");
        }
        if (string.startsWith("ALTER MEASURE FOLDER ")) {
            string2 = string.replaceFirst("ALTER MEASURE FOLDER ", "AMF ");
        }
        if (string.startsWith("DROP MEASURE FOLDER ")) {
            string2 = string.replaceFirst("DROP MEASURE FOLDER ", "DMF ");
        }
        if (string.startsWith("CREATE BUILD PROCESS ")) {
            string2 = string.replaceFirst("CREATE BUILD PROCESS ", "CBP ");
        }
        if (string.startsWith("ALTER BUILD PROCESS ")) {
            string2 = string.replaceFirst("ALTER BUILD PROCESS ", "ABP ");
        }
        if (string.startsWith("DROP BUILD PROCESS ")) {
            string2 = string.replaceFirst("DROP BUILD PROCESS ", "DBP ");
        }
        if (string.startsWith("CREATE ANALYTIC WORKSPACE ")) {
            string2 = string.replaceFirst("CREATE ANALYTIC WORKSPACE ", "CAW ");
        }
        if (string.startsWith("DROP ANALYTIC WORKSPACE ")) {
            string2 = string.replaceFirst("DROP ANALYTIC WORKSPACE ", "DAW ");
        }
        if (string.startsWith("CREATE REALM ")) {
            string2 = string.replaceFirst("CREATE REALM ", "CR ");
        }
        if (string.startsWith("ALTER REALM ")) {
            string2 = string.replaceFirst("ALTER REALM ", "AR ");
        }
        if (string.startsWith("CREATE OLAPACL ")) {
            string2 = string.replaceFirst("CREATE OLAPACL ", "COA ");
        }
        if (string.startsWith("ALTER OLAPACL ")) {
            string2 = string.replaceFirst("ALTER OLAPACL ", "AOA ");
        }
        return string2;
    }
}

