/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import oracle.dss.dataView.LocalDataSource;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.sql.NUMBER;

public class CubeDataSource
extends LocalDataSource {
    private static Pattern numeric = Pattern.compile("-?\\d*(\\.\\d+)?");

    public CubeDataSource() {
    }

    public CubeDataSource(Cube cube, TableModel tableModel) {
        Object object;
        int n = cube.getDimensions().size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Measure measure : cube.getMeasures()) {
            if (!measure.isSelected()) continue;
            object = measure.getDisplayLabel();
            arrayList.add((String)object);
        }
        this.rowCount = arrayList.size();
        this.rowLabels = arrayList.toArray(new String[this.rowCount]);
        if (tableModel != null) {
            int n2;
            this.columnCount = n2 = tableModel.getRowCount();
            this.defaultData1 = new double[this.rowCount][this.columnCount];
            this.columnLabels = new String[this.columnCount];
            for (int i = 0; i < n2; ++i) {
                String string;
                object = tableModel.getValueAt(i, 0);
                this.columnLabels[i] = object != null ? (string = object.toString()) : "";
                for (int j = n; j < tableModel.getColumnCount(); ++j) {
                    Object object2 = tableModel.getValueAt(i, j);
                    if (object2 == null) continue;
                    String string2 = object2.toString();
                    double d = 0.0;
                    if (object2 instanceof NUMBER) {
                        NUMBER nUMBER = (NUMBER)object2;
                        d = nUMBER.doubleValue();
                    } else if (this.isNumeric(string2)) {
                        d = Double.valueOf(string2);
                    }
                    this.defaultData1[j - n][i] = d;
                }
            }
            this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
        }
    }

    protected boolean isNumeric(String string) {
        return !string.isEmpty() && numeric.matcher(string).matches();
    }
}

