/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplateimpl;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.olap.OLAPResources;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Preferences;
import oracle.olap.app.Resources;
import oracle.olap.cubetemplate.CubeCatalogDialog;
import oracle.olap.cubetemplate.CubeTemplateManager;
import oracle.olap.cubetemplate.ImportConflictDialog;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TemplateSelector;
import oracle.olap.cubetemplateimpl.ExportPreprocessorImpl;
import oracle.olap.cubetemplateimpl.ImportFromTemplateDialog;
import oracle.olap.cubetemplateimpl.OLAPPersistenceImpl;
import oracle.olap.cubetemplateimpl.PLSQLXMLImpl;
import oracle.olap.cubetemplateimpl.TreeModelHelperImpl;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.olap.util.OLAPFetchIcon;
import oracle.olap.util.OLAPHelpProvider;

public class TemplateFactory {
    private static final String CUBE_NAME = "CUBE_NAME";

    private TemplateFactory() {
    }

    public static List<Object> createExportList(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
        }
        return arrayList;
    }

    public static JDialog doTemplateProcessing(CubeCatalogDialog.Mode mode, CubeCatalogDialog.Destination destination, CubeTemplateManager.OutputFormat outputFormat, List<Object> list) {
        Object object;
        boolean bl = true;
        if (list.size() == 0) {
            return null;
        }
        DBObject dBObject = (DBObject)list.get(0);
        Connection connection = dBObject.getConnection();
        ExportPreprocessorImpl exportPreprocessorImpl = new ExportPreprocessorImpl(connection);
        ObjectType objectType = ObjectType.fromNodeType(dBObject.getObjectType());
        ObjectType objectType2 = null;
        String string = null;
        String string2 = null;
        string = CubeAWUtil.getAnalyticWorkspaceName(dBObject);
        if (string == null) {
            try {
                string = exportPreprocessorImpl.getAWName(dBObject);
                string2 = exportPreprocessorImpl.getOwnerCube(dBObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 == null) {
            if (dBObject.getElement() instanceof ObjectFolder) {
                object = (ObjectFolder)dBObject.getElement();
                string2 = String.valueOf(object.getProperty(CUBE_NAME));
            } else if (dBObject.getNode() instanceof ObjectNode) {
                object = (ObjectNode)dBObject.getNode();
                string2 = (String)object.getProperty(CUBE_NAME);
            }
        }
        for (Object e : list) {
            objectType2 = ObjectType.fromNodeType(((DBObject)e).getObjectType());
            if (objectType2 == objectType) continue;
            objectType = ObjectType.ALL;
        }
        if (mode == CubeCatalogDialog.Mode.IMPORT && string == null && objectType != ObjectType.WORKSPACE && objectType != ObjectType.MEASURE_FOLDER) {
            object = new ImportFromTemplateDialog((Frame)Ide.getMainWindow(), connection, dBObject.getSchemaName());
            ((Window)object).setMinimumSize(new Dimension(400, 120));
            ((Window)object).setLocationRelativeTo((Component)Ide.getMainWindow());
            ((Dialog)object).setVisible(true);
            if (!((ImportFromTemplateDialog)object).isOKSelected()) {
                return null;
            }
            string = ((ImportFromTemplateDialog)object).getAWName();
        }
        object = TemplateFactory.createCubeCatalogDialog(mode, destination, outputFormat, list, objectType, string, string2);
        ((CubeCatalogDialog)object).setOptionsEnabled(bl);
        return object;
    }

    public static JDialog doTemplateProcessing(CubeCatalogDialog.Mode mode, CubeCatalogDialog.Destination destination, CubeTemplateManager.OutputFormat outputFormat, Object object) {
        ArrayList arrayList = new ArrayList(1);
        if (object instanceof List) {
            arrayList = (ArrayList)object;
        } else {
            arrayList.add(object);
        }
        return TemplateFactory.doTemplateProcessing(mode, destination, outputFormat, arrayList);
    }

    public static CubeCatalogDialog createCubeCatalogDialog(CubeCatalogDialog.Mode mode, CubeCatalogDialog.Destination destination, CubeTemplateManager.OutputFormat outputFormat, List<Object> list, ObjectType objectType, String string, String string2) {
        OLAPFetchIcon oLAPFetchIcon = new OLAPFetchIcon();
        TemplateSelector.setUpIcons(oLAPFetchIcon);
        ObjectType.setUpIcons(oLAPFetchIcon);
        OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
        OLAPResources oLAPResources = new OLAPResources();
        ObjectType.setResources(oLAPResources);
        DBObject dBObject = (DBObject)list.get(0);
        String string3 = dBObject.getSchemaName();
        Connection connection = dBObject.getConnection();
        boolean bl = true;
        String string4 = dBObject.getDBVersion();
        CubeTemplateManager cubeTemplateManager = TemplateFactory.getCubeTemplateManagerInstance(oLAPResources, oLAPErrorDisplay, connection);
        TreeModelHelperImpl treeModelHelperImpl = null;
        boolean bl2 = true;
        if (bl2) {
            treeModelHelperImpl = new TreeModelHelperImpl(list, string);
        }
        OLAPHelpProvider oLAPHelpProvider = new OLAPHelpProvider();
        String string5 = "";
        String string6 = "";
        if (list.size() == 1) {
            string5 = dBObject.getObjectName();
            string6 = "";
        }
        Preferences preferences = new Preferences(){

            @Override
            public String get(String string) {
                return null;
            }

            @Override
            public void set(String string, String string2) {
            }
        };
        return new CubeCatalogDialog((Frame)Ide.getMainWindow(), oLAPResources, preferences, oLAPErrorDisplay, oLAPHelpProvider, cubeTemplateManager, treeModelHelperImpl, connection, mode, destination, outputFormat, list, string5, string6, string, bl, string4, string3, string2, objectType, bl2);
    }

    public static CubeTemplateManager getCubeTemplateManagerInstance(Resources resources, ErrorDisplay errorDisplay, Connection connection) {
        OLAPFetchIcon oLAPFetchIcon = new OLAPFetchIcon();
        OLAPHelpProvider oLAPHelpProvider = new OLAPHelpProvider();
        ImportConflictDialog.setUpIcons(oLAPFetchIcon);
        boolean bl = true;
        PLSQLXMLImpl pLSQLXMLImpl = null;
        ExportPreprocessorImpl exportPreprocessorImpl = null;
        if (bl) {
            pLSQLXMLImpl = new PLSQLXMLImpl(connection);
            exportPreprocessorImpl = new ExportPreprocessorImpl(connection);
        }
        CubeTemplateManager cubeTemplateManager = new CubeTemplateManager(errorDisplay, resources, oLAPHelpProvider, (JFrame)Ide.getMainWindow(), new OLAPPersistenceImpl(resources), pLSQLXMLImpl, exportPreprocessorImpl, connection);
        return cubeTemplateManager;
    }
}

