/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.table.Queries;
import oracle.olap.cubetemplate.TreeNode;

public class NamespaceValidator {
    private Queries queries;
    private static final String XMLFILE = "cubetemplate.xml";
    private static final String FULLCHECK = "FULL_CHECK";
    private List<SqlObject> namespace = null;
    private final Connection conn;
    private final String owner;

    public NamespaceValidator(Connection connection, String string) {
        this.conn = connection;
        this.owner = string;
        try {
            String string2 = "oracle.olap.app.table";
            String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
            JavaXMLBind.BindToJavaStr(string3, string2, this);
            this.loadNamespace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadNamespace() throws SQLException, IOException {
        if (this.namespace == null) {
            List list = DatabaseUtils.ExecuteSQL(this.conn, this.getQuery(FULLCHECK), new Object[]{this.owner, this.owner, this.owner, this.owner, this.owner, this.owner, this.owner, this.owner, this.owner, this.owner, this.owner, this.owner});
            this.namespace = new ArrayList<SqlObject>();
            for (List list2 : list) {
                this.namespace.add(new SqlObject((String)list2.get(0), String.valueOf(list2.get(1)), String.valueOf(list2.get(2))));
            }
        }
    }

    public boolean checkForCollisions(List<TreeNode> list) {
        for (TreeNode treeNode : list) {
            if (this.checkForCollisions((String)treeNode.getUserObject(), treeNode.getParentName()) == Collision.NONE) continue;
            return true;
        }
        return false;
    }

    public Collision checkForCollisions(String string, String string2) {
        for (SqlObject sqlObject : this.namespace) {
            if (!sqlObject.name.equals(string) || sqlObject.parent != string2 && (sqlObject.parent == null || !sqlObject.parent.equals(string2))) continue;
            return sqlObject.getCollision();
        }
        return Collision.NONE;
    }

    private String getQuery(String string) {
        return this.queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    class SqlObject {
        public final String name;
        public final String parent;
        private final Collision collision;

        public SqlObject(String string, String string2, String string3) {
            this.name = string2;
            this.collision = Collision.valueOf(string3);
            this.parent = string;
        }

        public String toString() {
            return this.name;
        }

        public Collision getCollision() {
            return this.collision;
        }
    }

    public static enum Collision {
        NONE(""),
        TABLE("NAMESPACE_CONFLICT_WITH_TABLE_ERR_MSG"),
        AW("NAMESPACE_CONFLICT_WITH_AW_ERR_MSG"),
        VIEW("NAMESPACE_CONFLICT_WITH_VIEW_ERR_MSG"),
        SYNONYM("NAMESPACE_CONFLICT_WITH_SYNONYM_ERR_MSG"),
        DIMENSION("NAMESPACE_CONFLICT_WITH_DIMENSION_ERR_MSG"),
        HIERARCHY("NAMESPACE_CONFLICT_WITH_HIERARCHY_ERR_MSG"),
        LEVEL("NAMESPACE_CONFLICT_WITH_LEVEL_ERR_MSG"),
        CUBE("NAMESPACE_CONFLICT_WITH_CUBE_ERR_MSG"),
        MEASURE_FOLDER("NAMESPACE_CONFLICT_WITH_MEASURE.FOLDER_ERR_MSG"),
        MEASURE("NAMESPACE_CONFLICT_WITH_MEASURE_ERR_MSG"),
        DERIVED_MEASURE("NAMESPACE_CONFLICT_WITH_CALCMEASURE_ERR_MSG"),
        BUILD_PROCESS("NAMESPACE_CONFLICT_WITH_BUILD.PROCESS_ERR_MSG"),
        RENAMED("NAMESPACE_CONFLICT_WITH_RENAME_ERR_MSG");

        private final String key;

        private Collision(String string2) {
            this.key = string2;
        }

        public String getKey() {
            return this.key;
        }
    }
}

