/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.UpdateProcessorPropertiesFilter;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cube.model.SideEffects;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.db.CubeSQL;
import oracle.olap.db.view.OLAPDDLPanel;

public class OLAPDimensionDDLPanel
extends OLAPDDLPanel {
    public OLAPDimensionDDLPanel() {
        this(true);
    }

    public OLAPDimensionDDLPanel(boolean bl) {
        super(bl);
    }

    @Override
    protected String getSQL() throws UnsupportedDDLException {
        String string;
        Object object;
        DBObjectTransaction dBObjectTransaction;
        DBObjectProvider dBObjectProvider = this.m_config.getProvider();
        DDLDatabase dDLDatabase = null;
        if (dBObjectProvider instanceof DDLDatabase) {
            dDLDatabase = (DDLDatabase)dBObjectProvider;
        }
        SystemObject systemObject = this.m_config.getUpdatedObject();
        SystemObject systemObject2 = this.m_config.getOriginalObject();
        boolean bl = this.m_config.isReplaceAllowed();
        DDLOptions dDLOptions = new DDLOptions(bl, false);
        DDLGenerator dDLGenerator = OLAPDimensionDDLPanel.getDDLGenerator(this.m_config);
        if (dDLGenerator == null) {
            DBLog.getLogger().log(Level.WARNING, "No DDL generator found. DDL panel will not function.");
            return null;
        }
        SystemObject systemObject3 = this.m_rdbCreate != null && this.m_rdbCreate.isSelected() ? null : this.m_originalObjectForDDL;
        Difference difference = null;
        if (this.useProviderTransactionForDiff()) {
            dBObjectTransaction = new DBObjectTransaction(dBObjectProvider);
            dBObjectTransaction.includeUpdate(systemObject3, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject));
            if (systemObject instanceof SideEffects) {
                object = ((SideEffects)systemObject).getAffectedObjectNew().iterator();
                Iterator<SystemObject> iterator = ((SideEffects)systemObject).getAffectedObjectOld().iterator();
                while (object.hasNext() && iterator.hasNext()) {
                    string = iterator.next();
                    SystemObject systemObject4 = (SystemObject)object.next();
                    dBObjectTransaction.includeUpdate((SystemObject)string, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject4));
                }
            }
            dBObjectTransaction.setReplace(true);
            dBObjectTransaction.setCascade(true);
            try {
                object = dBObjectTransaction.getTransactionDifference();
                difference = object.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(dBObjectProvider)});
                this.print(difference);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (difference == null) {
            difference = dBObjectProvider.getDiffEngine().difference((Object)systemObject3, (Object)systemObject);
        }
        dBObjectTransaction = dDLGenerator.getUpdateDDL(dDLOptions, difference);
        object = dBObjectTransaction.getStatements();
        boolean bl2 = false;
        string = "";
        if (object.size() > 0) {
            string = dBObjectTransaction.toString();
            if ((string = ReservedWordsSyntaxHandler.Process(string)) != null && !string.isEmpty()) {
                try {
                    Object object2;
                    boolean bl3 = false;
                    String string2 = null;
                    DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
                    if (dependentTransactionalCubes.areUpdatedCubes(systemObject2, systemObject)) {
                        object2 = dependentTransactionalCubes.getCubeDDLStatements(systemObject2, systemObject);
                        CubeDDLStatements cubeDDLStatements = new CubeDDLStatements(systemObject2, systemObject, dBObjectTransaction.getStatements());
                        object2.add(0, cubeDDLStatements);
                        string2 = this.executeMany(dDLDatabase, bl2, (List<CubeDDLStatements>)object2);
                        object.clear();
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            CubeDDLStatements cubeDDLStatements2 = (CubeDDLStatements)iterator.next();
                            object.addAll(cubeDDLStatements2.getCubeDDLs());
                        }
                    } else {
                        string2 = this.execute(dDLDatabase, bl2, systemObject2, systemObject, (Collection<String>)object);
                    }
                    object2 = this.getObfuscatedCubeSQL((Collection<String>)object);
                    string = string2;
                    LOG.log(Level.FINEST, (String)object2);
                    LOG.log(Level.FINEST, string2);
                }
                catch (DBException dBException) {
                    StringWriter stringWriter = new StringWriter();
                    dBException.printStackTrace(new PrintWriter(stringWriter));
                    String string3 = stringWriter.toString();
                    string = this.getObfuscatedCubeSQL(string);
                    string = string + string3;
                }
            }
        }
        return string;
    }

    private String execute(DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2, Collection<String> collection) throws DBException {
        if (systemObject != null) {
            collection = CubeSQL.filterEmpty(systemObject, collection);
        }
        CubeSQL cubeSQL = new CubeSQL(dDLDatabase, bl, systemObject, systemObject2, collection, false);
        Map<String, Object> map = this.m_panelLibrary.getProperties();
        cubeSQL.setProperties(map);
        String string = cubeSQL.execute();
        return string;
    }

    private String executeMany(DDLDatabase dDLDatabase, boolean bl, List<CubeDDLStatements> list) throws DBException {
        CubeSQL cubeSQL = new CubeSQL(dDLDatabase, bl, list, false);
        Map<String, Object> map = this.m_panelLibrary.getProperties();
        cubeSQL.setProperties(map);
        String string = cubeSQL.execute();
        return string;
    }
}

