/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;

public class CubeDimensionStoragePanel
extends BaseEditorPanel<CubeDimension> {
    private JRadioButton surrogateKeysRadioButton;
    private JRadioButton uniqueKeysRadioButton;
    private JRadioButton consistentRadioButton;
    private JRadioButton solveConsistentRadioButton;
    private JRadioButton starConsistentRadioButton;

    public CubeDimensionStoragePanel() {
        this.layoutComponents();
    }

    protected void initialisePanel() {
        ActionListener[] actionListenerArray;
        boolean bl = ((CubeDimension)this.getUpdatedObject()).isAddUniqueKeys();
        this.uniqueKeysRadioButton.setSelected(!bl);
        this.surrogateKeysRadioButton.setSelected(bl);
        if (!this.isEditing() && this.isFlatOrValueHierarchyDimension()) {
            this.uniqueKeysRadioButton.setSelected(true);
            this.surrogateKeysRadioButton.setSelected(false);
        }
        this.consistentRadioButton.setSelected(true);
        if (((CubeDimension)this.getUpdatedObject()).getHierarchyConsistencyRule() != null) {
            actionListenerArray = ((CubeDimension)this.getUpdatedObject()).getHierarchyConsistencyRule();
            if (actionListenerArray.equals("CONSISTENT")) {
                this.consistentRadioButton.setSelected(true);
            }
            if (actionListenerArray.equals("SOLVE_CONSISTENT")) {
                this.solveConsistentRadioButton.setSelected(true);
            }
            if (actionListenerArray.equals("STAR_CONSISTENT")) {
                this.starConsistentRadioButton.setSelected(true);
            }
        }
        if (this.surrogateKeysRadioButton.getActionListeners() != null && this.surrogateKeysRadioButton.getActionListeners().length > 0) {
            for (ActionListener actionListener : actionListenerArray = this.surrogateKeysRadioButton.getActionListeners()) {
                this.surrogateKeysRadioButton.removeActionListener(actionListener);
            }
        }
        this.surrogateKeysRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeDimension cubeDimension;
                String string;
                if (CubeDimensionStoragePanel.this.surrogateKeysRadioButton.isSelected() && (string = (cubeDimension = (CubeDimension)CubeDimensionStoragePanel.this.getUpdatedObject()).getDimensionClassType()) != null && string.equalsIgnoreCase("MEASURE")) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)OLAPArb.get("INVALID_DIMENSION_MEMBER_LOADING_SELECTION_ERRMSG"), (String)OLAPArb.get("INVALID_DIMENSION_MEMBER_LOADING_SELECTION_TITLE"), null);
                    CubeDimensionStoragePanel.this.uniqueKeysRadioButton.setSelected(true);
                }
            }
        });
    }

    private boolean isFlatOrValueHierarchyDimension() {
        boolean bl = false;
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
        if (cubeDimension.getLevels().length == 0) {
            bl = true;
        } else {
            CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
            bl = true;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray = cubeDimension.getHierarchies()) {
                if (cubeDimensionHierarchy.getHierarchyValueType()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected void commitPanel() {
        if (this.uniqueKeysRadioButton.isSelected()) {
            ((CubeDimension)this.getUpdatedObject()).setAddUniqueKeys(false);
        }
        if (this.surrogateKeysRadioButton.isSelected()) {
            ((CubeDimension)this.getUpdatedObject()).setAddUniqueKeys(true);
        }
        if (this.consistentRadioButton.isSelected()) {
            ((CubeDimension)this.getUpdatedObject()).setHierarchyConsistencyRule("CONSISTENT");
        }
        if (this.solveConsistentRadioButton.isSelected()) {
            ((CubeDimension)this.getUpdatedObject()).setHierarchyConsistencyRule("SOLVE_CONSISTENT");
        }
        if (this.starConsistentRadioButton.isSelected()) {
            ((CubeDimension)this.getUpdatedObject()).setHierarchyConsistencyRule("STAR_CONSISTENT");
        }
    }

    private void layoutComponents() {
        JLabel jLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_STORAGE_PANEL_DIMENSION_LOAD_LABEL"));
        jLabel.setName("dimensionLoadLabel");
        JLabel jLabel2 = new JLabel(OLAPArb.getString("CUBE_DIMENSION_STORAGE_PANEL_HIERARCHY_DATA_LABEL"));
        jLabel2.setName("hierarchyDataLabel");
        this.surrogateKeysRadioButton = this.createRadioButton(OLAPArb.getString("CUBE_DIMENSION_STORAGE_PANEL_SURROGATE_KEYS_RADIO_BUTTON"), "surrogateKeysRadioButton");
        this.uniqueKeysRadioButton = this.createRadioButton(OLAPArb.getString("CUBE_DIMENSION_STORAGE_PANEL_UNIQUE_KEYS_RADIO_BUTTON"), "uniqueKeysRadioButton");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.surrogateKeysRadioButton);
        buttonGroup.add(this.uniqueKeysRadioButton);
        this.consistentRadioButton = this.createRadioButton(OLAPArb.getString("CUBE_DIMENSION_STORAGE_PANEL_CONSISTENT_RADIO_BUTTON"), "consistentRadioButton");
        this.solveConsistentRadioButton = this.createRadioButton(OLAPArb.getString("CUBE_DIMENSION_STORAGE_PANEL_SOLVE_CONSISTENT_RADIO_BUTTON"), "solveConsistentRadioButton");
        this.starConsistentRadioButton = this.createRadioButton(OLAPArb.getString("CUBE_DIMENSION_STORAGE_PANEL_STAR_CONSISTENT_RADIO_BUTTON"), "starConsistentRadioButton");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.consistentRadioButton);
        buttonGroup2.add(this.solveConsistentRadioButton);
        buttonGroup2.add(this.starConsistentRadioButton);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.surrogateKeysRadioButton, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.uniqueKeysRadioButton, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
        this.add(jLabel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.consistentRadioButton, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.solveConsistentRadioButton, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.starConsistentRadioButton, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 15), 0, 0));
    }

    private JRadioButton createRadioButton(String string, String string2) {
        String string3 = StringUtils.stripMnemonic((String)string);
        JRadioButton jRadioButton = new JRadioButton(string3);
        jRadioButton.setName(string2);
        jRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        return jRadioButton;
    }
}

