/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.actions.DropCascadeAction;
import oracle.olap.actions.DropCascadeConfirmDialog;
import oracle.olap.actions.model.CascadeDeleteDimensionWrapper;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.view.OLAPBaseChildTablePanel;
import oracle.olap.util.UIUtilities;

public class CubeDimensionLevelTablePanel<C extends CubeDimensionLevel, P extends CubeDimension>
extends OLAPBaseChildTablePanel<C, P>
implements DropCascadeAction {
    MyCellEditor myCellEditor;
    private int doCascadeDelete;

    public CubeDimensionLevelTablePanel() {
        super("CubeDimensionLevelTablePanel");
        this.init();
        this.getWrapperTable().setPreferredVisibleRowCount(15);
    }

    public CubeDimensionLevelTablePanel(String string) {
        super(string);
        this.init();
        this.getWrapperTable().setPreferredVisibleRowCount(15);
    }

    @Override
    public void init() {
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("levels", OLAPArb.getString("CUBE_DIMENSION_LEVELS"));
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        GenericTable genericTable = this.getWrapperTable();
        this.myCellEditor = new MyCellEditor();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        int n = this.getNameColumnIndex();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(this.myCellEditor);
        int n2 = this.getDescriptionColumnIndex();
        TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
        tableColumn2.setCellEditor(this.myCellEditor);
        int n3 = this.getShortLabelColumnIndex();
        TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
        tableColumn3.setCellEditor(this.myCellEditor);
        int n4 = this.getLongLabelColumnIndex();
        TableColumn tableColumn4 = tableColumnModel.getColumn(n4);
        tableColumn4.setCellEditor(this.myCellEditor);
    }

    @Override
    protected boolean preserveListOrder() {
        return true;
    }

    public String getChildProperty() {
        return "levels";
    }

    public Class getChildClass() {
        return CubeDimensionLevel.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return null;
    }

    @Override
    public C newChild() {
        CubeDimensionLevel cubeDimensionLevel = (CubeDimensionLevel)super.newChild();
        cubeDimensionLevel.setNewObject();
        cubeDimensionLevel.setDataType("VARCHAR2(60)");
        cubeDimensionLevel.setOriginalLevelName(cubeDimensionLevel.getName());
        cubeDimensionLevel.generateDescriptions();
        ((CubeDimension)this.getUpdatedObject()).addLevel(cubeDimensionLevel);
        return (C)cubeDimensionLevel;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        CubeDimension cubeDimension;
        ChildTableEditorPanel.RowInfo rowInfo;
        AbstractChildObjectWithDesc abstractChildObjectWithDesc;
        boolean bl = true;
        if (this.isEditing() && !(abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)(rowInfo = this.getWrapperTableModel().getRow(n)).getRowObject()).getNewObject() && (cubeDimension = (CubeDimension)this.getUpdatedObject()).getDimensionUsedInCube().equalsIgnoreCase("TRUE")) {
            CubeDimensionLevel cubeDimensionLevel = (CubeDimensionLevel)abstractChildObjectWithDesc;
            String string = cubeDimensionLevel.getOriginalLevelName();
            DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
            CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper = dependentTransactionalCubes.handleLevelDelete(string);
            if (cascadeDeleteDimensionWrapper.areDependencies()) {
                DropCascadeConfirmDialog dropCascadeConfirmDialog = new DropCascadeConfirmDialog(this, cascadeDeleteDimensionWrapper, string, OLAPArb.format("DROP_LEVEL_CASCADE_DIALOG_TITLE", string), false, null);
                Rectangle rectangle = UIUtilities.centerWindow((Component)Ide.getMainWindow(), 650, 400);
                dropCascadeConfirmDialog.setBounds(rectangle);
                dropCascadeConfirmDialog.setVisible(true);
                if (this.doCascadeDelete == 0) {
                    dependentTransactionalCubes.confirmDelete();
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public void setUserDeleteChoice(int n) {
        this.doCascadeDelete = n;
    }

    class MyCellEditor
    extends OLAPBaseChildTablePanel.MyBaseCellEditor {
        public MyCellEditor() {
            super(CubeDimensionLevelTablePanel.this);
        }

        @Override
        public boolean stopCellEditing() {
            int n = CubeDimensionLevelTablePanel.this.getNameColumnIndex();
            if (this.column == n) {
                boolean bl = true;
                String string = null;
                CubeDimension cubeDimension = (CubeDimension)this.abstractChildObjectWithDesc.getParent();
                String string2 = this.abstractChildObjectWithDesc.getName();
                String string3 = this.cellTextField.getText().toUpperCase();
                if (string3 == null || string3.length() == 0) {
                    bl = false;
                    string = OLAPArb.getString("CUBE_DIMENSION_LEVEL_NAME_VALIDATION_ERROR_MSG");
                } else {
                    try {
                        CubeDimensionLevelTablePanel.this.prov.validateName("LEVEL", string3);
                    }
                    catch (InvalidNameException invalidNameException) {
                        string = invalidNameException.getMessage();
                        bl = false;
                    }
                }
                if (bl) {
                    String string4 = CubeDimensionLevelTablePanel.this.prov.getInternalName(string3);
                    if (!CubeDimensionLevelTablePanel.this.isEditing()) {
                        ((CubeDimensionLevel)this.abstractChildObjectWithDesc).setOriginalLevelName(string3.toUpperCase());
                    } else if (this.abstractChildObjectWithDesc.getNewObject()) {
                        ((CubeDimensionLevel)this.abstractChildObjectWithDesc).setOriginalLevelName(string3.toUpperCase());
                    }
                    if (cubeDimension.findLevel(string4) != null && !string4.equals(string2)) {
                        string = OLAPArb.format("VALIDATION_ERROR_DUPLICATE_LEVEL_NAME_MSG", string4);
                        bl = false;
                    } else if (cubeDimension.findLevel(string2) != null && !string4.equals(string2) && CubeDimensionLevelTablePanel.this.isEditing()) {
                        cubeDimension.renameSpreadedAttributesForLevelRename(string2, string3);
                    }
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)OLAPArb.get("CUBE_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string2);
                    return bl;
                }
                CubeDimensionLevelTablePanel.this.upcaseNameFlag = true;
            }
            return super.stopCellEditing();
        }
    }
}

