/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.util.TreeSet;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.olap.app.ui.DataTypeUI;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.olap.db.view.ChildObjectEditorPanel2;

public class CubeDimensionLevelTableEditorPanel<T extends CubeDimensionLevel, P extends AbstractMappableSchemaObjectWithDesc>
extends ChildObjectEditorPanel2<T, P> {
    private DBObjectProvider prov;
    private DataTypeUI dataTypeUI;
    private TreeSet<CubeDimensionLevel> invalidLevels = new TreeSet(new DBObjectComparator());
    private String origLevelName;

    public CubeDimensionLevelTableEditorPanel() {
        super("CubeDimensionLevelTableEditorPanel", "LEVEL");
        this.layoutComponents();
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.setLevel((CubeDimensionLevel)this.getChildObject());
        this.origLevelName = null;
        if (this.getChildObject() != null) {
            this.origLevelName = ((CubeDimensionLevel)this.getChildObject()).getName();
        }
    }

    public void setLevel(CubeDimensionLevel cubeDimensionLevel) {
        this.updateLevelData();
    }

    private void updateLevelData() {
        if (this.getChildObject() == null) {
            this.dataTypeUI.setEnabled(false);
        } else {
            String string = ((CubeDimensionLevel)this.getChildObject()).getName();
            CubeDimensionLevel cubeDimensionLevel = (CubeDimensionLevel)this.getChildObject();
            this.dataTypeUI.setEnabled(true);
        }
        this.validate();
        this.repaint();
    }

    public void commit(CubeDimensionLevel cubeDimensionLevel) throws TraversalException {
        String string = cubeDimensionLevel.getName();
        CubeDimensionLevel cubeDimensionLevel2 = (CubeDimensionLevel)cubeDimensionLevel.copyTo(null);
        try {
            this.prov.validateName("LEVEL", string);
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidLevels.add(cubeDimensionLevel);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidLevels.contains(cubeDimensionLevel)) {
            this.invalidLevels.remove(cubeDimensionLevel);
        }
        String string2 = this.prov.getInternalName(string);
        cubeDimensionLevel2.setName(string2);
        cubeDimensionLevel2.copyTo(cubeDimensionLevel);
        if (!this.isEditing()) {
            cubeDimensionLevel.setOriginalLevelName(string2);
            cubeDimensionLevel2.setOriginalLevelName(string2);
        } else if (!cubeDimensionLevel.getNewObject()) {
            cubeDimensionLevel2.setOriginalLevelName(cubeDimensionLevel.getOriginalLevelName());
        } else {
            cubeDimensionLevel.setOriginalLevelName(string2);
            cubeDimensionLevel2.setOriginalLevelName(string2);
        }
        CubeDimension cubeDimension = cubeDimensionLevel.getCubeDimension();
        if (cubeDimension.findLevel(cubeDimensionLevel2.getName()) == null) {
            cubeDimension.addLevel(cubeDimensionLevel2);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        CubeDimensionLevel cubeDimensionLevel = (CubeDimensionLevel)this.getChildObject();
        this.commit(cubeDimensionLevel);
        CubeDimension cubeDimension = (CubeDimension)cubeDimensionLevel.getParent();
        if (cubeDimension.findLevel(cubeDimensionLevel.getName()) == null) {
            cubeDimension.addLevel(cubeDimensionLevel);
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"levels"});
        this.setVisible(false);
    }

    protected void validateObject() throws TraversalException {
    }
}

