/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.model;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Transient;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttributeMap;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.model.CubeDimensionSpreadedAttribute;
import oracle.olap.cubedimension.model.CubeDimensionsedObject;
import oracle.olap.db.model.DataTypeProperty;

public class CubeDimensionAttribute
extends CubeDimensionsedObject
implements DataTypeProperty {
    public static final String TYPE = "ATTRIBUTE";
    public static final String LONG_DESCRIPTION = "LONG_DESCRIPTION";
    public static final String SHORT_DESCRIPTION = "SHORT_DESCRIPTION";
    public static final String END_DATE = "END_DATE";
    public static final String TIME_SPAN = "TIME_SPAN";
    public static final String USER_ATTRIBUTE = "USER";

    public CubeDimensionAttribute() {
        this.setDataType("VARCHAR2(256)");
        this.setRole(USER_ATTRIBUTE);
        this.setPersistedOrSpecial(false);
        this.setAttributeAllowAutoDataTypeChange(true);
        this.initializeNewAttribute();
    }

    public CubeDimensionAttribute(String string) {
        super(string);
        this.setDataType("VARCHAR2(256)");
        this.setRole(USER_ATTRIBUTE);
        this.setPersistedOrSpecial(false);
        this.setAttributeAllowAutoDataTypeChange(true);
        this.setOriginalAttributeName(string);
        this.initializeNewAttribute();
    }

    public void initializeNewAttribute() {
        this.setAttributeVisibleForAll(true);
        this.setStar(true);
    }

    public String getType() {
        return TYPE;
    }

    public void setPersistedOrSpecial(boolean bl) {
        this.setProperty("persistedOrSpecial", bl);
    }

    public boolean getPersistedOrSpecial() {
        boolean bl = (Boolean)this.getProperty("persistedOrSpecial");
        return bl;
    }

    public void setRole(String string) {
        if (string == null) {
            string = USER_ATTRIBUTE;
        }
        this.setProperty("attributeType", string);
        if (string.equals(END_DATE)) {
            this.setDataType("DATE");
        }
        if (string.equals(TIME_SPAN)) {
            this.setDataType("NUMBER");
        }
    }

    public String getRole() {
        return (String)this.getProperty("attributeType");
    }

    public boolean isDescriptionRole() {
        return this.getRole().equals(LONG_DESCRIPTION) || this.getRole().equals(SHORT_DESCRIPTION);
    }

    public void setLanguage(String string) {
        this.setProperty("attributeLanguage", string);
    }

    public String getLanguage() {
        return (String)this.getProperty("attributeLanguage");
    }

    public void setAttributeVisibleForAll(boolean bl) {
        this.setProperty("attributeVisibleForAll", bl);
    }

    public boolean isAttributeVisibleForAll() {
        Boolean bl = (Boolean)this.getProperty("attributeVisibleForAll");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public boolean isAttributeAllowAutoDataTypeChange() {
        Boolean bl = (Boolean)this.getProperty("attributeAllowAutoDataTypeChange");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setAttributeAllowAutoDataTypeChange(boolean bl) {
        this.setProperty("attributeAllowAutoDataTypeChange", bl);
    }

    public void setIndex(boolean bl) {
        this.setProperty("index", bl);
    }

    public boolean isIndex() {
        Boolean bl = (Boolean)this.getProperty("index");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setStar(boolean bl) {
        this.setProperty("star", bl);
    }

    public boolean isStar() {
        Boolean bl = (Boolean)this.getProperty("star");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setNls(boolean bl) {
        this.setProperty("nls", bl);
    }

    public boolean isNls() {
        Boolean bl = (Boolean)this.getProperty("nls");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setGroupName(String string) {
        this.setProperty("groupName", string);
    }

    public String getGroupName() {
        return (String)this.getProperty("groupName");
    }

    public void setOriginalAttributeName(String string) {
        this.setProperty("originalAttributeName", string);
    }

    public String getOriginalAttributeName() {
        return (String)this.getProperty("originalAttributeName");
    }

    @Override
    public void setDataType(String string) {
        this.setProperty("dataType", string);
    }

    @Override
    public String getDataType() {
        return (String)this.getProperty("dataType");
    }

    public void addSpreadedAttribute(CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute) {
        this.getChildSupport("spreadedAttributes").addChild((Object)cubeDimensionSpreadedAttribute);
    }

    @Transient
    public CubeDimensionSpreadedAttribute[] getSpreadedAttributes() {
        return (CubeDimensionSpreadedAttribute[])this.getChildSupport("spreadedAttributes").getChildArray(CubeDimensionSpreadedAttribute.class);
    }

    public CubeDimensionSpreadedAttribute getSpreadedAttribute(String string) {
        for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : this.getSpreadedAttributes()) {
            String string2 = cubeDimensionSpreadedAttribute.getLevelName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return cubeDimensionSpreadedAttribute;
        }
        return null;
    }

    public void setSpreadedAttributes(CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray) {
        this.getChildSupport("spreadedAttributes").setChildArray((Object[])cubeDimensionSpreadedAttributeArray);
    }

    public CubeDimensionSpreadedAttribute getSpreadedAttributeUsingOriginal(String string) {
        for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : this.getSpreadedAttributes()) {
            String string2 = cubeDimensionSpreadedAttribute.getLevelOriginalName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return cubeDimensionSpreadedAttribute;
        }
        return null;
    }

    public void rename(CubeDimension cubeDimension, String string) {
        String string2 = this.getName();
        CubeDimensionMap cubeDimensionMap = this.getCubeDimension().getMap();
        this.setAttributeMapNameAndOriginal(cubeDimensionMap, string2, string);
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getCubeDimension().getHierarchies()) {
            cubeDimensionMap = cubeDimensionHierarchy.getMap();
            this.setAttributeMapNameAndOriginal(cubeDimensionMap, string2, string);
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                this.setAttributeMapNameAndOriginal(cubeDimensionMap, string2, string);
            }
        }
        if (cubeDimension != null) {
            cubeDimensionMap = cubeDimension.getMap();
            this.setAttributeMapName(cubeDimensionMap, string2, string);
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension.getHierarchies()) {
                cubeDimensionMap = cubeDimensionHierarchy.getMap();
                this.setAttributeMapName(cubeDimensionMap, string2, string);
                for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                    cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                    this.setAttributeMapName(cubeDimensionMap, string2, string);
                }
            }
        }
        this.setName(string);
        if (!this.getPersistedOrSpecial()) {
            this.setOriginalAttributeName(string);
        }
    }

    public void synchSortAttributeName(CubeDimension cubeDimension, String string) {
        CubeDimensionAttribute cubeDimensionAttribute;
        String string2 = this.getName();
        String string3 = cubeDimension.getDimensionSortAttributeName();
        if (string3 != null && string != null && (cubeDimensionAttribute = cubeDimension.findAttribute(string3)) != null && string3.equalsIgnoreCase(string2) && !string2.equalsIgnoreCase(string)) {
            cubeDimension.setDimensionSortAttributeName(string);
        }
    }

    private void setAttributeMapNameAndOriginal(CubeDimensionMap cubeDimensionMap, String string, String string2) {
        if (cubeDimensionMap != null) {
            for (CubeDimensionAttributeMap cubeDimensionAttributeMap : cubeDimensionMap.getAttributeMaps()) {
                if (!cubeDimensionAttributeMap.getMapAttribute().equals(string)) continue;
                cubeDimensionAttributeMap.setMapAttributeAndOriginal(string2);
            }
        }
    }

    private void setAttributeMapName(CubeDimensionMap cubeDimensionMap, String string, String string2) {
        if (cubeDimensionMap != null) {
            for (CubeDimensionAttributeMap cubeDimensionAttributeMap : cubeDimensionMap.getAttributeMaps()) {
                if (!cubeDimensionAttributeMap.getMapAttribute().equals(string)) continue;
                cubeDimensionAttributeMap.setMapAttribute(string2);
            }
        }
    }

    public void setName(String string) {
        super.setName(string);
        String string2 = this.getOriginalAttributeName();
        if (string2 == null) {
            this.setOriginalAttributeName(string);
        }
    }

    public void setParent(DBObject dBObject) {
        if (dBObject instanceof CubeDimension) {
            super.setParent(dBObject);
        }
    }
}

