/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.property.Transient;
import oracle.olap.OLAPArb;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.model.CubeDimensionSpreadedAttribute;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.cubexml.BaseCubeXML;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.olap.graph.DirectedGraph;
import oracle.olap.graph.Vertex;

public class CubeDimension
extends AbstractMappableSchemaObjectWithDesc {
    public static final String TYPE = "CUBE DIMENSION";
    public static final int MAP_DIM_FLAT_WITH_SURROGATE = 1;
    public static final int MAP_DIM_HIERARCHY_WITH_SURROGATE = 2;
    public static final int MAP_DIM_LEVELS_ONLY = 3;
    private static final Object OBJ_LOCK = new Object();
    private static boolean isEventDimTypeChangeActive = false;
    private String custom_order_str;

    public CubeDimension() {
        this.setDimensionMVEnabled(false);
    }

    public String getType() {
        return TYPE;
    }

    public static boolean isDimTypeChangeEventActive() {
        return isEventDimTypeChangeActive;
    }

    public void setDimensionType(String string) {
        isEventDimTypeChangeActive = true;
        if (string == null) {
            this.removeTimeAttributes();
        } else {
            this.addTimeAttributes();
        }
        this.setProperty("dimensionType", string);
        isEventDimTypeChangeActive = false;
    }

    public String getDimensionType() {
        return (String)this.getProperty("dimensionType");
    }

    public void setDimensionClassType(String string) {
        this.setProperty("dimensionClassType", string);
    }

    public String getDimensionClassType() {
        return (String)this.getProperty("dimensionClassType");
    }

    public void setDimensionSortAttributeName(String string) {
        this.setProperty("dimensionSortAttributeName", string);
    }

    public String getDimensionSortAttributeName() {
        return (String)this.getProperty("dimensionSortAttributeName");
    }

    public void setDimensionSortOrder(String string) {
        this.setProperty("dimensionSortOrder", string);
    }

    public String getDimensionSortOrder() {
        return (String)this.getProperty("dimensionSortOrder");
    }

    public void setDimensionNullSortOrder(String string) {
        this.setProperty("dimensionNullSortOrder", string);
    }

    public String getDimensionNullSortOrder() {
        return (String)this.getProperty("dimensionNullSortOrder");
    }

    public void setAddUniqueKeys(boolean bl) {
        this.setProperty("addUniqueKeys", bl);
    }

    public boolean isAddUniqueKeys() {
        Boolean bl = (Boolean)this.getProperty("addUniqueKeys");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public Boolean getAddUniqueKeys() {
        Boolean bl = (Boolean)this.getProperty("addUniqueKeys");
        return bl;
    }

    public void setHierarchyConsistencyRule(String string) {
        this.setProperty("hierarchyConsistencyRule", string);
    }

    public String getHierarchyConsistencyRule() {
        return (String)this.getProperty("hierarchyConsistencyRule");
    }

    public void setDimensionDefaultHierarchyName(String string) {
        this.setProperty("dimensionDefaultHierarchyName", string);
    }

    public String getDimensionDefaultHierarchyName() {
        return (String)this.getProperty("dimensionDefaultHierarchyName");
    }

    @Override
    public boolean isAnalyticWorkspaceRequiredForDDL() {
        return true;
    }

    public CubeDimensionLevel[] getSortedLevels() {
        CubeSubDimension cubeSubDimension;
        ArrayList arrayList = new ArrayList();
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
            if (!cubeDimensionHierarchy.getHierarchyLevelType()) continue;
            Vertex<T>[] vertexArray = new ArrayList();
            CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevelsReverse();
            int n = cubeDimensionHierarchyLevelArray.length;
            for (int i = 0; i < n; ++i) {
                cubeSubDimension = cubeDimensionHierarchyLevelArray[i];
                vertexArray.add(cubeSubDimension.getLevel().getName());
            }
            arrayList.add(vertexArray);
        }
        DirectedGraph directedGraph = new DirectedGraph(arrayList);
        Vertex<T>[] vertexArray = directedGraph.topologicalSort();
        CubeDimensionLevel[] cubeDimensionLevelArray = null;
        if (vertexArray != null) {
            cubeDimensionLevelArray = new CubeDimensionLevel[vertexArray.length];
            int n = 0;
            for (Vertex vertex : vertexArray) {
                cubeSubDimension = this.findLevel((String)vertex.getData());
                cubeDimensionLevelArray[n++] = cubeSubDimension;
            }
        }
        return cubeDimensionLevelArray;
    }

    public CubeDimensionLevel[] getLevels() {
        return (CubeDimensionLevel[])this.getChildSupport("levels").getChildArray(CubeDimensionLevel.class);
    }

    public void removeLevel(CubeDimensionLevel cubeDimensionLevel) {
        this.getChildSupport("levels").removeChild((Object)cubeDimensionLevel);
    }

    public void removeAllLevels() {
        this.getChildSupport("levels").clearChildren();
    }

    public void setLevels(CubeDimensionLevel[] cubeDimensionLevelArray) {
        this.getChildSupport("levels").setChildArray((Object[])cubeDimensionLevelArray);
    }

    public void addLevel(CubeDimensionLevel cubeDimensionLevel) {
        this.getChildSupport("levels").addChild((Object)cubeDimensionLevel);
    }

    public CubeDimensionLevel findLevel(String string) {
        CubeDimensionLevel[] cubeDimensionLevelArray;
        for (CubeDimensionLevel cubeDimensionLevel : cubeDimensionLevelArray = (CubeDimensionLevel[])this.getChildSupport("levels").getChildArray(CubeDimensionLevel.class)) {
            if (!cubeDimensionLevel.getName().equals(string)) continue;
            return cubeDimensionLevel;
        }
        return null;
    }

    public CubeDimensionLevel findLevelFromOriginalName(String string) {
        CubeDimensionLevel[] cubeDimensionLevelArray;
        for (CubeDimensionLevel cubeDimensionLevel : cubeDimensionLevelArray = (CubeDimensionLevel[])this.getChildSupport("levels").getChildArray(CubeDimensionLevel.class)) {
            if (!cubeDimensionLevel.getOriginalLevelName().equals(string)) continue;
            return cubeDimensionLevel;
        }
        return null;
    }

    public CubeDimensionAttribute[] getAttributes() {
        return (CubeDimensionAttribute[])this.getChildSupport("attributes").getChildArray(CubeDimensionAttribute.class);
    }

    public void removeAttribute(CubeDimensionAttribute cubeDimensionAttribute) {
        this.getChildSupport("attributes").removeChild((Object)cubeDimensionAttribute);
    }

    public void removeAllAttributes() {
        this.getChildSupport("attributes").clearChildren();
    }

    public void setAttributes(CubeDimensionAttribute[] cubeDimensionAttributeArray) {
        this.getChildSupport("attributes").setChildArray((Object[])cubeDimensionAttributeArray);
    }

    public void addAttribute(CubeDimensionAttribute cubeDimensionAttribute) {
        this.getChildSupport("attributes").addChild((Object)cubeDimensionAttribute);
    }

    public CubeDimensionAttribute findAttribute(String string) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray = (CubeDimensionAttribute[])this.getChildSupport("attributes").getChildArray(CubeDimensionAttribute.class)) {
            if (!cubeDimensionAttribute.getName().equals(string)) continue;
            return cubeDimensionAttribute;
        }
        return null;
    }

    public CubeDimensionAttribute findAttributeFromOriginalName(String string) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray = (CubeDimensionAttribute[])this.getChildSupport("attributes").getChildArray(CubeDimensionAttribute.class)) {
            if (!cubeDimensionAttribute.getOriginalAttributeName().equals(string)) continue;
            return cubeDimensionAttribute;
        }
        return null;
    }

    public CubeDimensionAttribute findLongDescriptionAttribute() {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray = (CubeDimensionAttribute[])this.getChildSupport("attributes").getChildArray(CubeDimensionAttribute.class)) {
            if (!cubeDimensionAttribute.getRole().equals("LONG_DESCRIPTION")) continue;
            return cubeDimensionAttribute;
        }
        return null;
    }

    public CubeDimensionAttribute findEndDateAttribute() {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray = (CubeDimensionAttribute[])this.getChildSupport("attributes").getChildArray(CubeDimensionAttribute.class)) {
            if (!cubeDimensionAttribute.getRole().equals("END_DATE")) continue;
            return cubeDimensionAttribute;
        }
        return null;
    }

    public CubeDimensionAttribute findTimeSpanAttribute() {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray = (CubeDimensionAttribute[])this.getChildSupport("attributes").getChildArray(CubeDimensionAttribute.class)) {
            if (!cubeDimensionAttribute.getRole().equals("TIME_SPAN")) continue;
            return cubeDimensionAttribute;
        }
        return null;
    }

    public void removeHierarchy(CubeDimensionHierarchy cubeDimensionHierarchy) {
        this.getChildSupport("hierarchies").removeChild((Object)cubeDimensionHierarchy);
    }

    public void removeAllHierarchies() {
        this.getChildSupport("hierarchies").clearChildren();
    }

    public void setHierarchies(CubeDimensionHierarchy[] cubeDimensionHierarchyArray) {
        this.getChildSupport("hierarchies").setChildArray((Object[])cubeDimensionHierarchyArray);
    }

    public void addHierarchy(CubeDimensionHierarchy cubeDimensionHierarchy) {
        this.getChildSupport("hierarchies").addChild((Object)cubeDimensionHierarchy);
    }

    public CubeDimensionHierarchy[] getHierarchies() {
        return (CubeDimensionHierarchy[])this.getChildSupport("hierarchies").getChildArray(CubeDimensionHierarchy.class);
    }

    public CubeDimensionHierarchy findHierarchy(String string) {
        CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
        for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray = (CubeDimensionHierarchy[])this.getChildSupport("hierarchies").getChildArray(CubeDimensionHierarchy.class)) {
            if (!cubeDimensionHierarchy.getName().equals(string)) continue;
            return cubeDimensionHierarchy;
        }
        return null;
    }

    public boolean isValueHierarchy(String string) {
        CubeDimensionHierarchy cubeDimensionHierarchy = this.findHierarchy(string);
        return cubeDimensionHierarchy != null && cubeDimensionHierarchy.getHierarchyValueType();
    }

    public int getHierarchyTypeStatus(String string) {
        CubeDimensionHierarchy cubeDimensionHierarchy = this.findHierarchy(string);
        if (cubeDimensionHierarchy == null) {
            return -1;
        }
        if (cubeDimensionHierarchy != null && cubeDimensionHierarchy.getHierarchyValueType()) {
            return 1;
        }
        return 0;
    }

    public void setMap(CubeDimensionMap cubeDimensionMap) {
        this.setProperty("map", (Object)cubeDimensionMap);
    }

    public CubeDimensionMap getMap() {
        return (CubeDimensionMap)((Object)this.getProperty("map"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimeAttributes() {
        boolean bl = true;
        boolean bl2 = true;
        Object object = OBJ_LOCK;
        synchronized (object) {
            Object object2;
            CubeDimensionAttribute[] cubeDimensionAttributeArray = this.getAttributes();
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray) {
                String string = cubeDimensionAttribute.getRole();
                if (string == null) continue;
                if (string.equals("END_DATE")) {
                    bl = false;
                }
                if (!string.equals("TIME_SPAN")) continue;
                bl2 = false;
            }
            if (bl) {
                object2 = new CubeDimensionAttribute("END_DATE");
                this.addAttribute((CubeDimensionAttribute)object2);
                String string = OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_END_DATE_NAME");
                ((CubeDimensionAttribute)object2).setName(string);
                ((CubeDimensionAttribute)object2).setOriginalAttributeName(string);
                ((CubeDimensionAttribute)object2).setRole("END_DATE");
                ((CubeDimensionAttribute)object2).setPersistedOrSpecial(true);
                ((CubeDimensionAttribute)object2).setDataType("DATE");
                ((CubeDimensionAttribute)object2).setAttributeAllowAutoDataTypeChange(false);
                ((CubeDimensionAttribute)object2).setAttributeVisibleForAll(true);
                ((CubeDimensionAttribute)object2).setStar(true);
                ((AbstractChildObjectWithDesc)object2).setDescription(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_END_DATE"));
                ((AbstractChildObjectWithDesc)object2).setShortDescription(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_END_DATE"));
                ((AbstractChildObjectWithDesc)object2).setLongDescription(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_END_DATE"));
            }
            if (bl2) {
                object2 = new CubeDimensionAttribute("TIME_SPAN");
                this.addAttribute((CubeDimensionAttribute)object2);
                String string = OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_TIME_SPAN_NAME");
                ((CubeDimensionAttribute)object2).setName(string);
                ((CubeDimensionAttribute)object2).setOriginalAttributeName(string);
                ((CubeDimensionAttribute)object2).setRole("TIME_SPAN");
                ((CubeDimensionAttribute)object2).setPersistedOrSpecial(true);
                ((CubeDimensionAttribute)object2).setDataType("NUMBER");
                ((CubeDimensionAttribute)object2).setAttributeAllowAutoDataTypeChange(false);
                ((CubeDimensionAttribute)object2).setAttributeVisibleForAll(true);
                ((CubeDimensionAttribute)object2).setStar(true);
                ((AbstractChildObjectWithDesc)object2).setDescription(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_TIMESPAN"));
                ((AbstractChildObjectWithDesc)object2).setShortDescription(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_TIMESPAN"));
                ((AbstractChildObjectWithDesc)object2).setLongDescription(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_TIMESPAN"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimeAttributes() {
        CubeDimensionAttribute[] cubeDimensionAttributeArray = this.getAttributes();
        Object object = OBJ_LOCK;
        synchronized (object) {
            for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray) {
                String string = cubeDimensionAttribute.getRole();
                if (string == null) continue;
                if (string.equals("END_DATE")) {
                    this.removeAttribute(cubeDimensionAttribute);
                }
                if (!string.equals("TIME_SPAN")) continue;
                this.removeAttribute(cubeDimensionAttribute);
            }
            String string = this.getDimensionSortAttributeName();
            if (string != null) {
                int n = 0;
                for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray) {
                    if (!cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(string)) continue;
                    n = 1;
                }
                if (n == 0) {
                    this.setDimensionSortAttributeName(null);
                }
            }
        }
    }

    public CubeDimensionHierarchyLevel getLeafHierarchyLevel() {
        CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
        for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray = this.getHierarchies()) {
            CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevels();
            if (cubeDimensionHierarchyLevelArray.length <= 0) continue;
            CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = cubeDimensionHierarchyLevelArray[0];
            return cubeDimensionHierarchyLevel;
        }
        return null;
    }

    public CubeDimensionHierarchyLevel findHierarchyLevel(String string) {
        CubeDimensionLevel cubeDimensionLevel = this.findLevel(string);
        if (cubeDimensionLevel != null) {
            CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray = (CubeDimensionHierarchy[])this.getChildSupport("hierarchies").getChildArray(CubeDimensionHierarchy.class)) {
                CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = cubeDimensionHierarchy.findHierarchyLevel(cubeDimensionLevel);
                if (cubeDimensionHierarchyLevel == null) continue;
                return cubeDimensionHierarchyLevel;
            }
        }
        return null;
    }

    public void renameSpreadedAttributesForLevelRename(String string, String string2) {
        CubeDimensionAttribute[] cubeDimensionAttributeArray;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimensionAttributeArray = (CubeDimensionAttribute[])this.getChildSupport("attributes").getChildArray(CubeDimensionAttribute.class)) {
            CubeDimensionLevel[] cubeDimensionLevelArray;
            if (!cubeDimensionAttribute.isStar()) continue;
            for (CubeDimensionLevel cubeDimensionLevel : cubeDimensionLevelArray = (CubeDimensionLevel[])this.getChildSupport("levels").getChildArray(CubeDimensionLevel.class)) {
                CubeDimensionSpreadedAttribute[] cubeDimensionSpreadedAttributeArray;
                if (!cubeDimensionLevel.getName().equalsIgnoreCase(string)) continue;
                for (CubeDimensionSpreadedAttribute cubeDimensionSpreadedAttribute : cubeDimensionSpreadedAttributeArray = cubeDimensionAttribute.getSpreadedAttributes()) {
                    if (!cubeDimensionSpreadedAttribute.getLevelName().equalsIgnoreCase(string)) continue;
                    cubeDimensionSpreadedAttribute.setLevelName(string2.toUpperCase());
                }
            }
        }
    }

    public void removeLevelCascade(String string) {
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
            if (cubeDimensionHierarchy.getHierarchyValueType()) continue;
            ArrayList<CubeDimensionHierarchyLevel> object = new ArrayList<CubeDimensionHierarchyLevel>();
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                String string2;
                String string3 = cubeDimensionHierarchyLevel.getName();
                IdentifierElement identifierElement = new IdentifierElement(string3);
                if (identifierElement.getCount() != 2 || !string.equalsIgnoreCase(string2 = identifierElement.getSecond())) continue;
                object.add(cubeDimensionHierarchyLevel);
            }
            if (object.size() <= 0) continue;
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : object) {
                cubeDimensionHierarchy.removeHierarchyLevel(cubeDimensionHierarchyLevel);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
            if (cubeDimensionHierarchy.getHierarchyValueType() || cubeDimensionHierarchy.getHierarchyLevels().length != 0) continue;
            arrayList.add(cubeDimensionHierarchy);
        }
        if (arrayList.size() > 0) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)iterator.next();
                this.removeHierarchy(cubeDimensionHierarchy);
            }
        }
    }

    public void removeAttributeCascade(CubeDimensionAttribute cubeDimensionAttribute) {
        CubeDimension cubeDimension = (CubeDimension)cubeDimensionAttribute.getParent();
        CubeDimensionMap cubeDimensionMap = cubeDimension.getMap();
        if (cubeDimensionMap != null) {
            cubeDimensionMap.removeNullAttributeMaps();
        }
        CubeDimensionLevel[] cubeDimensionLevelArray = cubeDimension.getLevels();
        CubeSubDimension[] cubeSubDimensionArray = cubeDimensionLevelArray;
        int n = cubeSubDimensionArray.length;
        for (int i = 0; i < n; ++i) {
            CubeDimensionLevel cubeDimensionLevel = cubeSubDimensionArray[i];
            cubeDimensionLevel.removeVisibleAttribute(cubeDimensionAttribute);
            cubeDimensionMap = cubeDimensionLevel.getMap();
            if (cubeDimensionMap == null) continue;
            cubeDimensionMap.removeNullAttributeMaps();
        }
        for (CubeSubDimension cubeSubDimension : cubeSubDimensionArray = cubeDimension.getHierarchies()) {
            CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray;
            cubeSubDimension.removeVisibleAttribute(cubeDimensionAttribute);
            cubeDimensionMap = ((CubeDimensionHierarchy)cubeSubDimension).getMap();
            if (cubeDimensionMap != null) {
                cubeDimensionMap.removeNullAttributeMaps();
            }
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchyLevelArray = ((CubeDimensionHierarchy)cubeSubDimension).getHierarchyLevels()) {
                cubeDimensionHierarchyLevel.removeVisibleAttribute(cubeDimensionAttribute);
                cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                if (cubeDimensionMap == null) continue;
                cubeDimensionMap.removeNullAttributeMaps();
            }
        }
    }

    public List<String> getChildLevels(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevelsReverse()) {
                String string2 = cubeDimensionHierarchyLevel.getLevelName();
                if (string2.equals(string)) {
                    bl = true;
                }
                if (!bl) continue;
                arrayList.add(String.format("%s.%s", this.getName(), cubeDimensionHierarchyLevel.getName()));
            }
        }
        return arrayList;
    }

    public boolean isFlatDimension() {
        return this.getLevels().length == 0 && this.getHierarchies().length == 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMapSnowFlake() {
        Object object;
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
            if (!cubeDimensionHierarchy.getHierarchyLevelType()) continue;
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevelsReverse()) {
                CubeDimensionMap cubeDimensionMap = cubeDimensionHierarchyLevel.getMap();
                if (cubeDimensionMap == null || (object = cubeDimensionMap.getParentKeyExpression()) == null || object.length() <= 0) continue;
                return true;
            }
        }
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
            Object var5_7 = null;
            if (!cubeDimensionHierarchy.getHierarchyLevelType()) continue;
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevelsReverse()) {
                String string;
                String string2;
                void var5_8;
                String string3;
                object = cubeDimensionHierarchyLevel.getMap();
                if (object == null || (string3 = ((CubeDimensionMap)((Object)object)).getMapQuery()) == null) continue;
                if (var5_8 == null) {
                    String string4 = string3;
                }
                if ((string2 = BaseCubeXML.processExpression((String)var5_8)).equals(string = BaseCubeXML.processExpression(string3))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getNotMappableCause() {
        if (this.getLevels().length == 0 && this.getHierarchies().length == 0 && this.getAddUniqueKeys() != null && this.getAddUniqueKeys().booleanValue()) {
            return 1;
        }
        if (this.getLevels().length > 0 && this.getHierarchies().length == 0) {
            return 3;
        }
        if (this.getLevels().length == 0 && this.getHierarchies().length > 0) {
            boolean bl = true;
            for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
                if (!cubeDimensionHierarchy.getHierarchyLevelType()) continue;
                bl = false;
                break;
            }
            if (bl && this.getAddUniqueKeys() != null && this.getAddUniqueKeys().booleanValue()) {
                return 2;
            }
        }
        return 0;
    }

    @Transient
    public String getDimensionUsedInCube() {
        return (String)this.getProperty("dimensionUsedInCube");
    }

    @Transient
    public void setDimensionUsedInCube(String string) {
        this.setProperty("dimensionUsedInCube", string);
    }

    @Transient
    public List<String> getDimensionCubeNames() {
        return (List)this.getProperty("dimensionCubeNames");
    }

    @Transient
    public void setDimensionCubeNames(List<String> list) {
        this.setProperty("dimensionCubeNames", list);
    }

    @Transient
    public String getWhereClause() {
        String string = null;
        if (this.getMap() != null && (string = this.getMap().getMapWhereClause()) != null) {
            return string;
        }
        for (CubeDimensionHierarchy cubeDimensionHierarchy : this.getHierarchies()) {
            if (cubeDimensionHierarchy.getMap() != null && (string = cubeDimensionHierarchy.getMap().getMapWhereClause()) != null) {
                return string;
            }
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                if (cubeDimensionHierarchyLevel.getMap() == null || (string = cubeDimensionHierarchyLevel.getMap().getMapWhereClause()) == null) continue;
                return string;
            }
        }
        return null;
    }

    @Transient
    public void setDimensionMVEnabled(boolean bl) {
        this.setProperty("dimensionMVEnabled", bl);
    }

    @Transient
    public boolean getDimensionMVEnabled() {
        Boolean bl = (Boolean)this.getProperty("dimensionMVEnabled");
        return bl;
    }

    @Transient
    public String getCustomOrderStr() {
        return this.custom_order_str;
    }

    @Transient
    public void setCustomOrderStr(String string) {
        this.custom_order_str = string;
    }

    public String getFormattedDependentCubeNames() {
        List<String> list = this.getDimensionCubeNames();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            stringBuffer.append(string);
            stringBuffer.append(", ");
        }
        Object object = stringBuffer.toString();
        if (((String)object).length() > 2) {
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        return object;
    }

    public static enum MAP_TYPE {
        STAR,
        SNOW_FLAKE;

    }
}

