/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.db.view.AWPanel;

public class CubeDimensionTypeAndAWPanel
extends AWPanel<CubeDimension>
implements ActionListener {
    private JLabel dimensionTypeLabel;
    private JRadioButton standardDimensionRadioButton;
    private JRadioButton timeDimensionRadioButton;
    private boolean initialized = false;
    private boolean radioButtonSelected = false;
    Resources resources = new OLAPResources();

    public CubeDimensionTypeAndAWPanel() {
        this.dimensionTypeLabel = new JLabel(this.resources.getString("CUBE_DIMENSION_TYPE_AW_PANEL_TYPE_LABEL"));
        this.standardDimensionRadioButton = new JRadioButton(this.resources.getString("CUBE_DIMENSION_TYPE_AW_PANEL_TYPE_STANDARD"));
        this.timeDimensionRadioButton = new JRadioButton(this.resources.getString("CUBE_DIMENSION_TYPE_AW_PANEL_TYPE_TIME"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().getClass().equals(JRadioButton.class)) {
            this.radioButtonSelected = true;
            this.setDimensionType();
            CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
            for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimension.getHierarchies()) {
                if (!cubeDimensionHierarchy.getHierarchyLevelType()) continue;
                if (this.timeDimensionRadioButton.isSelected()) {
                    cubeDimensionHierarchy.setNotSkipLevel(true);
                    cubeDimensionHierarchy.setNotRagged(true);
                    continue;
                }
                cubeDimensionHierarchy.setNotSkipLevel(false);
                cubeDimensionHierarchy.setNotRagged(false);
            }
        }
    }

    private void setDimensionType() {
        String string = null;
        if (this.timeDimensionRadioButton.isSelected()) {
            string = "TIME";
        }
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
        cubeDimension.setDimensionType(string);
    }

    @Override
    protected void initialisePanel() {
        CubeDimension cubeDimension;
        String string;
        super.initialisePanel();
        if (this.isEditing()) {
            this.disableDimensionTypeRadioButtons();
        }
        if ((string = (cubeDimension = (CubeDimension)this.getUpdatedObject()).getDimensionType()) == null) {
            this.standardDimensionRadioButton.setSelected(true);
        } else if (string.equalsIgnoreCase("TIME")) {
            this.timeDimensionRadioButton.setSelected(true);
        }
        if (!this.initialized) {
            this.initialized = true;
            ((CubeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    if (CubeDimensionTypeAndAWPanel.this.radioButtonSelected) {
                        return;
                    }
                    Map map = dBObjectChange.getPropertiesChanged();
                    for (String string : map.keySet()) {
                        String string2;
                        String string3;
                        if (!string.equals("name") || CubeDimensionTypeAndAWPanel.this.getUpdatedObject() == null || (string3 = ((CubeDimension)CubeDimensionTypeAndAWPanel.this.getUpdatedObject()).getName()) == null || string3.length() <= 0 || (string3 = string3.toUpperCase()).indexOf(string2 = CubeDimensionTypeAndAWPanel.this.resources.getString("DIMENSION_NAME_FOR_TIME").toUpperCase()) < 0) continue;
                        CubeDimensionTypeAndAWPanel.this.timeDimensionRadioButton.setSelected(true);
                        CubeDimensionTypeAndAWPanel.this.setDimensionType();
                    }
                }
            });
        }
    }

    private void disableDimensionTypeRadioButtons() {
        this.standardDimensionRadioButton.setEnabled(false);
        this.timeDimensionRadioButton.setEnabled(false);
    }

    @Override
    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        super.layoutComponents(dBUILayoutHelper);
        dBUILayoutHelper.nextRow();
        this.standardDimensionRadioButton.addActionListener(this);
        this.timeDimensionRadioButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.standardDimensionRadioButton);
        buttonGroup.add(this.timeDimensionRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.standardDimensionRadioButton);
        jPanel.add(this.timeDimensionRadioButton);
        dBUILayoutHelper.add((Component)this.dimensionTypeLabel, 1, 1, false, true);
        dBUILayoutHelper.add((Component)jPanel, 1, 1, false, true);
        if (this.isEditing()) {
            this.dimensionTypeLabel.setEnabled(false);
        }
    }
}

