/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.olap.app.Resources;
import oracle.olap.app.ui.GroupCheckBoxError;
import oracle.olap.app.ui.GroupCheckBoxModel;
import oracle.olap.app.ui.GroupCheckBoxSelection;
import oracle.olap.app.ui.GroupCheckBoxTable;
import oracle.olap.cube.partition.PartitionCheckBoxModel;

public class PartitionCheckBoxTable
extends GroupCheckBoxTable
implements GroupCheckBoxError {
    private PartitionCheckBoxModel partitionCheckBoxModel;
    private Map<String, Integer[]> queryCounts = new HashMap<String, Integer[]>();
    private boolean autoManageSelectionOrder;
    private Resources resources;

    public PartitionCheckBoxTable(PartitionCheckBoxModel partitionCheckBoxModel, Resources resources) {
        super(partitionCheckBoxModel);
        this.partitionCheckBoxModel = partitionCheckBoxModel;
        this.resources = resources;
    }

    @Override
    public void initialize(List<GroupCheckBoxSelection> list) {
        super.initialize(list);
        this.showQueryCountsWithCheckBox();
    }

    @Override
    public void setModel(GroupCheckBoxModel groupCheckBoxModel) {
        super.setModel(groupCheckBoxModel);
        this.partitionCheckBoxModel = (PartitionCheckBoxModel)groupCheckBoxModel;
    }

    @Override
    public List<GroupCheckBoxSelection> getCheckBoxSelections() {
        return this.checkBoxSelections;
    }

    public List<GroupCheckBoxSelection> getSuperCheckBoxSelections() {
        return super.getCheckBoxSelections();
    }

    public void setAutoManageSelectionOrder(boolean bl) {
        this.autoManageSelectionOrder = bl;
        this.setShowGraphics(bl);
    }

    public void fullInitialize(List<GroupCheckBoxSelection> list) {
        this.queryCounts.clear();
        this.initialize(list);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof GroupCheckBoxTable.GroupCheckBox) {
            GroupCheckBoxTable.GroupCheckBox groupCheckBox = (GroupCheckBoxTable.GroupCheckBox)actionEvent.getSource();
            if (groupCheckBox.isSelected()) {
                int n = this.partitionCheckBoxModel.getMaxGroupSelections();
                if (this.checkBoxSelections.size() == n) {
                    groupCheckBox.setSelected(false);
                    this.reportErrorTooManySelections();
                    return;
                }
                if (this.autoManageSelectionOrder) {
                    this.checkBoxSelections = super.getCheckBoxSelections();
                } else {
                    GroupCheckBoxSelection groupCheckBoxSelection = new GroupCheckBoxSelection(groupCheckBox.getColumnName(), groupCheckBox.getCheckBoxName());
                    this.checkBoxSelections.add(groupCheckBoxSelection);
                }
                this.showQueryCountsWithCheckBox();
            } else {
                GroupCheckBoxSelection groupCheckBoxSelection = null;
                boolean bl = false;
                for (GroupCheckBoxSelection groupCheckBoxSelection2 : this.checkBoxSelections) {
                    if (!groupCheckBoxSelection2.getColumnName().equals(groupCheckBox.getColumnName()) || !groupCheckBoxSelection2.getCheckBoxName().equals(groupCheckBox.getCheckBoxName())) continue;
                    bl = true;
                    groupCheckBoxSelection = groupCheckBoxSelection2;
                    break;
                }
                if (bl) {
                    this.checkBoxSelections.remove(groupCheckBoxSelection);
                    this.showQueryCountsWithCheckBox();
                }
            }
            this.updateObservers();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void reportErrorTooManySelections() {
        JOptionPane.showMessageDialog(this, this.resources.getString("CUBE.PARTITION.SELECTION.PANEL.MAX_SELECTIONS_ERROR.MSG"), this.resources.getString("CUBE.PARTITION.SELECTION.PANEL.MAX_SELECTIONS_ERROR.TITLE"), 0);
    }

    protected String getLevelNamesForPartition(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (Object object : this.groupCheckBoxes) {
            if (!((GroupCheckBoxTable.GroupCheckBox)object).getColumnName().equals(string)) continue;
            if (((GroupCheckBoxTable.GroupCheckBox)object).getCheckBoxName().equals(string2)) {
                bl = true;
                arrayList.add(((GroupCheckBoxTable.GroupCheckBox)object).getCheckBoxName());
                continue;
            }
            if (!bl) continue;
            if (((AbstractButton)object).isSelected()) break;
            arrayList.add(((GroupCheckBoxTable.GroupCheckBox)object).getCheckBoxName());
        }
        boolean bl2 = true;
        for (String string3 : arrayList) {
            if (!bl2) {
                stringBuffer.append(", ");
            }
            bl2 = false;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private void showQueryCountsWithCheckBox() {
        for (GroupCheckBoxTable.GroupCheckBox object : this.groupCheckBoxes) {
            object.setText(object.getCheckBoxName() + " ");
        }
        for (String string : this.partitionCheckBoxModel.getColumnNames()) {
            if (this.queryCounts.get(string) == null) continue;
            Integer[] integerArray = this.queryCounts.get(string);
            int n = 0;
            this.adjustMemberCounts(integerArray);
            for (String string2 : this.partitionCheckBoxModel.getCheckBoxNamesForColumn(string)) {
                GroupCheckBoxTable.GroupCheckBox groupCheckBox = this.getCheckBoxForCheckBoxStart(string, string2);
                if (groupCheckBox != null) {
                    this.displayQueryCountForCheckBox(groupCheckBox, string2, integerArray[n]);
                }
                ++n;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void showQueryCounts(String string, Integer[] integerArray) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showQueryCountsImpl(string, integerArray);
        } else {
            final String string2 = string;
            final Integer[] integerArray2 = integerArray;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PartitionCheckBoxTable.this.showQueryCountsImpl(string2, integerArray2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void showQueryCountsImpl(String string, Integer[] integerArray) {
        this.queryCounts.put(string, integerArray);
        for (Object object : this.groupCheckBoxes) {
            if (!((GroupCheckBoxTable.GroupCheckBox)object).getColumnName().equals(string)) continue;
            ((AbstractButton)object).setText(((GroupCheckBoxTable.GroupCheckBox)object).getCheckBoxName() + " ");
        }
        int n = 0;
        this.adjustMemberCounts(integerArray);
        for (String string2 : this.partitionCheckBoxModel.getCheckBoxNamesForColumn(string)) {
            GroupCheckBoxTable.GroupCheckBox groupCheckBox = this.getCheckBoxForCheckBoxStart(string, string2);
            if (groupCheckBox != null) {
                this.displayQueryCountForCheckBox(groupCheckBox, string2, integerArray[n]);
            }
            ++n;
        }
        this.revalidate();
        this.repaint();
    }

    private void displayQueryCountForCheckBox(GroupCheckBoxTable.GroupCheckBox groupCheckBox, String string, int n) {
        String string2 = n == 10000 ? ">" : "";
        String string3 = this.resources.getString("CUBE.PARTITION.SELECTION.PANEL.MEMBER_COUNT_UNAVAILABLE.LABEL");
        String string4 = this.resources.getString("CUBE.PARTITION.SELECTION.PANEL.MEMBERS.LABEL");
        if (n == -1) {
            if (groupCheckBox.isSelected()) {
                groupCheckBox.setText(groupCheckBox.getText() + " : " + string3);
            } else {
                groupCheckBox.setText(string + " : " + string3);
            }
        } else if (groupCheckBox.isSelected()) {
            groupCheckBox.setText(groupCheckBox.getText() + " : " + string2 + n + " " + string4);
        } else {
            groupCheckBox.setText(string + " : " + string2 + n + " " + string4);
        }
    }

    private void adjustMemberCounts(Integer[] integerArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            if (bl3) {
                if (n2 == -1) {
                    bl = true;
                }
            } else if (n2 == -1) {
                bl2 = true;
            }
            bl3 = false;
        }
        if (bl && !bl2) {
            integerArray[0] = 1;
        }
    }
}

