/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.buildspecifications;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildCommand;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.util.OLAPListTableModel;

public class CubeBuildCommandListTableModel<T>
extends OLAPListTableModel<CubeBuildCommand> {
    public static final int TYPE = 0;
    public static final int OPTION = 1;
    public static final int EXPRESSION = 2;
    public static final int MEASURES = 3;
    public static final int DIMSTATUS = 4;
    private static final String[] COL_NAMES = new String[]{OLAPArb.get("BUILD.SPECIFICATION.COMMAND.TYPE.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.OPTION.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.EXPRESSION.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.MEAS.SELECTION.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.DIM.CONDITION.LABEL")};
    private static final String[] COL_TIPS = new String[]{OLAPArb.get("BUILD.SPECIFICATION.COMMAND.TYPE.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.OPTION.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.EXPRESSION.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.MEAS.SELECTION.LABEL"), OLAPArb.get("BUILD.SPECIFICATION.COMMAND.DIM.CONDITION.LABEL")};
    private Cube cube;

    public CubeBuildCommandListTableModel() {
        super(COL_NAMES, COL_TIPS);
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.setSurrendersFocusOnKeystroke(true);
    }

    public void removeAll() {
        super.removeAll();
    }

    @Override
    protected Object getValueAt(CubeBuildCommand cubeBuildCommand, int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = cubeBuildCommand.getType();
                break;
            }
            case 1: {
                string = cubeBuildCommand.getOption();
                break;
            }
            case 2: {
                string = cubeBuildCommand.getExpression();
                break;
            }
            case 3: {
                string = cubeBuildCommand.getMeasureSelection();
                break;
            }
            case 4: {
                string = cubeBuildCommand.getDimensionCondition();
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.getRowCount();
        if (n < n3) {
            super.setValueAt(object, n, n2);
        }
    }

    @Override
    protected void setValueAt(Object object, CubeBuildCommand cubeBuildCommand, int n) {
        switch (n) {
            case 0: {
                cubeBuildCommand.setType((String)object);
                break;
            }
            case 1: {
                cubeBuildCommand.setOption((String)object);
                break;
            }
            case 2: {
                String string = (String)object;
                cubeBuildCommand.setExpression(string);
                break;
            }
            case 3: {
                cubeBuildCommand.setMeasureSelection((String)object);
                break;
            }
            case 4: {
                String string = (String)object;
                cubeBuildCommand.setDimensionCondition(string);
                break;
            }
        }
    }

    @Override
    protected boolean isCellEditable(CubeBuildCommand cubeBuildCommand, int n) {
        String string = cubeBuildCommand.getType();
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return string.equalsIgnoreCase("LOAD") || string.equalsIgnoreCase("OLAP DML") || string.equalsIgnoreCase("PLSQL");
            }
            case 3: {
                return string.equalsIgnoreCase("LOAD") || string.equalsIgnoreCase("CLEAR") || string.equalsIgnoreCase("OLAP DML") || string.equalsIgnoreCase("SOLVE");
            }
            case 4: {
                return string.equalsIgnoreCase("CLEAR") || string.equalsIgnoreCase("OLAP DML") || string.equalsIgnoreCase("SOLVE");
            }
        }
        return false;
    }

    protected List<CubeBuildCommand> add() {
        ArrayList<CubeBuildCommand> arrayList = new ArrayList<CubeBuildCommand>();
        CubeBuildCommand cubeBuildCommand = new CubeBuildCommand("LOAD");
        if (this.cube != null) {
            String string = CubeBuildSpecification.getDefaultCubeMeasureSelection(this.cube);
            cubeBuildCommand.setMeasureSelection(string);
        }
        arrayList.add(cubeBuildCommand);
        return arrayList;
    }
}

