/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.aggregation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.db.view.DimensionDisplay;
import oracle.olap.db.view.DimensionTree;
import oracle.olap.syntax.CubeAggregationDimension;

public class AggregationHierarchyPanel
extends JPanel
implements PropertyChangeListener {
    private DimensionTree hierarchyTree;
    private JScrollPane hierarchyScrollPane;
    private Cube cube;
    private Object allDimensionListObject;

    public AggregationHierarchyPanel() {
        this.layoutComponents();
    }

    public void initialisePanel(CubeMeasure cubeMeasure, Object object, List<CubeAggregationDimension> list) {
        this.initialisePanel(cubeMeasure.getCube(), object, list);
    }

    public void initialisePanel(Cube cube, Object object, List<CubeAggregationDimension> list) {
        this.cube = cube;
        this.allDimensionListObject = object;
        CubeDimension[] cubeDimensionArray = cube.getDimensions(object);
        this.hierarchyTree.init(cube.getDimensions(object));
        this.hierarchyTree.setSelectedAll(true);
        this.hierarchyTree.setExpandAll();
        if (list != null && list.size() > 0) {
            for (CubeAggregationDimension cubeAggregationDimension : list) {
                String string = cubeAggregationDimension.getName();
                List<CubeDimensionHierarchy> list2 = cubeAggregationDimension.getAggregationHierarchies();
                for (CubeDimension cubeDimension : cubeDimensionArray) {
                    if (!cubeDimension.getName().equalsIgnoreCase(string)) continue;
                    CubeDimensionHierarchy[] cubeDimensionHierarchyArray = cubeDimension.getHierarchies();
                    for (int i = 0; i < cubeDimensionHierarchyArray.length; ++i) {
                        if (list2.contains(cubeDimensionHierarchyArray[i])) continue;
                        this.hierarchyTree.setSelected(cubeDimensionHierarchyArray[i], false);
                    }
                }
            }
        }
    }

    public DimensionTree getDimensionHierarchyTree() {
        return this.hierarchyTree;
    }

    public void setEnablePanel(boolean bl) {
        this.hierarchyTree.enablePropertyChangeListeners(bl);
        this.hierarchyTree.setEditable(bl);
        this.hierarchyTree.setEnabled(bl);
    }

    private void layoutComponents() {
        this.hierarchyTree = new DimensionTree();
        this.hierarchyTree.setName("hierarchyTree");
        this.hierarchyTree.remove(DimensionDisplay.LEVELS);
        this.hierarchyTree.remove(DimensionDisplay.HIERARCHY_LEVELS);
        this.hierarchyScrollPane = new JScrollPane(this.hierarchyTree);
        this.hierarchyScrollPane.setName("hierarchyScrollPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.hierarchyScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof CubeAggregationDimension) {
            String string = propertyChangeEvent.getPropertyName();
            CubeAggregationDimension cubeAggregationDimension = (CubeAggregationDimension)object;
            String string2 = cubeAggregationDimension.getName();
            CubeDimensionality cubeDimensionality = this.cube.findDimensionality(string2);
            CubeDimension cubeDimension = this.cube.getDimensionMap(this.allDimensionListObject).get(cubeDimensionality.getName());
            this.hierarchyTree.enablePropertyChangeListeners(false);
            if (string.equalsIgnoreCase("NODE_SELECTED")) {
                this.hierarchyTree.setSelected(cubeDimension, true);
                this.hierarchyTree.treeDidChange();
            } else if (string.equalsIgnoreCase("NODE_UNSELECTED")) {
                this.hierarchyTree.setSelected(cubeDimension, false);
                this.hierarchyTree.treeDidChange();
            }
            this.hierarchyTree.enablePropertyChangeListeners(true);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.hierarchyTree != null) {
            this.hierarchyTree.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.hierarchyTree != null) {
            this.hierarchyTree.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

