/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.validators.ValidationException;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPImagesArb;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cube.panels.MapSourceJoin;
import oracle.olap.cubedimension.CubeDimensionBuilder;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.db.IdentifierElement;
import oracle.olap.ddl.Identifier;
import oracle.olap.map.panels.MapDefinition;
import oracle.olap.map.panels.MapPanel;
import oracle.olap.navigator.OLAPNavigatorResource;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.ValueComparisonCondition;

public class CubeMapPanel
extends MapPanel<Cube> {
    private Map<String, List<String>> mapObjectElements;
    private Map<String, String> dimMapAt;
    private List mapElements;
    private DefaultTableModel joinTableModel;
    private JTable joinTable;
    private DefaultComboBoxModel aggComboModel;
    private List<MapSourceJoin> joins;
    private LinkedHashSet<String> factSources = new LinkedHashSet();
    private LinkedHashSet<String> dimensionSources = new LinkedHashSet();
    private JPanel joinPanel;
    private boolean joinsChanged;
    private boolean sourceChanged;
    private boolean filterChanged;
    private final int FACT_SOURCE_COLUMN = 0;
    private final int DIMENSION_SOURCE_COLUMN = 1;

    public CubeMapPanel() {
        this.joins = new ArrayList<MapSourceJoin>();
    }

    @Override
    public String[] getMapObjectColumnNames() {
        String[] stringArray = super.getMapObjectColumnNames();
        stringArray[1] = OLAPArb.get("MAP_PANEL_TABLE_CUBE_MAP_OBJECT_COLUMN");
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getUnmappableMessage() throws Exception {
        void var7_14;
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        CubeDimensionBuilder cubeDimensionBuilder = new CubeDimensionBuilder(oracleDatabaseImpl);
        int n = ((Cube)this.getUpdatedObject()).getNotMappableCause();
        String string = null;
        String string2 = null;
        if (n == 1) {
            string = OLAPArb.format("MAP_CUBE_NO_MEASURE_ERR_MSG", ((Cube)this.getUpdatedObject()).getName());
        }
        Object object = this.getDataContext().get("dimensions");
        for (CubeDimension cubeDimension : ((Cube)this.getUpdatedObject()).getDimensions(object)) {
            int n2;
            if (!cubeDimension.isFullyLoaded()) {
                cubeDimensionBuilder.buildDetails(cubeDimension);
            }
            if ((n2 = cubeDimension.getNotMappableCause()) != 1 && n2 != 2) continue;
            string2 = OLAPArb.format("MAP_DIM_SURROGATE_ERR_MSG", cubeDimension.getName());
        }
        Object var7_8 = null;
        if (string != null || string2 != null) {
            String string3 = OLAPArb.format("MAP_CUBE_ERR_MSG", ((Cube)this.getUpdatedObject()).getName()) + "\n";
        }
        if (string != null) {
            void var7_10;
            String string4 = (String)var7_10 + string;
        }
        if (string2 != null) {
            void var7_12;
            String string5 = (String)var7_12 + string2;
        }
        return var7_14;
    }

    @Override
    public Map<String, List<String>> getMapObjectElements() {
        return this.mapObjectElements;
    }

    @Override
    protected void filterUpdated() {
        this.filterChanged = true;
    }

    @Override
    public void sourceValueChanged() throws SQLException {
        Object object;
        Object object2;
        List<DatabaseObject> list = this.getSources();
        Object object3 = this.factSources.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            boolean bl = false;
            if (object2 != null && !((String)object2).isEmpty()) {
                object = new IdentifierElement((String)object2);
                for (DatabaseObject databaseObject : list) {
                    if (!((IdentifierElement)object).getFirst().equals(databaseObject.getSchemaName()) || !((IdentifierElement)object).getSecond().equals(databaseObject.getName())) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            object3.remove();
        }
        this.joinPanel.setVisible(list.size() > 1);
        object3 = new ArrayList();
        object3.addAll(this.joins);
        this.joins.clear();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            MapSourceJoin mapSourceJoin = (MapSourceJoin)object2.next();
            object = mapSourceJoin.getFactExpression();
            String string = mapSourceJoin.getDimensionExpression();
            if (!this.isSourceReferenced(list, (String)object) || !this.isSourceReferenced(list, string)) continue;
            this.joins.add(mapSourceJoin);
        }
        this.loadJoinTable(true);
    }

    @Override
    public void sourceExpressionChange(String string, String string2) throws SQLException, DBException {
        String string3;
        String string4;
        String string5;
        this.sourceChanged = true;
        if (string2.isEmpty()) {
            return;
        }
        String string6 = this.extractSourceFromExpression(string2);
        String string7 = this.getQualifiedSource(string6);
        ArrayList<MapSourceJoin> arrayList = new ArrayList<MapSourceJoin>();
        for (MapSourceJoin object : this.joins) {
            String string8 = object.getDimensionExpression();
            String string9 = this.extractSourceFromExpression(string8);
            Iterator iterator = this.getQualifiedSource(string9);
            boolean bl = false;
            for (int i = 0; i < this.getMapTableModel().getRowCount(); ++i) {
                string5 = (String)this.getMapTableModel().getValueAt(i, 0);
                string4 = this.extractSourceFromExpression(string5);
                string3 = this.getQualifiedSource(string4);
                if (!((String)((Object)iterator)).equals(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(object);
        }
        this.joins.clear();
        this.joins.addAll(arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (String string10 : this.dimensionSources) {
            boolean bl = false;
            for (MapSourceJoin mapSourceJoin : this.joins) {
                String string11 = mapSourceJoin.getDimensionExpression();
                string5 = this.extractSourceFromExpression(string11);
                string4 = this.getQualifiedSource(string5);
                if (!string10.equals(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(string10);
        }
        if (!this.joins.isEmpty()) {
            this.dimensionSources.clear();
            this.dimensionSources.addAll(arrayList2);
        }
        boolean bl = false;
        if (this.isMeasure(string) && string2.length() > 0) {
            if (!this.factSources.contains(string7)) {
                this.factSources.add(string7);
                this.dimensionSources.remove(string7);
                boolean bl2 = true;
                List<Column> list = this.getSourceColumns(string7);
                if (list.size() > 0) {
                    String string12 = "";
                    if (this.dimensionSources.size() > 0) {
                        for (String string13 : this.dimensionSources) {
                            int n;
                            List<Column> list2 = this.getSourceColumns(string13);
                            string5 = new Identifier(string13, list2.get(0).getName()).toString();
                            block5: for (n = 0; n < this.getMapTableModel().getRowCount(); ++n) {
                                string3 = (String)this.getMapTableModel().getValueAt(n, 1);
                                if (this.isMeasure(string3)) continue;
                                String string14 = (String)this.getMapTableModel().getValueAt(n, 0);
                                for (int i = 0; i < list2.size(); ++i) {
                                    String string15;
                                    Identifier identifier = new Identifier(string13);
                                    String[] stringArray = identifier.getComponents();
                                    if (stringArray.length > 1) {
                                        string13 = stringArray[1];
                                    }
                                    if (!(string15 = new Identifier(string13, list2.get(i).getName()).toString()).equals(string14)) continue;
                                    string5 = string15;
                                    continue block5;
                                }
                            }
                            for (n = 0; n < list.size(); ++n) {
                                string3 = new Identifier(string13, list.get(n).getName()).toString();
                                if (!string3.equals(string5)) continue;
                                string12 = new Identifier(string6, list.get(n).getName()).toString();
                                break;
                            }
                            this.joins.add(new MapSourceJoin(string12, string5));
                        }
                    }
                }
            }
        } else if (!this.dimensionSources.contains(string7) && !this.factSources.contains(string7)) {
            this.dimensionSources.add(string7);
            boolean bl3 = true;
            if (this.factSources.size() > 0) {
                this.joins.add(new MapSourceJoin("", string2));
                for (MapSourceJoin mapSourceJoin : this.joins) {
                    if (mapSourceJoin.getDimensionExpression() != null) continue;
                    mapSourceJoin.setDimensionExpression(string6);
                }
            }
        }
        this.loadJoinTable(false);
    }

    public boolean isMeasure(String string) {
        IdentifierElement identifierElement = new IdentifierElement(string);
        return identifierElement.getCount() == 2 && ((Cube)this.getUpdatedObject()).getName().equals(identifierElement.getFirst());
    }

    @Override
    public void setMapTableProperties(JTable jTable) {
        this.setColumnWidth(2, 0);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new MapObjectCellEditor());
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        DefaultTableModel defaultTableModel = this.getMapTableModel();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 1);
            String string2 = (String)this.getMapTableModel().getValueAt(i, 0);
            try {
                this.sourceExpressionChange(string, string2);
                continue;
            }
            catch (Exception exception) {
                String string3 = exception.getStackTrace()[0].toString();
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string3, exception);
            }
        }
        this.joinsChanged = false;
        this.sourceChanged = false;
    }

    @Override
    public Component getJoinMapComponent() {
        JLabel jLabel = new JLabel(OLAPArb.get("MAP_CUBE_JOIN_CLAUSE"));
        jLabel.setName("joinLabel");
        this.joinTableModel = new DefaultTableModel();
        Object[] objectArray = new String[]{OLAPArb.get("MAP_CUBE_JOIN_FACT_TABLE_COLUMN"), OLAPArb.get("MAP_CUBE_JOIN_DIMENSION_TABLE_COLUMN")};
        this.joinTableModel.setColumnIdentifiers(objectArray);
        this.joinTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                CubeMapPanel.this.joinsChanged = true;
                String string = CubeMapPanel.this.getPseudoBuildQuery();
                CubeMapPanel.this.setQuery(string);
            }
        });
        this.joinTable = new JTable(this.joinTableModel);
        this.joinTable.setName("joinTable");
        TableColumn tableColumn = this.joinTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new MapJoinCellEditor());
        tableColumn = this.joinTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new MapJoinCellEditor());
        JScrollPane jScrollPane = new JScrollPane(this.joinTable);
        jScrollPane.setName("joinScrollPane");
        this.joinPanel = new JPanel();
        this.joinPanel.setName("joinPanel");
        this.joinPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.joinPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.joinPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this.joinPanel;
    }

    @Override
    public Component getFunctionComponent() {
        this.aggComboModel = new DefaultComboBoxModel();
        this.aggComboModel.addElement("SUM");
        this.aggComboModel.addElement("MIN");
        this.aggComboModel.addElement("MAX");
        this.aggComboModel.addElement("AVG");
        JPanel jPanel = new JPanel();
        jPanel.setName("aggPanel");
        jPanel.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel(OLAPArb.get("MAP_CUBE_AGGREGATION_LABEL"));
        jPanel.add(jLabel);
        JComboBox jComboBox = new JComboBox(this.aggComboModel);
        jComboBox.setName("aggComboBox");
        jPanel.add(jComboBox);
        return jPanel;
    }

    @Override
    public MapDefinition loadMappings(boolean bl) throws SQLException, DBException {
        String string;
        Object object;
        String string2;
        String string3;
        String string4;
        Object object2;
        AbstractChildDBObject[] abstractChildDBObjectArray;
        String string6;
        this.factSources.clear();
        this.dimensionSources.clear();
        this.joins.clear();
        String string7 = ((Cube)this.getUpdatedObject()).getName();
        this.mapElements = new ArrayList();
        MapDefinition mapDefinition = new MapDefinition();
        this.mapObjectElements = new HashMap<String, List<String>>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        CubeMeasure[] cubeMeasureArray = ((Cube)this.getUpdatedObject()).getMeasures();
        String string8 = ((Cube)this.getUpdatedObject()).getMapQuery();
        HashSet<String> hashSet = new HashSet<String>();
        Object object3 = this.getDataContext().get("dimensions");
        if (((Cube)this.getUpdatedObject()).getMapQuery() != null) {
            string8 = ((Cube)this.getUpdatedObject()).getMapQuery();
            hashSet.add(string8);
        }
        if ((string6 = ((Cube)this.getUpdatedObject()).getAggregationMethod()) != null) {
            this.aggComboModel.setSelectedItem(string6);
        }
        if (cubeMeasureArray != null) {
            abstractChildDBObjectArray = cubeMeasureArray;
            int n = abstractChildDBObjectArray.length;
            for (int i = 0; i < n; ++i) {
                AbstractChildDBObject abstractChildDBObject = abstractChildDBObjectArray[i];
                String string52 = abstractChildDBObject.getName();
                stringBuffer.append(string52 + ",");
                object2 = abstractChildDBObject.getMapExpression();
                if (object2 != null) {
                    stringBuffer2.append((String)object2 + ", ");
                }
                string4 = string52;
                string3 = String.format("%s.%s", string7, string52);
                string2 = "";
                this.mapElements.add(string3);
                mapDefinition.put(string4, (DBObject)abstractChildDBObject, string3, (String)object2, string2, false);
                if (object2 == null) continue;
                object = this.extractSourceFromExpression((String)object2);
                string = this.getQualifiedSource((String)object);
                this.factSources.add(string);
                this.dimensionSources.remove(string);
            }
        }
        if ((abstractChildDBObjectArray = ((Cube)this.getUpdatedObject()).getDimensions()) != null) {
            for (AbstractChildDBObject abstractChildDBObject : abstractChildDBObjectArray) {
                boolean bl2;
                Object object4;
                Object object5;
                object2 = ((Cube)this.getUpdatedObject()).findDimension(object3, abstractChildDBObject.getName());
                string4 = object2.getName();
                stringBuffer.append(string4 + ",");
                string3 = abstractChildDBObject.getMapExpression();
                if (string3 != null) {
                    stringBuffer2.append(string3 + ",");
                    stringBuffer3.append(string3 + ",");
                }
                if ((string2 = abstractChildDBObject.getMappedDimension()) == null) {
                    object = ((CubeDimension)object2).getLeafHierarchyLevel();
                    if (object != null) {
                        string2 = ((CubeDimensionHierarchyLevel)object).getLevel().getName();
                    }
                } else {
                    object = new IdentifierElement(string2);
                    string2 = null;
                    if (((IdentifierElement)object).getCount() == 2) {
                        string2 = ((IdentifierElement)object).get(1);
                    }
                    if (((IdentifierElement)object).getCount() == 3) {
                        string2 = ((IdentifierElement)object).get(2);
                    }
                }
                object = string4;
                string = string4;
                if (string2 != null) {
                    string = String.format("%s.%s", string, string2);
                }
                mapDefinition.put((String)object, (DBObject)object2, string, string3, string2, true);
                if (string3 != null && !string3.isEmpty()) {
                    object5 = this.extractSourceFromExpression(string3);
                    object4 = this.getQualifiedSource((String)object5);
                    bl2 = false;
                    if (!this.factSources.contains(object4)) {
                        this.dimensionSources.add((String)object4);
                    } else {
                        bl2 = true;
                    }
                    String string5 = "";
                    if (abstractChildDBObject.getMapJoinCondition() != null && !abstractChildDBObject.getMapJoinCondition().isEmpty()) {
                        string5 = abstractChildDBObject.getMapJoinCondition();
                        Set<String> set = this.parseSources(hashSet, string5);
                        hashSet.addAll(set);
                        SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string5, null);
                        if (syntaxObject instanceof ValueComparisonCondition) {
                            ValueComparisonCondition valueComparisonCondition = (ValueComparisonCondition)syntaxObject;
                            String string9 = valueComparisonCondition.getLhsArgument().toSyntax();
                            String string10 = valueComparisonCondition.getRhsArgument().toSyntax();
                            string9 = this.processExpression2(string9);
                            string10 = this.processExpression2(string10);
                            String string11 = this.getProvider().getDefaultSchema() + ".";
                            if (string9.startsWith(string11)) {
                                string9 = string9.substring(string11.length(), string9.length());
                            }
                            if (string10.startsWith(string11)) {
                                string10 = string10.substring(string11.length(), string10.length());
                            }
                            String string12 = this.extractSourceFromExpression(string9);
                            String string13 = this.extractSourceFromExpression(string10);
                            if (bl2) {
                                String string14;
                                if (string12.equals(object5)) {
                                    this.joins.add(new MapSourceJoin(string9, string10));
                                    if (!this.dimensionSources.contains(string13)) {
                                        string14 = this.getQualifiedSource(string13);
                                        this.dimensionSources.add(string14);
                                    }
                                } else if (string13.equals(object5)) {
                                    this.joins.add(new MapSourceJoin(string10, string9));
                                    if (!this.dimensionSources.contains(string12)) {
                                        string14 = this.getQualifiedSource(string12);
                                        this.dimensionSources.add(string14);
                                    }
                                }
                            } else if (string12.equals(object5)) {
                                this.joins.add(new MapSourceJoin(string10, string9));
                            } else if (string13.equals(object5)) {
                                this.joins.add(new MapSourceJoin(string9, string10));
                            }
                        }
                    }
                }
                object5 = new ArrayList();
                object4 = new ArrayList();
                for (CubeDimensionHierarchy cubeDimensionHierarchy : ((CubeDimension)object2).getHierarchies()) {
                    if (!cubeDimensionHierarchy.getHierarchyValueType()) continue;
                    object5.add(cubeDimensionHierarchy.getName());
                    object4.add(String.format("%s.%s", string4, cubeDimensionHierarchy.getName()));
                }
                for (CubeSubDimension cubeSubDimension : ((CubeDimension)object2).getSortedLevels()) {
                    object5.add(cubeSubDimension.getName());
                    object4.add(String.format("%s.%s", string4, cubeSubDimension.getName()));
                }
                bl2 = object4.size() == 0;
                int n = 1;
                if (bl2 || !((CubeDimension)object2).isAddUniqueKeys()) {
                    n = 1;
                }
                if (n != 0) {
                    object4.add(string4);
                }
                this.mapObjectElements.put(string4, (List<String>)object5);
                this.mapElements.add(object4);
            }
        }
        LinkedHashSet<MapSourceJoin> linkedHashSet = new LinkedHashSet<MapSourceJoin>(this.joins);
        this.joins.clear();
        this.joins.addAll(linkedHashSet);
        this.loadJoinTable(true);
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (stringBuffer2.toString().endsWith(",")) {
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        }
        if (stringBuffer3.toString().endsWith(",")) {
            stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
        }
        StringBuffer stringBuffer4 = new StringBuffer();
        for (String string15 : this.factSources) {
            if (string15 == null) continue;
            object2 = this.extractSource(string15);
            stringBuffer4.append((String)object2);
            stringBuffer4.append(",");
        }
        for (String string16 : this.dimensionSources) {
            if (string16 == null) continue;
            object2 = this.extractSource(string16);
            stringBuffer4.append((String)object2);
            stringBuffer4.append(",");
        }
        if (stringBuffer4.length() > 0) {
            stringBuffer4.deleteCharAt(stringBuffer4.length() - 1);
        }
        Object object6 = "";
        if (string8 != null) {
            object6 = String.format("select %s \n from %s \n group by %s", stringBuffer2, stringBuffer4, stringBuffer3);
        }
        if (bl) {
            this.setSource(stringBuffer4.toString());
        }
        this.setQuery(((String)object6).toString());
        String string17 = ((Cube)this.getUpdatedObject()).getMapWhereClause();
        if (string17 != null) {
            this.setFilter(string17);
        }
        return mapDefinition;
    }

    private void loadJoinTable(boolean bl) {
        boolean bl2;
        if (bl) {
            this.joinTableModel.setRowCount(0);
        }
        for (MapSourceJoin mapSourceJoin : this.joins) {
            boolean bl3 = false;
            String string = mapSourceJoin.getFactExpression();
            String string2 = mapSourceJoin.getDimensionExpression();
            for (int i = 0; i < this.joinTableModel.getRowCount(); ++i) {
                String string3 = (String)this.joinTableModel.getValueAt(i, 0);
                String string4 = (String)this.joinTableModel.getValueAt(i, 1);
                if (!string3.equalsIgnoreCase(string) || !string4.equalsIgnoreCase(string2)) continue;
                bl3 = true;
            }
            if (bl3) continue;
            this.joinTableModel.addRow(new Object[]{string, string2});
        }
        boolean bl4 = bl2 = this.joins.size() > 0;
        if (!this.joinPanel.isVisible() && bl2) {
            this.joinPanel.setVisible(true);
        }
    }

    @Override
    public String processColumn(String string, String string2) {
        CubeMeasure cubeMeasure = ((Cube)this.getUpdatedObject()).findMeasure(string);
        return string2;
    }

    @Override
    public void clearSourcesNotReferenced(List<DatabaseObject> list) throws SQLException {
        super.clearSourcesNotReferenced(list);
        for (int i = 0; i < this.joinTableModel.getRowCount(); ++i) {
            boolean bl = false;
            String string = (String)this.joinTableModel.getValueAt(i, 0);
            if (!this.isSourceReferenced(list, string)) {
                this.joinTableModel.setValueAt("", i, 0);
                bl = true;
            }
            boolean bl2 = false;
            String string2 = (String)this.joinTableModel.getValueAt(i, 1);
            if (!this.isSourceReferenced(list, string2)) {
                this.joinTableModel.setValueAt("", i, 1);
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            this.joinTableModel.removeRow(i);
        }
    }

    @Override
    public String getPseudoBuildQuery() {
        Object object;
        String string;
        String string2;
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer("\ngroup by ");
        String string3 = null;
        DefaultTableModel defaultTableModel = this.getMapTableModel();
        StringBuffer stringBuffer4 = new StringBuffer();
        boolean bl = true;
        StringBuffer stringBuffer5 = new StringBuffer();
        boolean bl2 = true;
        Object object2 = this.getDataContext().get("dimensions");
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            charSequence = (String)defaultTableModel.getValueAt(i, 0);
            string2 = (String)defaultTableModel.getValueAt(i, 1);
            IdentifierElement identifierElement = new IdentifierElement(string2);
            string = null;
            if (identifierElement.getCount() == 2) {
                string = identifierElement.getSecond();
            }
            if (this.isMeasure(string2)) {
                if (charSequence == null || ((String)charSequence).isEmpty()) {
                    stringBuffer4.append(string + ",");
                    continue;
                }
                object = (String)this.aggComboModel.getSelectedItem();
                stringBuffer2.append(String.format("  %s(%s) as %s,\n ", object, charSequence, identifierElement.getSecond()));
                bl = false;
                continue;
            }
            object = ((Cube)this.getUpdatedObject()).findDimensionality(identifierElement.getFirst());
            CubeDimension cubeDimension = ((Cube)this.getUpdatedObject()).findDimension(object2, object.getName());
            if (object == null) continue;
            if (charSequence == null || ((String)charSequence).isEmpty()) {
                stringBuffer5.append(cubeDimension.getName() + ",");
                continue;
            }
            stringBuffer.append(String.format("  %s, -- Into %s\n", charSequence, string2));
            stringBuffer3.append((String)charSequence + ", ");
            bl2 = false;
        }
        if (stringBuffer5.length() == 0) {
            stringBuffer.insert(0, String.format(" --- %s \n", OLAPArb.get("MAP_CUBE_ALL_DIMS_MAPPED_MSG")));
        } else if (bl2) {
            stringBuffer.insert(0, String.format(" --- %s \n", OLAPArb.get("MAP_CUBE_NO_DIMS_MAPPED_MSG")));
        } else {
            stringBuffer5.delete(stringBuffer5.length() - 2, stringBuffer5.length() - 1);
            stringBuffer.insert(0, String.format(" --- %s\n", OLAPArb.format("MAP_CUBE_SOME_DIMS_UNMAPPED_MSG", stringBuffer5)));
        }
        if (stringBuffer4.length() == 0) {
            stringBuffer2.insert(0, String.format(" --- %s \n", OLAPArb.get("MAP_CUBE_ALL_MEASURES_MAPPED_MSG")));
        } else if (bl) {
            stringBuffer2.insert(0, String.format(" --- %s \n", OLAPArb.get("MAP_CUBE_NO_MEASURES_MAPPED_MSG")));
        } else {
            stringBuffer4.delete(stringBuffer4.length() - 2, stringBuffer4.length() - 1);
            stringBuffer2.insert(0, String.format(" --- %s\n", OLAPArb.format("MAP_CUBE_SOME_MEASURES_UNMAPPED_MSG", stringBuffer4)));
        }
        StringBuffer stringBuffer6 = new StringBuffer(String.format("%s %s", stringBuffer, stringBuffer2));
        charSequence = new StringBuffer();
        string2 = "";
        for (int i = 0; i < this.joinTableModel.getRowCount(); ++i) {
            string = (String)this.joinTableModel.getValueAt(i, 0);
            object = (String)this.joinTableModel.getValueAt(i, 1);
            if (string.isEmpty() || ((String)object).isEmpty()) {
                ((StringBuffer)charSequence).append(" -- Join Condition is required");
                continue;
            }
            ((StringBuffer)charSequence).append(String.format("%s = %s\n and ", string, object));
        }
        String string4 = this.getFilter();
        if (string4.trim().length() > 0) {
            string2 = String.format("\nwhere %s", string4);
        }
        if (((StringBuffer)charSequence).length() > 0) {
            ((StringBuffer)charSequence).delete(((StringBuffer)charSequence).length() - 5, ((StringBuffer)charSequence).length() - 1);
            string2 = string4.trim().length() > 0 ? String.format("\nwhere %s and %s", charSequence, string4) : String.format("\nwhere %s", charSequence);
        }
        if (stringBuffer6.charAt(stringBuffer6.length() - 1) == ' ') {
            stringBuffer6.deleteCharAt(stringBuffer6.length() - 1);
        }
        if (stringBuffer6.charAt(stringBuffer6.length() - 1) == '\n') {
            stringBuffer6.deleteCharAt(stringBuffer6.length() - 1);
        }
        if (stringBuffer6.charAt(stringBuffer6.length() - 1) == ',') {
            stringBuffer6.deleteCharAt(stringBuffer6.length() - 1);
        }
        if (stringBuffer3.charAt(stringBuffer3.length() - 1) == ' ') {
            stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
        }
        if (stringBuffer3.charAt(stringBuffer3.length() - 1) == '\n') {
            stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
        }
        if (stringBuffer3.charAt(stringBuffer3.length() - 1) == ',') {
            stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
        }
        string3 = this.getSource();
        string = "";
        if (!stringBuffer3.toString().isEmpty()) {
            object = OLAPArb.format("CUBE_MAP_QUERY_MSG", ((Cube)this.getUpdatedObject()).getName());
            string = String.format("-- %s\n\nselect\n %s \nfrom %s %s %s", object, stringBuffer6.toString(), string3, string2, stringBuffer3);
        }
        return string;
    }

    @Override
    protected void clearMapView() {
        super.clearMapView();
        this.joinTableModel.setRowCount(0);
        this.joins.clear();
        this.factSources.clear();
        this.dimensionSources.clear();
        this.joinPanel.setVisible(false);
    }

    @Override
    protected void clearMap() {
        this.dimMapAt = new HashMap<String, String>();
        for (CubeDimensionality cubeDimensionality : ((Cube)this.getUpdatedObject()).getDimensions()) {
            String string;
            String string2 = cubeDimensionality.getName();
            String string3 = cubeDimensionality.getMappedDimension();
            if (cubeDimensionality.getMapExpression() != null) {
                this.dimMapAt.put(string2, string3);
            }
            cubeDimensionality.setMappedDimension(null);
            String string4 = cubeDimensionality.getMapExpression();
            if (string4 != null) {
                cubeDimensionality.setMapExpression("");
            }
            if ((string = cubeDimensionality.getMapJoinCondition()) == null) continue;
            cubeDimensionality.setMapJoinCondition("");
        }
        for (AbstractChildDBObject abstractChildDBObject : ((Cube)this.getUpdatedObject()).getMeasures()) {
            abstractChildDBObject.setMapExpression(null);
        }
    }

    @Override
    protected void commitMapTableEdits() {
        super.commitMapTableEdits();
        this.commitJoinTableEdits();
    }

    private void commitJoinTableEdits() {
        if (this.joinTable.isEditing()) {
            int n = this.joinTable.getEditingRow();
            int n2 = this.joinTable.getEditingColumn();
            TableCellEditor tableCellEditor = this.joinTable.getCellEditor(n, n2);
            tableCellEditor.stopCellEditing();
        }
    }

    private DBObject getMapObject(int n) {
        String string = ((Cube)this.getUpdatedObject()).getName();
        String string2 = (String)this.getMapTableModel().getValueAt(n, 1);
        IdentifierElement identifierElement = new IdentifierElement(string2);
        if (identifierElement.getCount() > 0) {
            if (identifierElement.getFirst().equals(string)) {
                if (identifierElement.getCount() > 1) {
                    String string3 = identifierElement.getSecond();
                    CubeMeasure cubeMeasure = ((Cube)this.getUpdatedObject()).findMeasure(string3);
                    return cubeMeasure;
                }
            } else {
                String string4;
                CubeDimensionLevel cubeDimensionLevel;
                Object object = this.getDataContext().get("dimensions");
                CubeDimensionality cubeDimensionality = ((Cube)this.getUpdatedObject()).findDimensionality(identifierElement.getFirst());
                CubeDimension cubeDimension = ((Cube)this.getUpdatedObject()).findDimension(object, cubeDimensionality.getName());
                if (identifierElement.getCount() > 1 && (cubeDimensionLevel = cubeDimension.findLevel(string4 = identifierElement.getSecond())) != null) {
                    return cubeDimensionLevel;
                }
                if (cubeDimension != null) {
                    return cubeDimension;
                }
            }
        }
        return null;
    }

    @Override
    protected void commitEdits() {
        super.commitEdits();
        this.commitJoinTableEdits();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        String string = (String)this.aggComboModel.getSelectedItem();
        ((Cube)this.getUpdatedObject()).setAggregationMethod(string);
        this.commitEdits();
        this.commitJoinTableEdits();
        if (!(this.joinsChanged || this.sourceChanged || this.filterChanged)) {
            return;
        }
        super.commitPanel();
    }

    @Override
    protected void commitMap() throws SQLException, DBException {
        Object object2;
        IdentifierElement identifierElement = null;
        ((Cube)this.getUpdatedObject()).setMapQuery(null);
        ((Cube)this.getUpdatedObject()).setAggregationMethod(null);
        for (Object object2 : ((Cube)this.getUpdatedObject()).getDimensions()) {
            object2.setMapExpression(null);
        }
        String string = (String)this.aggComboModel.getSelectedItem();
        String string2 = ((Cube)this.getUpdatedObject()).getName();
        String string3 = this.getFilter();
        object2 = null;
        boolean bl = false;
        for (int i = 0; i < this.getMapTableModel().getRowCount(); ++i) {
            Object object3;
            Object object4;
            String string4 = (String)this.getMapTableModel().getValueAt(i, 1);
            String string5 = (String)this.getMapTableModel().getValueAt(i, 0);
            if (string5 == null || (identifierElement = new IdentifierElement(string4)).getCount() <= 0) continue;
            if (identifierElement.getFirst().equals(string2)) {
                if (identifierElement.getCount() <= 1) continue;
                object4 = identifierElement.getSecond();
                object3 = ((Cube)this.getUpdatedObject()).findMeasure((String)object4);
                if (object3 == null) continue;
                this.setMeasureExpression((CubeMeasure)object3, string5);
                bl = true;
                continue;
            }
            object4 = ((Cube)this.getUpdatedObject()).findDimensionality(identifierElement.getFirst());
            if (object4 == null) continue;
            object3 = identifierElement.getFirst();
            if (identifierElement.getCount() > 1) {
                object3 = identifierElement.getSecond();
            }
            this.setDimensionExpression((CubeDimensionality)((Object)object4), string5, (String)object3);
        }
        if (!this.factSources.isEmpty()) {
            object2 = Identifier.stripQuotes((String)this.factSources.iterator().next());
            identifierElement = new IdentifierElement((String)object2);
            ((Cube)this.getUpdatedObject()).setMapQuery(identifierElement.getSecond());
            if (string3 != null && !string3.isEmpty()) {
                ((Cube)this.getUpdatedObject()).setMapWhereClause(string3);
            } else {
                ((Cube)this.getUpdatedObject()).setMapWhereClause(null);
            }
            if (bl) {
                ((Cube)this.getUpdatedObject()).setAggregationMethod(string);
            } else {
                ((Cube)this.getUpdatedObject()).setAggregationMethod(((Cube)this.getOriginalObject()).getAggregationMethod());
            }
        }
    }

    private void setMeasureExpression(CubeMeasure cubeMeasure, String string) throws DBException, SQLException {
        String string2 = this.getMapQueryExpression(string);
        ((Cube)this.getUpdatedObject()).setMapQuery(string2);
        if (string2 == null || string2.isEmpty()) {
            string2 = this.getSource().toUpperCase();
        }
        string = this.getExpression(string2, string);
        String string3 = cubeMeasure.getMapExpression();
        if (string3 != null || string3 == null && !string.isEmpty()) {
            cubeMeasure.setMapExpression(string);
        }
    }

    @Override
    protected void validateObject() throws TraversalException {
        CubePartition[] cubePartitionArray;
        super.validateObject();
        for (CubePartition cubePartition : cubePartitionArray = ((Cube)this.getUpdatedObject()).getPartitions()) {
            String string = cubePartition.getPartitionDimension();
            for (CubeDimensionality cubeDimensionality : ((Cube)this.getUpdatedObject()).getDimensions()) {
                String string2 = cubeDimensionality.getMappedDimension();
                if (!string2.equals(string)) continue;
                String string3 = ((Cube)this.getUpdatedObject()).getConsistentSolveSpec();
                Object object = this.getDataContext().get("dimensions");
                List<CubeAggregationDimension> list = SolveSyntax.getInstance().fromSyntax((Cube)this.getUpdatedObject(), ((Cube)this.getUpdatedObject()).getDimensionMap(object), this.getProvider(), string3);
                boolean bl = false;
                for (CubeAggregationDimension cubeAggregationDimension : list) {
                    String string4;
                    if (!string.equals(cubeAggregationDimension.getName()) || (string4 = cubeAggregationDimension.getAggregationFromLevel()) == null) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ValidationException validationException = new ValidationException(this.getUpdatedObject(), OLAPArb.format("CUBE_MAP_SUMMARY_MAP_MSG", string));
                this.processValidationException(validationException);
            }
        }
        super.validateObject();
    }

    private void setDimensionExpression(CubeDimensionality cubeDimensionality, String string, String string2) throws DBException, SQLException {
        String string3;
        String string4;
        String string5;
        Object object;
        int n;
        Object object3;
        Object object4;
        Object object5 = this.getDataContext().get("dimensions");
        CubeDimension cubeDimension = ((Cube)this.getUpdatedObject()).findDimension(object5, cubeDimensionality);
        String string6 = cubeDimension.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string7 = null;
        if (string2 != null) {
            int n2;
            string6 = string2;
            object4 = null;
            if (cubeDimension.getLevels().length > 0 || cubeDimension.getHierarchies().length > 0) {
                object3 = cubeDimension.getHierarchies();
                n2 = ((CubeDimensionHierarchy[])object3).length;
                block0: for (n = 0; n < n2; ++n) {
                    CubeDimensionHierarchy object22 = object3[n];
                    if (object22.isHierarchyDefault()) {
                        object4 = object22;
                    }
                    for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : object22.getHierarchyLevels()) {
                        object = String.format("%s.%s", cubeDimensionHierarchyLevel.getCubeDimension().getName(), cubeDimensionHierarchyLevel.getLevelName());
                        string5 = cubeDimensionHierarchyLevel.getLevelName();
                        if (!((String)object).equals(string2) && !string5.equals(string2)) continue;
                        string4 = String.format("%s.%s.%s", cubeDimension.getName(), object22.getName(), cubeDimensionHierarchyLevel.getLevel().getName());
                        string3 = String.format("%s.%s", cubeDimension.getName(), cubeDimensionHierarchyLevel.getLevel().getName());
                        arrayList.add(string4);
                        arrayList.add(string3);
                        if (!object22.isHierarchyDefault()) continue block0;
                        string7 = string4;
                        continue block0;
                    }
                }
            }
            if (object4 == null && cubeDimension.getHierarchies().length > 0 && arrayList.size() > 0) {
                string7 = (String)arrayList.get(0);
            }
            if ((object3 = this.dimMapAt.get(cubeDimension.getName())) == null && string7 != null) {
                string2 = string7;
            }
            n2 = 0;
            if (object3 != null) {
                for (String string8 : arrayList) {
                    if (!string8.equals(object3)) continue;
                    n2 = 1;
                    break;
                }
            }
            if (n2 == 0) {
                if (string7 != null) {
                    cubeDimensionality.setMappedDimension(string7);
                } else {
                    cubeDimensionality.setMappedDimension(string2);
                }
            } else {
                cubeDimensionality.setMappedDimension((String)object3);
            }
        } else {
            cubeDimensionality.setMappedDimension(null);
        }
        object4 = this.getMapQueryExpression(string);
        if (object4 == null || ((String)object4).isEmpty()) {
            object4 = this.getSource().toUpperCase();
        }
        string = this.getExpression((String)object4, string);
        cubeDimensionality.setMapExpression(string);
        if (string != null) {
            object3 = "";
            IdentifierElement identifierElement = new IdentifierElement(string);
            for (n = 0; n < this.joinTableModel.getRowCount(); ++n) {
                String string9 = (String)this.joinTableModel.getValueAt(n, 0);
                String string10 = (String)this.joinTableModel.getValueAt(n, 1);
                if (string10.equals(string)) {
                    if (string9 == null || string9.isEmpty()) continue;
                    String string11 = String.format("%s = %s", string9, string10);
                    cubeDimensionality.setMapJoinCondition(string11);
                    continue;
                }
                int n2 = 0;
                for (String string12 : this.dimensionSources) {
                    if (n2 == n) {
                        object3 = string12;
                        break;
                    }
                    ++n2;
                }
                List<Column> list = this.getSourceColumns((String)object3);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (Column)iterator.next();
                    string5 = ((Column)object).getName();
                    if (!string5.equals(string4 = identifierElement.getSecond()) || string9 == null || string9.isEmpty()) continue;
                    string3 = String.format("%s = %s", string9, string10);
                    cubeDimensionality.setMapJoinCondition(string3);
                }
            }
        }
    }

    @Override
    protected boolean isColumnEditable(int n) {
        boolean bl = super.isColumnEditable(n);
        if (n == 1) {
            bl = true;
        }
        if (n == 2) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Icon getMapObjectIcon(int n) {
        DBObject dBObject = this.getMapObject(n);
        if (dBObject != null) {
            if (dBObject instanceof CubeDimension) {
                return OLAPImagesArb.getIcon("DIMENSION_ICON");
            }
            if (dBObject instanceof CubeDimensionHierarchy) {
                return OLAPImagesArb.getIcon("HIERARCHY_ICON");
            }
            if (dBObject instanceof CubeDimensionLevel) {
                return OLAPImagesArb.getIcon("LEVEL_ICON");
            }
            if (dBObject instanceof CubeMeasure) {
                return OLAPNavigatorResource.getIcon("OLAPMEASURE_ICON");
            }
        }
        return null;
    }

    class MapJoinCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mapObjectComboBox = new JComboBox();

        public MapJoinCellEditor() {
            this.mapObjectComboBox.setName("mapObjectComboBox");
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
            String string = null;
            if (n2 == 1) {
                int n3 = 0;
                for (Object object2 : CubeMapPanel.this.dimensionSources) {
                    if (n3 == n) {
                        string = object2;
                        break;
                    }
                    ++n3;
                }
            } else {
                string = (String)CubeMapPanel.this.factSources.iterator().next();
            }
            try {
                List<Column> list = CubeMapPanel.this.getSourceColumns(string);
                String string2 = (String)defaultTableModel.getValueAt(n, n2);
                this.mapObjectComboBox.removeAllItems();
                for (Column column : list) {
                    this.mapObjectComboBox.addItem(CubeMapPanel.this.getSourceColumnID(string, column.getName()));
                }
                this.mapObjectComboBox.setSelectedItem(string2);
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            return this.mapObjectComboBox;
        }

        @Override
        public Object getCellEditorValue() {
            String string = "";
            Object object = this.mapObjectComboBox.getSelectedItem();
            if (object != null) {
                string = this.mapObjectComboBox.getSelectedItem().toString();
            }
            return string;
        }
    }

    class MapObjectCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mapObjectComboBox = new JComboBox();

        public MapObjectCellEditor() {
            this.mapObjectComboBox.setName("mapObjectComboBox");
            this.mapObjectComboBox.addItem(OLAPArb.get("AGGREGATE.FROM.LEVEL.DEFAULT"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
            String string = (String)defaultTableModel.getValueAt(n, 1);
            String string2 = (String)defaultTableModel.getValueAt(n, n2);
            List list = CubeMapPanel.this.mapElements;
            Object e = list.get(n);
            if (e instanceof List) {
                List list2 = (List)e;
                this.mapObjectComboBox.removeAllItems();
                for (String string3 : list2) {
                    this.mapObjectComboBox.addItem(string3);
                }
                this.mapObjectComboBox.setSelectedItem(string2);
                return this.mapObjectComboBox;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            String string = OLAPArb.get("AGGREGATE.FROM.LEVEL.DEFAULT");
            string = this.mapObjectComboBox.getSelectedItem().toString();
            return string;
        }
    }
}

