/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DefaultTokenGenerator;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;

public class CubeDDLGenerator
extends TokenDDLGenerator<OracleDDLType> {
    public CubeDDLGenerator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider.getClass(), dBObjectProvider);
        this.registerTokenGenerator("DIMENSIONALITY", (TokenGenerator)new DefaultTokenGenerator("{$dimension} DIMENSION KEY\n"));
        this.registerTokenGenerator("MEASURE", (TokenGenerator)new DefaultTokenGenerator("{$name} {$dataType}\n"));
        this.registerCreateDDL("CUBE", "[{$sqlxmlmap} begin dbms_cube.import_xml(to_clob(\n'{$sqlxmlmap}'\n));\n end;\n ]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerCreateDDL("CUBE", "CREATE CUBE {schema.name} (\n [{$dimensions} {each}...] , [{$measures} {each}...])", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerDropDDL("CUBE", "DROP CUBE {schema.name}", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.DROP));
        this.registerAlterDDL("CUBE", "[{-measures} ALTER CUBE  {schema.name} \nDROP ( {each.\"$name\"} )...]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerAlterDDL("CUBE", "[{+measures} ALTER CUBE  {schema.name} \nADD ( {each} ) )...]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerAlterDDL("CUBE", "[{-dimensions} ALTER CUBE  {schema.name} \nDROP ( {each.\"$name\"} )...]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerAlterDDL("CUBE", "[{+dimensions} ALTER CUBE  {schema.name} \nADD ( {each} )...]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerAlterDDL("CUBE", "[{^sqlxmlmap} begin dbms_cube.import_xml(to_clob(\n'{$sqlxmlmap}'\n));\n end;\n ]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
    }

    private void registerCreateComment() {
        this.registerCreateDDL("CUBE", "[{$description} COMMENT ON CUBE {schema.name} TYPE 'Description' IS '{$description}']", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerCreateDDL("CUBE", "[{$longDescription} COMMENT ON CUBE {schema.name} TYPE 'LongDescription' IS '{$longDescription}']", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerCreateDDL("CUBE", "[{$shortDescription} COMMENT ON CUBE {schema.name} TYPE 'ShortDescription' IS '{$shortDescription}']", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerCreateDDL("CUBE", "[{$measures} [{each.$description} COMMENT ON CUBE DIMENSION {schema.name} FOR MEASURE {each.\"$name\"} IS {each.description};] \n ...]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerCreateDDL("CUBE", "[{$measures} [{each.$longDescription} COMMENT ON CUBE DIMENSION {schema.name} FOR MEASURE {each.\"$name\"} IS {each.longDescription};] \n ...]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerCreateDDL("CUBE", "[{$measures} [{each.$shortDescription} COMMENT ON CUBE DIMENSION {schema.name} FOR MEASURE {each.\"$name\"} IS {each.shortDescription};] \n ...]", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
    }

    private void registerAlterComment() {
        this.registerAlterDDL("CUBE", "[{^description} COMMENT ON CUBE {schema.name} TYPE 'Description' IS '{$description}']", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerAlterDDL("CUBE", "[{^longDescription} COMMENT ON CUBE {schema.name} TYPE 'LongDescription' IS '{$longDescription}']", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
        this.registerAlterDDL("CUBE", "[{^shortDescription} COMMENT ON CUBE {schema.name} TYPE 'ShortDescription' IS '{$shortDescription}']", (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SEQ));
    }
}

