/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.tree.view.JTree2;
import oracle.olap.app.tree.view.NodeIcon;
import oracle.olap.build.BuildObject;
import oracle.olap.build.wizard.BuildObjectsTreeModel;
import oracle.olap.navigator.OLAPNavigatorResource;

public class BuildObjectsTree
extends JTree2 {
    private TreeModel model;
    private boolean addCubeDimensionality;
    private Schema schema;
    public static final String AVAILABLE = "AVAILABLE";
    public static final String SELECTED = "SELECTED";
    private String treeID;

    public BuildObjectsTree(String string) {
        this(string, null);
    }

    public BuildObjectsTree(String string, Schema schema) {
        this.treeID = string;
        this.schema = schema;
        this.addCubeDimensionality = true;
        this.setCellRenderer(new BuildObjectsRenderer());
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public void setModel(TreeModel treeModel) {
        this.model = treeModel;
    }

    @Override
    public TreeModel getModel() {
        return this.model;
    }

    public void setAddCubeDimensionality(boolean bl) {
        this.addCubeDimensionality = bl;
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.model.getRoot();
        if (defaultMutableTreeNode.getUserObject() instanceof BuildObject) {
            BuildObject buildObject = (BuildObject)defaultMutableTreeNode.getUserObject();
            if (buildObject.getType().equalsIgnoreCase("CUBE")) {
                this.addBuildObjectNode(defaultMutableTreeNode2, defaultMutableTreeNode, BuildObjectsTreeModel.CUBES);
            } else if (buildObject.getType().equalsIgnoreCase("CUBE DIMENSION")) {
                this.addBuildObjectNode(defaultMutableTreeNode2, defaultMutableTreeNode, BuildObjectsTreeModel.DIMENSIONS);
            }
        } else if (defaultMutableTreeNode.getUserObject() instanceof Measure) {
            Measure measure = (Measure)defaultMutableTreeNode.getUserObject();
            this.addMeasureNode(defaultMutableTreeNode2, defaultMutableTreeNode, measure.getCube().getName());
        }
    }

    private void addBuildObjectNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, String string) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!defaultMutableTreeNode3.getUserObject().equals(string)) continue;
            if (defaultMutableTreeNode3.getChildCount() == 0) {
                if (this.addCubeDimensionality) {
                    this.addCubeDimensionality(defaultMutableTreeNode, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode3.add(defaultMutableTreeNode2);
                break;
            }
            boolean bl = false;
            for (int j = 0; j < defaultMutableTreeNode3.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(j);
                BuildObject buildObject = (BuildObject)defaultMutableTreeNode4.getUserObject();
                BuildObject buildObject2 = (BuildObject)defaultMutableTreeNode2.getUserObject();
                if (!buildObject.getName().equalsIgnoreCase(buildObject2.getName())) continue;
                bl = true;
                DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0);
                if (defaultMutableTreeNode6.getChildCount() > 0) {
                    this.moveChildMeasures(defaultMutableTreeNode, defaultMutableTreeNode2, buildObject2.getName());
                }
                defaultMutableTreeNode5.remove(defaultMutableTreeNode2);
                break;
            }
            if (bl) break;
            if (this.addCubeDimensionality) {
                this.addCubeDimensionality(defaultMutableTreeNode, defaultMutableTreeNode2);
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            break;
        }
    }

    private void addCubeDimensionality(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        DefaultMutableTreeNode defaultMutableTreeNode3;
        DefaultMutableTreeNode defaultMutableTreeNode4;
        BuildObject buildObject = (BuildObject)defaultMutableTreeNode2.getUserObject();
        if (!buildObject.getType().equalsIgnoreCase("CUBE")) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode5 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!defaultMutableTreeNode4.getUserObject().equals(BuildObjectsTreeModel.DIMENSIONS)) continue;
            defaultMutableTreeNode5 = defaultMutableTreeNode4;
            break;
        }
        if (defaultMutableTreeNode5 != null && this.schema != null && defaultMutableTreeNode2.getParent() != null && (defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent().getParent()) != null) {
            defaultMutableTreeNode4 = this.findBuildObjectsHolderNode(defaultMutableTreeNode3, BuildObjectsTreeModel.DIMENSIONS);
            Cube cube = this.schema.findCube(buildObject.getName());
            for (Dimension dimension : cube.getDimensions()) {
                DefaultMutableTreeNode defaultMutableTreeNode6 = this.findBuildObjectNode(defaultMutableTreeNode4, dimension.getName());
                if (defaultMutableTreeNode6 == null) continue;
                defaultMutableTreeNode5.add(defaultMutableTreeNode6);
            }
        }
    }

    private void moveChildMeasures(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode3;
        DefaultMutableTreeNode defaultMutableTreeNode4 = this.findBuildObjectsHolderNode(defaultMutableTreeNode, BuildObjectsTreeModel.CUBES);
        DefaultMutableTreeNode defaultMutableTreeNode5 = null;
        for (int i = 0; i < defaultMutableTreeNode4.getChildCount(); ++i) {
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(i);
            BuildObject buildObject = (BuildObject)defaultMutableTreeNode3.getUserObject();
            if (!buildObject.getType().equals("CUBE") || !buildObject.getName().equalsIgnoreCase(string)) continue;
            defaultMutableTreeNode5 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode5 != null) {
            DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode5.getChildAt(0);
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0);
            for (int i = 0; i < defaultMutableTreeNode3.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode7 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(i);
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode(defaultMutableTreeNode7.getUserObject()));
            }
        }
    }

    private void addMeasureNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.findBuildObjectsHolderNode(defaultMutableTreeNode, BuildObjectsTreeModel.CUBES);
        if (defaultMutableTreeNode3 != null) {
            DefaultMutableTreeNode defaultMutableTreeNode4;
            DefaultMutableTreeNode defaultMutableTreeNode5;
            if (defaultMutableTreeNode2.getParent().getChildCount() == 1) {
                defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent().getParent();
                if (this.addCubeDimensionality && this.treeID.equalsIgnoreCase(AVAILABLE)) {
                    this.addCubeDimensionality(defaultMutableTreeNode, defaultMutableTreeNode5);
                }
                if (defaultMutableTreeNode5.getParent() != null && (defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode5.getParent()).getParent() != defaultMutableTreeNode) {
                    defaultMutableTreeNode4.remove(defaultMutableTreeNode5);
                }
            }
            if ((defaultMutableTreeNode5 = this.findBuildObjectNode(defaultMutableTreeNode3, string)) != null) {
                defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode5.getChildAt(0);
                if (defaultMutableTreeNode4.getChildCount() > 0) {
                    boolean bl = false;
                    for (int i = 0; i < defaultMutableTreeNode4.getChildCount(); ++i) {
                        Measure measure = (Measure)defaultMutableTreeNode2.getUserObject();
                        DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(i);
                        Measure measure2 = (Measure)defaultMutableTreeNode6.getUserObject();
                        if (!measure2.getName().equalsIgnoreCase(measure.getName())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        defaultMutableTreeNode4.add(defaultMutableTreeNode2);
                    }
                } else {
                    defaultMutableTreeNode4.add(defaultMutableTreeNode2);
                }
            } else {
                defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent().getParent();
                BuildObject buildObject = (BuildObject)defaultMutableTreeNode4.getUserObject();
                if (this.addCubeDimensionality && this.treeID.equalsIgnoreCase(SELECTED)) {
                    this.addCubeDimensionality(defaultMutableTreeNode, defaultMutableTreeNode4);
                }
                DefaultMutableTreeNode defaultMutableTreeNode7 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                defaultMutableTreeNode5 = new DefaultMutableTreeNode(buildObject);
                DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(BuildObjectsTreeModel.MEASURES);
                defaultMutableTreeNode5.add(defaultMutableTreeNode8);
                if (buildObject.isMVRewriteEnabled()) {
                    if (defaultMutableTreeNode7.getChildCount() > 0) {
                        for (int i = 0; i < defaultMutableTreeNode7.getChildCount(); ++i) {
                            DefaultMutableTreeNode defaultMutableTreeNode9 = (DefaultMutableTreeNode)defaultMutableTreeNode7.getChildAt(i);
                            defaultMutableTreeNode8.add(new DefaultMutableTreeNode(defaultMutableTreeNode9.getUserObject()));
                        }
                        DefaultMutableTreeNode defaultMutableTreeNode10 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getParent();
                        if (this.addCubeDimensionality) {
                            this.addCubeDimensionality(defaultMutableTreeNode, defaultMutableTreeNode4);
                        }
                        defaultMutableTreeNode10.remove(defaultMutableTreeNode4);
                    }
                } else {
                    defaultMutableTreeNode8.add(new DefaultMutableTreeNode(defaultMutableTreeNode2.getUserObject()));
                    defaultMutableTreeNode7.remove(defaultMutableTreeNode2);
                }
                defaultMutableTreeNode3.add(defaultMutableTreeNode5);
            }
        }
    }

    private DefaultMutableTreeNode findBuildObjectsHolderNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!defaultMutableTreeNode2.getUserObject().equals(string)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private DefaultMutableTreeNode findBuildObjectNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            BuildObject buildObject = (BuildObject)defaultMutableTreeNode2.getUserObject();
            if (!buildObject.getName().equalsIgnoreCase(string)) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    public void expandTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.expandTree(defaultMutableTreeNode);
    }

    private void expandTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getChildCount() > 0) {
            TreePath treePath = BuildObjectsTree.getPath(defaultMutableTreeNode);
            this.expandPath(treePath);
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                this.expandTree((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            }
        }
    }

    class BuildObjectsRenderer
    extends DefaultTreeCellRenderer {
        NodeIcon nodeIcon;

        public BuildObjectsRenderer() {
            this.nodeIcon = new NodeIcon(){

                @Override
                public Icon getIcon(Object object) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    if (defaultMutableTreeNode.getUserObject() instanceof String) {
                        String string = String.valueOf(defaultMutableTreeNode.getUserObject());
                        if (string.equalsIgnoreCase(BuildObjectsTreeModel.DIMENSIONS)) {
                            return OLAPNavigatorResource.getIcon("OLAPDIMENSION_FOLDER_ICON");
                        }
                        if (string.equalsIgnoreCase(BuildObjectsTreeModel.CUBES)) {
                            return OLAPNavigatorResource.getIcon("OLAPCUBE_FOLDER_ICON");
                        }
                        if (string.equalsIgnoreCase(BuildObjectsTreeModel.MEASURES)) {
                            return OLAPNavigatorResource.getIcon("OLAPMEASURE_FOLDER_ICON");
                        }
                    } else if (defaultMutableTreeNode.getUserObject() instanceof BuildObject) {
                        BuildObject buildObject = (BuildObject)defaultMutableTreeNode.getUserObject();
                        if (buildObject.getType().equalsIgnoreCase("CUBE DIMENSION")) {
                            return OLAPNavigatorResource.getIcon("OLAPDIMENSION_ICON");
                        }
                        if (buildObject.getType().equalsIgnoreCase("CUBE")) {
                            return OLAPNavigatorResource.getIcon("OLAPCUBE_ICON");
                        }
                    } else if (defaultMutableTreeNode.getUserObject() instanceof Measure) {
                        return OLAPNavigatorResource.getIcon("OLAPMEASURE_ICON");
                    }
                    return null;
                }

                @Override
                public Icon getDisabledIcon(Object object) {
                    return this.getIcon(object);
                }
            };
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(this.nodeIcon.getIcon(object));
            return this;
        }
    }
}

