/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.tree.model;

import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.NodeType;
import oracle.olap.app.tree.model.Tree;

public class VirtualTreeModel
extends DefaultTreeModel {
    private Tree tree;
    private boolean multipleRoot;
    private int numberOfLevels = -1;

    public VirtualTreeModel(Tree tree) {
        super(null);
        this.tree = tree;
        tree.setModel(this);
        this.loadCompleteTree();
    }

    public Tree getTree() {
        return this.tree;
    }

    public Node findNode(String string, String string2, SearchOptions searchOptions) {
        return this.tree.findNode(string, string2, searchOptions);
    }

    public void findNodes(String string, String string2, SearchOptions searchOptions, List<Node> list) {
        this.tree.findNodes(string, string2, searchOptions, list);
    }

    public void reinit() {
        this.loadCompleteTree();
    }

    private void loadCompleteTree() {
        this.multipleRoot = false;
        if (this.tree.getRoots().size() == 1) {
            Node node = this.tree.getRoots().get(0);
            this.setRoot(node);
        } else {
            DefaultNode defaultNode = new DefaultNode(this.tree, null, "DUMMY_ROOT");
            this.setRoot(defaultNode);
            for (Node node : this.tree.getRoots()) {
                defaultNode.addChild(node);
            }
            this.multipleRoot = true;
        }
    }

    public boolean isMultipleRoot() {
        return this.multipleRoot;
    }

    @Override
    public void setRoot(TreeNode treeNode) {
        super.setRoot(treeNode);
    }

    public void setFilterDepth(int n) {
        if (n == -1) {
            this.loadCompleteTree();
            return;
        }
        if (this.root instanceof Node) {
            DefaultNode defaultNode = new DefaultNode(this.tree, null, "DUMMY_ROOT");
            this.setRoot(defaultNode);
            this.multipleRoot = true;
            for (Node node : this.tree.getRoots()) {
                this.addNodesAtDepth(defaultNode, node, n);
            }
        }
    }

    private void addNodesAtDepth(Node node, Node node2, int n) {
        if (node2.getDepth() == n) {
            node.addChild(node2);
            return;
        }
        if (n < node2.getDepth()) {
            return;
        }
        List<Node> list = node2.getChildren();
        for (Node node3 : list) {
            this.addNodesAtDepth(node, node3, n);
        }
    }

    @Override
    public Object getChild(Object object, int n) {
        DefaultNode defaultNode = this.getNode(object);
        Node node = defaultNode.getChild(n);
        return node;
    }

    @Override
    public int getChildCount(Object object) {
        DefaultNode defaultNode = this.getNode(object);
        defaultNode.loadChildren().size();
        int n = defaultNode.getChildCount();
        return n;
    }

    private DefaultNode getNode(Object object) {
        return (DefaultNode)object;
    }

    @Override
    public boolean isLeaf(Object object) {
        Node node = (Node)object;
        return this.getRoot() != node && this.numberOfLevels > 0 && node.getDepth() >= this.numberOfLevels - 1;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        int n = ((Node)object).getChildren().indexOf(object2);
        return n;
    }

    public Node newNode(DefaultNode defaultNode, HierarchyNodeData hierarchyNodeData) {
        DefaultNode defaultNode2 = new DefaultNode(this.tree, defaultNode, hierarchyNodeData);
        defaultNode2.setNodeType(NodeType.NEW);
        if (defaultNode == null) {
            this.tree.addRoot(defaultNode2);
        }
        this.tree.logNewNodeChange(defaultNode2);
        if (defaultNode == null) {
            this.loadCompleteTree();
        }
        return defaultNode2;
    }

    public void removeNodeOnly(Node node) {
        this.tree.removeNode(node);
        this.loadCompleteTree();
    }

    public void moveNode(Node node, Node node2) {
        node.setNodeType(NodeType.MOVED);
        this.insertNodeInto(node, node2, 0);
        this.tree.moveNodeChange(node, node2);
    }

    public void removeNodeFromParent(Node node) {
        node.setNodeType(NodeType.REMOVED);
        Node node2 = node.getParent();
        boolean bl = false;
        if (node2 == null) {
            node2 = (Node)this.getRoot();
            bl = true;
        }
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        nArray[0] = node2.getIndex(node);
        node2.remove(nArray[0]);
        objectArray[0] = node;
        this.nodesWereRemoved(node2, nArray, objectArray);
    }

    public void setNumberOfLevels(int n) {
        this.numberOfLevels = n;
    }
}

