/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;

public class TemplateMetadata {
    private Cube cube;
    private Dimension baseDimension;
    private Dimension timeDimension;
    private List<Dimension> refDimensions;

    public TemplateMetadata(Dimension dimension) {
        this.baseDimension = dimension;
        if (dimension.isTime()) {
            this.timeDimension = dimension;
        }
    }

    public TemplateMetadata(Cube cube) {
        this.refDimensions = new ArrayList<Dimension>();
        if (cube != null) {
            this.cube = cube;
            this.timeDimension = this.findTimeDimension(cube.getDimensions());
        }
    }

    public Cube getCube() {
        return this.cube;
    }

    public boolean isCube() {
        return this.cube != null;
    }

    public Dimension getBaseDimension() {
        return this.baseDimension;
    }

    public List<Dimension> getReferenceDimensions() {
        return this.refDimensions;
    }

    public Dimension getTimeDimension() {
        return this.timeDimension;
    }

    private Dimension findTimeDimension(List<Dimension> list) {
        for (Dimension dimension : list) {
            if (!dimension.isTime()) continue;
            return dimension;
        }
        return null;
    }
}

