/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.hierarchyviewer.HierarchyViewerDialog;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.util.OLAPErrorDisplay;

public class TemplateHyperParamHierarchyMembers
extends TemplateHyperParam
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchyMembers.class.getName());
    private DimensionHierarchy hierarchy;
    private HyperLabel membersHyperLabel;
    private QDRData[] qdrs = new QDRData[]{new QDRData("", "0", "")};
    private static final String TEMP_DEFAULT = "'Q1'";
    public static final String DIMENSION_PROPERTY = "dimension";
    private static final ParseNode pattern = new ParseNode("hierarchy_members", Type.LEVEL.toString(), ParseNode.PatternType.LOOP);

    public TemplateHyperParamHierarchyMembers() {
        this.membersHyperLabel = new HyperLabel(TEMP_DEFAULT);
        this.membersHyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamHierarchyMembers.this.showHierarchyMembersDialog();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.membersHyperLabel;
    }

    private void showHierarchyMembersDialog() {
        block16: {
            Object object;
            Object object2;
            OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
            String string = OLAPArb.getString("DIMENSION_MEMBER_SELECTOR_TITLE");
            OLAPResources oLAPResources = new OLAPResources();
            Connection connection = this.getTemplateHyperContext().getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            String string2 = dBUtil.getConnectionResolver().getConnectionName(connection);
            oracle.olap.app.olapmetadata.Dimension dimension = this.hierarchy.getDimension();
            ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
            if (!dimension.isFlat()) {
                object2 = dimension.getHierarchies();
                object = object2.iterator();
                while (object.hasNext()) {
                    DimensionHierarchy dimensionHierarchy = object.next();
                    try {
                        arrayList.add(new HierarchyET(connection, dimension, dimensionHierarchy));
                    }
                    catch (SQLException sQLException) {
                        LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                    }
                }
            } else {
                try {
                    arrayList.add(new HierarchyET(connection, dimension, null));
                }
                catch (SQLException sQLException) {
                    LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                }
            }
            if (arrayList.size() > 0) {
                try {
                    object2 = this.hierarchy.getName();
                    HierarchyViewerDialog hierarchyViewerDialog = new HierarchyViewerDialog(SwingUtilities.getWindowAncestor(this.membersHyperLabel), string, arrayList, (String)object2, oLAPResources, "SELECT_DIMENSION_MEMBERS_MODE", this.qdrs);
                    hierarchyViewerDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    object = new Dimension(350, 400);
                    hierarchyViewerDialog.setPreferredSize((Dimension)object);
                    hierarchyViewerDialog.setSize((Dimension)object);
                    hierarchyViewerDialog.setLocationRelativeTo(this.membersHyperLabel);
                    hierarchyViewerDialog.setVisible(true);
                    boolean bl = hierarchyViewerDialog.isOKSelected();
                    if (!bl) break block16;
                    TreePath[] treePathArray = hierarchyViewerDialog.getTree().getSelectionPaths();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (treePathArray != null) {
                        this.qdrs = new QDRData[treePathArray.length];
                        int n = 0;
                        for (TreePath treePath : treePathArray) {
                            Object object3 = treePath.getLastPathComponent();
                            DefaultNode defaultNode = (DefaultNode)object3;
                            if (!(defaultNode.getUserObject() instanceof HierarchyNodeData)) continue;
                            HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)defaultNode.getUserObject();
                            stringBuffer.append("'" + hierarchyNodeData.dimKey + "'");
                            stringBuffer.append(",");
                            this.qdrs[n++] = new QDRData(this.hierarchy, hierarchyNodeData.dimKey, hierarchyNodeData.desc);
                        }
                        if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        }
                        this.setValue(stringBuffer);
                        TreePath[] treePathArray2 = null;
                        StringBuffer stringBuffer2 = stringBuffer;
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", treePathArray2, stringBuffer2);
                        this.firePropertyChangeEvent(propertyChangeEvent);
                    }
                }
                catch (Exception exception) {
                    oLAPErrorDisplay.show(exception, OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR"), OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), this.membersHyperLabel);
                    LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            } else {
                object2 = null;
                MessageDialog.error((Component)this.membersHyperLabel, (Object)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_NOT_FOUND"), (String)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), (String)object2);
            }
        }
    }

    @Override
    public int getPixelSize(int n) {
        String string = this.membersHyperLabel.getText();
        if (string.length() > 0) {
            return this.membersHyperLabel.getFontMetrics(this.membersHyperLabel.getFont()).stringWidth(string);
        }
        return 100;
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof DimensionHierarchy) {
            DimensionHierarchy dimensionHierarchy = (DimensionHierarchy)propertyChangeEvent.getNewValue();
            this.setHierarchy(dimensionHierarchy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setHierarchy(DimensionHierarchy dimensionHierarchy) {
        if (this.hierarchy == dimensionHierarchy) {
            return;
        }
        this.hierarchy = dimensionHierarchy;
        Param param = this.getParam();
        if (param == null) {
            return;
        }
        String string = param.getDefault();
        Connection connection = this.getTemplateHyperContext().getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.setValue(TEMP_DEFAULT);
        ResultSet resultSet = null;
        if (!Connections.getInstance().lock(connection)) return;
        try {
            CharSequence charSequence;
            String string2 = this.getBaseTemplateHyperView().getExpression(string, null);
            resultSet = dBUtil.executeQuery(string2, new ArrayList());
            ArrayList<String> arrayList = new ArrayList<String>();
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    arrayList.add((String)charSequence);
                }
            }
            if (!arrayList.isEmpty()) {
                this.qdrs = new QDRData[arrayList.size()];
                charSequence = new StringBuilder();
                for (int i = 0; i < this.qdrs.length; ++i) {
                    String string3 = (String)arrayList.get(i);
                    this.qdrs[i] = new QDRData(dimensionHierarchy, string3, "");
                    ((StringBuilder)charSequence).append(String.format("'%s',", string3));
                }
                ((StringBuilder)charSequence).deleteCharAt(((StringBuilder)charSequence).lastIndexOf(","));
                this.setValue(((StringBuilder)charSequence).toString());
            }
            if (resultSet == null) return;
        }
        catch (Exception exception) {
            try {
                LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                if (resultSet == null) return;
            }
            catch (Throwable throwable) {
                if (resultSet == null) throw throwable;
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
            return;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(connection);
        return;
    }

    @Override
    public Object getValue() {
        return this.qdrs;
    }

    @Override
    public String getExpression() {
        return this.membersHyperLabel.getText();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public void setDefault(String string) {
        if (!string.toLowerCase().startsWith("select ")) {
            super.setDefault(string);
        }
    }

    @Override
    public boolean setValue(Object object) {
        this.membersHyperLabel.setText(object.toString());
        return true;
    }
}

