/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import oracle.olap.app.hyper.HyperLinkCombo;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.templates.templateview.ItemSelectedListener;
import oracle.olap.app.templates.templateview.TemplateHyperParam;

public abstract class TemplateHyperParamCombo
extends TemplateHyperParam
implements ItemListener {
    private DefaultComboBoxModel defaultComboBoxModel;
    protected HyperLinkCombo hyperCombo;
    private List<ItemSelectedListener> itemSelectedListeners;
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamCombo.class.getName());
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";

    public TemplateHyperParamCombo() {
        this.initFromConstructor();
    }

    private void initFromConstructor() {
        this.itemSelectedListeners = new ArrayList<ItemSelectedListener>();
        this.defaultComboBoxModel = new DefaultComboBoxModel();
        this.hyperCombo = new HyperLinkCombo((ComboBoxModel)this.defaultComboBoxModel);
        this.hyperCombo.addItemListener(this);
    }

    public void insertElement(Object object, int n) {
        this.defaultComboBoxModel.insertElementAt(object, n);
    }

    public void addElement(Object object) {
        this.defaultComboBoxModel.addElement(object);
    }

    public void removeElement(Object object) {
        this.defaultComboBoxModel.removeElement(object);
    }

    public void removeAllElements() {
        this.defaultComboBoxModel.removeAllElements();
    }

    public boolean setSelectedElement(Object object) {
        if (object == null) {
            return false;
        }
        Object object2 = this.getSelectedElement();
        if (object.equals(this.defaultComboBoxModel.getSelectedItem())) {
            return true;
        }
        for (int i = 0; i < this.defaultComboBoxModel.getSize(); ++i) {
            Object e = this.defaultComboBoxModel.getElementAt(i);
            if (!e.equals(object)) continue;
            this.defaultComboBoxModel.setSelectedItem(e);
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", object2, object);
            this.firePropertyChangeEvent(propertyChangeEvent);
            return true;
        }
        return false;
    }

    public Object getSelectedElement() {
        Object object = this.defaultComboBoxModel.getSelectedItem();
        return object;
    }

    @Override
    public Object getValue() {
        Object object = this.defaultComboBoxModel.getSelectedItem();
        return object;
    }

    @Override
    public Object getValue(String string) {
        Object object = this.defaultComboBoxModel.getSelectedItem();
        if ((string.toLowerCase().endsWith(NAME) || string.toLowerCase().endsWith(DESCRIPTION)) && object instanceof ItemElement) {
            ItemElement itemElement = (ItemElement)object;
            object = itemElement.getProperty(string);
        }
        return object;
    }

    @Override
    public boolean setValue(Object object) {
        return this.setSelectedElement(object);
    }

    public final DefaultComboBoxModel getComboBoxModel() {
        return this.defaultComboBoxModel;
    }

    @Override
    public Component getComponent() {
        return this.hyperCombo;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        if (this.isSaveSelectionToParam()) {
            object = this.getSelectedElement();
            if (this.getParam() != null) {
                this.updateDefault(object);
            }
        }
        if (itemEvent.getStateChange() == 1) {
            object = null;
            Object object2 = itemEvent.getItem();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", object, object2);
            this.fireItemSelection();
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    public void firePropertyChangeEvent() {
        Object object = this.getSelectedElement();
        Object var2_2 = null;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", var2_2, object);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    public void updateDefault(Object object) {
        if (object != null) {
            if (object instanceof NamedObjectWithDesc) {
                this.getParam().updateDefault(((NamedObjectWithDesc)object).getName());
            } else {
                this.getParam().updateDefault(object.toString());
            }
        } else {
            this.getParam().updateDefault(null);
        }
    }

    public boolean isSaveSelectionToParam() {
        return true;
    }

    public void fireItemSelection() {
        for (ItemSelectedListener itemSelectedListener : this.itemSelectedListeners) {
            LOG.finest("firing Item Selection " + itemSelectedListener);
            itemSelectedListener.itemSelected(this);
        }
    }

    public void addItemSelectionListener(ItemSelectedListener itemSelectedListener) {
        this.itemSelectedListeners.add(itemSelectedListener);
    }

    public void removeItemSelectionListener(ItemSelectedListener itemSelectedListener) {
        this.itemSelectedListeners.remove(itemSelectedListener);
    }

    @Override
    public String getDefault() {
        String string = super.getDefault();
        if (string == null && this.getParam() != null && this.getParam().getItems().size() > 0) {
            string = this.getParam().getItems().get(0).getExpression();
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return this.getComboBoxModel() != null && this.getComboBoxModel().getSize() > 0;
    }

    @Override
    public int getPixelSize(int n) {
        if (this.getExpression() != null) {
            return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.getExpression());
        }
        return 100;
    }
}

