/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.app.dimension.SelectMemberDialog;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionView;
import oracle.olap.app.olapmetadata.DimensionViewColumn;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamBaseDimension
extends TemplateHyperParam {
    private HyperLabel hyperLabel = new HyperLabel("");
    private Dimension dimension;
    private String member;
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamBaseDimension.class.getName());
    private static final ParseNode pattern = new ParseNode("base_dimension", Type.DIMENSION.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamBaseDimension() {
        this.hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamBaseDimension.this.showDimensionSelection();
            }
        });
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    private void showDimensionSelection() {
        DimensionHierarchy dimensionHierarchy = this.dimension.getDefaultHierarchy();
        String string = null;
        if (dimensionHierarchy != null) {
            string = dimensionHierarchy.getName();
        }
        SelectMemberDialog selectMemberDialog = new SelectMemberDialog(this.getTemplateContext().getDatabase().getConnection(), this.dimension.getSchema().getName(), this.dimension.getName(), string);
        selectMemberDialog.setSize(500, 450);
        selectMemberDialog.setLocationRelativeTo(this.hyperLabel);
        selectMemberDialog.setModal(true);
        selectMemberDialog.setVisible(true);
        if (selectMemberDialog.clickedOK()) {
            this.member = selectMemberDialog.getSelectedMember();
            this.hyperLabel.setText((String)this.getValue());
        }
    }

    public void setDimension(Dimension dimension) throws SQLException, IOException {
        block1: {
            this.dimension = dimension;
            this.hyperLabel.setText(dimension.getName());
            DimensionView dimensionView = dimension.getView();
            DimensionViewColumn dimensionViewColumn = dimensionView.findColumnType("KEY");
            if (dimensionViewColumn == null) break block1;
            String string = "select " + dimensionViewColumn.getName() + " from " + dimensionView.getName() + " where rownum=1";
            List<List<String>> list = this.getTemplateContext().getDatabase().executeSQL(string);
            Iterator<List<String>> iterator = list.iterator();
            if (iterator.hasNext()) {
                List<String> list2 = iterator.next();
                this.member = list2.get(0);
                this.hyperLabel.setText((String)this.getValue());
            }
        }
    }

    @Override
    public String getExpression() {
        if (this.dimension != null) {
            if (this.member == null) {
                return this.dimension.getName();
            }
            return this.dimension.getName() + "='" + this.member + "'";
        }
        return "";
    }

    @Override
    public Object getValue() {
        if (this.dimension != null) {
            if (this.member == null) {
                return this.dimension.getName();
            }
            return this.dimension.getName() + "='" + this.member + "'";
        }
        return "";
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof String) {
            this.hyperLabel.setText((String)object);
        }
        return true;
    }

    @Override
    public Component getComponent() {
        return this.hyperLabel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void init() {
        if (this.getTemplateContext().getBaseDimension() != null) {
            try {
                this.setDimension(this.getTemplateContext().getBaseDimension());
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
    }

    @Override
    public int getPixelSize(int n) {
        return this.hyperLabel.getFontMetrics(this.hyperLabel.getFont()).stringWidth(this.getExpression());
    }
}

