/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.table;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.app.table.Column;
import oracle.olap.app.table.Format;
import oracle.olap.app.table.Query;
import oracle.olap.app.table.QueryPanel;
import oracle.olap.app.table.QueryTableCellViewer;
import oracle.olap.app.table.QueryTableModel;
import oracle.olap.app.table.TableLabelCellRenderer;
import oracle.olap.app.table.TextFormatter;
import oracle.olap.app.table.TooltipFormat;
import oracle.olap.app.table.View;

public class QueryTable
extends GenericTable {
    private QueryTableModel queryTableModel;
    private Query query;
    private View view;
    private List<Format> formats;
    private Map<String, TextFormatter> m_textFormatters;

    public QueryTable(QueryTableModel queryTableModel, List<Format> list) {
        super((TableModel)queryTableModel);
        this.queryTableModel = queryTableModel;
        this.query = queryTableModel.getQuery();
        this.view = this.query.getView();
        this.formats = list;
        this.m_textFormatters = new HashMap<String, TextFormatter>();
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = null;
            String string2 = exception.getLocalizedMessage();
            if (string2 == null || string2.length() == 0) {
                string2 = exception.getClass().toString();
            }
            String string3 = OLAPArb.get("GENERIC_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string);
        }
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (component instanceof JComponent) {
            Format format;
            List<Column> list;
            Column column;
            JComponent jComponent = (JComponent)component;
            String string = (String)this.getValueAt(n, n2);
            if (this.view != null && (column = (list = this.view.getColumnList()).get(n2)).getFormatting() != null && string != null && (format = QueryPanel.getFormat(this.formats, column.getFormatting())) != null) {
                TooltipFormat tooltipFormat = format.getTooltipFormat();
                try {
                    if (this.m_textFormatters.get(column.getFormatting()) == null) {
                        this.m_textFormatters.put(column.getFormatting(), (TextFormatter)tooltipFormat.getClassParam().newInstance());
                    }
                    TextFormatter textFormatter = this.m_textFormatters.get(column.getFormatting());
                    string = textFormatter.getText(string);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            jComponent.setToolTipText(string);
        }
        return component;
    }

    private void init() throws Exception {
        this.setDefaultEditor(Object.class, new QueryTableCellViewer(this.formats, this.view));
        this.setDefaultRenderer(Object.class, new TableLabelCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (QueryTable.this.view != null) {
                    List<Column> list = QueryTable.this.view.getColumnList();
                    for (Column column : list) {
                        String string;
                        if (!column.getName().equalsIgnoreCase(jTable.getColumnName(n2)) || (string = column.getJustify()) == null) continue;
                        if (string.equalsIgnoreCase("RIGHT")) {
                            this.setHorizontalAlignment(4);
                            continue;
                        }
                        if (!string.equalsIgnoreCase("LEFT")) continue;
                        this.setHorizontalAlignment(2);
                    }
                }
                return this;
            }
        });
        this.setColumnWidths();
    }

    private void setColumnWidths() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            String string = (String)tableColumn.getHeaderValue();
            if (this.view == null) continue;
            List<Column> list = this.view.getColumnList();
            for (Column column : list) {
                int n;
                if (!column.getName().equalsIgnoreCase(string) || (n = column.getWidth()) <= 0) continue;
                tableColumn.setPreferredWidth(n);
            }
        }
    }
}

