/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.util.Logger;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionHierarchyView;
import oracle.olap.app.olapmetadata.DimensionHierarchyViewColumn;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.SubDimension;

public class DimensionHierarchy
extends SubDimension {
    public static final String LEVEL = "LEVEL";
    private List<DimensionHierarchyLevel> hierLevels = new ArrayList<DimensionHierarchyLevel>();
    private boolean levelBased;
    private boolean isRagged;
    private boolean isSkipLevel;
    private DimensionHierarchyView hierarchyView;
    private Database database;

    public DimensionHierarchy(Dimension dimension, String string, String string2, String string3, boolean bl, boolean bl2) {
        super(dimension, string, string2);
        this.levelBased = string3.equals(LEVEL);
        this.isRagged = bl;
        this.isSkipLevel = bl2;
    }

    public DimensionHierarchy(Database database, Dimension dimension, String string, String string2, String string3, boolean bl, boolean bl2) {
        this(dimension, string, string2, string3, bl, bl2);
        this.database = database;
    }

    public boolean isLevelBased() {
        return this.levelBased;
    }

    public boolean isRagged() {
        return this.isRagged;
    }

    public boolean isSkipLevel() {
        return this.isSkipLevel;
    }

    public void setETViewName(String string) {
        if (this.hierarchyView == null) {
            this.hierarchyView = new DimensionHierarchyView(this, string);
        } else {
            this.hierarchyView.setName(string);
        }
    }

    public String getViewName() {
        if (this.database != null) {
            String string = null;
            try {
                string = this.database.getUser();
            }
            catch (Exception exception) {
                Logger.severe(DimensionHierarchy.class, (Throwable)exception);
            }
            if (string != null && !string.equalsIgnoreCase(this.getDimension().getSchema().getName())) {
                return this.getDimension().getSchema().getName() + "." + this.hierarchyView.getName();
            }
        }
        return this.hierarchyView != null ? this.hierarchyView.getName() : null;
    }

    public DimensionHierarchyView getView() {
        return this.hierarchyView;
    }

    public List<DimensionHierarchyLevel> getHierarchyLevels() {
        return this.hierLevels;
    }

    public DimensionHierarchyLevel addHierarchyLevel(DimensionLevel dimensionLevel, String string) {
        DimensionHierarchyLevel dimensionHierarchyLevel = new DimensionHierarchyLevel(this, dimensionLevel, string);
        this.hierLevels.add(dimensionHierarchyLevel);
        return dimensionHierarchyLevel;
    }

    public DimensionHierarchyLevel addHierarchyLevel(DimensionLevel dimensionLevel, String string, int n) {
        DimensionHierarchyLevel dimensionHierarchyLevel = new DimensionHierarchyLevel(this, dimensionLevel, string);
        this.hierLevels.add(n, dimensionHierarchyLevel);
        return dimensionHierarchyLevel;
    }

    public DimensionHierarchyLevel findHierarchyLevel(String string) {
        for (DimensionHierarchyLevel dimensionHierarchyLevel : this.hierLevels) {
            if (!dimensionHierarchyLevel.getDimensionLevel().getName().equals(string)) continue;
            return dimensionHierarchyLevel;
        }
        return null;
    }

    public int getDepth(DimensionHierarchyLevel dimensionHierarchyLevel) {
        int n = 1;
        for (DimensionHierarchyLevel dimensionHierarchyLevel2 : this.hierLevels) {
            if (dimensionHierarchyLevel2.getDimensionLevel().getName().equals(dimensionHierarchyLevel.getLevelName())) break;
            ++n;
        }
        return n;
    }

    public String getKeyColumnName() {
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = this.getView().findColumnType("KEY");
        return dimensionHierarchyViewColumn != null ? dimensionHierarchyViewColumn.getName() : null;
    }

    public String getParentColumnName() {
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = this.getView().findColumnType("PARENT");
        return dimensionHierarchyViewColumn != null ? dimensionHierarchyViewColumn.getName() : null;
    }

    public String getDepthColumnName() {
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = this.getView().findColumnType("DEPTH");
        return dimensionHierarchyViewColumn != null ? dimensionHierarchyViewColumn.getName() : null;
    }

    public String getLevelColumnName() {
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = this.getView().findColumnType("LEVEL_NAME");
        return dimensionHierarchyViewColumn != null ? dimensionHierarchyViewColumn.getName() : null;
    }

    public String getOrderColumnName() {
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = this.getView().findColumnType("HIER_ORDER");
        return dimensionHierarchyViewColumn != null ? dimensionHierarchyViewColumn.getName() : null;
    }

    public String getShortDescriptionDisplayColumnName() {
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn;
        DimensionAttribute dimensionAttribute = this.getDimension().findAttributeRole("SHORT_DESCRIPTION");
        if (dimensionAttribute != null && (dimensionHierarchyViewColumn = this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName())) != null) {
            return dimensionHierarchyViewColumn.getName();
        }
        return null;
    }

    public String getLongDescriptionDisplayColumnName() {
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn;
        DimensionAttribute dimensionAttribute = this.getDimension().findAttributeRole("LONG_DESCRIPTION");
        if (dimensionAttribute != null && (dimensionHierarchyViewColumn = this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName())) != null) {
            return dimensionHierarchyViewColumn.getName();
        }
        return null;
    }

    public String getDisplayColumnName() {
        DimensionAttribute dimensionAttribute = this.getDimension().findAttributeRole("SHORT_DESCRIPTION");
        if (dimensionAttribute == null) {
            dimensionAttribute = this.getDimension().findAttributeRole("LONG_DESCRIPTION");
        }
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = null;
        dimensionHierarchyViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
        if (dimensionHierarchyViewColumn != null) {
            return dimensionHierarchyViewColumn.getName();
        }
        return null;
    }

    public String getDescriptionColumnName() {
        DimensionAttribute dimensionAttribute = this.getDimension().findAttributeRole("DESCRIPTION");
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = null;
        dimensionHierarchyViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
        if (dimensionHierarchyViewColumn != null) {
            return dimensionHierarchyViewColumn.getName();
        }
        return null;
    }

    public String getLongDescriptionColumnName() {
        DimensionAttribute dimensionAttribute = this.getDimension().findAttributeRole("LONG_DESCRIPTION");
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = null;
        dimensionHierarchyViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
        if (dimensionHierarchyViewColumn != null) {
            return dimensionHierarchyViewColumn.getName();
        }
        return null;
    }

    public String getShortDescriptionColumnName() {
        DimensionAttribute dimensionAttribute = this.getDimension().findAttributeRole("SHORT_DESCRIPTION");
        DimensionHierarchyViewColumn dimensionHierarchyViewColumn = null;
        dimensionHierarchyViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
        if (dimensionHierarchyViewColumn != null) {
            return dimensionHierarchyViewColumn.getName();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("%s.%s HierarchyLevels", this.getDimension().getName(), this.getName()));
        stringBuffer.append(" [");
        for (DimensionHierarchyLevel dimensionHierarchyLevel : this.hierLevels) {
            stringBuffer.append(dimensionHierarchyLevel.getDimensionLevel().getName());
            stringBuffer.append(",");
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

