/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapixml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.cubetemplate.CubeTemplateManager;
import oracle.olap.cubetemplate.PLSQLForXMLGenerator;

public class MetadataUtil {
    private static Logger LOG = Logger.getLogger(CubeTemplateManager.class.getName());

    private MetadataUtil() {
    }

    public static String GetFullXML(String string) {
        return MetadataUtil.GetHeader() + string + MetadataUtil.GetFooter();
    }

    public static String GetHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Metadata\n");
        stringBuffer.append("  Version=\"1.2\" MinimumDatabaseVersion=\"11.2\">\n");
        return stringBuffer.toString();
    }

    public static String GetFooter() {
        return "</Metadata>";
    }

    public static String GenerateCubeSQLXML(String string) {
        return MetadataUtil.GenerateCubeSQLXML("xmlCLOB", string);
    }

    public static String GenerateCubeSQLXML(String string, String string2) {
        return MetadataUtil.GenerateCubeSQLXML(string, string2, true);
    }

    public static String GenerateCubeSQLXML(String string, String string2, boolean bl) {
        String string3 = "tmp :='";
        String string4 = String.format("';%ndbms_lob.writeappend(%s, length(tmp), tmp);%n", string);
        int n = (string2.length() / 3500 + 1) * (string3.length() + string4.length());
        String string5 = null;
        String string6 = null;
        if (bl) {
            string5 = String.format("DECLARE%n%1$s clob;%ntmp varchar2(4000);%nBEGIN%ndbms_lob.createtemporary(%1$s,TRUE);%ndbms_lob.open(%1$s, DBMS_LOB.LOB_READWRITE);%n", string);
            string6 = "dbms_cube.import_xml(xmlClob);\ndbms_lob.close(xmlClob);\nEND;\n";
        } else {
            string5 = String.format("DECLARE%n%1$s clob;%nxmlOptionsCLOB clob;%nxmlOutCLOB clob := NULL;%ntmp varchar2(4000);%nBEGIN%ndbms_lob.createtemporary(%1$s,TRUE);%ndbms_lob.createtemporary(xmlOptionsCLOB,TRUE);%ndbms_lob.open(%1$s, DBMS_LOB.LOB_READWRITE);%n", string);
            string6 = "dbms_cube.create_import_options(out_options_xml=>xmlOptionsCLOB, modify_if_exists => false);\ndbms_cube.import_xml(in_xml => xmlClob, options_xml => xmlOptionsCLOB, out_xml => xmlOutCLOB);\ndbms_lob.close(xmlClob);\nEND;\n";
        }
        StringWriter stringWriter = new StringWriter(string5.length() + string6.length() + n);
        stringWriter.append(string5);
        try {
            PLSQLForXMLGenerator.writePLSQLPieces(string2, stringWriter, string3, string4, true);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        stringWriter.append(string6);
        return stringWriter.toString();
    }
}

