/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.db;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OraclePreparedStatement;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.RowSetCallBack;
import oracle.olap.app.db.RowSetMetadataCallback;
import oracle.sql.CLOB;

public class DatabaseUtils {
    public static Connection GetConnection(String string, String string2, String string3) throws SQLException {
        DriverManager.registerDriver((Driver)new OracleDriver());
        if (!string.startsWith("jdbc:")) {
            string = "jdbc:oracle:thin:@" + string;
        }
        return DriverManager.getConnection(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List GetSchemas(Connection connection) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try (ResultSet resultSet = null;){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getSchemas();
            while (resultSet.next()) {
                arrayList.add(resultSet.getObject(1));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List GetTables(Connection connection, String string) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try (ResultSet resultSet = null;){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getTables(null, string, null, null);
            while (resultSet.next()) {
                arrayList.add(resultSet.getObject(3));
            }
        }
        return arrayList;
    }

    public static List GetViews(Connection connection, String string) throws SQLException, IOException {
        ArrayList arrayList = new ArrayList();
        String string2 = "select view_name from user_views";
        List list = DatabaseUtils.ExecuteSQL(connection, string2);
        for (List list2 : list) {
            arrayList.add(list2.get(0));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Column> GetTableColumns(Connection connection, String string, String string2) throws SQLException {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        try (ResultSet resultSet = null;){
            String string3;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, string, string2, null);
            int n = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                string3 = resultSet.getString(4);
                String string4 = resultSet.getString(5);
                int n2 = resultSet.getInt(11);
                Column column = new Column(string3, string4);
                if (n2 == 0) {
                    column.setIsNullable(false);
                }
                arrayList.add(column);
            }
            resultSet.close();
            resultSet = databaseMetaData.getPrimaryKeys(null, string, string2);
            block4: while (resultSet.next()) {
                string3 = resultSet.getString(4);
                for (Column column : arrayList) {
                    if (!column.getName().equals(string3)) continue;
                    column.setIsPrimaryKey(true);
                    continue block4;
                }
            }
        }
        return arrayList;
    }

    public static String GetSQL(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            int n2 = 0;
            n2 = object != null ? object.toString().length() : 4;
            n = i == 0 ? stringBuffer.toString().indexOf(63) : stringBuffer.toString().indexOf(63, n + n2 + 1);
            if (object == null) {
                stringBuffer.replace(n, n + 1, "null");
                continue;
            }
            if (object instanceof String) {
                stringBuffer.replace(n, n + 1, "'" + object + "'");
                continue;
            }
            if (object instanceof Integer) {
                stringBuffer.replace(n, n + 1, object.toString());
                continue;
            }
            if (!(object instanceof Date)) continue;
            stringBuffer.replace(n, n + 1, object.toString());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List ExecuteSQL(Connection connection, String string, Map<String, Object> map) throws SQLException, IOException {
        List list;
        block23: {
            void var6_10;
            Object object;
            block21: {
                block22: {
                    Object object2;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    String string2 = string;
                    if (map != null) {
                        for (String object32 : map.keySet()) {
                            int n;
                            object = map.get(object32);
                            if (string2.toLowerCase().indexOf(":" + object32.toLowerCase()) >= 0) {
                                try {
                                    object2 = (String)object;
                                    n = Integer.parseInt((String)object2);
                                    object = new Integer(n);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                hashMap.put(object32.toLowerCase(), object);
                            }
                            object2 = "{" + object32.toLowerCase() + "}";
                            n = string2.toLowerCase().indexOf((String)object2);
                            if (n < 0) continue;
                            string2 = string2.substring(0, n) + object + string2.substring(n + ((String)object2).length(), string2.length());
                        }
                    }
                    string = string2;
                    map = hashMap;
                    ArrayList arrayList = new ArrayList();
                    Object var6_7 = null;
                    try {
                        if (map == null) {
                            Statement statement = connection.createStatement();
                        } else {
                            Object object3 = object = connection.prepareStatement(string);
                            if (object instanceof OraclePreparedStatement) {
                                object2 = (OraclePreparedStatement)object;
                                for (String string3 : map.keySet()) {
                                    Object object4 = map.get(string3);
                                    if (object4 == null) {
                                        object2.setNullAtName(string3, 12);
                                        continue;
                                    }
                                    if (object4 instanceof String) {
                                        object2.setStringAtName(string3, (String)object4);
                                        continue;
                                    }
                                    if (!(object4 instanceof Integer)) continue;
                                    Integer n = (Integer)object4;
                                    object2.setIntAtName(string3, n.intValue());
                                }
                            }
                        }
                        if (!string.trim().toUpperCase().startsWith("SELECT")) break block21;
                        object = DatabaseUtils.GetResults(connection, string, (Statement)var6_10, map);
                        if (var6_10 == null) break block22;
                    }
                    catch (Throwable throwable) {
                        void var6_11;
                        if (var6_11 != null) {
                            var6_11.close();
                        }
                        throw throwable;
                    }
                    var6_10.close();
                }
                return object;
            }
            if (string.trim().toUpperCase().startsWith("COMMIT")) {
                connection.commit();
            } else if (string.trim().toUpperCase().startsWith("ROLLBACK")) {
                connection.rollback();
            } else if (var6_10 instanceof PreparedStatement) {
                object = (PreparedStatement)var6_10;
                object.execute();
            } else {
                int n = var6_10.executeUpdate(string);
            }
            list = null;
            if (var6_10 == null) break block23;
            var6_10.close();
        }
        return list;
    }

    public static List ExecuteSQL(Connection connection, String string) throws SQLException, IOException {
        Object[] objectArray = null;
        return DatabaseUtils.ExecuteSQL(connection, string, objectArray);
    }

    public static List ExecuteSQL(Connection connection, String string, String string2) throws SQLException, IOException {
        Object[] objectArray = new Object[]{string2};
        return DatabaseUtils.ExecuteSQL(connection, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ExecuteSQL(Connection connection, String string, Object[] objectArray) throws SQLException, IOException {
        ArrayList arrayList = new ArrayList();
        try (Statement statement = null;){
            Object object;
            if (objectArray == null) {
                statement = string.toLowerCase().startsWith("begin") ? connection.prepareStatement(string) : connection.createStatement();
            } else {
                object = connection.prepareStatement(string);
                statement = object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2;
                    if (objectArray[i] == null) {
                        object.setNull(i + 1, 12);
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        object2 = (String)objectArray[i];
                        object.setString(i + 1, (String)object2);
                        continue;
                    }
                    if (objectArray[i] instanceof Integer) {
                        object2 = (Integer)objectArray[i];
                        object.setInt(i + 1, (Integer)object2);
                        continue;
                    }
                    if (!(objectArray[i] instanceof Date)) continue;
                    object2 = (Date)objectArray[i];
                    object.setDate(i + 1, (Date)object2);
                }
            }
            if (string.trim().toUpperCase().startsWith("SELECT")) {
                object = DatabaseUtils.GetResults(connection, string, statement, objectArray);
                return object;
            }
            if (string.trim().toUpperCase().startsWith("COMMIT")) {
                connection.commit();
            } else if (string.trim().toUpperCase().startsWith("ROLLBACK")) {
                connection.rollback();
            } else if (statement instanceof PreparedStatement) {
                object = (PreparedStatement)statement;
                object.execute();
            } else {
                int n = statement.executeUpdate(string);
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List GetResults(Connection connection, String string, Statement statement, Object object) throws SQLException, IOException {
        ArrayList arrayList;
        block37: {
            arrayList = new ArrayList();
            try (ResultSet resultSet = null;){
                if (string.trim().toUpperCase().startsWith("SELECT") || object != null) {
                    if (statement instanceof PreparedStatement) {
                        resultSet = ((PreparedStatement)statement).executeQuery();
                    } else if (statement instanceof Statement) {
                        resultSet = statement.executeQuery(string);
                    }
                    String string2 = "";
                    if (resultSet == null || !string.trim().toUpperCase().startsWith("SELECT")) break block37;
                    resultSet.setFetchSize(200);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    if (resultSetMetaData == null) break block37;
                    int n = resultSetMetaData.getColumnCount();
                    while (resultSet.next()) {
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        for (int i = 0; i < n; ++i) {
                            Object object2 = resultSet.getObject(i + 1);
                            if (object2 != null) {
                                String string3;
                                StringBuffer stringBuffer;
                                int n2;
                                char[] cArray;
                                Reader reader;
                                Object object3;
                                if (object2 instanceof CLOB) {
                                    object3 = (CLOB)object2;
                                    reader = null;
                                    try {
                                        reader = object3.getCharacterStream();
                                        cArray = new char[1000];
                                        n2 = 0;
                                        stringBuffer = new StringBuffer(2000);
                                        while ((n2 = reader.read(cArray)) != -1) {
                                            string3 = new String(cArray, 0, n2);
                                            stringBuffer.append(string3);
                                        }
                                        arrayList2.add(stringBuffer.toString());
                                        continue;
                                    }
                                    finally {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                if (object2 instanceof Clob) {
                                    object3 = (Clob)object2;
                                    reader = null;
                                    try {
                                        reader = object3.getCharacterStream();
                                        cArray = new char[1000];
                                        n2 = 0;
                                        stringBuffer = new StringBuffer(2000);
                                        while ((n2 = reader.read(cArray)) != -1) {
                                            string3 = new String(cArray, 0, n2);
                                            stringBuffer.append(string3);
                                        }
                                        arrayList2.add(stringBuffer.toString());
                                        continue;
                                    }
                                    finally {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                }
                                arrayList2.add(object2.toString().trim());
                                continue;
                            }
                            arrayList2.add(null);
                        }
                        arrayList.add(arrayList2);
                    }
                    break block37;
                }
                if (string.trim().toUpperCase().startsWith("COMMIT")) {
                    connection.commit();
                } else if (string.trim().toUpperCase().startsWith("ROLLBACK")) {
                    connection.rollback();
                } else {
                    int n = statement.executeUpdate(string);
                }
            }
        }
        return arrayList;
    }

    public static void ExecuteSQL(Connection connection, String string, RowSetCallBack rowSetCallBack) throws SQLException {
        DatabaseUtils.ExecuteSQL(connection, string, rowSetCallBack, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ExecuteSQL(Connection connection, String string, RowSetCallBack rowSetCallBack, RowSetMetadataCallback rowSetMetadataCallback, Object[] objectArray) throws SQLException {
        try (Statement statement = null;){
            Object object;
            AutoCloseable autoCloseable;
            if (objectArray == null) {
                statement = connection.createStatement();
            } else {
                autoCloseable = connection.prepareStatement(string);
                statement = autoCloseable;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        autoCloseable.setNull(i + 1, 12);
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        object = (String)objectArray[i];
                        autoCloseable.setString(i + 1, (String)object);
                        continue;
                    }
                    if (objectArray[i] instanceof Integer) {
                        object = (Integer)objectArray[i];
                        autoCloseable.setInt(i + 1, (Integer)object);
                        continue;
                    }
                    if (!(objectArray[i] instanceof Date)) continue;
                    object = (Date)objectArray[i];
                    autoCloseable.setDate(i + 1, (Date)object);
                }
            }
            if (string.trim().toUpperCase().startsWith("SELECT")) {
                autoCloseable = null;
                if (statement instanceof PreparedStatement) {
                    autoCloseable = ((PreparedStatement)statement).executeQuery();
                } else if (statement instanceof Statement) {
                    autoCloseable = statement.executeQuery(string);
                }
                String string2 = "";
                if (autoCloseable != null) {
                    object = autoCloseable.getMetaData();
                    if (rowSetMetadataCallback != null) {
                        rowSetMetadataCallback.processRowSetMetadata((ResultSetMetaData)object);
                    }
                    if (object != null) {
                        int n = object.getColumnCount();
                        while (autoCloseable.next()) {
                            rowSetCallBack.processRowSet((ResultSet)autoCloseable);
                        }
                    }
                }
            } else if (string.trim().toUpperCase().startsWith("COMMIT")) {
                connection.commit();
            } else if (string.trim().toUpperCase().startsWith("ROLLBACK")) {
                connection.rollback();
            } else {
                int n = statement.executeUpdate(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ExecuteSPL(Connection connection, String string) throws SQLException, IOException {
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin ? := dbms_aw.interp(?); end;");
        Reader reader = null;
        try {
            String string2;
            oracleCallableStatement.registerOutParameter(1, 2005);
            oracleCallableStatement.setString(2, string.toString());
            oracleCallableStatement.execute();
            CLOB cLOB = oracleCallableStatement.getCLOB(1);
            reader = cLOB.getCharacterStream();
            char[] cArray = new char[1000];
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(2000);
            while ((n = reader.read(cArray)) != -1) {
                string2 = new String(cArray, 0, n);
                stringBuffer.append(string2);
            }
            string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
        }
    }

    public static String ExecuteStoredProc(Connection connection, String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "begin ? :=" + string + "(" + string2 + "); end;";
        CallableStatement callableStatement = connection.prepareCall(string3);
        callableStatement.registerOutParameter(1, 1);
        callableStatement.executeUpdate();
        String string4 = callableStatement.getString(1);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public static Object ExecuteStoredProc(Connection connection, String string, Object[] objectArray) throws SQLException, IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
        }
        return DatabaseUtils.ExecuteStoredProc(connection, string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object ExecuteStoredProc(Connection connection, String string, List list) throws SQLException, IOException {
        CLOB cLOB = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append("?,");
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            String string2 = "begin " + string + "(" + stringBuffer.toString() + "); end;";
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string2);
            int n = 1;
            int n2 = -1;
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                Class clazz;
                String string3;
                object = object2.next();
                if (object instanceof Class && (string3 = (clazz = (Class)object).getName()).equals("oracle.sql.CLOB")) {
                    n2 = n;
                    oracleCallableStatement.registerOutParameter(n++, 2005);
                }
                if (object instanceof CLOB) {
                    oracleCallableStatement.setCLOB(n++, (CLOB)object);
                }
                if (object instanceof String) {
                    oracleCallableStatement.setString(n++, (String)object);
                }
                if (object instanceof Integer) {
                    oracleCallableStatement.setInt(n++, ((Integer)object).intValue());
                }
                if (!(object instanceof Date)) continue;
                oracleCallableStatement.setDate(n++, (Date)object);
            }
            oracleCallableStatement.execute();
            if (n2 != -1 && list.get(n2 - 1) instanceof Class && ((String)(object = ((Class)(object2 = (Class)list.get(n2 - 1))).getName())).equals("oracle.sql.CLOB")) {
                cLOB = oracleCallableStatement.getCLOB(n2);
            }
        }
        return cLOB;
    }

    public static String ConvertCLOBToString(CLOB cLOB) throws SQLException, IOException {
        Reader reader = cLOB.getCharacterStream();
        char[] cArray = new char[1000];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(2000);
        while ((n = reader.read(cArray)) != -1) {
            String string = new String(cArray, 0, n);
            stringBuffer.append(string);
        }
        reader.close();
        return stringBuffer.toString();
    }

    public static CLOB ConvertStringToCLOB(Connection connection, String string) throws SQLException, IOException {
        CLOB cLOB = null;
        try {
            cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            cLOB.open(1);
            Writer writer = cLOB.setCharacterStream(1L);
            writer.write(string);
            writer.flush();
            writer.close();
            cLOB.close();
        }
        catch (IOException iOException) {
            cLOB.freeTemporary();
            throw iOException;
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testCLOB(String[] stringArray) {
        Connection connection = null;
        try {
            connection = DatabaseUtils.GetConnection("jdbc:oracle:thin:@adc6141176:1521:omain3", "global", "global");
            Object object = DatabaseUtils.ExecuteStoredProc(connection, "dbms_cube.export_xml", new Object[]{"GLOBAL.CHANNEL94", CLOB.class});
            if (object instanceof CLOB) {
                CLOB cLOB = (CLOB)object;
                String string = DatabaseUtils.ConvertCLOBToString(cLOB);
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(new java.util.Date());
        DatabaseUtils.testCLOB(stringArray);
    }
}

