/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.calcfactory.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.transform.stream.StreamSource;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.Preferences;
import oracle.olap.app.Resources;
import oracle.olap.app.UISettings;
import oracle.olap.app.calcfactory.ui.AlwaysSelectableComboBox;
import oracle.olap.app.calcfactory.ui.NamingDialog;
import oracle.olap.app.calcfactory.ui.NamingPanel;
import oracle.olap.app.calcfactory.ui.SimpleFileFilter;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.CalcToTemplate;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateList;
import oracle.olap.app.templates.templatelist.TemplateNameFormat;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.app.ui.CheckBoxList;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.app.ui.MultiLineTextArea;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.db.CubeCalcPersist;
import oracle.olap.db.view.TransactionWaitCursorManager;
import oracle.olap.stringexpr.NameSyntaxParseException;
import oracle.olap.stringexpr.StringExprParser;

public class CalcFactoryDialog
extends JDialog
implements PropertyChangeListener,
ActionListener {
    private JPanel mainPanel;
    private JLabel hierarchyLabel;
    private AlwaysSelectableComboBox hierarchyComboBox;
    private DefaultComboBoxModel timeHierarchyComboBoxModel;
    private JLabel timeDimensionLabel;
    private JLabel timeDimensionNameLabel;
    private JButton helpButton;
    private Preferences preferences;
    private Database database;
    private Schema schema;
    private Cube cube;
    private Dimension timeDimension;
    private Frame parentFrame;
    private TemplateList defaultCalcList;
    private TemplateList templateList;
    private DefaultListModel measureListModel;
    private CheckBoxList measureList;
    private List<TemplateGroupHyperView> calcGroupHyperViews;
    private JPanel calcCheckBoxPanel;
    private JPanel calcCheckBoxScrollPanel;
    private JLabel previewLabel;
    private GenericTable previewTable;
    private DefaultTableModel previewTableModel;
    private JLabel nameTemplateFileLabel;
    private JLabel calcTemplateFileLabel;
    private NamingPanel namingPanel;
    private int prevTabIndex;
    private boolean cancel;
    private CubeCalcPersist calcCreator;
    private Resources resources;
    private String calcTemplateFileName;
    private String calcNameTemplateFileName;
    private HelpProvider helpProvider;
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    static String NAME_PACKAGE_NAME;
    private static String CALC_DIR;
    private static String CALC_FILE_NAME;
    private static String CALC_NAME_FILE_NAME;
    private final FetchIcon fetchIcon;
    private static final Logger LOG;
    private int calcCount = 0;

    public CalcFactoryDialog(Frame frame, Resources resources, FetchIcon fetchIcon, Preferences preferences, HelpProvider helpProvider, Database database, CubeCalcPersist cubeCalcPersist, Cube cube) throws Exception {
        super(frame);
        Object object;
        NAME_PACKAGE_NAME = "oracle.olap.app.templates.templatelist";
        this.parentFrame = frame;
        this.resources = resources;
        this.preferences = preferences;
        this.database = database;
        this.calcCreator = cubeCalcPersist;
        this.helpProvider = helpProvider;
        this.fetchIcon = fetchIcon;
        this.setTitle(this.getResourceString("CALCFACTORY.DLG.TITLE"));
        this.schema = cube.getSchema();
        OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(database, this.schema);
        oLAPMetadataReader.loadCube(cube.getName());
        cube.getSchema().setLoaded(true);
        this.cube = this.schema.findCube(cube.getName());
        this.cube.setSQLExpressionsEnabled(cube.isSQLExpressionsEnabled());
        this.setSize(625, 675);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(frame);
        this.timeHierarchyComboBoxModel = new DefaultComboBoxModel();
        this.measureListModel = new DefaultListModel();
        this.timeDimensionNameLabel = new JLabel();
        if (this.cube != null) {
            Object object2;
            List<Object> list;
            List<Dimension> list2 = this.cube.getDimensions();
            for (Dimension object22 : list2) {
                if (!object22.isTime()) continue;
                this.timeDimension = object22;
                this.timeDimensionNameLabel.setText(this.timeDimension.getName());
                list = this.timeDimension.getHierarchies();
                object2 = this.timeDimension.getDefaultHierarchy();
                if (object2 != null && ((NamedObject)object2).getName().length() > 0) {
                    this.timeHierarchyComboBoxModel.addElement(((NamedObject)object2).getName());
                    for (Object object3 : list) {
                        if (!((DimensionHierarchy)object3).isLevelBased() || ((NamedObject)object3).equals(object2)) continue;
                        this.timeHierarchyComboBoxModel.addElement(((NamedObject)object3).getName());
                    }
                } else {
                    for (Object object3 : list) {
                        if (!((DimensionHierarchy)object3).isLevelBased()) continue;
                        this.timeHierarchyComboBoxModel.addElement(((NamedObject)object3).getName());
                    }
                }
                break;
            }
            object = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    try {
                        CalcFactoryDialog.this.measureSelected();
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                    }
                }
            };
            List<Measure> list3 = this.cube.getMeasures();
            list = new ArrayList();
            object2 = new ArrayList();
            for (Object object3 : list3) {
                if (((Measure)object3).isDerived()) {
                    object2.add(((NamedObject)object3).getName());
                    continue;
                }
                list.add(((NamedObject)object3).getName());
            }
            Collections.sort(list);
            Collections.sort(object2);
            list.addAll((Collection<Object>)object2);
            for (Object object3 : list) {
                JCheckBox jCheckBox = new JCheckBox((String)object3);
                this.measureListModel.addElement(jCheckBox);
                jCheckBox.addChangeListener((ChangeListener)object);
            }
        }
        boolean bl = true;
        this.loadCalcsFromXML(null, bl);
        this.defaultCalcList = this.templateList;
        if (preferences != null && (object = preferences.get(CALC_FILE_NAME)) != null) {
            this.calcTemplateFileName = object;
            bl = false;
            TemplateList templateList = this.templateList;
            if (this.loadCalcsFromXML(this.calcTemplateFileName, bl)) {
                this.mergeNameFormatFromCalcList(templateList);
            } else {
                this.calcTemplateFileName = "";
            }
        }
        this.namingPanel = new NamingPanel(this);
        this.addUI();
        this.setupAndDisplayCalcs(database, this.schema);
        this.namingPanel.setDefaultCalcList(this.templateList);
        if (preferences != null && (object = preferences.get(CALC_NAME_FILE_NAME)) != null) {
            TemplateList templateList = this.templateList;
            bl = false;
            if (this.loadCalcsFromXML((String)object, bl)) {
                this.setupNamingRules();
                this.mergeCalcFromCalcList(templateList);
                if (object != null) {
                    this.nameTemplateFileLabel.setText((String)object);
                }
                this.namingPanel.setTemplateList(this.templateList);
                this.updatePreviewTable();
            } else {
                object = "";
            }
        }
        if (this.timeDimensionNameLabel.getText().length() == 0) {
            this.timeDimensionLabel.setVisible(false);
            this.timeDimensionNameLabel.setVisible(false);
        } else {
            object = this.getResourceString("CALCFACTORY.DLG.HIERARCHY", this.timeDimension.getName());
            this.hierarchyLabel.setText(StringUtils.stripMnemonic((String)object));
        }
        if (this.timeHierarchyComboBoxModel.getSize() == 0) {
            this.hierarchyLabel.setVisible(false);
            this.hierarchyComboBox.setVisible(false);
        }
        if (this.measureListModel.getSize() > 0) {
            this.measureList.setSelectedIndex(0);
        }
        if (this.nameTemplateFileLabel.getText().length() == 0) {
            this.nameTemplateFileLabel.setText(this.getResourceString("CALCFACTORY.FILE.NAME.USE.DEFAULT"));
        }
        if (this.calcTemplateFileLabel.getText().length() == 0) {
            this.calcTemplateFileLabel.setText(this.getResourceString("CALCFACTORY.FILE.CALC.USE.DEFAULT"));
        }
        this.setDefaultCursor();
    }

    private void setBusyCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void measureSelected() throws SQLException, IOException {
        this.updatePreviewTable();
    }

    private boolean updatePreviewTable() throws SQLException, IOException {
        boolean bl = true;
        this.previewTableModel.getDataVector().removeAllElements();
        Enumeration enumeration = this.measureListModel.elements();
        while (enumeration.hasMoreElements()) {
            JCheckBox jCheckBox = (JCheckBox)enumeration.nextElement();
            if (!jCheckBox.isSelected()) continue;
            String string = jCheckBox.getText();
            Measure measure = null;
            List<Measure> list = this.cube.getMeasures();
            for (Measure measure2 : list) {
                if (!measure2.getName().equals(string)) continue;
                measure = measure2;
                break;
            }
            for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
                for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    Object[] objectArray;
                    block10: {
                        objectArray = null;
                        if (!templateHyperView.isSelected()) continue;
                        string6 = this.getResourceString("CALCFACTORY.INVALID.SYNTAX");
                        string5 = this.getResourceString("CALCFACTORY.INVALID.SYNTAX");
                        string4 = this.getResourceString("CALCFACTORY.INVALID.SYNTAX");
                        string3 = this.getResourceString("CALCFACTORY.INVALID.SYNTAX");
                        string2 = this.getResourceString("CALCFACTORY.INVALID.SYNTAX");
                        try {
                            string6 = this.getGeneratedName(templateHyperView, "name", measure);
                            string5 = this.getGeneratedName(templateHyperView, "description", measure);
                            string4 = this.getGeneratedName(templateHyperView, "shortDescription", measure);
                            string3 = this.getGeneratedName(templateHyperView, "longDescription", measure);
                            string2 = this.getGeneratedMeasureExpression(templateHyperView, measure);
                        }
                        catch (NameSyntaxParseException nameSyntaxParseException) {
                            bl = false;
                            String string7 = this.getResourceString("CALCFACTORY.INVALID.SYNTAX");
                            if (string6.equals(string7)) {
                                string6 = string7 + " (" + nameSyntaxParseException.getMessage() + ")";
                            }
                            if (string5.equals(string7)) {
                                string5 = string7 + " (" + nameSyntaxParseException.getMessage() + ")";
                            }
                            if (string4.equals(string7)) {
                                string4 = string7 + " (" + nameSyntaxParseException.getMessage() + ")";
                            }
                            if (string3.equals(string7)) {
                                string3 = string7 + " (" + nameSyntaxParseException.getMessage() + ")";
                            }
                            if (!string2.equals(string7)) break block10;
                            string2 = string7 + " (" + nameSyntaxParseException.getMessage() + ")";
                        }
                    }
                    objectArray = new Object[]{templateHyperView.getDesc(), string6, string5, string4, string3, string2};
                    this.previewTableModel.addRow(objectArray);
                }
            }
        }
        int n = this.previewTableModel.getRowCount();
        this.previewLabel.setText(this.getResourceString("CALCFACTORY.DLG.PREVIEW.HEADER", Integer.toString(n)));
        this.previewTableModel.fireTableDataChanged();
        return bl;
    }

    private String getGeneratedNameFromRuleSyntax(TemplateHyperView templateHyperView, String string, Measure measure) throws NameSyntaxParseException, SQLException, IOException {
        return templateHyperView.generateFromRule(string, measure, null);
    }

    private String getGeneratedName(TemplateHyperView templateHyperView, String string, Measure measure) throws NameSyntaxParseException, SQLException, IOException {
        return templateHyperView.generateName(string, measure, null, "");
    }

    private String getGeneratedMeasureExpression(TemplateHyperView templateHyperView, Measure measure) throws SQLException, IOException {
        return templateHyperView.getExpression(measure);
    }

    public void setNamingRule(Template template, String string, String string2) throws SQLException, IOException {
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                if (!templateHyperView.getTemplate().equals(template)) continue;
                templateHyperView.getTemplateNameFormat().setRule(string, string2);
                return;
            }
        }
    }

    private Measure getFirstMeasure() {
        Enumeration enumeration = this.measureListModel.elements();
        Measure measure = null;
        Measure measure2 = null;
        while (enumeration.hasMoreElements()) {
            String string;
            JCheckBox jCheckBox = (JCheckBox)enumeration.nextElement();
            if (measure == null) {
                string = jCheckBox.getText();
                measure = this.getMeasureFromName(string);
            }
            if (!jCheckBox.isSelected()) continue;
            string = jCheckBox.getText();
            measure2 = this.getMeasureFromName(string);
            return measure2;
        }
        if (measure2 == null) {
            measure2 = measure;
        }
        return measure2;
    }

    public String getGeneratedNameFromRuleSyntax(Template template, String string) throws NameSyntaxParseException, SQLException, IOException {
        Measure measure = this.getFirstMeasure();
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                if (!templateHyperView.getTemplate().equals(template)) continue;
                String string2 = this.getGeneratedNameFromRuleSyntax(templateHyperView, string, measure);
                return string2;
            }
        }
        return "";
    }

    public String getGeneratedName(Template template, String string) throws NameSyntaxParseException, SQLException, IOException {
        Measure measure = this.getFirstMeasure();
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                if (!templateHyperView.getTemplate().equals(template)) continue;
                String string2 = this.getGeneratedName(templateHyperView, string, measure);
                return string2;
            }
        }
        return "";
    }

    private Measure getMeasureFromName(String string) {
        List<Measure> list = this.cube.getMeasures();
        for (Measure measure : list) {
            if (!measure.getName().equals(string)) continue;
            return measure;
        }
        return null;
    }

    public String getResourceString(String string) {
        if (this.resources != null) {
            return this.resources.getString(string);
        }
        return string;
    }

    public String getResourceString(String string, String string2) {
        if (this.resources != null) {
            return this.resources.getString(string, string2);
        }
        return string + " " + string2;
    }

    public String getResourceString(String string, String string2, String string3) {
        if (this.resources != null) {
            return this.resources.getString(string, string2, string3);
        }
        return string + " " + string2 + " " + string3;
    }

    private void setupAndDisplayCalcs(Database database, Schema schema) throws SQLException, IOException {
        this.calcGroupHyperViews = new ArrayList<TemplateGroupHyperView>();
        TemplateContext templateContext = new TemplateContext(database, new TemplateMetadata(this.cube));
        for (TemplateGroup templateGroup : this.templateList.getTemplateGroups()) {
            if (this.timeHierarchyComboBoxModel.getSize() == 0 && templateGroup.isTimeTemplate()) continue;
            this.calcGroupHyperViews.add(new TemplateGroupHyperView(null, templateContext, new TemplateHyperContextImpl(this.database.getConnection(), this.resources, this.fetchIcon), templateGroup));
        }
        if (this.calcTemplateFileName != null) {
            this.calcTemplateFileLabel.setText(this.calcTemplateFileName);
        }
        this.setupNamingRules();
        this.displayCalcs();
        this.setSelectedMeasures();
        this.updatePreviewTable();
        this.measureList.repaint();
    }

    private void hierarchySelectionChanged() throws SQLException, IOException {
        String string = (String)this.timeHierarchyComboBoxModel.getSelectedItem();
        DimensionHierarchy dimensionHierarchy = null;
        List<DimensionHierarchy> list = this.timeDimension.getHierarchies();
        for (DimensionHierarchy dimensionHierarchy2 : list) {
            if (!dimensionHierarchy2.isLevelBased() || !dimensionHierarchy2.getName().equals(string)) continue;
            dimensionHierarchy = dimensionHierarchy2;
            this.setHierarchyForCalcGroupHyper(dimensionHierarchy);
        }
    }

    private void setHierarchyForCalcGroupHyper(DimensionHierarchy dimensionHierarchy) throws SQLException, IOException {
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            templateGroupHyperView.setHierarchy(dimensionHierarchy);
        }
    }

    public void useDefaultCalcTemplateAction() {
        try {
            Object object;
            Enumeration enumeration = this.measureListModel.elements();
            while (enumeration.hasMoreElements()) {
                object = (JCheckBox)enumeration.nextElement();
                ((AbstractButton)object).setSelected(false);
            }
            object = this.templateList;
            this.templateList = this.defaultCalcList;
            this.mergeNameFormatFromCalcList((TemplateList)object);
            this.preferences.set(CALC_FILE_NAME, "");
            this.calcTemplateFileName = this.getResourceString("CALCFACTORY.FILE.CALC.USE.DEFAULT");
            this.calcTemplateFileLabel.setText(this.getResourceString("CALCFACTORY.FILE.CALC.USE.DEFAULT"));
            this.setupAndDisplayCalcs(this.database, this.schema);
            this.calcTemplateFileLabel.repaint();
            this.getContentPane().repaint();
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
    }

    public void useDefaultNameTemplateAction() {
        this.nameTemplateFileLabel.setText(this.getResourceString("CALCFACTORY.FILE.NAME.USE.DEFAULT"));
        this.preferences.set(CALC_NAME_FILE_NAME, "");
        boolean bl = true;
        this.loadCalcsFromXML(null, bl);
        this.defaultCalcList = this.templateList;
        try {
            this.namingPanel.setDefaultCalcList(this.defaultCalcList);
            this.namingPanel.useDefaultNameTemplate();
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
    }

    private void create() throws SQLException, IOException {
        this.calcCreator.clear();
        Enumeration enumeration = this.measureListModel.elements();
        int n = 0;
        if (!this.updatePreviewTable()) {
            String string = this.getResourceString("CALCFACTORY.DLG.TITLE");
            String string2 = this.getResourceString("CALCFACTORY.DLG.MSG.FIX.INVALID.SYNTAX");
            JOptionPane.showMessageDialog(this.parentFrame, string2, string, 0);
            return;
        }
        try {
            Object object;
            String string3;
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                object2 = (JCheckBox)enumeration.nextElement();
                if (!((AbstractButton)object2).isSelected() || (string3 = this.isMeasureCreated((String)(object = ((AbstractButton)object2).getText()))) == null) continue;
                arrayList.add(string3);
            }
            if (arrayList.size() > 0) {
                object2 = new StringBuffer();
                for (String string3 : arrayList) {
                    ((StringBuffer)object2).append(string3);
                    ((StringBuffer)object2).append(", ");
                }
                ((StringBuffer)object2).delete(((StringBuffer)object2).length() - 2, ((StringBuffer)object2).length());
                object = this.getResourceString("CALCFACTORY.DLG.TITLE");
                string3 = this.getResourceString("CALCFACTORY.DLG.MSG.FIX.MEASURE.EXISTS", ((StringBuffer)object2).toString());
                int n2 = JOptionPane.showConfirmDialog(this.parentFrame, string3, (String)object, 0);
                if (n2 != 0) {
                    return;
                }
            }
            enumeration = this.measureListModel.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (JCheckBox)enumeration.nextElement();
                if (!((AbstractButton)object2).isSelected()) continue;
                object = ((AbstractButton)object2).getText();
                this.calcCount += this.createHyperCalcs((String)object);
                ++n;
            }
            if (n == 0) {
                object2 = this.getResourceString("CALCFACTORY.DLG.MSG.SELECT.MEASURE");
                object = this.getResourceString("CALCFACTORY.DLG.MSG.TITLE.SELECT.MEASURE");
                JOptionPane.showMessageDialog(this.parentFrame, object2, (String)object, 1);
                return;
            }
            if (this.calcCount == 0) {
                object2 = this.getResourceString("CALCFACTORY.DLG.MSG.SELECT.CALCS");
                object = this.getResourceString("CALCFACTORY.DLG.MSG.TITLE.SELECT.MEASURE");
                JOptionPane.showMessageDialog(this.parentFrame, object2, (String)object, 1);
                return;
            }
            object2 = this.getResourceString("CALCFACTORY.DLG.CREATING.CALCS.MSG", String.valueOf(this.calcCount));
            object = new RaptorTask((String)object2, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        CalcFactoryDialog.this.calcCreator.commit();
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            object.setCancellable(false);
            object.setPausable(false);
            object.setMessage((String)object2);
            object.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            String string = RaptorTaskUtils.getErrorMessage((Throwable)throwable);
                            if (string == null || string.length() == 0) {
                                string = throwable.getLocalizedMessage();
                            }
                            String string2 = CalcFactoryDialog.this.getResourceString("CALCFACTORY.DLG.MSG.CALCS.CREATE.FAIL", string);
                            CalcFactoryDialog.this.showErrorDialog(string2);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            String string = CalcFactoryDialog.this.getResourceString("CALCFACTORY.DLG.MSG.CALCS.CREATED", Integer.toString(CalcFactoryDialog.this.calcCount));
                            String string2 = CalcFactoryDialog.this.getResourceString("CALCFACTORY.DLG.TITLE");
                            JOptionPane.showMessageDialog(CalcFactoryDialog.this.parentFrame, string, string2, 1);
                            if (CalcFactoryDialog.this.preferences != null) {
                                CalcFactoryDialog.this.preferences.set(CALC_FILE_NAME, CalcFactoryDialog.this.calcTemplateFileName);
                                String string3 = CalcFactoryDialog.this.calcNameTemplateFileName;
                                if (string3 == null) {
                                    string3 = "";
                                }
                                CalcFactoryDialog.this.preferences.set(CALC_NAME_FILE_NAME, string3);
                            }
                            CalcFactoryDialog.this.dispose();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            string3 = RaptorTaskManager.getInstance();
            string3.addTask((RaptorTask)object);
        }
        catch (Exception exception) {
            Object object;
            String string = exception.getMessage();
            if (string == null) {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                exception.printStackTrace(printWriter);
                string = ((StringWriter)object).toString();
                LOG.log(Level.WARNING, exception.getMessage(), exception);
            }
            object = this.getResourceString("CALCFACTORY.DLG.TITLE");
            JOptionPane.showMessageDialog(this, string, (String)object, 0);
        }
    }

    private Measure getMeasureForName(String string) {
        Measure measure = null;
        List<Measure> list = this.cube.getMeasures();
        for (Measure measure2 : list) {
            if (!measure2.getName().equals(string)) continue;
            measure = measure2;
            break;
        }
        return measure;
    }

    public String isMeasureCreated(String string) throws Exception {
        Measure measure = this.getMeasureForName(string);
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                DimensionHierarchy dimensionHierarchy;
                String string2;
                boolean bl;
                if (!templateHyperView.isSelected() || !(bl = this.calcCreator.isMeasureCreated(this.cube, string2 = templateHyperView.generateName(measure, dimensionHierarchy = null, templateHyperView.getNameSuffix())))) continue;
                return string2;
            }
        }
        return null;
    }

    public int createHyperCalcs(String string) throws Exception {
        int n = 0;
        Measure measure = this.getMeasureForName(string);
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                if (!templateHyperView.isSelected()) continue;
                Object var8_8 = null;
                DimensionHierarchy dimensionHierarchy = null;
                String string2 = templateHyperView.generateName(measure, dimensionHierarchy, templateHyperView.getNameSuffix());
                String string3 = "";
                String string4 = templateHyperView.generateDescription(measure, dimensionHierarchy, string3);
                this.calcCreator.setDescription(this.cube, string2, "DESCRIPTION", string4);
                String string5 = templateHyperView.generateLongDescription(measure, dimensionHierarchy, string3);
                this.calcCreator.setDescription(this.cube, string2, "LONG_DESCRIPTION", string5);
                String string6 = templateHyperView.generateShortDescription(measure, dimensionHierarchy, string3);
                this.calcCreator.setDescription(this.cube, string2, "SHORT_DESCRIPTION", string6);
                String string7 = templateHyperView.getType();
                String string8 = templateHyperView.getExpression(measure);
                Object object = this.calcCreator.addDerivedMeasure(this.cube, string2, string7, string8, null);
                ++n;
            }
        }
        return n;
    }

    public void cancel() {
        this.cancel = true;
        this.dispose();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private void showHelp() {
        this.helpProvider.showHelp(this.mainPanel, "olap_generate_calculated_measures");
    }

    public void addTemplateList(TemplateList templateList) {
        this.templateList = templateList;
    }

    private void bindToJava(String string, String string2, Object object) throws Exception {
        InputStream inputStream = CalcFactoryDialog.class.getResourceAsStream(string);
        String string3 = CalcToTemplate.transform(new StreamSource(inputStream));
        JavaXMLBind.BindToJavaStr(string3, string2, object);
    }

    private void bindToJava(File file, String string, Object object) throws Exception {
        String string2 = CalcToTemplate.transform(new StreamSource(file));
        JavaXMLBind.BindToJavaStr(string2, string, object);
    }

    void setComments(TemplateList templateList) throws SQLException, IOException {
        templateList.setComment(StringExprParser.getDocumentation());
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : templateGroupHyperView.getParamNames()) {
                stringBuffer.append(string.toLowerCase() + ", ");
            }
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                for (Template template : templateList.getTemplatesOnly()) {
                    if (!template.getName().equalsIgnoreCase(templateHyperView.getName())) continue;
                    template.getTemplateNameFormat().setComment(stringBuffer.toString());
                }
            }
        }
    }

    private void loadNamingRulesFromXMLFile(String string) {
        TemplateList templateList = this.templateList;
        try {
            if (new File(string).exists()) {
                this.bindToJava(string, NAME_PACKAGE_NAME, (Object)this);
                for (Template template : this.templateList.getTemplatesOnly()) {
                    for (Template template2 : templateList.getTemplatesOnly()) {
                        TemplateNameFormat templateNameFormat;
                        if (!template.getName().equalsIgnoreCase(template2.getName()) || (templateNameFormat = template.getTemplateNameFormat()) == null) continue;
                        template2.setTemplateNameFormat(templateNameFormat);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
        this.templateList = templateList;
    }

    private boolean loadCalcsFromXML(String string, boolean bl) {
        return this.loadCalcsFromXML(bl, string);
    }

    private boolean loadCalcsFromXML(boolean bl, String string) {
        block6: {
            try {
                String string2 = "";
                if (bl) {
                    string = "calcs.xml";
                    InputStream inputStream = CalcFactoryDialog.class.getResourceAsStream(string);
                    string2 = CalcToTemplate.transform(new StreamSource(inputStream));
                    JavaXMLBind.BindToJavaStr(string2, NAME_PACKAGE_NAME, this);
                    this.templateList.setFileName(string);
                    for (TemplateGroup templateGroup : this.templateList.getTemplateGroups()) {
                        for (Template template : templateGroup.getTemplatesOnly()) {
                            template.setUi(null);
                        }
                    }
                    break block6;
                }
                File file = new File(string);
                if (file.exists()) {
                    this.bindToJava(file, NAME_PACKAGE_NAME, (Object)this);
                    break block6;
                }
                return false;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, exception.getMessage(), exception);
            }
        }
        return true;
    }

    private void setupNamingRules() throws SQLException, IOException {
        for (Template template : this.templateList.getTemplatesOnly()) {
            for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
                for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                    TemplateNameFormat templateNameFormat;
                    if (template.getName() == null || !template.getName().toUpperCase().equals(templateHyperView.getDesc().toUpperCase()) || (templateNameFormat = template.getTemplateNameFormat()) == null) continue;
                    templateHyperView.setTemplateNameFormat(templateNameFormat);
                }
            }
        }
    }

    private void saveCalcTemplateAction() throws SQLException, IOException {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.preferences.get(CALC_DIR);
        jFileChooser = string == null ? new JFileChooser() : new JFileChooser(string);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(this.getResourceString("CALCFACTORY.DLG.TEMPLATE"), "xml");
        jFileChooser.setFileFilter(simpleFileFilter);
        if (this.calcTemplateFileName != null) {
            jFileChooser.setSelectedFile(new File(this.calcTemplateFileName));
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 0) {
            this.preferences.set(CALC_DIR, jFileChooser.getSelectedFile().getParent());
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            this.saveCalcXML(string2);
        }
    }

    private void saveCalcXML(String string) throws SQLException, IOException {
        if (string.trim().length() > 0) {
            Object object;
            Object object3;
            StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"windows-1252\" ?>\n");
            stringBuffer.append("<TemplateList>\n");
            this.templateList.removeAllMeasures();
            Enumeration enumeration = this.measureListModel.elements();
            while (enumeration.hasMoreElements()) {
                object3 = (JCheckBox)enumeration.nextElement();
                if (!((AbstractButton)object3).isSelected()) continue;
                String object22 = ((AbstractButton)object3).getText();
                this.templateList.addMeasure(object22, true);
            }
            stringBuffer.append(this.templateList.getMeasureXML());
            for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
                object = new ArrayList<BaseTemplate>();
                for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                    Template template = (Template)templateHyperView.getTemplate();
                    if (templateHyperView.getCheckBox().isSelected()) {
                        template.setSelected(true);
                    }
                    object.add(templateHyperView.getTemplate());
                }
                if (object.size() <= 0) continue;
                stringBuffer.append(templateGroupHyperView.getTemplateGroup().toXML((List<BaseTemplate>)object));
            }
            stringBuffer.append("</TemplateList>\n");
            try {
                if (string.toUpperCase().equals(string.toUpperCase()) && !string.toUpperCase().endsWith(".XML")) {
                    string = string + ".XML";
                }
                if (string.toLowerCase().equals(string) && !string.toLowerCase().endsWith(".xml")) {
                    string = string + ".xml";
                }
                object3 = new FileOutputStream(string);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object3, "UTF-8");
                object = new BufferedWriter(outputStreamWriter);
                ((Writer)object).write(stringBuffer.toString());
                ((BufferedWriter)object).close();
                outputStreamWriter.close();
                ((FileOutputStream)object3).close();
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
                String string2 = this.getResourceString("CALCFACTORY.NAMING.UNABLE.TO.SAVE.FILE.MSG", string, iOException.getMessage());
                object = this.getResourceString("CALCFACTORY.TEMPLATE.FILEDLG.TITLE");
                JOptionPane.showMessageDialog(this, string2, (String)object, 0);
            }
        }
    }

    private void saveNameTemplateAction() {
        JFileChooser jFileChooser = null;
        String string = this.preferences.get(CALC_DIR);
        jFileChooser = string == null ? new JFileChooser() : new JFileChooser(string);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(this.getResourceString("CALCFACTORY.DLG.TEMPLATE"), "xml");
        jFileChooser.setFileFilter(simpleFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.preferences.set(CALC_DIR, jFileChooser.getSelectedFile().getParent());
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            this.saveNameCalcXML(string2);
        }
    }

    private void saveNameCalcXML(String string) {
        this.namingPanel.save(string);
        this.calcNameTemplateFileName = string;
    }

    private void mergeNameFormatFromCalcList(TemplateList templateList) {
        for (Template template : templateList.getTemplatesOnly()) {
            if (template.getTemplateNameFormat() == null) continue;
            boolean bl = false;
            for (Template template2 : this.templateList.getTemplatesOnly()) {
                if (!template2.getName().equals(template.getName()) || template2.getTemplateNameFormat() == null) continue;
                template2.setTemplateNameFormat(template.getTemplateNameFormat());
                bl = true;
                break;
            }
            if (bl) continue;
            this.templateList.addTemplate(template);
        }
    }

    private void mergeCalcFromCalcList(TemplateList templateList) {
        for (TemplateGroup templateGroup : templateList.getTemplateGroups()) {
            this.templateList.addTemplateGroup(templateGroup);
        }
    }

    private void loadNameTemplateAction() {
        try {
            TemplateList templateList = this.templateList;
            String string = this.getResourceString("CALCFACTORY.DLG.TEMPLATE");
            String string2 = this.preferences.get(CALC_DIR);
            this.calcNameTemplateFileName = this.openFileUsingChooser(string2, this.calcNameTemplateFileName, string);
            if (this.calcNameTemplateFileName != null) {
                boolean bl = false;
                this.loadCalcsFromXML(this.calcNameTemplateFileName, bl);
                this.setupNamingRules();
            }
            this.mergeCalcFromCalcList(templateList);
            if (this.calcNameTemplateFileName != null) {
                this.nameTemplateFileLabel.setText(this.calcNameTemplateFileName);
                this.preferences.set(CALC_NAME_FILE_NAME, this.calcNameTemplateFileName);
            }
            this.namingPanel.setTemplateList(this.templateList);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
    }

    private void loadCalcTemplateAction() {
        try {
            TemplateList templateList = this.templateList;
            String string = this.getResourceString("CALCFACTORY.DLG.TEMPLATE");
            String string2 = this.preferences.get(CALC_DIR);
            this.calcTemplateFileName = this.openFileUsingChooser(string2, this.calcTemplateFileName, string);
            if (this.calcTemplateFileName != null) {
                boolean bl = false;
                this.loadCalcsFromXML(this.calcTemplateFileName, bl);
                this.setupNamingRules();
                this.mergeNameFormatFromCalcList(templateList);
                this.setupAndDisplayCalcs(this.database, this.schema);
                this.preferences.set(CALC_FILE_NAME, this.calcTemplateFileName);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
    }

    private void setSelectedMeasures() {
        Enumeration enumeration = this.measureListModel.elements();
        while (enumeration.hasMoreElements()) {
            JCheckBox jCheckBox = (JCheckBox)enumeration.nextElement();
            String string = jCheckBox.getText();
            if (!this.templateList.isMeasureSelected(string)) continue;
            jCheckBox.setSelected(true);
        }
    }

    private void showNamingDialog() {
        try {
            NamingDialog namingDialog = new NamingDialog(this, this.templateList);
            namingDialog.setVisible(true);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
    }

    private String openFileUsingChooser(String string, String string2, String string3) {
        int n;
        JFileChooser jFileChooser = null;
        jFileChooser = string != null ? new JFileChooser(string) : new JFileChooser();
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(string3, "xml");
        jFileChooser.setFileFilter(simpleFileFilter);
        if (string2 != null) {
            jFileChooser.setSelectedFile(new File(string2));
        }
        if ((n = jFileChooser.showOpenDialog(this)) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.updatePreviewTable();
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    private void displayCalcs() throws SQLException, IOException {
        this.calcCheckBoxScrollPanel.removeAll();
        this.calcCheckBoxScrollPanel.setLayout(new GridLayout(1, 1));
        JScrollPane jScrollPane = new JScrollPane(this.calcCheckBoxPanel);
        this.calcCheckBoxScrollPanel.add(jScrollPane);
        this.calcCheckBoxPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        int n = 0;
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            Object object;
            templateGroupHyperView.removePropertyChangeListener(this);
            templateGroupHyperView.addPropertyChangeListener(this);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 12);
            gridBagConstraints.fill = 2;
            JLabel jLabel = new JLabel("<html><b>" + templateGroupHyperView.getLocalizedName() + "</b></html>");
            this.calcCheckBoxPanel.add((Component)jLabel, gridBagConstraints);
            JPanel jPanel = templateGroupHyperView.getPanel(0);
            if (jPanel != null) {
                object = jPanel.getSize();
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 11;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(5, 5, 0, 12);
                gridBagConstraints.insets.left = 10;
                this.calcCheckBoxPanel.add((Component)jPanel, gridBagConstraints);
            }
            object = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        CalcFactoryDialog.this.measureSelected();
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                    }
                }
            };
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                JCheckBox jCheckBox = templateHyperView.getCheckBox();
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 20, 0, 12);
                this.calcCheckBoxPanel.add((Component)jCheckBox, gridBagConstraints);
                jCheckBox.addActionListener((ActionListener)object);
            }
            if (++n >= this.calcGroupHyperViews.size()) continue;
            JSeparator jSeparator = new JSeparator(0);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 2;
            this.calcCheckBoxPanel.add((Component)jSeparator, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calcCheckBoxPanel.add((Component)new JPanel(), gridBagConstraints);
        this.calcCheckBoxScrollPanel.revalidate();
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public void setHelpButtonVisible(boolean bl) {
        this.helpButton.setVisible(bl);
    }

    private List<String> getSelectedCalcs() throws SQLException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TemplateGroupHyperView templateGroupHyperView : this.calcGroupHyperViews) {
            for (TemplateHyperView templateHyperView : templateGroupHyperView.getTemplateViews()) {
                if (!templateHyperView.isSelected()) continue;
                arrayList.add(templateHyperView.getName());
            }
        }
        return arrayList;
    }

    private void updateNamingPanel() throws Exception {
        List<String> list = this.getSelectedCalcs();
        this.namingPanel.setSelectedCalcs(list);
    }

    private void addUI() {
        MultiLineTextArea multiLineTextArea = new MultiLineTextArea(this.getResourceString("CALCFACTORY.DLG.TOP.DESC"));
        this.nameTemplateFileLabel = new JLabel();
        this.calcTemplateFileLabel = new JLabel();
        JLabel jLabel = new JLabel(this.getResourceString("CALCFACTORY.DLG.NAME.TEMPLATE"));
        JLabel jLabel2 = new JLabel(this.getResourceString("CALCFACTORY.DLG.CALC.TEMPLATE"));
        this.timeDimensionLabel = new JLabel(this.getResourceString("CALCFACTORY.DLG.TIME.DIM"));
        String string = this.getResourceString("CALCFACTORY.DLG.HIERARCHY");
        this.hierarchyLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.hierarchyLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.hierarchyComboBox = new AlwaysSelectableComboBox((ComboBoxModel)this.timeHierarchyComboBoxModel);
        this.hierarchyLabel.setLabelFor(this.hierarchyComboBox);
        string = this.getResourceString("CALCFACTORY.DLG.MEASURES");
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = this.getResourceString("CALCFACTORY.DLG.CALC.SELECTIONS");
        JLabel jLabel4 = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        JButton jButton = new JButton(this.getResourceString("CALCFACTORY.DLG.LOAD"));
        JButton jButton2 = new JButton(this.getResourceString("CALCFACTORY.DLG.SAVE"));
        JButton jButton3 = new JButton(this.getResourceString("CALCFACTORY.DLG.NAME.BUTTON.USE.DEFAULT"));
        this.measureList = new CheckBoxList();
        jLabel3.setLabelFor(this.measureList);
        this.measureList.setModel(this.measureListModel);
        this.measureList.setVisibleRowCount(5);
        this.previewLabel = new JLabel(this.getResourceString("CALCFACTORY.DLG.PREVIEW.HEADER", "0"));
        this.previewTableModel = new DefaultTableModel();
        this.previewTable = new GenericTable((TableModel)this.previewTableModel);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(this.previewLabel);
        this.previewTable.setAutoResizeMode(0);
        this.previewTableModel.addColumn(this.getResourceString("CALCFACTORY.DLG.PREVIEW.COL.TYPE"));
        this.previewTableModel.addColumn(this.getResourceString("CALCFACTORY.DLG.PREVIEW.COL.NAME"));
        this.previewTableModel.addColumn(this.getResourceString("CALCFACTORY.DLG.PREVIEW.COL.DESC"));
        this.previewTableModel.addColumn(this.getResourceString("CALCFACTORY.DLG.PREVIEW.COL.SHORT.DESC"));
        this.previewTableModel.addColumn(this.getResourceString("CALCFACTORY.DLG.PREVIEW.COL.LONG.DESC"));
        this.previewTableModel.addColumn(this.getResourceString("CALCFACTORY.DLG.PREVIEW.COL.EXPRESSION"));
        TableColumn tableColumn = this.previewTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(300);
        JLabel jLabel5 = new JLabel(this.getResourceString("CALCFACTORY.DLG.NAME.GEN.RULES"));
        JButton jButton4 = new JButton(this.getResourceString("CALCFACTORY.DLG.NAMING.RULES"));
        JButton jButton5 = new JButton(this.getResourceString("CALCFACTORY.DLG.SAVE"));
        JButton jButton6 = new JButton(this.getResourceString("CALCFACTORY.DLG.LOAD"));
        JButton jButton7 = new JButton(this.getResourceString("CALCFACTORY.DLG.CALC.BUTTON.USE.DEFAULT"));
        JButton jButton8 = new JButton(this.getResourceString("CALCFACTORY.DLG.OK"));
        JButton jButton9 = new JButton(this.getResourceString("CALCFACTORY.DLG.CANCEL"));
        this.helpButton = new JButton(this.getResourceString("CALCFACTORY.DLG.HELP"));
        this.helpButton.setVisible(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = UISettings.getPanelInsets();
        final JPanel jPanel2 = new JPanel();
        jPanel2.setName("CalcPanel");
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, gridBagConstraints);
        int n = 4;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.insets = UISettings.getLabelInsets();
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        JScrollPane jScrollPane = new JScrollPane(this.measureList);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.calcCheckBoxPanel = new JPanel();
        this.calcCheckBoxPanel.setLayout(new GridBagLayout());
        this.calcCheckBoxScrollPanel = new JPanel();
        this.calcCheckBoxScrollPanel.setLayout(new GridLayout(1, 1));
        JScrollPane jScrollPane2 = new JScrollPane(this.calcCheckBoxPanel);
        this.calcCheckBoxScrollPanel.add(jScrollPane2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.insets = UISettings.getLabelInsets();
        jPanel.add((Component)jLabel4, gridBagConstraints);
        jLabel4.setLabelFor(this.calcCheckBoxScrollPanel);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        gridBagConstraints.gridwidth = n;
        jPanel.add((Component)this.calcCheckBoxScrollPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        jPanel.add((Component)this.hierarchyLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        gridBagConstraints.gridwidth = n - 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.hierarchyComboBox, gridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jSeparator, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        jScrollPane2 = new JScrollPane((Component)this.previewTable);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        componentWithTitlebar.setComponent((JComponent)jScrollPane2);
        jPanel.add((Component)componentWithTitlebar, gridBagConstraints);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)jButton6);
        buttonBar.add((Component)jButton5);
        buttonBar.add((Component)jButton7);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = UISettings.getLabelWeightX();
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = UISettings.getTextFieldWeightX();
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.calcTemplateFileLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.insets = UISettings.getTextFieldInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = UISettings.getLabelInsets();
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)buttonBar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)jButton8, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton9, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        final JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("fullNamingPanel");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = -1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = UISettings.getLabelInsets();
        gridBagConstraints2.gridwidth = n;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        jPanel3.add((Component)this.namingPanel, gridBagConstraints2);
        ButtonBar buttonBar2 = new ButtonBar();
        buttonBar2.add((Component)jButton);
        buttonBar2.add((Component)jButton2);
        buttonBar2.add((Component)jButton3);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = UISettings.getLabelWeightX();
        gridBagConstraints2.insets = UISettings.getLabelInsets();
        jPanel3.add((Component)jLabel, gridBagConstraints2);
        gridBagConstraints2.weightx = UISettings.getTextFieldWeightX();
        gridBagConstraints2.insets = UISettings.getTextFieldInsets();
        gridBagConstraints2.insets = UISettings.getLabelInsets();
        gridBagConstraints2.weightx = 1.0;
        jPanel3.add((Component)this.nameTemplateFileLabel, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)buttonBar2, gridBagConstraints2);
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(this.getResourceString("CALCFACTORY.DLG.CALC.TAB"), jPanel2);
        jTabbedPane.add(this.getResourceString("CALCFACTORY.DLG.NAMING.TAB"), jPanel3);
        this.prevTabIndex = jTabbedPane.getSelectedIndex();
        this.mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = -1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets.left = UISettings.getLabelInsets().left;
        gridBagConstraints3.insets.right = UISettings.getLabelInsets().right;
        gridBagConstraints3.insets.top = UISettings.getLabelInsets().top;
        gridBagConstraints3.insets.bottom = UISettings.getLabelInsets().bottom;
        gridBagConstraints3.insets.left += 10;
        gridBagConstraints3.weighty = 0.0;
        this.mainPanel.add((Component)multiLineTextArea, gridBagConstraints3);
        ++gridBagConstraints3.gridy;
        gridBagConstraints3.weighty = 1.0;
        this.mainPanel.add((Component)jTabbedPane, gridBagConstraints3);
        ++gridBagConstraints3.gridy;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.insets.bottom += 5;
        this.mainPanel.add((Component)dialogButtonBar, gridBagConstraints3);
        this.setContentPane(this.mainPanel);
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (jTabbedPane.getSelectedComponent() == jPanel2) {
                    CalcFactoryDialog.this.namingPanel.save();
                    try {
                        CalcFactoryDialog.this.updatePreviewTable();
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                    }
                }
                if (jTabbedPane.getSelectedComponent() == jPanel3) {
                    try {
                        CalcFactoryDialog.this.updateNamingPanel();
                    }
                    catch (Exception exception) {
                        LOG.log(Level.FINE, exception.getMessage(), exception);
                    }
                }
                CalcFactoryDialog.this.prevTabIndex = jTabbedPane.getSelectedIndex();
            }
        });
        this.getRootPane().setDefaultButton(jButton8);
        jButton8.setActionCommand("OK_ID");
        jButton8.addActionListener(this);
        jButton9.setActionCommand("CANCEL_ID");
        jButton9.addActionListener(this);
        this.helpButton.setActionCommand("HELP_ID");
        this.helpButton.addActionListener(this);
        this.hierarchyComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        CalcFactoryDialog.this.hierarchySelectionChanged();
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                    }
                }
            }
        });
        this.hierarchyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CalcFactoryDialog.this.hierarchySelectionChanged();
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalcFactoryDialog.this.showNamingDialog();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CalcFactoryDialog.this.saveCalcTemplateAction();
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        });
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalcFactoryDialog.this.loadCalcTemplateAction();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalcFactoryDialog.this.loadNameTemplateAction();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalcFactoryDialog.this.saveNameTemplateAction();
            }
        });
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalcFactoryDialog.this.useDefaultCalcTemplateAction();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalcFactoryDialog.this.useDefaultNameTemplateAction();
            }
        });
        this.registerKeyboardActions();
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
            try {
                transactionWaitCursorManager.setDialog(this);
                transactionWaitCursorManager.showWaitCursor();
                this.create();
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
            finally {
                transactionWaitCursorManager.showDefaultCursor();
                transactionWaitCursorManager.reset();
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.cancel();
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            this.showHelp();
        }
    }

    private void showErrorDialog(String string) {
        String string2 = this.getResourceString("CALCFACTORY.DLG.TITLE");
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    static {
        CALC_DIR = "TEMPLATE_DIRECTORY";
        CALC_FILE_NAME = "TEMPLATE_FILE";
        CALC_NAME_FILE_NAME = "TEMPLATE_NAME_FILE";
        LOG = Logger.getLogger(CalcFactoryDialog.class.getName());
    }
}

