/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFactory;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Version;
import oracle.olap.cubetemplate.CubeCatalogDialog;
import oracle.olap.cubetemplate.CubeTemplateManager;
import oracle.olap.cubetemplateimpl.TemplateFactory;
import oracle.olap.util.OLAPErrorDisplay;

public class MultipleExportXMLAction
extends AbstractMenuAction {
    private String where = CubeCatalogDialog.Destination.TO_BOTH.toString();
    private CubeTemplateManager.OutputFormat format = CubeTemplateManager.OutputFormat.XML;
    private ErrorDisplay errorDisplay = null;
    private StringWriter writer = null;
    List<DBObject> selection;
    private JDialog dialog;

    public void launch() {
        String string = OLAPArb.get("QUICK_DDL_PROGRESSBAR_TITLE");
        if (this.where.equals(CubeCatalogDialog.Destination.TO_BOTH.toString()) || this.where.equals(CubeCatalogDialog.Destination.TO_FILE.toString()) || this.where.equals(CubeCatalogDialog.Destination.TO_TABLE.toString())) {
            RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    if (MultipleExportXMLAction.this.format == CubeTemplateManager.OutputFormat.PLSQL) {
                        this.setMessage(OLAPArb.get("QUICK_DDL_PROGRESSBAR_GEN_PLSQL_MSG"));
                    } else {
                        this.setMessage(OLAPArb.get("QUICK_DDL_PROGRESSBAR_GEN_XML_MSG"));
                    }
                    MultipleExportXMLAction.this.dialog = TemplateFactory.doTemplateProcessing(CubeCatalogDialog.Mode.EXPORT, CubeCatalogDialog.Destination.valueOf(MultipleExportXMLAction.this.where), MultipleExportXMLAction.this.format, MultipleExportXMLAction.this.selection);
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(string);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            String string = RaptorTaskUtils.getErrorMessage((Throwable)throwable);
                            MultipleExportXMLAction.this.warn(throwable);
                            MultipleExportXMLAction.this.errorDisplay.show(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (MultipleExportXMLAction.this.dialog != null) {
                                MultipleExportXMLAction.this.dialog.setModal(true);
                                MultipleExportXMLAction.this.dialog.setVisible(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        } else {
            Object object2;
            this.errorDisplay = new OLAPErrorDisplay();
            CubeTemplateManager cubeTemplateManager = TemplateFactory.getCubeTemplateManagerInstance(new OLAPResources(), this.errorDisplay, this.selection.get(0).getConnection());
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            for (Object object2 : this.selection) {
                arrayList.add((DBObject)object2);
            }
            String string2 = this.getDBObject().getDBVersion();
            Object object3 = object2 = new Version(string2);
            CubeTemplateManager cubeTemplateManager2 = cubeTemplateManager;
            ArrayList<DBObject> arrayList2 = arrayList;
            RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL, (Version)object3, cubeTemplateManager2, arrayList2){
                final /* synthetic */ Version val$dbVersion2;
                final /* synthetic */ CubeTemplateManager val$ctm2;
                final /* synthetic */ ArrayList val$dataObjs2;
                {
                    this.val$dbVersion2 = version;
                    this.val$ctm2 = cubeTemplateManager;
                    this.val$dataObjs2 = arrayList;
                    super(string, bl, iRaptorTaskRunMode);
                }

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    boolean bl2 = false;
                    String string = "NON_OWNER_MAPPED_QUALIFIED";
                    boolean bl3 = true;
                    String string2 = "12.1";
                    Version version = new Version("12.2.0.0.0");
                    if (this.val$dbVersion2.compareTo(version) >= 0) {
                        string2 = "12.2";
                    }
                    MultipleExportXMLAction.this.writer = new StringWriter();
                    try {
                        if (MultipleExportXMLAction.this.format == CubeTemplateManager.OutputFormat.PLSQL) {
                            this.setMessage(OLAPArb.get("QUICK_DDL_PROGRESSBAR_GEN_PLSQL_MSG"));
                            this.val$ctm2.saveToPLSQL(this.val$dataObjs2, bl2, string, bl3, string2, MultipleExportXMLAction.this.writer);
                        } else {
                            this.setMessage(OLAPArb.get("QUICK_DDL_PROGRESSBAR_GEN_XML_MSG"));
                            this.val$ctm2.saveToXML(this.val$dataObjs2, bl2, string, bl3, string2, MultipleExportXMLAction.this.writer);
                        }
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(string);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            MultipleExportXMLAction.this.warn(throwable);
                            if (throwable instanceof SQLException) {
                                SQLException sQLException = (SQLException)throwable;
                                String string = OLAPArb.get("QUICK_DDL_TITLE");
                                String string2 = OLAPArb.get("QUICK_DDL_NOT_ATTACHED");
                                MultipleExportXMLAction.this.errorDisplay.show(throwable, string, string2, (Component)Ide.getMainWindow());
                            } else if (throwable instanceof Exception) {
                                MultipleExportXMLAction.this.errorDisplay.show(throwable);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    final String string = MultipleExportXMLAction.this.writer.toString();
                    if (MultipleExportXMLAction.this.where.equals("worksheet")) {
                        if (MultipleExportXMLAction.this.format == CubeTemplateManager.OutputFormat.PLSQL) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RaptorDBAddin.getSqlOpener().openNewEditor(string, MultipleExportXMLAction.this.selection.get(0).getConnectionName());
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        File file = File.createTempFile("template", ".xml");
                                        file.deleteOnExit();
                                        Editor editor = EditorManager.getEditorManager().openDefaultEditorInFrame(URLFactory.newFileURL((File)file));
                                        ((CodeEditor)editor).replaceSelection(string);
                                        editor.open();
                                    }
                                    catch (IOException iOException) {
                                        MultipleExportXMLAction.this.warn(iOException);
                                    }
                                }
                            });
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Transferable transferable = new Transferable(){

                                    @Override
                                    public DataFlavor[] getTransferDataFlavors() {
                                        return new DataFlavor[]{DataFlavor.stringFlavor};
                                    }

                                    @Override
                                    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                                        return dataFlavor == DataFlavor.stringFlavor || dataFlavor == DataFlavor.plainTextFlavor;
                                    }

                                    @Override
                                    public Object getTransferData(DataFlavor dataFlavor) {
                                        return string;
                                    }
                                };
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
                            }
                        });
                    }
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
    }

    public void setArgs(String string) {
        if (string != null) {
            String[] stringArray = string.split(";");
            this.where = stringArray[0];
            this.format = CubeTemplateManager.OutputFormat.valueOf(stringArray[1]);
        }
    }

    public void setSelection(List<DBObject> list) {
        this.selection = list;
    }
}

