/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.jdbc.OracleCallableStatement;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olap.security.DataSecurityPolicy;
import oracle.olap.security.ORASUtil;
import oracle.olap.security.RealmConstraint;

public class DropDataSecurityRealmAction
extends AbstractOLAPDDLAction {
    private static Logger LOG = Logger.getLogger(DropDataSecurityRealmAction.class.getName());
    private static Queries queries;
    private static final String XMLFILE = "datasecurityactionqueries.xml";
    private static final String REMOVE_ACES = "REMOVE_ACES";
    private static final String DELETE_ACL = "DELETE_ACL";
    private static final String REMOVE_REALMS = "REMOVE_REALMS";
    private static final String APPEND_REALM_CONSTRAINT = "APPEND_REALM_CONSTRAINT";
    private String policyName;
    private String objName;
    private ORASUtil orasUtil;
    private DataSecurityPolicy dsp;

    @Override
    public void launch() {
        DBObject dBObject = this.getDBObject();
        ObjectNode objectNode = (ObjectNode)this.getContext().getElement();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        Connection connection = oracleDatabaseImpl.getConnection();
        this.orasUtil = ORASUtil.getInstance();
        this.objName = String.valueOf(objectNode.getProperty("DIMENSION_NAME"));
        if (this.objName == null) {
            this.objName = String.valueOf(objectNode.getProperty("CUBE_NAME"));
        }
        this.policyName = this.orasUtil.createDSPName(this.objName);
        this.dsp = this.orasUtil.getDSPDO(connection, this.policyName);
        super.launch();
    }

    @Override
    protected void executeOLAPDDLStatements() throws Exception {
        DBObject dBObject = this.getDBObject();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        Connection connection = oracleDatabaseImpl.getConnection();
        String string = this.getOLAPDDLStatements();
        try (OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);){
            oracleCallableStatement.execute();
        }
    }

    @Override
    protected Collection<String> getOLAPDDL(DBObject dBObject) {
        String string = this.getQuery(REMOVE_ACES);
        String string2 = this.getQuery(DELETE_ACL);
        String string3 = this.getQuery(REMOVE_REALMS);
        String string4 = this.getQuery(APPEND_REALM_CONSTRAINT);
        String string5 = dBObject.getObjectName();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.orasUtil = ORASUtil.getInstance();
        stringBuffer.append("DECLARE\n");
        stringBuffer.append(" realm_cons XS$REALM_CONSTRAINT_TYPE;\n");
        stringBuffer.append("BEGIN\n");
        stringBuffer.append(String.format(string3, this.policyName));
        stringBuffer.append("\n");
        if (this.dsp != null) {
            List<RealmConstraint> list = this.dsp.getRealmDOs();
            for (RealmConstraint realmConstraint : list) {
                String string6 = realmConstraint.getACLName();
                String string7 = realmConstraint.getRealmCondition();
                string7 = string7.replaceAll("'", "''");
                if (string6.equalsIgnoreCase(string5)) continue;
                stringBuffer.append(String.format(string4, string7, string6, this.policyName));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(String.format(string, string5));
        stringBuffer.append("\n");
        stringBuffer.append(String.format(string2, string5));
        stringBuffer.append("\n");
        stringBuffer.append("END;");
        stringBuffer.append("\n");
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    @Override
    protected String getOLAPDDLStatements() throws Exception {
        String string = "";
        DBObject dBObject = this.getDBObject();
        Collection<String> collection = this.getOLAPDDL(dBObject);
        if (collection != null && !collection.isEmpty()) {
            String[] stringArray = new String[collection.size()];
            stringArray = collection.toArray(stringArray);
            string = stringArray[0];
        }
        return string;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        DropDataSecurityRealmAction.queries = queries;
    }
}

