/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.jdbc.OracleCallableStatement;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.olapmetadata.MetadataChange;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.table.Queries;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class DropDMLProgramAction
extends AbstractOLAPDDLAction {
    private static Logger LOG = Logger.getLogger(DropDMLProgramAction.class.getName());
    private static Queries queries;
    private static final String XMLFILE = "dmlprogramactionqueries.xml";
    private static final String DROP_DMLPROGRAM = "DROP_DMLPROGRAM";

    @Override
    protected void executeOLAPDDLStatements() throws Exception {
        DBObject dBObject = this.getDBObject();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        Connection connection = oracleDatabaseImpl.getConnection();
        String string = dBObject.getConnectionName();
        String string2 = dBObject.getSchemaName();
        String string3 = dBObject.getObjectName();
        String string4 = CubeAWUtil.getAnalyticWorkspaceName(dBObject);
        String string5 = this.getOLAPDDLStatements();
        try (OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string5);){
            oracleCallableStatement.execute();
        }
        try {
            OLAPMetadataCache.recordMetadataChange(string, string2, new MetadataChange(string4, string3, Type.DMLPROGRAM, "DELETION"));
            OLAPMetadataCache.getUpdatedSchema(string, string2);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    protected Collection<String> getOLAPDDL(DBObject dBObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        String string3 = CubeAWUtil.getAnalyticWorkspaceName(dBObject);
        String string4 = string + "." + string3;
        String string5 = this.getQuery(DROP_DMLPROGRAM);
        string5 = String.format(string5, string4, string2);
        arrayList.add(string5);
        return arrayList;
    }

    @Override
    protected String getOLAPDDLStatements() throws Exception {
        String string = "";
        DBObject dBObject = this.getDBObject();
        Collection<String> collection = this.getOLAPDDL(dBObject);
        if (collection != null && !collection.isEmpty()) {
            String[] stringArray = new String[collection.size()];
            stringArray = collection.toArray(stringArray);
            string = stringArray[0];
        }
        return string;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        DropDMLProgramAction.queries = queries;
    }
}

