/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.calcs.DependenciesTableModel;

public class ConfirmDropMeasurePanel
extends JPanel {
    private List<Measure> dependencies;
    private GenericTable dependenciesTable;
    private DependenciesTableModel tableModel;
    private String measureName;

    public ConfirmDropMeasurePanel() {
        this(Collections.EMPTY_LIST, "");
    }

    public ConfirmDropMeasurePanel(List<Measure> list, String string) {
        this.dependencies = list;
        this.measureName = string;
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.tableModel = new DependenciesTableModel();
        this.dependenciesTable = new GenericTable((TableModel)this.tableModel);
        this.setupTableColumns();
        this.populateTable();
    }

    private void populateTable() {
        if (!this.dependencies.isEmpty()) {
            for (Measure measure : this.dependencies) {
                String string = "";
                if (measure.getType().equals("BASE")) {
                    string = OLAPArb.getString("DEPENDENCIES_TABLE_MODEL_BASE_MEASURE");
                } else if (measure.getType().equals("DERIVED")) {
                    string = OLAPArb.getString("DEPENDENCIES_TABLE_MODEL_CALCULATED_MEASURE");
                }
                Object[] objectArray = new Object[]{String.format("%s.%s", measure.getCube().getName(), measure.getName()), string, measure.getExpression()};
                this.tableModel.addRow(objectArray);
            }
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.dependenciesTable);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB")));
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        int n = 0;
        this.add((Component)new JLabel(OLAPArb.format("DROP_MEASURE_NOTIFICATION", this.measureName)), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        ++n;
        if (!this.dependencies.isEmpty()) {
            this.add((Component)new JLabel(OLAPArb.getString("DROP_MEASURE_DEPENDENCIES_NOTIFICATION")), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        int n2 = ++n;
        ++n;
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, n2, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private void setupTableColumns() {
        this.dependenciesTable.setAutoResizeMode(0);
        this.dependenciesTable.setColumnSelectorAvailable(false);
        TableColumn tableColumn = this.dependenciesTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(220);
        tableColumn = this.dependenciesTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.dependenciesTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(450);
    }

    protected String getMeasureName() {
        return this.measureName;
    }

    protected GenericTable getDependenciesTable() {
        return this.dependenciesTable;
    }

    protected List<Measure> getDependencies() {
        return this.dependencies;
    }
}

