/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.history.LocalState;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdevimpl.history.LocalHistoryEntry;
import oracle.jdevimpl.history.LocalHistoryProvider;
import oracle.jdevimpl.resource.HistoryArb;

public class RestoreDeletionsPanel
extends JPanel {
    private CardLayout mainLayout = new CardLayout();
    private JSplitPane verticalSplit = new JSplitPane();
    private JSplitPane horizontalSplit = new JSplitPane();
    private BorderLayout objectLayout = new BorderLayout();
    private JPanel objectPanel = new JPanel();
    private JLabel objectLabel = RestoreDeletionsPanel.createTitleLabel();
    private JScrollPane objectScroll = new JScrollPane();
    private CustomJTree objectTree = new CustomJTree();
    private DefaultMutableTreeNode objectTreeRoot;
    private JPanel historyPanel = new JPanel();
    private BorderLayout historyLayout = new BorderLayout();
    private JLabel historyLabel = RestoreDeletionsPanel.createTitleLabel();
    private HistoryComponent historyList = HistoryManager.getHistoryManager().createHistoryComponent();
    private JPanel previewPanel = new JPanel();
    private BorderLayout previewLayout = new BorderLayout();
    private JLabel previewLabel = RestoreDeletionsPanel.createTitleLabel();
    private JScrollPane previewScroll = new JScrollPane();
    private BasicEditorPane previewEditPane = new BasicEditorPane();
    private HashMap<URL, DefaultMutableTreeNode> objectTreeNodes = new LinkedHashMap<URL, DefaultMutableTreeNode>();
    private HashMap revisionMappings = new HashMap();

    public RestoreDeletionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.verticalSplit.setOrientation(0);
        DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
        JTreeCellData treeCellData = new JTreeCellData(null, null, true, TriStateBoolean.TRUE);
        this.objectTreeRoot = new JMutableTreeNode(treeCellData);
        selModel.setSelectionMode(1);
        this.objectPanel.setLayout(this.objectLayout);
        ResourceUtils.resLabel((JLabel)this.objectLabel, (Component)this.objectTree, (String)HistoryArb.get("SELECT_OBJECT"));
        this.objectLabel.setIcon(OracleIcons.getIcon((String)"structure.png"));
        this.objectTree.setModel((TreeModel)new DefaultTreeModel(this.objectTreeRoot));
        this.objectTree.setRootVisible(false);
        this.objectTree.setScrollsOnExpand(true);
        this.objectTree.setSelectionModel((TreeSelectionModel)selModel);
        this.objectTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                RestoreDeletionsPanel.this.objectSelectionChanged(e);
            }
        });
        this.objectScroll.setBorder(this.createMatteTopBorder());
        this.historyPanel.setLayout(this.historyLayout);
        ResourceUtils.resLabel((JLabel)this.historyLabel, (Component)this.historyList.getTable(), (String)HistoryArb.get("SELECT_REVISION"));
        this.historyLabel.setIcon(OracleIcons.getIcon((String)"history.png"));
        this.historyList.setSingleSelection(true);
        this.historyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RestoreDeletionsPanel.this.historySelectionChanged(e);
            }
        });
        this.historyList.setBorder(this.createMatteTopBorder());
        this.previewPanel.setLayout(this.previewLayout);
        this.previewLabel.setIcon(OracleIcons.getIcon((String)"lov.png"));
        ResourceUtils.resLabel((JLabel)this.previewLabel, (Component)this.previewEditPane, (String)HistoryArb.get("PREVIEW"));
        this.previewEditPane.setEditable(false);
        this.previewScroll.setBorder(this.createMatteTopBorder());
        this.historyPanel.add((Component)this.historyLabel, "North");
        this.historyPanel.add((Component)this.historyList, "Center");
        this.horizontalSplit.add((Component)this.historyPanel, "right");
        this.objectScroll.setViewportView((Component)this.objectTree);
        this.objectPanel.add((Component)this.objectLabel, "North");
        this.objectPanel.add((Component)this.objectScroll, "Center");
        this.horizontalSplit.add((Component)this.objectPanel, "left");
        this.verticalSplit.add((Component)this.horizontalSplit, "top");
        this.horizontalSplit.setBorder(null);
        this.previewScroll.setViewportView((Component)this.previewEditPane);
        this.previewPanel.add((Component)this.previewLabel, "North");
        this.previewPanel.add((Component)this.previewScroll, "Center");
        this.verticalSplit.add((Component)this.previewPanel, "bottom");
        this.add((Component)this.verticalSplit, "jSplitPane1");
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.objectTree);
    }

    private static final JLabel createTitleLabel() {
        JLabel titleLabel = new JLabel();
        titleLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        titleLabel.setMinimumSize(new Dimension(0, 0));
        return titleLabel;
    }

    private final Border createMatteTopBorder() {
        return BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow"));
    }

    public void setModel(URLPath path) {
        this.revisionMappings.clear();
        this.objectTreeNodes.clear();
        this.objectTreeRoot.removeAllChildren();
        if (path != null) {
            int i;
            URL[] entries = path.asList().toArray(new URL[0]);
            int count = 0;
            for (i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                for (int j = 0; j < entries.length; ++j) {
                    if (j == i || entries[j] == null || !URLFileSystem.isBaseURLFor((URL)entries[i], (URL)entries[j])) continue;
                    entries[j] = null;
                    ++count;
                }
            }
            if (count > 0) {
                URL[] temp = new URL[entries.length - count];
                count = 0;
                for (int i2 = 0; i2 < entries.length; ++i2) {
                    if (entries[i2] == null) continue;
                    temp[count++] = entries[i2];
                }
                entries = temp;
            }
            if (entries != null) {
                for (i = 0; i < entries.length; ++i) {
                    Object[] deletions;
                    URL url = entries[i];
                    URL parentURL = URLFileSystem.getParent((URL)url);
                    if (parentURL != null) {
                        this.objectTreeNodes.put(parentURL, this.objectTreeRoot);
                    }
                    this.addObjectTreeNode(url);
                    oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
                    Object[] objectArray = deletions = mgr != null ? mgr.getDeletions(url) : null;
                    if (deletions == null || deletions.length <= 0) continue;
                    this.populateObjectTree(deletions);
                }
            }
        }
        TreePath nodePath = new TreePath(this.objectTreeRoot);
        this.objectTree.collapsePath(nodePath);
        this.objectTree.expandPath(nodePath);
        this.objectTree.expandAllRows();
        this.objectTree.setSelectionRow(0);
        if (!this.objectTreeNodes.isEmpty()) {
            for (Map.Entry<URL, DefaultMutableTreeNode> entry : this.objectTreeNodes.entrySet()) {
                if (URLFileSystem.isDirectoryPath((URL)entry.getKey())) continue;
                this.objectTree.setSelectionPath(new TreePath(entry.getValue().getPath()));
                break;
            }
        }
        Enumeration<TreeNode> e = this.objectTreeRoot.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
            JTreeCellData jTreeCellData = (JTreeCellData)node.getUserObject();
        }
        this.horizontalSplit.setDividerLocation(0.5);
        this.verticalSplit.setDividerLocation(0.33);
    }

    CustomJTree getObjectTree() {
        return this.objectTree;
    }

    LocalState[] getAllLocalStates() {
        Enumeration<TreeNode> e;
        ArrayList<LocalState> list = new ArrayList<LocalState>();
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        Enumeration<TreeNode> enumeration = e = mgr != null ? this.objectTreeRoot.breadthFirstEnumeration() : null;
        if (e != null) {
            while (e.hasMoreElements()) {
                JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
                JTreeCellData data = (JTreeCellData)node.getUserObject();
                Object objId = data.getUserObject();
                if (objId == null) continue;
                LocalState state = (LocalState)this.revisionMappings.get(objId);
                if (state == null) {
                    state = mgr.getLastState(objId);
                }
                if (state == null) continue;
                list.add(state);
            }
        }
        LocalState[] states = new LocalState[list.size()];
        list.toArray(states);
        return states;
    }

    public LocalState[] getLocalStates() {
        Enumeration<TreeNode> e;
        ArrayList<LocalState> list = new ArrayList<LocalState>();
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        Enumeration<TreeNode> enumeration = e = mgr != null ? this.objectTreeRoot.breadthFirstEnumeration() : null;
        if (e != null) {
            while (e.hasMoreElements()) {
                Object objId;
                JMutableTreeNode node = (JMutableTreeNode)e.nextElement();
                JTreeCellData data = (JTreeCellData)node.getUserObject();
                TriStateBoolean tsBool = data.getCheckBoxState();
                if (!tsBool.isTrue() || (objId = data.getUserObject()) == null) continue;
                LocalState state = (LocalState)this.revisionMappings.get(objId);
                if (state == null) {
                    state = mgr.getLastState(objId);
                }
                if (state == null) continue;
                list.add(state);
            }
        }
        LocalState[] states = new LocalState[list.size()];
        list.toArray(states);
        return states;
    }

    private void populateObjectTree(Object[] objs) {
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        if (objs != null && mgr != null) {
            for (int i = 0; i < objs.length; ++i) {
                LocalState last = mgr.getLastState(objs[i]);
                if (last == null) continue;
                JMutableTreeNode node = this.addObjectTreeNode(last.getStateURL());
                JTreeCellData data = (JTreeCellData)node.getUserObject();
                data.setUserObject(objs[i]);
            }
        }
    }

    private JMutableTreeNode addObjectTreeNode(URL url) {
        if (url == null) {
            return null;
        }
        URL parentURL = URLFileSystem.getParent((URL)url);
        DefaultMutableTreeNode parentNode = null;
        if (parentURL == null) {
            parentNode = this.objectTreeRoot;
        } else {
            parentNode = (JMutableTreeNode)this.objectTreeNodes.get(parentURL);
            if (parentNode == null) {
                parentNode = this.addObjectTreeNode(parentURL);
            }
        }
        JTreeCellData treeCellData = new JTreeCellData(null, URLFileSystem.getFileName((URL)url), true, TriStateBoolean.FALSE);
        treeCellData.setToolTipText(URLFileSystem.getPlatformPathName((URL)url));
        treeCellData.setIcon(URLFileSystem.isDirectoryPath((URL)url) ? OracleIcons.getIcon((String)"open.png") : OracleIcons.getIcon((String)"file.png"));
        JMutableTreeNode child = new JMutableTreeNode(treeCellData);
        parentNode.add((MutableTreeNode)child);
        this.objectTreeNodes.put(url, (DefaultMutableTreeNode)child);
        return child;
    }

    private Object getObjectTreeSelection() {
        TreePath path = this.objectTree.getSelectionPath();
        JMutableTreeNode node = (JMutableTreeNode)(path != null ? path.getLastPathComponent() : null);
        JTreeCellData data = node != null ? (JTreeCellData)node.getUserObject() : null;
        return data != null ? data.getUserObject() : null;
    }

    private void objectSelectionChanged(TreeSelectionEvent e) {
        int count;
        Object objId = this.getObjectTreeSelection();
        oracle.ide.history.HistoryManager mgr = oracle.ide.history.HistoryManager.getHistoryManager();
        LocalState[] states = mgr != null && objId != null ? mgr.getLocalHistory(objId) : new LocalState[]{};
        this.historyList.setModel((HistoryModel)new DeletionsModel(states));
        this.historyList.sortTableByProperty(SharedProperties.getDateProperty(), false);
        Object[] prototypes = new Object[this.historyList.getModel().getProperties().length];
        for (int i = 0; i < prototypes.length; ++i) {
            HistoryProperty property = this.historyList.getModel().getProperties()[i];
            if (prototypes[i] == null && property == SharedProperties.getDateProperty()) {
                prototypes[i] = "15-Sep-2009 11:40:27";
            }
            if (prototypes[i] == null && property == SharedProperties.getRevisionProperty()) {
                prototypes[i] = new RevisionIdentifier(OracleIcons.getIcon((String)"filesave.png"), "Local");
            }
            if (prototypes[i] == null && property == SharedProperties.getDateProperty()) {
                prototypes[i] = "Load External State";
            }
            if (prototypes[i] != null) continue;
            prototypes[i] = "Don't know this one";
        }
        this.historyList.getTable().autoSizeColumnsToFit(prototypes);
        Object last = objId != null ? this.revisionMappings.get(objId) : null;
        boolean foundLast = false;
        HistoryModel model = this.historyList.getModel();
        int n = count = model != null ? model.getSize() : 0;
        if (last != null) {
            for (int i = 0; i < count; ++i) {
                LocalHistoryEntry entry = (LocalHistoryEntry)model.getEntry(i);
                if (!entry.getState().equals(last)) continue;
                this.historyList.setSingleSelection((HistoryEntry)entry);
                foundLast = true;
                break;
            }
        }
        if (!foundLast && count > 0) {
            this.historyList.setSingleSelection(model.getEntry(count - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void historySelectionChanged(ListSelectionEvent e) {
        URL url;
        HistoryEntry[] entries = this.historyList.getSelection();
        LocalState state = null;
        if (entries != null && entries.length == 1 && entries[0] instanceof LocalHistoryEntry) {
            state = ((LocalHistoryEntry)entries[0]).getState();
            Object objId = this.getObjectTreeSelection();
            if (objId != null) {
                this.revisionMappings.put(objId, state);
            }
        }
        URL uRL = url = state != null ? state.getDataURL() : null;
        if (url != null) {
            Reader reader = null;
            try {
                URL lastURL = state.getStateURL();
                String suffix = URLFileSystem.getSuffix((URL)lastURL);
                reader = StreamDecoder.getReader((String)suffix, (URL)url);
                TextBuffer buffer = TextBufferFactory.createTextBuffer();
                buffer.read(reader);
                this.previewEditPane.setDocument((Document)new BasicDocument(lastURL.getPath(), buffer));
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.previewEditPane.setText("");
    }

    private static final class DeletionsModel
    extends DefaultHistoryModel {
        DeletionsModel(LocalState[] states) {
            this.addProperties(LocalHistoryProvider.PROPERTIES);
            if (states != null) {
                ArrayList<LocalHistoryEntry> list = new ArrayList<LocalHistoryEntry>();
                for (int i = 0; i < states.length; ++i) {
                    list.add(new LocalHistoryEntry(states[i]));
                }
                HistoryEntry[] entries = new HistoryEntry[list.size()];
                list.toArray(entries);
                this.addEntries(entries);
            }
        }
    }
}

