/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerEvent;
import oracle.ide.docking.DrawerListener;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.DrawerWindowConfig;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.ide.view.ViewStateEvent;
import oracle.ide.view.ViewStateListener;

public abstract class DrawerEditor
extends Editor {
    private String _editorClassId;
    private DrawerWindow _window;
    private Component _gui;
    private boolean _suppressPersistence;
    private final ViewStateListener _viewStateListener = new ViewStateListener(){

        public void viewExpanded(ViewStateEvent e) {
            DrawerEditor.this.persistDrawerStates();
        }

        public void viewCollapsed(ViewStateEvent e) {
            DrawerEditor.this.persistDrawerStates();
        }
    };
    private final DrawerListener _drawerListener = new DrawerListener(){

        public void drawerMinimized(DrawerEvent de) {
            DrawerEditor.this.persistDrawerStates();
        }

        public void drawerRestored(DrawerEvent de) {
            DrawerEditor.this.persistDrawerStates();
        }
    };

    public DrawerEditor() {
        if (this.supportsDrawers()) {
            DrawerWindowConfig c = new DrawerWindowConfig();
            c.icon(this.getTabIcon());
            c.tabName(this.getTabName());
            c.titleName(this.getTabName());
            c.topComponent(null);
            c.type(0);
            this._window = new DrawerWindow(this.getId() + ".DrawerWindow", (View)this, this.getControllerImpl(), c);
            this._editorClassId = "DrawerEditor-" + ((Object)((Object)this)).getClass().getName() + "_";
        }
    }

    protected final Collection<View> getDrawerViews() {
        return this._window.drawerViews();
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        super.updateVisibleActions(updateMessage);
        if (this._window != null) {
            this._window.updateVisibleActions(updateMessage);
        }
    }

    protected boolean supportsDrawers() {
        return true;
    }

    public final Controller getController() {
        return this._window != null ? this._window.getController() : this.getControllerImpl();
    }

    protected abstract Controller getControllerImpl();

    public Component getGUI() {
        if (!this.supportsDrawers()) {
            return this.getGUIImpl();
        }
        if (this._gui == null) {
            this.initializeGUI();
            this._gui = this._window.getGUI();
            this._gui.setBackground(UIManager.getColor("EditorPane.background"));
            ((JComponent)this._gui).setOpaque(true);
        }
        return this._gui;
    }

    protected Component getGUIImpl() {
        throw new UnsupportedOperationException();
    }

    protected void initializeGUI() {
    }

    protected final void addDrawer(View view, DrawerConfig config, double ratio) {
        view.addViewStateListener(this._viewStateListener);
        this._window.addDrawerListener(this._drawerListener);
        this._window.addDrawer(view, config);
        DTCache cache = Ide.getDTCache();
        Map editorState = (Map)cache.getData(this._editorClassId);
        RestoreState state = null;
        if (editorState != null) {
            String value = (String)editorState.get(view.getTabName());
            RestoreState restoreState = state = value != null ? RestoreState.valueOf(value) : null;
        }
        if (state == null || state == RestoreState.EXPANDED) {
            this._window.expand(view, ratio);
            return;
        }
        if (state == RestoreState.MINIMIZED) {
            this._window.getGUI();
            this._window.minimize(view);
            return;
        }
    }

    protected final void removeIfPresent(View view) {
        this._window.removeIfPresent(view);
        this._window.removeDrawerListener(this._drawerListener);
        view.removeViewStateListener(this._viewStateListener);
    }

    protected final void setSuppressPersistence(boolean suppressPersistence) {
        this._suppressPersistence = suppressPersistence;
    }

    protected final void persistDrawerStates() {
        if (!this.supportsDrawers()) {
            return;
        }
        if (this._suppressPersistence) {
            return;
        }
        DTCache cache = Ide.getDTCache();
        HashMap<String, String> editorState = (HashMap<String, String>)cache.getData(this._editorClassId);
        if (editorState == null) {
            editorState = new HashMap<String, String>();
            cache.putData(this._editorClassId, editorState);
        }
        for (View view : this._window.drawerViews()) {
            RestoreState state = !this._window.showing(view) ? RestoreState.MINIMIZED : (this._window.expanded(view) ? RestoreState.EXPANDED : RestoreState.COLLAPSED);
            editorState.put(view.getTabName(), state.toString());
        }
    }

    private static enum RestoreState {
        EXPANDED,
        COLLAPSED,
        MINIMIZED;

    }
}

