/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdevimpl.compare.BaseCompareEditor;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareOpenHint;
import oracle.jdevimpl.resource.CompareArb;

public class CompareEditor
extends BaseCompareEditor
implements StatusProvider,
FindableEditor {
    static final String COMPARE_OPEN_HINT = "CompareOpenHint";
    private JLabel _statusLabel = new JLabel();
    private CompareView _view;
    private ActionListener _defaultActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                IdeAction.find((int)CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID).performAction(CompareEditor.this.getContext());
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)CompareEditor.this.getGUI(), (Throwable)e);
            }
        }
    };
    private TextBuffer _textBuffer;

    public Component getDefaultFocusComponent() {
        if (!(this._view instanceof BaseCompareView)) {
            return super.getDefaultFocusComponent();
        }
        Component defaultFocusable = ((BaseCompareView)this._view).getFocusComponent();
        return defaultFocusable != null ? defaultFocusable : super.getDefaultFocusComponent();
    }

    @Override
    public CompareView getCompareView() {
        return this._view;
    }

    private void compare(CompareModel model) {
        int[] diffCount = model.getDifferenceTypeCounts();
        int total = model.getDifferenceCount();
        final CompareOpenHint hint = (CompareOpenHint)this.getContext().getProperty(COMPARE_OPEN_HINT);
        if (total == 0) {
            this._statusLabel.setText(CompareArb.get("COMPARE_STATUS_ZERO"));
        } else {
            this._statusLabel.setText(MessageFormat.format(CompareArb.get("COMPARE_STATUS_FORMAT"), String.valueOf(total), String.valueOf(diffCount[0]), String.valueOf(diffCount[1]), String.valueOf(diffCount[2])));
        }
        this._view = CompareViewFactory.createCompareView((CompareModel)model);
        if (this._view instanceof BaseCompareView) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (hint == null) {
                        ((BaseCompareView)CompareEditor.this._view).goToFirstDifference();
                    } else {
                        ContributorKind left = hint.getEditorKind() == CompareOpenHint.EditorKind.LEFT ? ContributorKind.FIRST : ContributorKind.SECOND;
                        ((BaseCompareView)CompareEditor.this._view).setSyncVerticalScroll(false);
                        ((BaseCompareView)CompareEditor.this._view).moveTo(left, hint.getStartPosition(), hint.getEndPosition());
                    }
                }
            });
            final IdeAction goToPreviousAction = this.createLocalAction(Ide.findCmdID((String)"compare.navigatePrevious"));
            final IdeAction goToNextAction = this.createLocalAction(Ide.findCmdID((String)"compare.navigateNext"));
            ((BaseCompareView)this._view).addPositionListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    goToPreviousAction.updateAction();
                    goToNextAction.updateAction();
                }
            });
        }
        this.augmentToolbarComponents();
        this.stateDone();
        if (this._view instanceof BaseCompareView) {
            ((BaseCompareView)this._view).addPopupManager((ComparePopupManager)this);
        }
        if (this._view instanceof ListCompareView) {
            ((ListCompareView)this._view).addDefaultActionListener(this._defaultActionListener);
        }
    }

    public Component getBottomComponent() {
        if (this._view instanceof BaseCompareView) {
            return ((BaseCompareView)this._view).getHorizontalScrollComponent();
        }
        return super.getBottomComponent();
    }

    public Object getEditorAttribute(String attribute) {
        if (this._view instanceof BaseCompareView) {
            if ("scrollable".equals(attribute)) {
                return Boolean.FALSE;
            }
            if (attribute == "horizontal_scrollbar_policy") {
                return new Integer(31);
            }
            if (attribute == "vertical_scrollbar_policy") {
                return new Integer(21);
            }
        }
        if ("menu_id".equals(attribute)) {
            return CompareArb.get("COMPARE_MENU");
        }
        return super.getEditorAttribute(attribute);
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context != null) {
            context.setView((View)this);
            context.setElement((Element)context.getNode());
        }
        return context;
    }

    public void open() {
        CompareModel model = ((CompareNode)this.getContext().getNode()).getModel();
        if (model == null) {
            String message = ((CompareNode)this.getContext().getNode()).getMessage();
            if (message == null) {
                CompareArb.get("COMPARE_NOT_AVAILABLE");
            }
            this.stateError(message);
            return;
        }
        this.compare(model);
        try {
            this.getContext().getNode().open();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void close() {
        if (this._view != null) {
            this._view.dispose();
        }
        super.close();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scscomparewindow_html");
    }

    @Override
    protected Controller getControllerImpl() {
        return CompareController.getDefaultController();
    }

    public Toolbar getToolbar() {
        return super.getToolbar();
    }

    public Component getFixedTopMargin() {
        return super.getFixedTopMargin();
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public JComponent[] getCustomCells() {
        return new JComponent[]{this._statusLabel};
    }

    public boolean isExpandable(JComponent cell) {
        return true;
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._view instanceof EditorPaneView) {
            return ((EditorPaneView)this._view).getCurrentEditorPane();
        }
        return null;
    }

    public void setContext(Context context) {
        super.setContext(context);
        if (context != null && context.getNode() instanceof TextNode) {
            this._textBuffer = ((TextNode)context.getNode()).acquireTextBuffer();
        }
    }
}

