/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.javatools.history.AbstractHistoryModel;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.DefaultHistoryFilter;
import oracle.jdeveloper.history.HistoryFilter;

public class DefaultHistoryModel
extends AbstractHistoryModel {
    private List _entries = new ArrayList();
    private Set _properties = new LinkedHashSet();
    private HistoryProperty[] _scratchArray;
    private HistoryProperty[] _defaultProperties;

    public DefaultHistoryModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultHistoryModel(DefaultHistoryModel model) {
        DefaultHistoryModel defaultHistoryModel = model;
        synchronized (defaultHistoryModel) {
            this._entries.addAll(model._entries);
            this._properties.addAll(model._properties);
            this.setPatterns(model.getPatterns().toArray(new String[0]));
            this._scratchArray = model._scratchArray != null ? (HistoryProperty[])model._scratchArray.clone() : null;
            this._defaultProperties = model._defaultProperties != null ? (HistoryProperty[])model._defaultProperties.clone() : null;
        }
    }

    public synchronized void applyFilter(URL url, HistoryFilter filter) {
        if (filter == null) {
            return;
        }
        Iterator itr = this._entries.iterator();
        while (itr.hasNext()) {
            HistoryEntry entry = (HistoryEntry)itr.next();
            if (filter instanceof DefaultHistoryFilter ? ((DefaultHistoryFilter)filter).accept((HistoryModel)this, url, entry) : filter.accept(entry)) continue;
            itr.remove();
        }
    }

    protected synchronized void addProperties(HistoryProperty[] properties) {
        this._properties.addAll(Arrays.asList(properties));
        this._scratchArray = new HistoryProperty[this._properties.size()];
    }

    protected synchronized void addEntries(HistoryEntry[] entries) {
        if (entries.length == 0) {
            return;
        }
        int firstIndex = this.getSize();
        this._entries.addAll(Arrays.asList(entries));
        this.fireEntriesInserted(firstIndex, firstIndex + entries.length - 1);
    }

    public synchronized HistoryProperty[] getProperties() {
        if (this._scratchArray == null) {
            return new HistoryProperty[0];
        }
        this._properties.toArray(this._scratchArray);
        Arrays.sort(this._scratchArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                HistoryProperty property1 = (HistoryProperty)o1;
                HistoryProperty property2 = (HistoryProperty)o2;
                if (property1.getWeight() > property2.getWeight()) {
                    return 1;
                }
                if (property1.getWeight() < property2.getWeight()) {
                    return -1;
                }
                return 0;
            }
        });
        return this._scratchArray;
    }

    public synchronized HistoryEntry getEntry(int i) {
        return (HistoryEntry)this._entries.get(i);
    }

    public synchronized void setDefaultProperties(HistoryProperty[] defaultProperties) {
        this._defaultProperties = defaultProperties;
    }

    public synchronized HistoryProperty[] getDefaultProperties() {
        if (this._defaultProperties != null) {
            return this._defaultProperties;
        }
        LinkedHashSet<HistoryProperty> defaultProperties = new LinkedHashSet<HistoryProperty>();
        for (HistoryProperty property : this._properties) {
            if (!property.isDefault()) continue;
            defaultProperties.add(property);
        }
        return defaultProperties.toArray(new HistoryProperty[0]);
    }

    public synchronized int getSize() {
        return this._entries.size();
    }
}

