/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.palette.interactor;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.interactor.IlvMakeSDMNodeInteractor;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.AccessibleManagerView;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.DragEventBridge;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.res.UndoResource;
import oracle.diagram.sdm.engine.SDMEngineUtil;
import oracle.diagram.sdm.interaction.DefaultSDMInPlaceEditPlugin;
import oracle.diagram.sdm.model.SplittableSDMLink;
import oracle.diagram.sdm.palette.interactor.PropertyInitializer;
import oracle.diagram.sdm.undo.SDMAddObjectCommand;
import oracle.diagram.sdm.undo.SDMEngineAdjustingCommand;
import oracle.diagram.sdm.undo.SDMEngineCommand;
import oracle.diagram.sdm.undo.SDMSetFromCommand;
import oracle.diagram.sdm.undo.SDMSetToCommand;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;

public class MakeSDMNodeInteractor
extends IlvMakeSDMNodeInteractor
implements DragAndDropAwareInteractor {
    private static final String TASK_NAME = UndoResource.getBundle().getString("create.text");
    private final PaletteTask _task;
    private PropertyInitializer _initializer = null;
    protected IlvGraphic _lastHit = null;
    private final DropTargetListener _dtl = new DragEventBridge(){

        @Override
        protected boolean isValidTarget(DropTargetEvent event) {
            return true;
        }

        @Override
        protected void processAWTEvent(AWTEvent event) {
            MakeSDMNodeInteractor.this.processEvent(event);
        }
    };

    public MakeSDMNodeInteractor(PaletteTask task) {
        this._task = task;
        this.enableEvents(8L);
        this.enableEvents(32L);
    }

    public void setPropertyInitializer(PropertyInitializer initializer) {
        this._initializer = initializer;
    }

    protected void attach(final IlvManagerView view) {
        if (view instanceof AccessibleManagerView) {
            AccessibleManagerView accessibleView = (AccessibleManagerView)view;
            boolean isRequestFocusEnabled = accessibleView.isRequestFocusEnabled();
            accessibleView.setRequestFocusEnabled(false);
            super.attach(view);
            accessibleView.setRequestFocusEnabled(isRequestFocusEnabled);
        } else {
            super.attach(view);
        }
        if (!ReadOnlyUtil.checkWritable(this.getPaletteTask().getDiagramContext())) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeSDMNodeInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
        }
    }

    protected void detach() {
        super.detach();
        if (!this._task.isAborting()) {
            this._task.finished();
        }
    }

    protected PaletteTask getPaletteTask() {
        return this._task;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && this.getManagerView().getInteractor() == this) {
            this.getManagerView().popInteractor();
            keyEvent.consume();
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.react(new IlvPoint((float)e.getX(), (float)e.getY()));
    }

    protected void react(IlvPoint p) {
        Object linkObject;
        IlvPoint p1 = new IlvPoint(p);
        IlvTransformer ilvtransformer = this.getTransformer();
        if (ilvtransformer != null) {
            ilvtransformer.apply(p1);
        }
        IlvGraphic g = this.getManagerView().getManager().getObject(p1, this.getManagerView());
        if (this._lastHit != null && this._lastHit != g) {
            this.unHighlight(this._lastHit);
            this._lastHit = null;
        }
        if (this._lastHit == null && g != null && g instanceof IlvLinkImage && (linkObject = this.getEngine().getObject(g)) instanceof SplittableSDMLink && ((SplittableSDMLink)linkObject).canSplitLink(this.getTag())) {
            this._lastHit = g;
            this.highlight(this._lastHit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void highlight(IlvGraphic g) {
        IlvSDMEngine engine = this.getEngine();
        engine.setAdjusting(true);
        try {
            Object obj = engine.getObject(g);
            if (obj != null) {
                engine.addPseudoClass(obj, "__highlighted");
            }
            this.getEngine().setSelected(obj, true);
        }
        finally {
            engine.setAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unHighlight(IlvGraphic g) {
        IlvSDMEngine engine = this.getEngine();
        engine.setAdjusting(true);
        try {
            Object obj = engine.getObject(g);
            if (obj != null) {
                engine.removePseudoClass(obj, "__highlighted");
            }
            SDMEngineUtil.setSelected(this.getEngine(), obj, false);
        }
        finally {
            engine.setAdjusting(false);
        }
    }

    protected final void invokeCommand(Command cmd) {
        this.invokeCommand(cmd, true);
    }

    protected final void invokeCommand(Command cmd, boolean viaCmdProcessor) {
        Context context = this.getPaletteTask().getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        cmd.setContext(context);
        try {
            if (viaCmdProcessor) {
                CommandProcessor.getInstance().invoke(cmd);
            } else {
                cmd.doit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean requiresModelUndo() {
        return true;
    }

    protected String getUndoName() {
        return TASK_NAME;
    }

    protected void createNode(float x, float y) {
        IlvSDMEngine engine = this.getEngine();
        Object parent = null;
        if (engine.isDropToGroupEnabled()) {
            parent = engine.getParent(this.getManagerView(), x, y, true);
        }
        this.createNode(x, y, parent, true);
    }

    public boolean isValidContext(IlvGraphic graphic) {
        return graphic instanceof IlvManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNode(float x, float y, Object parent, boolean allowLinkSplitAtPoint) {
        IlvGrapher parentGraphic;
        IlvSDMEngine engine = this.getEngine();
        Object object = parentGraphic = parent != null ? engine.getGraphic(parent, true) : engine.getGrapher();
        if (!ReadOnlyUtil.checkWritableCreateNode(this.getPaletteTask().getDiagramContext(), (IlvGraphic)parentGraphic)) {
            final IlvManagerView view = this.getManagerView();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeSDMNodeInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
            return;
        }
        IlvSDMModel model = engine.getModel();
        Object obj = null;
        CommandProcessor.getInstance().beginTrans(this.getUndoName());
        this.invokeCommand(new SDMEngineAdjustingCommand(engine, true));
        try {
            IlvGraphic newGraphic;
            Object hit;
            obj = model.createNode(this.getTag());
            this.setNodeProperties(model, obj);
            boolean isNewNodeAdded = false;
            IlvPoint viewPoint = new IlvPoint(x, y);
            this.getManagerView().getTransformer().apply(viewPoint);
            if (allowLinkSplitAtPoint && (hit = engine.getObject(viewPoint, this.getManagerView(), true)) != null && model.isLink(hit) && hit instanceof SplittableSDMLink && ((SplittableSDMLink)hit).canSplitLink(obj)) {
                Object link = model.createLink(model.getTag(hit));
                ((SplittableSDMLink)hit).afterSplit(model, link);
                Object prevTo = model.getTo(hit);
                this.invokeCommand(new SDMAddObjectCommand(model, obj, parent, null), this.requiresModelUndo());
                isNewNodeAdded = true;
                this.invokeCommand(new SDMSetToCommand(model, hit, prevTo, obj), this.requiresModelUndo());
                this.invokeCommand(new SDMSetFromCommand(model, link, null, obj), this.requiresModelUndo());
                this.invokeCommand(new SDMSetToCommand(model, link, null, prevTo), this.requiresModelUndo());
                this.invokeCommand(new SDMAddObjectCommand(model, link, model.getParent(hit), null), this.requiresModelUndo());
            }
            if (!isNewNodeAdded) {
                this.invokeCommand(new SDMAddObjectCommand(model, obj, parent, null), this.requiresModelUndo());
            }
            if (this.isGridMode() && this.getManagerView().getGrid() != null && (newGraphic = engine.getGraphic(obj, true)) != null) {
                IlvTransformer tfx = this.getManagerView().getTransformer();
                IlvRect bbox = newGraphic.boundingBox(tfx);
                viewPoint.translate(-bbox.width / 2.0f, -bbox.height / 2.0f);
                this.getManagerView().snapToGrid(viewPoint);
                viewPoint.translate(bbox.width / 2.0f, bbox.height / 2.0f);
                tfx.inverse(viewPoint);
                x = viewPoint.x;
                y = viewPoint.y;
            }
            final Object modelObj = obj;
            final float tmpX = x;
            final float tmpY = y;
            this.invokeCommand(new SDMEngineCommand(Ide.findOrCreateCmdID((String)(MakeSDMNodeInteractor.class.getName() + "." + "moveObject")), 0, "", engine){

                @Override
                protected int doitImpl() throws Exception {
                    this.getEngine().moveObject(modelObj, null, tmpX, tmpY, false, 16, true);
                    return 0;
                }

                @Override
                protected int undoImpl() throws Exception {
                    return 0;
                }
            }, this.requiresModelUndo());
        }
        finally {
            this.invokeCommand(new SDMEngineAdjustingCommand(engine, false));
        }
        this.getManager().deSelectAll(false);
        engine.deselectAllObjects();
        engine.setSelected(obj, true);
        if (this.isAutoEditLabel()) {
            this.performLabelEdit(new IlvPoint(x, y), obj);
        } else {
            CommandProcessor.getInstance().endTrans();
        }
    }

    protected void performLabelEdit(IlvPoint p, Object modelObject) {
        InPlaceEditPlugin plugin = PluginUtil.getPlugin(this.getManagerView(), InPlaceEditPlugin.class);
        if (plugin instanceof DefaultSDMInPlaceEditPlugin) {
            DefaultSDMInPlaceEditPlugin sdmPlugin = (DefaultSDMInPlaceEditPlugin)plugin;
            sdmPlugin.performLabelEditAndEndTransaction(modelObject);
        } else {
            CommandProcessor.getInstance().endTrans();
        }
    }

    protected void setNodeProperties(IlvSDMModel model, Object object) {
        super.setNodeProperties(model, object);
        if (this._initializer != null) {
            this._initializer.initializeProperties(this.getPaletteTask().getPaletteItem(), model, object);
        }
    }

    @Override
    public DragGestureListener getDragGestureListener() {
        return null;
    }

    @Override
    public DragSourceListener getDragSourceListener() {
        return null;
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this._dtl;
    }
}

