/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.palette.interactor;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.interactor.IlvMakeSDMLinkInteractor;
import ilog.views.sdm.renderer.IlvRendererUtil;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.DragAndDropAwareInteractor;
import oracle.diagram.core.interaction.InteractorEventAware;
import oracle.diagram.core.interaction.event.DiagramPendingActionEvent;
import oracle.diagram.core.interaction.event.InteractorEvent;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.geom.GeomUtil;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.DragEventBridge;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.res.UndoResource;
import oracle.diagram.sdm.engine.SDMEngineUtil;
import oracle.diagram.sdm.graphic.PolyPointsPersisted;
import oracle.diagram.sdm.interaction.DefaultSDMInPlaceEditPlugin;
import oracle.diagram.sdm.palette.interactor.PropertyInitializer;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;

public class MakeSDMLinkInteractor
extends IlvMakeSDMLinkInteractor
implements DragAndDropAwareInteractor,
InteractorEventAware {
    private static final String TASK_NAME = UndoResource.getBundle().getString("create.text");
    private final PaletteTask _task;
    private boolean _autoEdit = false;
    private PropertyInitializer _initializer = null;
    private boolean _finalCreate = false;
    private IlvGraphic _createdObject = null;
    private IlvSDMEngine _engine = null;
    private IlvManagerView _view = null;
    private MyTransformerListener _transformerListener;
    private MouseEvent _lastDragEvent;
    protected boolean _supportsLinkConnect = false;
    protected IlvGraphic _lastHit = null;
    private final DropTargetListener _dtl = new DragEventBridge(){
        private final IlvPoint _tpoint = new IlvPoint();

        @Override
        protected boolean isValidTarget(DropTargetEvent event) {
            DropTargetEvent dtde;
            if (event instanceof DropTargetDragEvent) {
                dtde = (DropTargetDragEvent)event;
                this._tpoint.setLocation((float)((DropTargetDragEvent)dtde).getLocation().x, (float)((DropTargetDragEvent)dtde).getLocation().y);
            } else if (event instanceof DropTargetDropEvent) {
                dtde = (DropTargetDropEvent)event;
                this._tpoint.setLocation((float)((DropTargetDropEvent)dtde).getLocation().x, (float)((DropTargetDropEvent)dtde).getLocation().y);
            }
            IlvGraphic g = MakeSDMLinkInteractor.this.getManager().getObject(this._tpoint, MakeSDMLinkInteractor.this.getManagerView(), MakeSDMLinkInteractor.this.isCreationInSubManagersAllowed());
            return g != null && MakeSDMLinkInteractor.this.acceptOrigin(this._tpoint, g);
        }

        @Override
        protected void processAWTEvent(AWTEvent event) {
            MakeSDMLinkInteractor.this.processEvent(event);
        }
    };

    public MakeSDMLinkInteractor(PaletteTask task) {
        this._task = task;
        this.setAllowingMultiplePoints(true);
        this.setCreationInSubManagersAllowed(true);
        this.setSelfLinkAllowed(true);
        this.setSelectionMode(true);
        this.setOpaqueMode(true);
        this.setGrapherMode(true);
        this.enableEvents(8L);
    }

    public boolean isLinkConnectionMode() {
        return this._supportsLinkConnect;
    }

    public void setLinkConnectionMode(boolean canConnectLinks) {
        this._supportsLinkConnect = canConnectLinks;
    }

    protected String getUndoName() {
        return TASK_NAME;
    }

    public boolean isAutoEditLabel() {
        return this._autoEdit;
    }

    public void setAutoEditLabel(boolean autoEdit) {
        this._autoEdit = autoEdit;
    }

    public void setPropertyInitializer(PropertyInitializer initializer) {
        this._initializer = initializer;
    }

    protected final boolean acceptOrigin(IlvPoint p, IlvGraphic fromNode) {
        return super.acceptOrigin(p, fromNode) && this.isValidSource(fromNode);
    }

    public boolean isValidSource(IlvGraphic source) {
        IlvSDMEngine engine = this.getEngine();
        IlvSDMModel model = engine.getModel();
        Object obj = engine.getObject(source);
        return obj != null && !model.isLink(obj);
    }

    protected final boolean acceptDestination(IlvPoint p, IlvGraphic toNode) {
        return super.acceptDestination(p, toNode) && this.isValidDestination(this.getFrom(), toNode);
    }

    public boolean isValidDestination(IlvGraphic source, IlvGraphic dest) {
        if (source == dest && !this.isSelfLinkAllowed()) {
            return false;
        }
        IlvSDMEngine engine = this.getEngine();
        IlvSDMModel model = engine.getModel();
        Object obj = engine.getObject(dest);
        return obj != null && (!model.isLink(obj) || this.isLinkConnectionMode());
    }

    protected void detach() {
        this.getManagerView().removeTransformerListener((TransformerListener)this._transformerListener);
        this._transformerListener = null;
        super.detach();
        if (!this._task.isAborting()) {
            this._task.finished();
        }
    }

    protected PaletteTask getPaletteTask() {
        return this._task;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27 && this.getManagerView().getInteractor() == this) {
            this.getManagerView().popInteractor();
            keyEvent.consume();
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        boolean allowEnsureVisible = this.allowEnsureVisible();
        this.allowEnsureVisible(false);
        super.processMouseMotionEvent(event);
        this.allowEnsureVisible(allowEnsureVisible);
        if (event.getID() == 506) {
            this._lastDragEvent = event;
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        super.processMouseEvent(event);
        if (event.getID() == 501 && this.getFrom() != null && this.getTo() == null && this._lastHit != null) {
            this.doIt();
        }
    }

    protected void clipEndpoints(IlvGraphic from, IlvGraphic to, IlvPoint[] points) {
        IlvSDMEngine engine = this.getEngine();
        IlvRect rFrom = engine.getRenderer().getLinkConnectionRectangle(engine, from, this.getTransformer());
        this.clipEndpoint(points, rFrom, true);
        IlvRect rTo = engine.getRenderer().getLinkConnectionRectangle(engine, to, this.getTransformer());
        this.clipEndpoint(points, rTo, false);
    }

    protected void clipEndpoint(IlvPoint[] points, IlvRect r, boolean origin) {
        IlvPoint result;
        IlvPoint p2;
        IlvPoint p1 = origin ? points[1] : points[points.length - 2];
        GeomUtil.Intersection side = GeomUtil.getRectangularIntersection((Rectangle2D.Float)r, (Point2D.Float)p1, (Point2D.Float)(p2 = origin ? points[0] : points[points.length - 1]), (Point2D.Float)(result = new IlvPoint()));
        if (side != GeomUtil.Intersection.NONE) {
            points[origin ? 0 : points.length - 1].setLocation(result.x, result.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvLinkImage createLink(IlvGraphic src, IlvGraphic target) {
        IlvLinkImage link = null;
        try {
            this._finalCreate = true;
            CommandProcessor.getInstance().beginTrans(this.getUndoName());
            IlvGrapher grapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)src, (IlvGraphic)target);
            IlvTransformer convSrcTx = ManagerUtil.getConversionTransformer((IlvManager)grapher, (IlvManager)src.getGraphicBag());
            IlvTransformer convDstTx = ManagerUtil.getConversionTransformer((IlvManager)grapher, (IlvManager)target.getGraphicBag());
            IlvRect rSrc = src.boundingBox();
            IlvPoint srcPoint = new IlvPoint((float)rSrc.getCenterX(), (float)rSrc.getCenterY());
            IlvRect rDst = target.boundingBox();
            IlvPoint dstPoint = new IlvPoint((float)rDst.getCenterX(), (float)rDst.getCenterY());
            IlvPoint linkSrcPoint = new IlvPoint(srcPoint);
            convSrcTx.apply(linkSrcPoint);
            IlvPoint linkDstPoint = new IlvPoint(dstPoint);
            convDstTx.apply(linkDstPoint);
            link = this.createObject(src, target, new IlvPoint[]{linkSrcPoint, linkSrcPoint, linkSrcPoint, linkDstPoint}, this.isOriented());
        }
        finally {
            this._finalCreate = false;
        }
        if (this._createdObject != null) {
            if (this.isAutoEditLabel()) {
                this.performLabelEdit((IlvLinkImage)this._createdObject);
            } else {
                CommandProcessor.getInstance().endTrans();
            }
        } else {
            CommandProcessor.getInstance().abortTrans();
        }
        return link;
    }

    public final IlvLinkImage createObject(IlvGraphic fromGraphic, IlvGraphic toGraphic, IlvPoint[] aPoints, final boolean oriented) {
        IlvGraphic realFromGraphic = this.getFrom();
        if (realFromGraphic != fromGraphic && this._lastHit != null) {
            fromGraphic = realFromGraphic;
            toGraphic = FakeNode.find(this._lastHit, true);
        }
        final IlvGraphic from = fromGraphic;
        final IlvGraphic to = toGraphic;
        if (!this._finalCreate) {
            IlvLinkImage link = super.createObject(from, to, aPoints, oriented);
            return link;
        }
        final IlvPoint[] tmpPoints = new IlvPoint[aPoints.length - 2];
        tmpPoints[0] = aPoints[0];
        tmpPoints[tmpPoints.length - 1] = aPoints[aPoints.length - 1];
        System.arraycopy(aPoints, 3, tmpPoints, 1, aPoints.length - 4);
        final IlvPoint[] points = tmpPoints;
        this.clipEndpoints(from, to, points);
        Runnable task1 = new Runnable(){

            @Override
            public void run() {
                if (to instanceof FakeNode) {
                    IlvSDMModel model = MakeSDMLinkInteractor.this.getEngine().getModel();
                    model.setAdjusting(true);
                    Object linkObject = model.createLink(MakeSDMLinkInteractor.this.getTag());
                    MakeSDMLinkInteractor.this.setLinkProperties(model, linkObject);
                    Object fromObject = MakeSDMLinkInteractor.this.getFromObject();
                    Object toObject = MakeSDMLinkInteractor.this.getEngine().getObject(MakeSDMLinkInteractor.this._lastHit);
                    model.setFrom(linkObject, fromObject);
                    model.setTo(linkObject, toObject);
                    model.addObject(linkObject, null, null);
                    model.setAdjusting(false);
                    IlvGraphic newLink = MakeSDMLinkInteractor.this.getEngine().getGraphic(linkObject, true);
                    MakeSDMLinkInteractor.this._createdObject = newLink;
                } else {
                    MakeSDMLinkInteractor.this._createdObject = (IlvGraphic)MakeSDMLinkInteractor.super.createObject(from, to, points, oriented);
                }
            }
        };
        Runnable task2 = new Runnable(){

            @Override
            public void run() {
                final IlvLinkImage link = (IlvLinkImage)MakeSDMLinkInteractor.this._createdObject;
                Object model = MakeSDMLinkInteractor.this.getEngine().getObject((IlvGraphic)link);
                boolean pointControl = IlvRendererUtil.getGraphicPropertyAsBoolean((IlvSDMEngine)MakeSDMLinkInteractor.this.getEngine(), (Object)model, (String)"PointControl", null, (boolean)false);
                if (pointControl) {
                    IlvTransformer tx = MakeSDMLinkInteractor.this.getTransformer();
                    IlvLinkConnector srcConnector = IlvLinkConnector.GetAttached((IlvGraphic)from);
                    if (srcConnector != null) {
                        IlvPoint p = new IlvPoint(points[0]);
                        if (tx != null) {
                            tx.apply(p);
                        }
                        srcConnector.connectLink(link, p, true, ManagerUtil.getManager(from).getDrawingTransformer(MakeSDMLinkInteractor.this.getManagerView()));
                    }
                    if (to instanceof FakeNode) {
                        GraphicConnector gc = GraphicConnector.findOrCreateConnector(MakeSDMLinkInteractor.this._lastHit);
                        IlvPoint p = new IlvPoint(points[points.length - 1]);
                        if (tx != null) {
                            tx.apply(p);
                        }
                        gc.connectLink(link, p, false, ManagerUtil.getTransformingManager(MakeSDMLinkInteractor.this._lastHit).getDrawingTransformer(MakeSDMLinkInteractor.this.getManagerView()));
                        MakeSDMLinkInteractor.this._lastHit = null;
                    } else {
                        IlvLinkConnector dstConnector = IlvLinkConnector.GetAttached((IlvGraphic)to);
                        if (dstConnector != null) {
                            IlvPoint p = new IlvPoint(points[points.length - 1]);
                            if (tx != null) {
                                tx.apply(p);
                            }
                            dstConnector.connectLink(link, p, false, ManagerUtil.getManager(to).getDrawingTransformer(MakeSDMLinkInteractor.this.getManagerView()));
                        }
                    }
                    ManagerUtil.getManager((IlvGraphic)link).applyToObject((IlvGraphic)link, new IlvApplyObject(){

                        public void apply(IlvGraphic g, Object o) {
                            if (tmpPoints.length > 2) {
                                link.setIntermediateLinkPoints(tmpPoints, 1, tmpPoints.length - 2);
                            } else {
                                link.setIntermediateLinkPoints(new IlvPoint[0], 0, 0);
                            }
                        }
                    }, null, true);
                    if (link instanceof PolyPointsPersisted) {
                        String pointData = ((PolyPointsPersisted)link).getPointData();
                        if (model != null) {
                            IlvRendererUtil.updateObjectProperties((IlvSDMEngine)MakeSDMLinkInteractor.this._engine, (Object)model, (String)"sdm:polyPoints", (Object)pointData, null);
                        }
                    }
                }
            }
        };
        if (this.requiresModelUndo()) {
            SDMUndoUtil.captureModelUndo(this.getPaletteTask().getDiagramContext().getPlugin(IdeContextPlugin.class).getContext(), this.getEngine().getModel(), task1);
        } else {
            task1.run();
        }
        SDMUndoUtil.captureModelUndo(this.getPaletteTask().getDiagramContext().getPlugin(IdeContextPlugin.class).getContext(), this.getEngine().getModel(), task2);
        this.getManager().deSelectAll(false);
        this.getEngine().deselectAllObjects();
        this.getEngine().setSelected(this.getEngine().getObject(this._createdObject), true);
        return (IlvLinkImage)this._createdObject;
    }

    protected void performLabelEdit(IlvLinkImage link) {
        Object modelObject = this._engine.getObject((IlvGraphic)link);
        InPlaceEditPlugin plugin = PluginUtil.getPlugin(this._view, InPlaceEditPlugin.class);
        if (plugin instanceof DefaultSDMInPlaceEditPlugin) {
            DefaultSDMInPlaceEditPlugin sdmPlugin = (DefaultSDMInPlaceEditPlugin)plugin;
            sdmPlugin.performLabelEditAndEndTransaction(modelObject);
        } else {
            CommandProcessor.getInstance().endTrans();
        }
    }

    protected void setLinkProperties(IlvSDMModel model, Object object) {
        super.setLinkProperties(model, object);
        if (this._initializer != null) {
            this._initializer.initializeProperties(this.getPaletteTask().getPaletteItem(), model, object);
        }
    }

    protected IlvPoint[] getPoints(boolean transformed) {
        return super.getPoints(transformed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt() {
        IlvGraphic to;
        Context context = this.getPaletteTask().getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        final IlvSDMEngine engine = this.getEngine();
        IlvGraphic from = this.getFrom();
        Object object = to = this.getTo() != null ? this.getTo() : FakeNode.find(this._lastHit, true);
        if (!ReadOnlyUtil.checkWritableCreateLink(this.getPaletteTask().getDiagramContext(), (IlvGraphic)IlvGrapher.getLowestCommonGrapher((IlvGraphic)from, (IlvGraphic)to), null, from, to)) {
            final IlvManagerView view = this.getManagerView();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeSDMLinkInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
            return;
        }
        try {
            this._finalCreate = true;
            CommandProcessor.getInstance().beginTrans(this.getUndoName());
            if (to instanceof FakeNode) {
                IlvGraphic newLink;
                IlvPoint[] points = this.getPoints(false);
                if (points.length >= 2 && points[points.length - 1].equals((Object)points[points.length - 2])) {
                    IlvPoint[] tmpPoints = new IlvPoint[points.length - 1];
                    System.arraycopy(points, 0, tmpPoints, 0, points.length - 1);
                    points = tmpPoints;
                }
                if ((newLink = this.makePolyPoint(points)) != null) {
                    this.addPolyPoints(newLink);
                    if (this.getManagerView().getInteractor() == this) {
                        this.getManagerView().popInteractor();
                    }
                }
            } else {
                super.doIt();
            }
        }
        finally {
            this._finalCreate = false;
        }
        if (this._createdObject != null) {
            if (engine.isLinkLayoutEnabled()) {
                Runnable task1 = new Runnable(){

                    @Override
                    public void run() {
                        engine.performLinkLayout();
                    }
                };
                if (this.requiresModelUndo()) {
                    SDMUndoUtil.captureModelUndo(context, engine.getModel(), task1);
                } else {
                    task1.run();
                }
            }
            if (this.isAutoEditLabel()) {
                this.performLabelEdit((IlvLinkImage)this._createdObject);
            } else {
                CommandProcessor.getInstance().endTrans();
            }
        } else {
            CommandProcessor.getInstance().abortTrans();
        }
    }

    protected void attach(final IlvManagerView view) {
        boolean isFocusable = view.isFocusable();
        view.setFocusable(false);
        super.attach(view);
        view.setFocusable(isFocusable);
        this._transformerListener = new MyTransformerListener();
        view.addTransformerListener((TransformerListener)this._transformerListener);
        this._engine = this.getEngine();
        this._view = view;
        if (!ReadOnlyUtil.checkWritable(this.getPaletteTask().getDiagramContext())) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (view.getInteractor() == MakeSDMLinkInteractor.this) {
                        view.popInteractor();
                    }
                }
            });
        }
    }

    protected boolean requiresModelUndo() {
        return true;
    }

    @Override
    public DragGestureListener getDragGestureListener() {
        return null;
    }

    @Override
    public DragSourceListener getDragSourceListener() {
        return null;
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this._dtl;
    }

    protected void react(IlvPoint p) {
        IlvPoint p1 = new IlvPoint(p);
        IlvTransformer ilvtransformer = this.getTransformer();
        if (ilvtransformer != null) {
            ilvtransformer.apply(p1);
        }
        IlvGraphic g = this.getGrapher().getObject(p1, this.getManagerView(), this.isCreationInSubManagersAllowed());
        super.react(p);
        if (this._lastHit != null && this._lastHit != g) {
            this.unHighlight(this._lastHit);
            this._lastHit = null;
        }
        if (this._lastHit == null && g != null && g instanceof IlvLinkImage && this.isLinkConnectionMode() && (this.getFrom() == null && this.isValidSource(g) || this.getFrom() != null && this.isValidDestination(this.getFrom(), g))) {
            this._lastHit = g;
            this.highlight(this._lastHit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void highlight(IlvGraphic g) {
        if (this.getFrom() == null && !this.isValidSource(g) || this.getFrom() != null && this.getFrom() != g && !this.isValidDestination(this.getFrom(), g)) {
            return;
        }
        IlvSDMEngine engine = this.getEngine();
        engine.setAdjusting(true);
        try {
            Object obj = engine.getObject(g);
            if (obj != null) {
                engine.addPseudoClass(obj, "__highlighted");
            }
            this.getEngine().setSelected(obj, true);
        }
        finally {
            engine.setAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unHighlight(IlvGraphic g) {
        IlvSDMEngine engine = this.getEngine();
        engine.setAdjusting(true);
        try {
            Object obj = engine.getObject(g);
            if (obj != null) {
                engine.removePseudoClass(obj, "__highlighted");
            }
            SDMEngineUtil.setSelected(this.getEngine(), obj, false);
        }
        finally {
            engine.setAdjusting(false);
        }
    }

    @Override
    public boolean processInteractorEvent(InteractorEvent event) {
        DiagramPendingActionEvent epae;
        if (event instanceof DiagramPendingActionEvent && (epae = (DiagramPendingActionEvent)event).getAction().getCommandId() == 5) {
            epae.consume();
            return true;
        }
        return false;
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (MakeSDMLinkInteractor.this._lastDragEvent != null && MakeSDMLinkInteractor.this.getManagerView().getInteractor() == MakeSDMLinkInteractor.this) {
                final MouseEvent event = new MouseEvent(MakeSDMLinkInteractor.this._lastDragEvent.getComponent(), 506, System.currentTimeMillis(), MakeSDMLinkInteractor.this._lastDragEvent.getModifiers(), MakeSDMLinkInteractor.this._lastDragEvent.getX(), MakeSDMLinkInteractor.this._lastDragEvent.getY(), MakeSDMLinkInteractor.this._lastDragEvent.getClickCount(), false, MakeSDMLinkInteractor.this._lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MakeSDMLinkInteractor.this.processEvent(event);
                    }
                });
            }
        }
    }
}

