/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.layout;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.IlvLayoutGraphicFilter;
import ilog.views.graphlayout.link.IlvLinkLayout;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.diagram.framework.graphic.Edge2EdgeLinkShapePolicy;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;

public class SDMDiagramLinkLayout
extends IlvLinkLayout {
    public SDMDiagramLinkLayout() {
    }

    public SDMDiagramLinkLayout(SDMDiagramLinkLayout layout) {
        super((IlvLinkLayout)layout);
    }

    public IlvGraphLayoutReport performLayout(boolean force, boolean redraw) throws IlvGraphLayoutException {
        IlvGraphModel graphModel = this.getGraphModel();
        IlvLayoutGraphicFilter oldFilter = null;
        Edge2EdgeLayoutGraphicFilter edge2edgeFilter = new Edge2EdgeLayoutGraphicFilter();
        try {
            if (graphModel instanceof IlvGrapherAdapter) {
                IlvGrapherAdapter adapter = (IlvGrapherAdapter)graphModel;
                oldFilter = adapter.getFilter();
                adapter.setFilter((IlvLayoutGraphicFilter)edge2edgeFilter);
            }
            IlvGraphLayoutReport report = super.performLayout(force, redraw);
            LinkedList<IlvLinkImage> linkList = edge2edgeFilter.getLinkList();
            if (!linkList.isEmpty()) {
                IlvGrapherAdapter adapter = (IlvGrapherAdapter)graphModel;
                adapter.setFilter(oldFilter);
                HashMap<IlvLinkImage, IlvPoint> pointMap = new HashMap<IlvLinkImage, IlvPoint>();
                for (IlvLinkImage link : linkList) {
                    Object linkObj;
                    IlvSDMModel sdmModel;
                    Object toObj;
                    IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGraphic)link);
                    IlvGraphic realToGraphic = engine.getGraphic(toObj = (sdmModel = engine.getModel()).getTo(linkObj = engine.getObject((IlvGraphic)link)), false);
                    if (realToGraphic == null) {
                        Enumeration allObjects = engine.getAllObjects();
                        while (allObjects.hasMoreElements()) {
                            Object obj = allObjects.nextElement();
                            if (!obj.equals(toObj)) continue;
                            sdmModel.setTo(linkObj, obj);
                            realToGraphic = engine.getGraphic(obj, false);
                            break;
                        }
                    }
                    if (realToGraphic == null) {
                        link.setVisible(false);
                        continue;
                    }
                    if (!(realToGraphic instanceof IlvLinkImage)) continue;
                    GraphicConnector.findOrCreateConnector(realToGraphic);
                    Edge2EdgeLinkShapePolicy policy = Edge2EdgeLinkShapePolicy.findPolicy(realToGraphic);
                    policy.ensureConnection(link, false);
                    FakeNode.find(link.getTo(), true);
                    GraphicPin pin = GraphicPin.findPin(link, false);
                    IlvPoint pinPoint = pin.getConnectionPoint();
                    pointMap.put(link, pinPoint);
                }
                for (IlvLinkImage link : pointMap.keySet()) {
                    FakeNode fakeNode = FakeNode.find(link.getTo(), true);
                    IlvPoint pinPoint = (IlvPoint)pointMap.get(link);
                    IlvRect fakeNodeBox = fakeNode.boundingBox();
                    fakeNode.move(pinPoint.x, pinPoint.y);
                    fakeNode.resize(0.0f, 0.0f);
                    IlvRect fakeNodeBox1 = fakeNode.boundingBox();
                    final IlvLinkImage filterLink = link;
                    adapter.setFilter(new IlvLayoutGraphicFilter(){

                        public boolean accept(IlvGraphic nodeOrLink) {
                            return !(nodeOrLink instanceof IlvLinkImage) || nodeOrLink == filterLink;
                        }
                    });
                    super.performLayout(force, redraw);
                    IlvPoint[] points1 = link.getLinkPoints(null);
                    pinPoint = points1[points1.length - 1];
                    fakeNode.move(fakeNodeBox.x, fakeNodeBox.y);
                    fakeNodeBox1 = fakeNode.boundingBox();
                    link.movePoint(points1.length - 1, pinPoint.x, pinPoint.y, null);
                }
                linkList.clear();
                adapter.setFilter(oldFilter);
            }
            return report;
        }
        catch (IlvGraphLayoutException exc) {
            edge2edgeFilter.getLinkList().clear();
            ((IlvGrapherAdapter)graphModel).setFilter(oldFilter);
            throw exc;
        }
    }

    private static class Edge2EdgeLayoutGraphicFilter
    extends IlvLayoutGraphicFilter {
        private LinkedList<IlvLinkImage> _linkList = new LinkedList();

        private Edge2EdgeLayoutGraphicFilter() {
        }

        public LinkedList<IlvLinkImage> getLinkList() {
            return this._linkList;
        }

        public boolean accept(IlvGraphic nodeOrLink) {
            if (nodeOrLink instanceof IlvLinkImage) {
                IlvLinkImage link = (IlvLinkImage)nodeOrLink;
                IlvGraphic from = link.getFrom();
                IlvGraphic to = link.getTo();
                if (from instanceof FakeNode || to instanceof FakeNode) {
                    if (!this._linkList.contains(link)) {
                        this._linkList.add(link);
                    }
                    return false;
                }
                return true;
            }
            return !(nodeOrLink instanceof FakeNode);
        }
    }
}

